<?php
/*
 Ajax Chat for TRPG ver.2.6.2.1
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

/*
 * 入力内容をダイス変換
 */
function convert_dice($string) {
    // 基本ダイス変換
        // [2d6+5@u(l)o4cr6mfz1]/3
    if (preg_match("/(.*)[[]([0-9]+)(d)([0-9]+)([-\+\*\/\s]*[0-9-\+\*\/\s]*)@?([ul][0-9]+s?o?)?(cr?[0-9\-]+m?)?(f?z?[0-9\-]*)[\]]([\/\*]{0,1}[1-9]*)(.*$)/i", $string, $dice)) {
        $GLOBAL['AJAX_CHAT_TRPG']['count_one'] = true;
        $dice_result = dice_convert($dice[2], $dice[4], $dice[5], $dice[6], $dice[7], $dice[8], $dice[9]);
        $string = $dice[1].$dice_result.$dice[10];
    }
    // 市販ルール対応
    // ＳＷレーティング振り
    elseif (USE_CONSUMER_RULES) {
        if(preg_match("/(.*)[[]([0-9]{0,})([rl])([0-9]{1,})([-\+\*\/\s]{0,}[0-9-\+\*\/\s]{0,})[\]](.*$)/i", $string, $rating)) {
            $dice_result = dice_convert($rating[2], $rating[4], $rating[5], "", "", "", "", $rating[3]);
            $string = $rating[1].$dice_result.$rating[6];
        }
    }

    return $string;
}


/**************
 * ダイス
 **************/

/*
 * ダイス計算
 */
function dice_convert($dicenum, $dicenumber, $revision, $pickup, $c, $f, $finalcal, $dice_type = "d") {
    $dice_hidden = false;

    // 修正値計算用再変換
    $revision = preg_replace("/\s/","+",$revision);

    // 返り値用：元のダイス
    $dice = "[%s".$dice_type.$dicenumber.$revision;
    if ($dice_type == "d") {
        if ($pickup || $c || $f) {
            $dice .= "@".$pickup.$c. $f;
        }
    }
    $dice .= "]";
    $row_dice = $dice;
    $dice = sprintf($row_dice, $dicenum).$finalcal;

    // 市販ルール用ダイス置換
    if (DICE_MAX && USE_CONSUMER_RULES) {
        require_once './lib/consumer_rule.php';

        // 「ダイス変換はブラックボックス」ルールの場合
        // 改修の際は厳守してください
        if ($dice_type == "r") {
            $dice_hidden = true;
        }
 
        // SW
        if ($dice_type == "r") {
            $rating = intval($dicenumber);
            if (!is_int($rating) || $rating < 0 || $rating > 100) {
                return $dice.'<font style="color:#'.MAIN_TEXTCOLOR.';">(レーティングの指定が正しくありません)</font>';
                }
            if ($dicenum) $c = "cr".$dicenum."-";
            $f = "fz2";
            $dicenum = 2;
            $dicenumber = 6;
        }
                // G
                // S
                // DC
                // NW
    }

    // ダイスを振る
    $rolling = "";
    $total_sum = 0;
    $value = 0;
    $roll = array();
    $arr_dicenum = array(0 => $dicenum);

    $total_success = 0;
    for ($i=0;$i<10;$i++) {
        if (!$arr_dicenum[$i]) {
            $arr_dicenum[$i] = $dicenum;
        }
        // ダイスロール
        list($error, $roll[$i]) = dice_main($arr_dicenum[$i], $dicenumber, $revision, $c, $f, $pickup);
        if ($error) {
            return $dice.'<font style="color:#'.MAIN_TEXTCOLOR.';">'.$error.'</font>';
        }

        // 市販ルール対対応：ダイス合計値計算
        if (USE_CONSUMER_RULES) {
            $roll[$i]['dice_sum_disp'] = $roll[$i]['dice_sum'];

            if ($dice_hidden) {
                $roll[$i]['dice_sum_disp'] = null;
            }

            // SW
            if ($dice_type == "r") {
                $roll[$i]['dice_sum'] = convert_sw_rating($rating, $roll[$i]['dice_sum']);
            }
        }

        // ダイス出力準備(1)
        $rolling .= $roll[$i]['dice_list'] ." ";
        if ($pickup) {
            $rolling .= $roll[$i]['success_num'].'個成功 ';
            $total_success += $roll[$i]['success_num'];
            if ($roll[$i]['clit_num']) {
                $rolling .= $roll[$i]['clit_num'].'個クリティカル ';
            }

        }
        if (!$dice_hidden) {
            $rolling .= "= ".(int)$roll[$i]['dice_sum'];
            $total_sum += (int)$roll[$i]['dice_sum'];
        } elseif ($dice_type == "r") {
            $rolling .= "= " . array_sum($roll[$i]['d_result']);
            $rolling .= " →";
            $total_sum += (int)$roll[$i]['dice_sum'];
        }

        // クリティカルで振り足す
        if ($roll[$i]['flg_c'] && $roll[$i]['rolling_num']) {
            // サーバの安全のため、規定数以上は手動振り足し [回数の基準はブックですw]
            if ($i != 9) {
                $rolling .= " = ";
                if ($pickup) {
                    $rolling .= $roll[$i]['rolling_num'].'個';
                }
                $rolling .= C_ROLLING_MSG." ";
            } else {
                if ($roll[$i]['clit_num']) { 
                    $add_rolling_num = $roll[$i]['clit_num'];
                } else {
                    $add_rolling_num = $dicenum;
                }
                $rolling .= "***もう一回".sprintf($row_dice, $add_rolling_num)."を振り足してください***";
            }

            $j = $i+1;
            if ($pickup && $roll[$i]['clit_num']) {
                $arr_dicenum[$j] = $roll[$i]['clit_num'];
            } else {
                $arr_dicenum[$j] = $arr_dicenum[$i];
            }

     // 振り足さない場合ループを抜ける
        } else {
            break;
        }
    }

    if (!$dice_hidden && count($arr_dicenum) > 1) {
        $rolling .= ' = トータル';
        if ($total_success) {
            $rolling .= " ". $total_success.'個成功,';
        }
        if ($total_sum) {
            $rolling .= " 合計 ". $total_sum;
        }
    }
    // 修正値を加える
    // ファンブルは0点で1回目のダイスがファンブルの場合は修正値も入らない
    if($revision && (!F_ZERO || !$roll[0]['flg_f'])) {
        list($value, $error) = calc_value($total_sum, $revision);
    } else {
        $value = $total_sum + $revision;
    }
    if ($error) {
        return $dice.'<font style="color:#'.MAIN_TEXTCOLOR.';">'.$error.'</font>';
    }

    // 最終値の乗除算
    if ($finalcal) {
        if (preg_match("/^(\*)([0-9]{1,})$/", $finalcal, $finalmalti)) {
            $value = $value * $finalmalti[2];
        } elseif (preg_match("/^\/([0-9]+)$/", $finalcal, $finaldev)) {
            if ($finaldev[1] != 0) {
                $value = $value / $finaldev[1];
            } else {
                return $dice."(0では割れません)";
            }
        } else {
            return $dice.'<font style="color:#'.MAIN_TEXTCOLOR.';">'."(最終乗除算の設定が不正です)</font>";
        }
    }

    // ダイス出力準備(2)
    $dice .= " = ";
    if ($finalcal) $dice = $dice."[";
    $dice .= $rolling;

    if($revision) {
        if (F_ZERO && $roll[0]['flg_f'] && !$pickup) {
            $revision = "<s>".$revision."</s>";
        }
        $dice .= " ".$revision;
    }
    if ($finalcal) $dice .= "]".$finalcal;
    if ($value !== false) {
        $dice .= " = ".round($value, 1);
    }
    $dice .= '</span> ';
    $dice = '; font-weight: bold;">'.$dice;
    // クリティカル・ファンブルの場合強調色
    // 回ってファンブルで止まった場合はクリティカル扱い
    if ($roll[0]['flg_c']) {
        $dice = ' <span style="color:#'.C_COLOR. $dice;
    } elseif ($roll[0]['flg_f']) {
        $dice = ' <span style="color:#'.F_COLOR. $dice;
    } else {
        $dice = ' <span style="color:#'.DICE_COLOR. $dice;
    }

    return $dice;
}

/*
 * ダイス本体
 */
function dice_main($dicenum, $dicenumber, $revision, $c, $f, $pickup) {
    $error = '';
    $d_result = array();
    $dice_sum = 0;
    $flg_m = '';

    if ((int)DICE_MAX > 1000) {
        $error = ' (ダイス数の設定が誤っています。1000個以下にしてください)]';
    } elseif ($dicenum >= 1 && $dicenum <= (int)DICE_MAX) {
        if ($dicenumber >= 2 && $dicenumber <= 100) {
            // クリティカル判定
            if (preg_match("/^c(r)?([0-9\-]+)(m)?$/i", $c, $matches_c)) {
                $flg_m = $matches_c[3];
            }

            // ファンブルは0点の場合
            if (preg_match("/^fz([0-9]+)([\-]*)$/i", $f)) {
                define(F_ZERO, true);
            } else {
                define(F_ZERO, false);
            }

            // roll
            mt_srand((double) microtime() * 1000000);

            // 一定値以上/以下の出目をカウント
            if ($pickup) {
                if (!preg_match("/^([ul])([0-9]+)(o)?$/i", $pickup, $matches_p)) {
                    error_log('ダイスの指定が不正です');
                }
                $pickup_v = $matches_p[1];
                $pickup_number = $matches_p[2];
                $pickup_one = $matches_p[3];
            }
            $dice_sum = 0;
            $success_num = 0;
            $clit_num = 0;
            $rolling_num = 0;
            $flg_c = false;
            $flg_r = false;
            $flg_f = false;

            // 1個ずつダイスロール
            for ($i=0; $i<$dicenum; $i++) {
                $d_result[$i]['result'] = mt_rand(1, $dicenumber);

                // 一定値以上/以下の出目をカウント
                if ($pickup) {
                    // クリティカル/ファンブルの検出
                    list($d_result[$i]['flg_c'], $flg_r, $d_result[$i]['flg_f']) = cf_check($d_result[$i]['result'], $c, $f);
                    if (!$flg_c && $d_result[$i]['flg_c']) {
                        $flg_c = true;
                    }

                    // 成否判断
                    $d_result[$i]['success'] = false;
                    if ((stristr($pickup_v, 'u') && $d_result[$i]['result'] >= $pickup_number)
                            || (stristr($pickup_v, 'l') && $d_result[$i]['result'] <= $pickup_number)) {
                        $d_result[$i]['success'] = true;
                        $success_num++;

                        // クリティカル
                        if ($d_result[$i]['flg_c']) {
                            $clit_num++;
                            // クリティカル振り足し
                            if ($flg_r) {
                                $rolling_num++;
                            }
                        }

                        // クリットは最大の出目扱い
                        if ($d_result[$i]['flg_c'] && $flg_m) {
                                $d_result[$i]['add_number'] = (int)$dicenumber;
                        } else {
                                $d_result[$i]['add_number'] = (int)$d_result[$i]['result'];
                        }

                        // 合計値
                        //最大値のみ加算する場合
                        if ($pickup_one) {
                            if ((int)$d_result[$i]['add_number'] > (int)$d_result['result_max']) {
                                $d_result['result_max'] = (int)$d_result[$i]['add_number'];
                            }
                        // 成功値全部加算する場合
                        } else {
                            $dice_sum += $d_result[$i]['add_number'];
                        }
                    }

                // 通常のダイスロール
                } else {
                    $dice_sum += $d_result[$i]['result'];
                }

                // 出目出力
                if ($i != 0) {
                    $dice_list .= ", ";
                } else {
                   $dice_list = "(";
                }
                // 成功ダイスは色を変える
                if ($pickup) {
                    if ($d_result[$i]['success']) {
                        $d_result[$i]['result'] = '<font color="#'.S_COLOR.'">'.$d_result[$i]['result'].'</font>';
                    }
                }
                $dice_list .= $d_result[$i]['result'];
            }
            $dice_list .= ")";

            // 合計値：最大値のみ加算する場合
            if ($pickup_one) {
                 $dice_sum = $d_result['result_max'];
            }
            // クリティカル・ファンブルの判定:通常ダイス
            if ($pickup=='' && ($c || $f)) {
                list($flg_c, $flg_r, $flg_f) = cf_check($dice_sum, $c, $f);

                if ($flg_c && $flg_r) {
                    $rolling_num = 1;
                }

                if (F_ZERO && $flg_f) {
                    $dice_sum = 0;
                }
            }

        } else {
            $error = ' (d2～d100の範囲で指定してください)';
        }
    } else {
        $error = ' (ダイスの数は1から'.DICE_MAX.'の間で指定してください)';
    }

    $d_result['dice_sum'] = $dice_sum;
    $d_result['success_num'] = $success_num;
    $d_result['clit_num'] = $clit_num;
    $d_result['rolling_num'] = $rolling_num;
    $d_result['dice_list'] = $dice_list;
    $d_result['d_result'] = $d_result;
    $d_result['flg_c'] = $flg_c;
    $d_result['flg_f'] = $flg_f;

    return array($error, $d_result);
}

/*
 * ダイス修正値の計算
 */
function calc_value($dice_sum, $revision) {
    $multi = preg_match("/\*/", $revision);
    $dev = preg_match("/\//", $revision);
    $add = preg_match("/\+/", $revision);
    $subtract = preg_match("/\-/", $revision);

    // +-*/で分割
    $revision = preg_replace("/\+/","<>+<>",$revision);
    $revision = preg_replace("/\-/","<>-<>",$revision);
    $revision = preg_replace("/\*/","<>*<>",$revision);
    $revision = preg_replace("/\//","<>/<>",$revision);
    $parts = explode("<>",$revision);
    array_splice($parts, 0, 1, $dice_sum);

    // 乗算&除算
    if ($multi || $dev) {
        foreach ($parts as $k => $v) {
            if ($v != '0' && $v == '*') {
                if (!preg_match("/[0-9]{1,}/", $parts[$k+1])) $error = "演算子が連続してます";
                $flg = $k;
                array_splice($parts, $k+1, 1, $parts[$k-1] * $parts[$k+1]);
                array_splice($parts, $k-1, 1, 0);
                array_splice($parts, $k, 1, $parts[$k-2]);
                array_splice($parts, $k-2, 1, '+');
            }
            if ($v != '0' && $v == '/') {
                if (!preg_match("/[0-9]{1,}/", $parts[$k+1])) $error = "演算子が連続してます";
                array_splice($parts, $k+1, 1, $parts[$k-1] / $parts[$k+1]);
                array_splice($parts, $k-1, 1, 0);
                array_splice($parts, $k, 1, $parts[$k-2]);
                array_splice($parts, $k-2, 1, '+');
            }
        }
    }

    // 加減算
        foreach ($parts as $k => $v){
            if ($v != '0') {
                if ($v == '+') {
                    if (!preg_match("/[0-9]{1,}/", $parts[$k+1]))  $error = "演算子が連続してます";
                    array_splice($parts, 0, 1, $parts[0] + $parts[$k+1]);
                } elseif ($v == '-') {
                    if (!preg_match("/[0-9]{1,}/", $parts[$k+1]))  $error = "演算子が連続してます";
                    array_splice($parts, 0, 1, $parts[0] - $parts[$k+1]);
                }
            }
        }

    return array($parts[0], $error);
}

/*
 * クリティカル･ファンブルの検出
 */
function cf_check($dice_sum, $c, $f) {
    if ($c || $f) {
        if ($c && preg_match("/^c(r)?([0-9]+)([\-]*)(m)?$/i", $c, $clit)) {
            if ($clit[3] && $dice_sum >= $clit[2]) {
                $flg_c = true;
            } elseif (!$clit[3] && $dice_sum == $clit[2]) {
                $flg_c = true;
            } else {
                $flg_c = false;
            }
            if ($flg_c) {
                if ($clit[1]) {
                    $flg_r = true;
                }
            }
        }
        if ($f && preg_match("/^[fF][zZ]{0,1}([0-9]{1,})([\-]{0,})$/i", $f, $famble)) {
            if ($famble[2] && $dice_sum <= $famble[1]) {
                $flg_f = true;
            } elseif (!$famble[2] && $dice_sum == $famble[1]) {
                $flg_f = true;
            } else {
                $flg_f = false;
            }
        }
    }
    return array($flg_c, $flg_r, $flg_f);
}

?>