<?php
/*
 Ajax Chat for TRPG ver.2.6.2.1
 (c)2007-2009 Cake All Rights Reserved.
 Mail : cake_67@users.sourceforge.jp
 Home : http://trpgtools-onweb.sourceforge.jp/
 */

// 設定ファイルの読み込み
require_once './trpgchat-ini.php';
require_once './lib/trpgchat.php';
require_once './lib/pastlog.php';

// 設定セット
set_config(read_config());

// 直近の過去ログ＆HTML化過去ログ両方非表示なら動作しない
if (DELETE_LAST_PASTLOG && !PUBLIC_PASTLOG) error("現在過去ログは表示できません", false, true);

// アクセスブロック
access_block();

// HTML出力
print html_header(CHAT_TITLE.' 過去ログ', 'index');

// JavaScript読み込み
require_once './lib/js/trpgchat-js.php';
?>
<script type="text/javascript">
<!--
//-->
</script>
</head>
<body>
<base target="mainframe">
<table border="0" cellspacing="3" cellpadding="0">
<tr>
<td align="left" valign="top">

<?php 
// 直近の過去ログを「流す」場合は表示せず
if (!DELETE_LAST_PASTLOG) {
    print <<< DOC
<table border="0" cellspacing="3" cellpadding="0">
<tr>
<td colspan="2" class="nodisplay">
DOC;
print '<form action="./pastlog_main.php" target="mainframe" method="'.METHOD.'" name="show" class="show" id="show">';
print <<< DOC
</td>
</tr>
<tr>
<td colspan="2" nowrap>
お名前：<input type="text" name="name_on" id="name_on" size="8" class="inputname">
</td>
</tr>
<tr>
<td colspan="2" nowrap>
パスワード：<input type="password" name="pwd_on" size="4" class="inputpwd" id="pwd_on">
</td>
</tr>
<tr>
<td nowrap>
DOC;
show_icon(WHISPER_ON_ICON, '', '', '', '∂', 'お名前とパスワードを入力してください', '');
print <<< DOC
<input type="submit" id="last" class="btn sub" value="最新のログ">
</td>
<td class="nodisplay">
</form></td>
</tr>
<tr>
<td class="nodisplay"><form action="./#" method="METHOD" onsubmit="pastlogHtmlOutput();return false;"></td>
</tr>
<tr>
<td>
<input type="submit" class="btn sub" value="ダウンロード" >
</td>
</tr>
<tr>
<td class="nodisplay">
</form></td>
</tr>
</table>
<hr>
DOC;

}

// HTML化過去ログファイルの表示
if (PUBLIC_PASTLOG) {
    print "<p>\n";
    print_pastlog_contents_list(PAST_DIR, 'root', 'DESC', '', '', '' , 'open', 'close', 'もっと前のログ', 'クリックで開閉', 'mainframe');
    print "</p>\n";
    print "<hr>\n";
}
?>
<table border="0" cellspacing="3" cellpadding="0">
<tr>
<td class="nodisplay">
<form action="<?php print HOME; ?>" method="<?php print METHOD; ?>" target="_self">
</td>
<td>
<input type="image" class="btn sub" src="<?php print HOME_ICON; ?>" alt="ホーム" title="ホーム">
</td>
<td class="nodisplay">
</form>
</td>
</tr>
</table>

</td>
<td width="100%" valign="top">
<iframe src="./pastlog_main.php" width="100%" frameborder="1" border="1" allowtransparency="true" scrolling="auto" name="mainframe" class="mainframe" style="height:525px;" id="mainframe"></iframe>
</td></tr>
</table>
<noscript>
<p><img src="image/blog_jscript.gif" alt="Javascript" width="80" height="15">過去ログ表示機能は、JavaScript が不可の環境では一部機能のみ使用可能です</p>
</noscript>

<?php
// フッター
print html_footer(true, true);
 ?>