/*
 * demodulator.c
 *
 *  Created on: 2015/03/10
 *      Author: takemasa
 */

#ifndef _DEMODULATOR_H_
#define _DEMODULATOR_H_

#include "framework.h"
#include <math.h>

void init_demodulator(void)
{
    /*
     * 復調アルゴリズムの初期化はここで行う。
     */

}

void radio_demodulate_wide_FM( short idata[], short qdata[], short* left, short* right )
{
    /*
     * ワイドFMの復調アルゴリズムを実行する。
     *
     * 受信IFデータは複素情報となっており、それぞれidata[], qdata[]引数として渡される。
     * いずれの引数も[-1..1) の閾値を取る。なお、それぞれの配列要素数は WIDE_FM_OVERSAMPE 個である。
     *
     * 復調オーディオデータはステレオであり、左右データをそれぞれ*left, *right引数に返す。
     * いずれの引数も[-1..1) の閾値を取る。
     *
     * IFはオーバーサンプルされているがオーディオはされていないので、1/WIDE_FM_OVERSAMPEの
     * デシメーション処理をしなければならない。
     *
     */

    *left = *right = 0;

}

void radio_demodulate_non_wide_FM( int idata, int qdata, short* left, short* right )
{

    *left = *right = 0;
        /*
         * 現在の復調モードを取得し、そのモードに応じて適切なアルゴリズムを実行する。
         * 以下のコードはスケルトンなので、適切なアルゴリズムを実装すること。
         *
         * 受信IFデータは複素情報となっており、それぞれidata, qdata引数として渡される。
         * いずれの引数も[-1..1) の閾値を取る。
         *
         * 復調オーディオデータはステレオであり、左右データをそれぞれ*left, *right引数に返す。
         * いずれの引数も[-1..1) の閾値を取る。
         *
         */
    switch (radio_api_getARM_mode()){
    case radio_mode_NFM :   // ナローFM復調
        break;

    case radio_mode_AM :    // AM復調
        {
                // テスト用の複素包絡線検波
            float i, q;

            q = qdata;
            i = idata;

            *left = *right = sqrtf( q*q + i*i )/65536;

        }
        break;
    case radio_mode_SAM :   // 同期AM復調
           // 動作テスト用880Hz生成プログラム。
           // 実アルゴリズムで置き換えること
        {
            float f;
            static short phase = 0;

            f = sinf( 2 * 3.14 * phase / 32768 ) * 32767 * 0.999;
            phase += 880 ;

            * right = *left = f;
        }
        break;

    case radio_mode_USB :   // USB復調
        break;

    case radio_mode_LSB :   // LSB復調
        break;

    case radio_mode_CW :    // CW復調
        break;
    }




}


#endif /* _DEMODULATOR_H_ */
