/*
 * demodulator.h
 *
 *  Created on: 2015/03/10
 *      Author: takemasa
 */

#ifndef DEMODULATOR_H_
#define DEMODULATOR_H_

    // Following mode macro can be used only the demodulator
#define radio_mode_WFM  2
#define radio_mode_NFM  4
#define radio_mode_AM   5
#define radio_mode_SAM  6
#define radio_mode_LSB  7
#define radio_mode_USB  8
#define radio_mode_CW   9

#ifndef _MACRO_ONLY
    // These APIs are published for the demodulator programmer
#define radio_api_getARM_mode() (radio.comdata[1])
#define radio_api_getAIS_if_shift() (signed short)(radio.comdata[2])
#define radio_api_getAAT_attack() (radio.comdata[3])
#define radio_api_getAFA_fade() (radio.comdata[4])
#define radio_api_getAST_noise_squelch_level() (radio.comdata[5])
#define radio_api_getACP_cw_pitch() (radio.comdata[6])
#define radio_api_getADN_denoiser() (radio.comdata[7])
#define radio_api_getAAN_auto_notch() (radio.comdata[8])
#define radio_api_getAGL_gain_level() (radio.comdata[11])
// Flag 0
#define radio_api_getAIF_filter() ((radio.comdata[0]>>1)&0x7)
#define radio_api_getABN_noise_blanker_on() ((~radio.comdata[0]>>11)&0x1)
#define radio_api_getARG_agc_on() (~(radio.comdata[0]>>13)&0x1)
#define radio_api_is_USB()  ((radio.comdata[0]>>6)&0x1)     // 1 if USB

// Flag10
#define radio_api_getANE_noise_squelch_on() ((radio.comdata[10]>>1)&0x1)
#define radio_api_getAAF_hpf() ((radio.comdata[10]>>4)&0x3)
#define radio_api_getAAF_lpf() ((radio.comdata[10]>>2)&0x3)

// Flag 12
#define radio_api_getAVP_voice_squelch_level() ((radio.comdata[12])&0x3F)
#define radio_api_getAVS_voice_squelch_on() ((~radio.comdata[12]>>7)&0x1)

// Set S meter
#define radio_api_set_S_meter(s) radio.smeter = s


void init_demodulator(void);
void radio_demodulate_wide_FM( short idata[], short qdata[], short* left, short* right );
void radio_demodulate_non_wide_FM( int idata, int qdata, short* left, short* right );

#endif /* _MACRO_ONLY */

#endif /* DEMODULATOR_H_ */
