/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN
 *
 *  上記著作権者は，以下の (1)〜(4) の条件か，Free Software Foundation
 *  によって公表されている GNU General Public License の Version 2 に記
 *  述されている条件を満たす場合に限り，本ソフトウェア（本ソフトウェア
 *  を改変したものを含む．以下同じ）を使用・複製・改変・再配布（以下，
 *  利用と呼ぶ）することを無償で許諾する．
 *  (1) 本ソフトウェアをソースコードの形で利用する場合には，上記の著作
 *      権表示，この利用条件および下記の無保証規定が，そのままの形でソー
 *      スコード中に含まれていること．
 *  (2) 本ソフトウェアを，ライブラリ形式など，他のソフトウェア開発に使
 *      用できる形で再配布する場合には，再配布に伴うドキュメント（利用
 *      者マニュアルなど）に，上記の著作権表示，この利用条件および下記
 *      の無保証規定を掲載すること．
 *  (3) 本ソフトウェアを，機器に組み込むなど，他のソフトウェア開発に使
 *      用できない形で再配布する場合には，次のいずれかの条件を満たすこ
 *      と．
 *    (a) 再配布に伴うドキュメント（利用者マニュアルなど）に，上記の著
 *        作権表示，この利用条件および下記の無保証規定を掲載すること．
 *    (b) 再配布の形態を，別に定める方法によって，TOPPERSプロジェクトに
 *        報告すること．
 *  (4) 本ソフトウェアの利用により直接的または間接的に生じるいかなる損
 *      害からも，上記著作権者およびTOPPERSプロジェクトを免責すること．
 *
 *  本ソフトウェアは，無保証で提供されているものである．上記著作権者お
 *  よびTOPPERSプロジェクトは，本ソフトウェアに関して，その適用可能性も
 *  含めて，いかなる保証も行わない．また，本ソフトウェアの利用により直
 *  接的または間接的に生じたいかなる損害に関しても，その責任を負わない．
 *
 *  @(#) $Id: sample1.h,v 1.3 2009/05/13 13:10:13 suikan Exp $
 */

#ifndef _FRAMEWORK_H_
#define _FRAMEWORK_H_

/*
 *  RX_IFアプリケーションのヘッダファイル
 */

#include <t_services.h>
#include "demodulator.h"


/*
 * デバッグマクロ
 *
 * コメントアウトすると機能がディセーブルになる
*/
// #define DEBUG_QUEUEDEPTH    // シリアルポートから、タスク間Queueの深さを表示させる
// #define DEBUG_DSPLOAD       // シリアルポートからDSP負荷率を表示させる
// #define DEBUG_COMMAND           // DSPに送られてくるコマンドの表示
// #define DEBUG_COMMAND_API       // 復調器から使えるAPIのデバッグ用
// #define DEBUG_BLOCK_FLOAT       // WFMモードでブロック浮動小数点の整数化がうまく出来ているかダンプする。

/**
 * \brief RX_IF受信SPORTバッファのDMAサイズ
 * \details
 * RX_IF受信SPORTバッファのDMAサイズ。単位は[count]。バイト単位ではなく
 * 転送カウントが単位なので注意。
 * ワイドFMモードの場合、1サンプルが16カウントになる。
 * 非ワイドFMモードでは、1サンプルが4カウント。
 *
 * バッファサイズが32の場合、ワイドFMモードでは2サンプル(63uS)ごとに、
 * 非ワイドFMモードでは8サンプル(252uS)ごとに割り込みがかかる。
 *
 * なお、このバッファサイズは必ず4の倍数にすること。
 */
#define RXIF_BUFSIZE 32

/**
 * \brief AF送信SPORTバッファのDMAサイズ
 * \details
 * AF送信SPORTバッファのDMAサイズ。単位は[count]。バイト単位ではなく
 * 転送カウントが単位なので注意。
 * 1サンプルが2カウント。
 *
 * バッファサイズが8の場合、4サンプル(126uS)ごとに割り込みがかかる。
 *
 * なお、このバッファサイズは必ず2の倍数にすること。
 */
#define AF_BUFSIZE 8


/**
 * \brief TASK_RX_IF と TASK_AF の間のデータキューサイズ
 * \details
 * 2つのタスクの間のキューのサイズ[エントリ]を指定する。両タスクの
 * 実行の間にはWideFM/nonWideFM切り替えと、割り込み周期の差異に起因する
 * ジッターが生じするため、キューが必要になる。
 *
 * キューのサイズを決める要素は2つある。ひとつはキュー受信側
 * (TASK_AF)がデータを読み取る周期、もうひとつはキュー送信側
 * (TASK_RX_IF)がデータを読み取る周期である。いずれも単位はサンプルで、
 * このうち大きなほうがデータキューのサイズを決める。
 *
 * キューはオーバーフローとアンダーフローを避けるように作らなければならない。
 * アンダーフローはキューの受信側の割り込みが先行した場合に発生する。
 * これを避けるには、受信側が先行した場合に備えてダミーデータを
 * キューに入れておく必要がある。この数は、先で論じた周期の一番大きい物に
 * しておく。
 *
 * オーバーフローはキューの送信側の割り込みが先行した場合に発生する。
 * これを避けるには、送信側が先行した場合に備えて空き領域を
 * 確保する必要がある。この数は先で論じた周期の一番大きい物に
 * しておく。
 *
 * 結論として、キューには、最も長い割り込み周期[単位はサンプル]の倍の
 * 領域が必要である。
 *
 * なお、このソフトウェアは1サンプルあたり2[エントリ]をキューに格納するため、
 * キューの長さ[エントリ]は、割り込み周期[サンプル]の四倍になる。
 *
 *
 */
#define AF_QUESIZE          80      /* 送受信タスクの間のキューの長さ。8サンプルが最長割り込み周期と仮定してさらにマージンをもたせている */

#define WIDE_FM_OVERSAMPE   8       /* AF1サンプルあたりのWide FM サンプル数 */

#define WIDE_FM_FLAG        2       /* プライマリ・チャンネルのWIDE FM Modeを表すフラグのマスク */

#define PARAMDATA_NUM 16


/*
 *  各タスクの優先度の定義
 */

#define TASK_PRIORITY_AF       5  /* AF DMAタスクの優先度。送信なので優先度高 */
#define TASK_PRIORITY_RX_IF   10  /* RX-IF DMA処理タスクの優先度。復調も行う */
#define LOGTASK_PRIORITY      12  /* デフォルトの初期優先度を上書きする */
#define TASK_PRIORITY_MONITOR 15  /* モニター・タスクの優先度。優先度低 */

/*
 *  ターゲット依存の定義（CPU例外ハンドラの起動方法など）
 */


#define STACK_SIZE_RX_IF    1024    /* タスクのスタックサイズ */
#define STACK_SIZE_AF       1024    /* タスクのスタックサイズ */
#define STACK_SIZE_MONITOR  1024    /* タスクのスタックサイズ */
#define TASK_PORTID         1       /* 文字入力するシリアルポートID */



/*
 *  関数のプロトタイプ宣言
 */
#ifndef _MACRO_ONLY


    // ラジオアルゴリズムとのやりとりに使う変数
extern struct RADIO {
    unsigned short flags;
    unsigned short smeter;
    unsigned short comdata[PARAMDATA_NUM];
} radio;

extern struct RADIO radio;


extern void rx_if_task(VP_INT exinf);   /* SPORT0 RX DMAバッファの内容を復調するタスク */
extern void af_task(VP_INT exinf);      /* 復調済みAF信号をSPORT0 TX DMAバッファにコピーするタスク */
extern void monitor_task(VP_INT exinf);   /* SPORT0 TX DMAバッファにAFデータを書き込むタスク */
extern void sport0_rx_int_handler( void );  /* SPORT0 RX DMA割り込みのハンドラ */
extern void sport0_tx_int_handler( void );  /* SPORT0 TX DMA割り込みのハンドラ */
void init_peripherals(VP_INT p);        /* ペリフェラルの初期化関数 */


#endif /* _MACRO_ONLY */

#endif /* _FRAMEWORK_H_ */
