/*
 * Tester class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester;

import ts.tester.MethodInvoker;
import java.util.StringTokenizer;
import java.util.Collections;
import java.util.List;
import java.util.ArrayList;
import java.util.LinkedList;

/**
 * sNX̒ۃNXB
 * <br>
 * lXȎsNX̊ƂȂ钊ۃNXłB
 * ̃NXpNX̎P[X\bhsB
 * <br>
 * P[X\bh̏́AsNXɒɒ`ĂA
 * Ɩ߂lȂAANZXwqpubÑ\bhłB
 * <br>
 * ̃NXł́AP[X\bhƂ̑OɌĂяo郁\bh̃Zbg
 * P[XƂĂB
 * P[X\郁\bh͈ȉ̒ʂłB
 * \bh͈ȉ̏ԂǂɌĂяoB
 * <ul>
 * <li>{@link ts.tester.Tester#initInvocation(String) initInvocation}</li>
 * <li>{@link ts.tester.Tester#preInvocation(String) preInvocation}</li>
 * <li>iP[X\bhj</li>
 * <li>{@link ts.tester.Tester#postInvocation(String) postInvocation}</li>
 * <li>{@link ts.tester.Tester#endInvocation(String) endInvocation}</li>
 * </ul>
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/05/07 15:19:59 $
 */
public abstract class Tester
{
  /** ꏏɎs鎎sIuWFNgi[郊XgB */
  private List<Tester> childTesterLst_ = new LinkedList<Tester>();

  /**
   * ftHgRXgN^B
   */
  public Tester()
  {}

  /**
   * ꏏɎs鎎sIuWFNgǉB
   * <br>
   * k̏ꍇ͖B
   *
   * @param  tester ꏏɎs鎎sIuWFNgB
   */
  public void addTester(Tester tester)
  {
    if (tester != null) {
      childTesterLst_.add(tester);
    }
  }

  /**
   * Ŝ̏sB
   * <br>
   * SĂ̎P[X⎎Ŝ̑OɌĂяoB
   * sIuWFNgAKvȏ邽߂ɗpӂĂB
   */
  protected abstract void initTesting();

  /**
   * Ŝ̑OsB
   * <br>
   * SĂ̎P[XJnOɌĂяoB
   * P[X̎҂AKvȑOs@^B
   */
  protected void preTesting()
  {}

  /**
   * P[X̏sB
   * <br>
   * P[X\bh⎎P[X̑OɌĂяoB
   * sIuWFNgAKvȏ邽߂ɗpӂĂB
   *
   * @param  methodName P[X\bhB
   */
  protected abstract void initInvocation(String methodName);

  /**
   * P[X̑OsB
   * <br>
   * P[X\bh̒OɌĂяoB
   * P[X̎҂AKvȑOs@񋟂B
   *
   * @param  methodName P[X\bhB
   */
  protected void preInvocation(String methodName)
  {}

  /**
   * P[X̌㏈sB
   * <br>
   * P[X\bh̒ɌĂяoB
   * P[X̎҂AKvȌ㏈s@񋟂B
   *
   * @param  methodName P[X\bhB
   */
  protected void postInvocation(String methodName)
  {}

  /**
   * P[X̏IsB
   * <br>
   * P[X\bh⎎P[X̌㏈\bhɌĂяoB
   * sIuWFNgAKvȏI邽߂ɗpӂĂB
   *
   * @param  methodName P[X\bhB
   */
  protected abstract void endInvocation(String methodName);

  /**
   * Ŝ̌㏈sB
   * <br>
   * SĂ̎P[X̎sɌĂяoB
   * P[X̎҂AKvȌ㏈s@񋟂B
   */
  protected void postTesting()
  {}

  /**
   * Ŝ̏IsB
   * <br>
   * SĂ̎P[X\bh⎎Ŝ̌㏈\bȟɌĂяoB
   * sIuWFNgAKvȏI邽߂ɗpӂĂB
   */
  protected abstract void endTesting();

  /**
   * fꂽƂɌĂ΂郁\bhB
   * <br>
   * fꂽꍇ́AŜ̌㏈I͌Ă΂ꂸA
   * ̃\bhĂяoB
   *
   * @param  exc f̌ƂȂOIuWFNgB
   * @throws Exception ̗OIuWFNg̃\bhŏȂ
   *           ꍇA܂͂̃\bhŐVɗOX[ꂽꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected void stopTesting(Exception exc) throws Exception
  {
    assert (exc != null) : "@param:e is null.";

    throw exc;
  }

  /**
   * w肳ꂽsIuWFNg̎P[XsB
   * <br>
   * Ɏw肳ꂽ{@link ts.tester.Tester Tester}IuWFNg̃NXɒ
   * `ꂽP[XsB
   * \bhɃkw肳ꂽꍇ́Aɒ`ꂽSẴ\bh𖼑Ȍ
   * ɎsB
   * eNXɒ`ꂽ\bh͎sȂB
   * <br>
   * \bh̎sOɂ́A{NX
   * {@link ts.tester.Tester#initTesting() initTesting}\bhA
   * {@link ts.tester.Tester#preTesting() preTesting}\bhA
   * {@link ts.tester.Tester#initInvocation(String) initInvocation}\bhA
   * {@link ts.tester.Tester#preInvocation(String) preInvocation}\bh
   * Ă΂A\bh̎sɂ́A
   * {@link ts.tester.Tester#postInvocation(String) postInvocation}\bhA
   * {@link ts.tester.Tester#endInvocation(String) endInvocation}\bhA
   * {@link ts.tester.Tester#postTesting() postTesting}\bhA
   * {@link ts.tester.Tester#endTesting() endTesting}\bhĂ΂B
   * ̃\bĥA
   * {@link ts.tester.Tester#initTesting() initTesting}A
   * {@link ts.tester.Tester#initInvocation(String) initInvocation}A
   * {@link ts.tester.Tester#endInvocation(String) endInvocation}A
   * {@link ts.tester.Tester#endTesting() endTesting} ́AsNX̂
   * I邽߂ɎgpB
   * {@link ts.tester.Tester#preTesting() preTesting}A
   * {@link ts.tester.Tester#preInvocation(String) preInvocation}A
   * {@link ts.tester.Tester#postInvocation(String) postInvocation}A
   * {@link ts.tester.Tester#postTesting() postTesting} 
   * ۂ̎P[X郆[U[ɗpӂĂB
   * <br>
   * w肳ꂽO̎P[X\bh݂Ȃꍇ͗OB
   * P[X\bh̎sɗOX[ꂽꍇ͗OX[B
   *
   * @param  tester sIuWFNgB
   * @param  methodName s鎎P[X\bhB
   * @throws NoSuchMethodException w肳ꂽÖȂE߂lȂ
   *           \bh݂ȂꍇB
   * @throws IllegalAccessException w肳ꂽÕ\bh̃ANZXwq
   *           pubNłȂꍇB
   * @throws Exception \bh̎sɗOX[ꂽꍇB
   * @throws AssertionError sIuWFNgɃkw肳ꂽꍇ
   *          ifobO[ĥ݁jB
   */
  public static void run(Tester tester, String methodName)
    throws NoSuchMethodException, IllegalAccessException, Exception
  {
    assert (tester != null) : "@param:tester is null.";

    boolean noSuchMethod = false;
    Tester t = null;
    try {
      tester.initTesting();
      tester.preTesting();

      int n = tester.childTesterLst_.size() + 1;
      List<Tester> testerLst = new ArrayList<Tester>(n);
      testerLst.add(tester);
      testerLst.addAll(tester.childTesterLst_);

      for (int i=1; i<n; i++) {
        t = testerLst.get(i);
        t.initTesting();
      }

      if (methodName == null) {
        for (int i=0; i<n; i++) {
          t = testerLst.get(i);
          if (i != 0) t.preTesting();
          MethodInvoker.invokeAllMethods(t);
          t.postTesting();
        }
      }
      else {
        StringTokenizer st = new StringTokenizer(methodName, ",");
        List<Object> mL = Collections.list(st);

        noSuchMethod = true;
        for (int i=0; i<n; i++) {
          t = testerLst.get(i);
          for (Object m : mL) {
            try {
              if (i != 0) t.preTesting();
              MethodInvoker.invokeMethodRegex(t, m.toString().trim());
              noSuchMethod = false;
              t.postTesting();
            }
            catch (NoSuchMethodException e) {
              continue;
            }
          }
        }
      }

      for (int i=n-1; i>=0; i--) {
        t = testerLst.get(i);
        t.endTesting();
      }
    }
    catch (Exception e) {
      t.stopTesting(e);
    }

    if (noSuchMethod) {
      throw new NoSuchMethodException(methodName);
    }
  }

  /**
   * w肳ꂽsNX̎P[XsB
   * <br>
   * Ɏw肳ꂽ{@link ts.tester.Tester Tester}̊gNXɒɒ`ꂽ
   * P[XsB
   * \bhɃkw肳ꂽꍇ́Aɒ`ꂽSẴ\bh𖼑O
   * ɎsB
   * eNXɒ`ꂽ\bh͎sȂB
   * <br>
   * \bh̎sOɂ́A{NX
   * {@link ts.tester.Tester#initTesting() initTesting}\bhA
   * {@link ts.tester.Tester#preTesting() preTesting}\bhA
   * {@link ts.tester.Tester#initInvocation(String) initInvocation}\bhA
   * {@link ts.tester.Tester#preInvocation(String) preInvocation}\bh
   * Ă΂A\bh̎sɂ́A
   * {@link ts.tester.Tester#postInvocation(String) postInvocation}\bhA
   * {@link ts.tester.Tester#endInvocation(String) endInvocation}\bhA
   * {@link ts.tester.Tester#postTesting() postTesting}\bhA
   * {@link ts.tester.Tester#endTesting() endTesting}\bhĂ΂B
   * ̃\bĥA
   * {@link ts.tester.Tester#initTesting() initTesting}A
   * {@link ts.tester.Tester#initInvocation(String) initInvocation}A
   * {@link ts.tester.Tester#endInvocation(String) endInvocation}A
   * {@link ts.tester.Tester#endTesting() endTesting} ́AsNX̂
   * I邽߂ɎgpB
   * {@link ts.tester.Tester#preTesting() preTesting}A
   * {@link ts.tester.Tester#preInvocation(String) preInvocation}A
   * {@link ts.tester.Tester#postInvocation(String) postInvocation}A
   * {@link ts.tester.Tester#postTesting() postTesting} 
   * ۂ̎P[X郆[U[ɗpӂĂB
   * <br>
   * w肳ꂽO̎P[X\bh݂Ȃꍇ͗OB
   * P[X\bh̎sɗOX[ꂽꍇ͗OX[B
   *
   * @param  testerClass sNXB
   * @param  methodName s鎎P[X\bhB
   * @throws NoSuchMethodException w肳ꂽÖȂE߂lȂ
   *           \bh݂ȂꍇB
   * @throws IllegalAccessException w肳ꂽÕ\bh̃ANZXwq
   *           pubNłȂꍇB
   * @throws Exception \bh̎sɗOX[ꂽꍇB
   * @throws AssertionError sNXɃkw肳ꂽꍇ
   *          ifobO[ĥ݁jB
   */
  public static void run(
    Class<? extends Tester> testerClass, String methodName)
  throws NoSuchMethodException, IllegalAccessException, Exception
  {
    assert (testerClass != null) : "@param:testerClass is null.";

    Tester tester = testerClass.newInstance();
    run(tester, methodName);
  }
}
