/*
 * ResultTypeTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;

/**
 * <code>ResultType</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:50 $
 */
public class ResultTypeTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(ResultTypeTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void _toString()
  {
    EQUAL(ResultType.OK.toString(), "OK");
    EQUAL(ResultType.NG.toString(), "NG");
    EQUAL(ResultType.KnownBug.toString(), "KnownBug");
    EQUAL(ResultType.Empty.toString(), "Empty");
    EQUAL(ResultType.Incomplete.toString(), "Incomplete");
  }

  public void _ordinal()
  {
    EQUAL(ResultType.OK.ordinal(), 0);
    EQUAL(ResultType.NG.ordinal(), 1);
    EQUAL(ResultType.KnownBug.ordinal(), 2);
    EQUAL(ResultType.Empty.ordinal(), 3);
    EQUAL(ResultType.Incomplete.ordinal(), 4);
  }

  public void _equals()
  {
    TRUE(ResultType.OK.equals(ResultType.OK));
    TRUE(ResultType.NG.equals(ResultType.NG));
    TRUE(ResultType.KnownBug.equals(ResultType.KnownBug));
    TRUE(ResultType.Empty.equals(ResultType.Empty));
    TRUE(ResultType.Incomplete.equals(ResultType.Incomplete));

    FALSE(ResultType.OK.equals(ResultType.NG));
    FALSE(ResultType.OK.equals(ResultType.KnownBug));
    FALSE(ResultType.OK.equals(ResultType.Empty));
    FALSE(ResultType.OK.equals(ResultType.Incomplete));

    FALSE(ResultType.NG.equals(ResultType.OK));
    FALSE(ResultType.NG.equals(ResultType.KnownBug));
    FALSE(ResultType.NG.equals(ResultType.Empty));
    FALSE(ResultType.NG.equals(ResultType.Incomplete));

    FALSE(ResultType.KnownBug.equals(ResultType.OK));
    FALSE(ResultType.KnownBug.equals(ResultType.NG));
    FALSE(ResultType.KnownBug.equals(ResultType.Empty));
    FALSE(ResultType.KnownBug.equals(ResultType.Incomplete));

    FALSE(ResultType.Empty.equals(ResultType.OK));
    FALSE(ResultType.Empty.equals(ResultType.NG));
    FALSE(ResultType.Empty.equals(ResultType.KnownBug));
    FALSE(ResultType.Empty.equals(ResultType.Incomplete));

    FALSE(ResultType.Incomplete.equals(ResultType.OK));
    FALSE(ResultType.Incomplete.equals(ResultType.NG));
    FALSE(ResultType.Incomplete.equals(ResultType.KnownBug));
    FALSE(ResultType.Incomplete.equals(ResultType.Empty));
  }

  public void _compareTo()
  {
    TRUE(ResultType.OK.compareTo(ResultType.OK) == 0);
    TRUE(ResultType.OK.compareTo(ResultType.NG) < 0);
    TRUE(ResultType.OK.compareTo(ResultType.KnownBug) < 0);
    TRUE(ResultType.OK.compareTo(ResultType.Empty) < 0);
    TRUE(ResultType.OK.compareTo(ResultType.Incomplete) < 0);

    TRUE(ResultType.NG.compareTo(ResultType.OK) > 0);
    TRUE(ResultType.NG.compareTo(ResultType.NG) == 0);
    TRUE(ResultType.NG.compareTo(ResultType.KnownBug) < 0);
    TRUE(ResultType.NG.compareTo(ResultType.Empty) < 0);
    TRUE(ResultType.NG.compareTo(ResultType.Incomplete) < 0);

    TRUE(ResultType.KnownBug.compareTo(ResultType.OK) > 0);
    TRUE(ResultType.KnownBug.compareTo(ResultType.NG) > 0);
    TRUE(ResultType.KnownBug.compareTo(ResultType.KnownBug) == 0);
    TRUE(ResultType.KnownBug.compareTo(ResultType.Empty) < 0);
    TRUE(ResultType.KnownBug.compareTo(ResultType.Incomplete) < 0);

    TRUE(ResultType.Empty.compareTo(ResultType.OK) > 0);
    TRUE(ResultType.Empty.compareTo(ResultType.NG) > 0);
    TRUE(ResultType.Empty.compareTo(ResultType.KnownBug) > 0);
    TRUE(ResultType.Empty.compareTo(ResultType.Empty) == 0);
    TRUE(ResultType.Empty.compareTo(ResultType.Incomplete) < 0);

    TRUE(ResultType.Incomplete.compareTo(ResultType.OK) > 0);
    TRUE(ResultType.Incomplete.compareTo(ResultType.NG) > 0);
    TRUE(ResultType.Incomplete.compareTo(ResultType.KnownBug) > 0);
    TRUE(ResultType.Incomplete.compareTo(ResultType.Empty) > 0);
    TRUE(ResultType.Incomplete.compareTo(ResultType.Incomplete) == 0);
  }

  public void getDeclaredClass()
  {
    EQUAL(ResultType.OK.getDeclaringClass(), ResultType.class);
    EQUAL(ResultType.NG.getDeclaringClass(), ResultType.class);
    EQUAL(ResultType.KnownBug.getDeclaringClass(), ResultType.class);
    EQUAL(ResultType.Empty.getDeclaringClass(), ResultType.class);
    EQUAL(ResultType.Incomplete.getDeclaringClass(), ResultType.class);
  }

  public void _valueOf()
  {
    EQUAL(ResultType.valueOf("OK"), ResultType.OK);
    EQUAL(ResultType.valueOf("NG"), ResultType.NG);
    EQUAL(ResultType.valueOf("KnownBug"), ResultType.KnownBug);
    EQUAL(ResultType.valueOf("Empty"), ResultType.Empty);
    EQUAL(ResultType.valueOf("Incomplete"), ResultType.Incomplete);
  }

  public void values()
  {
    ResultType[] types = ResultType.values();
    EQUAL(types.length, 5);
    EQUAL(types[0], ResultType.OK);
    EQUAL(types[1], ResultType.NG);
    EQUAL(types[2], ResultType.KnownBug);
    EQUAL(types[3], ResultType.Empty);
    EQUAL(types[4], ResultType.Incomplete);
  }

  public void use_with_for_each()
  {
    final String[] arr = { "OK", "NG", "KnownBug", "Empty", "Incomplete" };
    int i = 0;

    for (ResultType type : ResultType.values()) {
      EQUAL(type.toString(), arr[i++]);
    }
  }

  public void use_with_switch()
  {
    ResultType type = ResultType.Empty;

    switch (type) {
    case  OK :
      EQUAL(type, ResultType.OK);
      break;
    case  NG :
      EQUAL(type, ResultType.NG);
      break;
    case  KnownBug :
      EQUAL(type, ResultType.KnownBug);
      break;
    case  Empty :
      EQUAL(type, ResultType.Empty);
      break;
    case  Incomplete :
      EQUAL(type, ResultType.Incomplete);
      break;
    default:
      NG();
      break;
    }
  }  
}
