/*
 * _Printer class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.coverage;

import ts.tester.function.print.AbstractPrinter;
import ts.tester.function.CaseResult;
import ts.tester.function.CheckResult;
import ts.tester.coverage.ObjectWriter;

/**
 * JobWvZXŐꂽ茋ʃIuWFNgOɓn߂
 * o̓NXB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/05/07 15:20:00 $
 */
class _Printer extends AbstractPrinter
{
  /**
   * ftHgRXgN^B
   */
  public _Printer()
  {
    ObjectWriter.prepareOutput();
  }

  /**
   * w肳ꂽO̎P[X茋ʃIuWFNg쐬B
   *
   * @param  name P[XB
   * @param  parent e̎P[X茋ʃIuWFNgB
   * @return P[X茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public CaseResult createCaseResult(String name, CaseResult parent)
  {
    assert (name != null) : "@param:name is null.";
    assert (parent != null) : "@param:parent is null.";

    _CaseResult result = new _CaseResult(name, parent);

    if (parent == null || !(parent instanceof _CaseResult)) {
      output(new _PrintEvent(_PrintEventType.CREATE_CASE_RESULT,
        result.getId()));
    }
    else {
      output(new _PrintEvent(_PrintEventType.CREATE_CASE_RESULT,
        result.getId(), ((_CaseResult) parent).getId()));
    }

    return result;
  }

  /**
   * Ŝ̊JnɌĂяo郁\bhB
   *
   * @param  root ŏʂ̎P[X茋ʃIuWFNgB
   * @throws AssertionError k͕sȏꍇifobO[ĥ݁jB
   */
  public void testStarted(CaseResult root)
  {
    assert (root != null) : "@param:root is null.";
    assert (root instanceof _CaseResult) :
      "@param:current is not an instance of _CaseResult.";

    output(new _PrintEvent(
      _PrintEventType.TEST_STARTED, ((_CaseResult) root).getId()));
  }

  /**
   * Ŝ̏IɌĂяo郁\bhB
   *
   * @param  root ŏʂ̎P[X茋ʃIuWFNgB
   * @throws AssertionError k͕sȏꍇifobO[ĥ݁jB
   */
  public void testEnded(CaseResult root)
  {
    assert (root != null) : "@param:root is null.";
    assert (root instanceof _CaseResult) :
      "@param:current is not an instance of _CaseResult.";

    output(new _PrintEvent(
      _PrintEventType.TEST_ENDED, ((_CaseResult) root).getId()));
  }

  /**
   * P[X̊JnɌĂяo郁\bhB
   *
   * @param  current Jn鎎P[X̔茋ʃIuWFNgB
   * @throws AssertionError k͕sȏꍇifobO[ĥ݁jB
   */
  public void caseStarted(CaseResult current)
  {
    assert (current != null) : "@param:current is null.";
    assert (current instanceof _CaseResult) :
      "@param:current is not an instance of _CaseResult.";

    output(new _PrintEvent(
      _PrintEventType.CASE_STARTED, ((_CaseResult) current).getId()));
  }
  
  /**
   * P[X̏IɌĂяo郁\bhB
   *
   * @param  current I鎎P[X̔茋ʃIuWFNgB
   * @throws AssertionError k͕sȏꍇifobO[ĥ݁jB
   */
  public void caseEnded(CaseResult current)
  {
    assert (current != null) : "@param:current is null.";
    assert (current instanceof _CaseResult) :
      "@param:current is not an instance of _CaseResult.";

    output(new _PrintEvent(
      _PrintEventType.CASE_ENDED, ((_CaseResult) current).getId()));
  }

  /**
   * 肪sꂽɌĂяo郁\bhB
   *
   * @param  check 茋ʃIuWFNgB
   * @param  current ݂̎P[X̔茋ʃIuWFNgB
   * @throws AssertionError k͕sȏꍇifobO[ĥ݁jB
   */
  public void checkOccured(CheckResult check, CaseResult current)
  {
    assert (check != null) : "@param:check is null.";
    assert (current != null) : "@param:current is null.";
    assert (current instanceof _CaseResult) :
      "@param:current is not an instance of _CaseResult.";

    output(new _PrintEvent(
      _PrintEventType.CHECK_OCCURED, ((_CaseResult) current).getId(), check));
  }

  /**
   * bZ[W̓o^ꍇɌĂяo郁\bhB
   *
   * @param  msg o^郁bZ[WB
   * @param  current ݂̎P[X̔茋ʃIuWFNgB
   * @throws AssertionError k͕sȏꍇifobO[ĥ݁jB
   */
  public void messageNoted(String msg, CaseResult current)
  {
    assert (msg != null) : "@param:msg is null.";
    assert (current != null) : "@param:current is null.";
    assert (current instanceof _CaseResult) :
      "@param:current is not an instance of _CaseResult.";

    output(new _PrintEvent(
      _PrintEventType.MESSAGE_NOTED, ((_CaseResult) current).getId(), msg));
  }

  /**
   * ̒fɌĂяo郁\bhB
   *
   * @param  current ݂̎P[X̔茋ʃIuWFkƁB
   * @throws AssertionError k͕sȏꍇifobO[ĥ݁jB
   */
  public void testStopped(CaseResult current)
  {
    assert (current != null) : "@param:current is null.";
    assert (current instanceof _CaseResult) :
      "@param:current is not an instance of _CaseResult.";

    output(new _PrintEvent(
      _PrintEventType.TEST_STOPPED, ((_CaseResult) current).getId()));
  }

  /**
   * P[X茋ʂɑ΂Cxg̓eAOɏo͂B
   *
   * @param  event CxgIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected static void output(_PrintEvent event)
  {
    try {
      ObjectWriter.outputObject(event);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
