/*
 * PrinterGroupBaseTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.print;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.*;
import java.util.*;

/**
 * <code>PrinterGroupBase</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:52 $
 */
public class PrinterGroupBaseTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup printerGroup = new PrinterGroup();
      printerGroup.addPrinter(new ConsolePrinter());
      printerGroup.addPrinter(new ConsolePrinter());
      printerGroup.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(printerGroup);

      run(PrinterGroupBaseTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  private ObjectInspector oi_ = new ObjectInspector(this);
  private List<Printer> printerLst_  = new ArrayList<Printer>();
  private Map<CaseResult, Printer> caseToPrinterMap_ =
    new HashMap<CaseResult, Printer>();

  public PrinterGroupBaseTest()
  {
    oi_.expect("printerLst_", printerLst_);
    oi_.expect("caseToPrinterMap_", caseToPrinterMap_);
    oi_.expect("isStopped_", false);
  }

  protected void preInvocation(String method)
  {
    printerLst_.clear();
    caseToPrinterMap_.clear();
    oi_.expect("isStopped_", false);
  }

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgRXgN^B");

    PrinterGroupBase o = new PrinterGroupBase();
    NOTNULL(o);
  }

  public void addPrinter()
  {
    MSG("PrinterIuWFNg̒ǉB");

    PrinterGroupBase pg = new PrinterGroupBase();
    EQUAL(pg.printerList().size(), 0);

    ConsolePrinter p1 = new ConsolePrinter(); 
    ConsolePrinter p2 = new ConsolePrinter();
    printerLst_.add(p1);
    printerLst_.add(p2);

    pg.addPrinter(p1);
    pg.addPrinter(p2);
    oi_.inspect(pg);

    List lst = pg.printerList();
    EQUAL(lst.size(), 2);
    EQUAL(lst.get(0), p1);
    EQUAL(lst.get(1), p2);
  }

  public void addPrinter_1()
  {
    MSG("k̏ꍇB");

    PrinterGroupBase pg = new PrinterGroupBase();
    try {
      pg.addPrinter(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setStopped()
  {
    MSG("ftO̐ݒ");

    ConsolePrinter p1 = new ConsolePrinter();
    ConsolePrinter p2 = new ConsolePrinter();
    printerLst_.add(p1);
    printerLst_.add(p2);

    PrinterGroupBase pg = new PrinterGroupBase();
    pg.addPrinter(p1);
    pg.addPrinter(p2);
    FALSE(pg.isStopped());
    FALSE(p1.isStopped());
    FALSE(p2.isStopped());

    pg.setStopped(true);
    TRUE(pg.isStopped());
    TRUE(p1.isStopped());
    TRUE(p2.isStopped());

    pg.setStopped(false);
    FALSE(pg.isStopped());
    FALSE(p1.isStopped());
    FALSE(p2.isStopped());
  }

  public void createCaseResult()
  {
    MSG("P[XIuWFNg̍쐬B");

    final List<CaseResult> caseLst = new ArrayList<CaseResult>();
    class ConsolePrinterEx extends ConsolePrinter {
      public CaseResult createCaseResult(String name, CaseResult parent) {
        CaseResult cr = super.createCaseResult(name, parent);
        caseLst.add(cr);
        return cr;
      }
    }

    PrinterGroupBase pg = new PrinterGroupBase();
    CaseResult cr = pg.createCaseResult("abc", CaseResult.NULL);
    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("caseLst_", caseLst);
    oi.expect("name_", "abc");
    oi.expect("messageBuf_", new StringBuffer());
    oi.expect("parent_", CaseResult.NULL);
    oi.expect("NULL", CaseResult.NULL);
    oi.inspect(cr);

    ConsolePrinter p0 = new ConsolePrinterEx();
    ConsolePrinter p1 = new ConsolePrinterEx();

    pg.addPrinter(p0);
    pg.addPrinter(p1);
    cr = pg.createCaseResult("def", CaseResult.NULL);
    oi.expect("name_", "def");
    oi.expect("messageBuf_", new StringBuffer());
    oi.inspect(cr);
    EQUAL(caseLst.size(), 2);
    EQUAL(caseLst.get(0).getClass().getName(),
      "ts.tester.function.print.ConsolePrinterBase$_CaseResult");
    EQUAL(caseLst.get(1).getClass().getName(),
      "ts.tester.function.print.ConsolePrinterBase$_CaseResult");
  }

  public void CaseResultGroup_addMessage()
  {
    PrinterGroupBase printer = new PrinterGroupBase();
    ConsolePrinter prt0 = new ConsolePrinter();
    ConsolePrinter prt1 = new ConsolePrinter();
    printer.addPrinter(prt0);
    printer.addPrinter(prt1);

    CaseResult cr = printer.createCaseResult("aaa", CaseResult.NULL);
    EQUAL(cr.getClass().getName(),
      "ts.tester.function.print.PrinterGroupBase$CaseResultGroup");

    cr.addMessage("");
    EQUAL(cr.getMessage(), "\r\n");
  }

  public void CaseResultGroup_count()
  {
    PrinterGroupBase printer = new PrinterGroupBase();
    CaseResult cr = printer.createCaseResult("aaa", CaseResult.NULL);
    EQUAL(cr.count(ResultType.NG), 0);

    ConsolePrinter prt0 = new ConsolePrinter();
    ConsolePrinter prt1 = new ConsolePrinter();
    printer.addPrinter(prt0);
    printer.addPrinter(prt1);

    cr = printer.createCaseResult("aaa", CaseResult.NULL);
    EQUAL(cr.count(ResultType.NG), 0);

    cr.addChildResult(CheckResult.NG());
    EQUAL(cr.count(ResultType.NG), 1);

    CaseResult cr1 = printer.createCaseResult("bbb", cr);
    EQUAL(cr1.count(ResultType.NG), 0);

    cr1.addChildResult(CheckResult.NG());
    EQUAL(cr1.count(ResultType.NG), 1);

    cr.addChildResult(cr1);
    EQUAL(cr.count(ResultType.NG), 2);
  }

  public void testStarted()
  {
    MSG("ʏ̑");

    final List<CaseResult> caseLst = new ArrayList<CaseResult>();
    class ConsolePrinterEx extends ConsolePrinter {
      private String id_;
      ConsolePrinterEx(String id) {
        id_ = id;
      }
      public CaseResult createCaseResult(String name, CaseResult parent) {
        name += " generated by " + id_;
        CaseResult cr = super.createCaseResult(name, parent);
        caseLst.add(cr);
        return cr;
      }
      public void testStarted(CaseResult root) {
        TRUE(root.getName().endsWith(" generated by " + id_));
        super.testStarted(root);
      }
    }

    PrinterGroupBase pg = new PrinterGroupBase();
    CaseResult root = pg.createCaseResult("AAA", CaseResult.NULL);
    EQUAL(caseLst.size(), 0);
    pg.testStarted(root);

    ConsolePrinter p0 = new ConsolePrinterEx("PRT0");
    ConsolePrinter p1 = new ConsolePrinterEx("PRT1");
    ConsolePrinter p2 = new ConsolePrinterEx("PRT2");
    pg.addPrinter(p0);
    pg.addPrinter(p1);
    pg.addPrinter(p2);
    root = pg.createCaseResult("BBB", CaseResult.NULL);
    pg.testStarted(root);
    EQUAL(caseLst.size(), 3);
  }

  public void testEnded()
  {
    MSG("ʏ̑");

    final List<CaseResult> caseLst = new ArrayList<CaseResult>();
    class ConsolePrinterEx extends ConsolePrinter {
      private String id_;
      ConsolePrinterEx(String id) {
        id_ = id;
      }
      public CaseResult createCaseResult(String name, CaseResult parent) {
        name += " generated by " + id_;
        CaseResult cr = super.createCaseResult(name, parent);
        caseLst.add(cr);
        return cr;
      }
      public void testEnded(CaseResult root) {
        TRUE(root.getName().endsWith(" generated by " + id_));
        super.testStarted(root);
      }
    }

    PrinterGroupBase pg = new PrinterGroupBase();
    CaseResult root = pg.createCaseResult("AAA", CaseResult.NULL);
    EQUAL(caseLst.size(), 0);
    pg.testEnded(root);

    ConsolePrinter p0 = new ConsolePrinterEx("PRT0");
    ConsolePrinter p1 = new ConsolePrinterEx("PRT1");
    ConsolePrinter p2 = new ConsolePrinterEx("PRT2");
    pg.addPrinter(p0);
    pg.addPrinter(p1);
    pg.addPrinter(p2);
    root = pg.createCaseResult("CCC", CaseResult.NULL);
    pg.testEnded(root);
    EQUAL(caseLst.size(), 3);
  }

  public void caseStarted()
  {
    MSG("ʏ̑");

    final List<CaseResult> caseLst = new ArrayList<CaseResult>();
    class ConsolePrinterEx extends ConsolePrinter {
      private String id_;
      ConsolePrinterEx(String id) {
        id_ = id;
      }
      public CaseResult createCaseResult(String name, CaseResult parent) {
        name += " generated by " + id_;
        CaseResult cr = super.createCaseResult(name, parent);
        caseLst.add(cr);
        return cr;
      }
      public void caseStarted(CaseResult current) {
        TRUE(current.getName().endsWith(" generated by " + id_));
        super.caseStarted(current);
      }
    }

    PrinterGroupBase pg = new PrinterGroupBase();
    ConsolePrinter p0 = new ConsolePrinterEx("PRT0");
    ConsolePrinter p1 = new ConsolePrinterEx("PRT1");
    ConsolePrinter p2 = new ConsolePrinterEx("PRT2");
    pg.addPrinter(p0);
    pg.addPrinter(p1);
    pg.addPrinter(p2);
    CaseResult root = pg.createCaseResult("AAA", CaseResult.NULL);
    EQUAL(caseLst.size(), 3);
    CaseResult child = pg.createCaseResult("CCC", root);
    EQUAL(caseLst.size(), 6);
    pg.caseStarted(child);
  }

  public void caseEnded()
  {
    MSG("ʏ̑");

    final List<CaseResult> caseLst = new ArrayList<CaseResult>();
    class ConsolePrinterEx extends ConsolePrinter {
      private String id_;
      ConsolePrinterEx(String id) {
        id_ = id;
      }
      public CaseResult createCaseResult(String name, CaseResult parent) {
        name += " generated by " + id_;
        CaseResult cr = super.createCaseResult(name, parent);
        caseLst.add(cr);
        return cr;
      }
      public void caseEnded(CaseResult current) {
        TRUE(current.getName().endsWith(" generated by " + id_));
        super.caseEnded(current);
      }
    }

    PrinterGroupBase pg = new PrinterGroupBase();
    ConsolePrinter p0 = new ConsolePrinterEx("PRT0");
    ConsolePrinter p1 = new ConsolePrinterEx("PRT1");
    ConsolePrinter p2 = new ConsolePrinterEx("PRT2");
    pg.addPrinter(p0);
    pg.addPrinter(p1);
    pg.addPrinter(p2);
    CaseResult root = pg.createCaseResult("AAA", CaseResult.NULL);
    EQUAL(caseLst.size(), 3);
    CaseResult child = pg.createCaseResult("CCC", root);
    EQUAL(caseLst.size(), 6);
    pg.caseEnded(child);
  }

  public void checkOccured()
  {
    MSG("ʏ̑");

    final List<CaseResult> caseLst = new ArrayList<CaseResult>();
    class ConsolePrinterEx extends ConsolePrinter {
      private String id_;
      ConsolePrinterEx(String id) {
        id_ = id;
      }
      @Override
      public CaseResult createCaseResult(String name, CaseResult parent) {
        name += " generated by " + id_;
        CaseResult cr = super.createCaseResult(name, parent);
        caseLst.add(cr);
        return cr;
      }
      @Override
      public void checkOccured(CheckResult check, CaseResult current) {
        TRUE(current.getName().endsWith(" generated by " + id_));
        super.checkOccured(check, current);
      }
    }

    PrinterGroupBase pg = new PrinterGroupBase();
    ConsolePrinter p0 = new ConsolePrinterEx("PRT0");
    ConsolePrinter p1 = new ConsolePrinterEx("PRT1");
    ConsolePrinter p2 = new ConsolePrinterEx("PRT2");
    pg.addPrinter(p0);
    pg.addPrinter(p1);
    pg.addPrinter(p2);
    CaseResult root = pg.createCaseResult("AAA", CaseResult.NULL);
    EQUAL(caseLst.size(), 3);
    CaseResult child = pg.createCaseResult("CCC", root);
    EQUAL(caseLst.size(), 6);
    pg.checkOccured(CheckResult.OK(), child);
  }

  public void messageNoted()
  {
    MSG("ʏ̑");

    final List<CaseResult> caseLst = new ArrayList<CaseResult>();
    class ConsolePrinterEx extends ConsolePrinter {
      private String id_;
      ConsolePrinterEx(String id) {
        id_ = id;
      }
      @Override
      public CaseResult createCaseResult(String name, CaseResult parent) {
        name += " generated by " + id_;
        CaseResult cr = super.createCaseResult(name, parent);
        caseLst.add(cr);
        return cr;
      }
      @Override
      public void messageNoted(String message, CaseResult current) {
        TRUE(current.getName().endsWith(" generated by " + id_));
        super.messageNoted(message, current);
      }
    }

    PrinterGroupBase pg = new PrinterGroupBase();
    ConsolePrinter p0 = new ConsolePrinterEx("PRT0");
    ConsolePrinter p1 = new ConsolePrinterEx("PRT1");
    ConsolePrinter p2 = new ConsolePrinterEx("PRT2");
    pg.addPrinter(p0);
    pg.addPrinter(p1);
    pg.addPrinter(p2);
    CaseResult root = pg.createCaseResult("AAA", CaseResult.NULL);
    EQUAL(caseLst.size(), 3);
    CaseResult child = pg.createCaseResult("CCC", root);
    EQUAL(caseLst.size(), 6);
    pg.messageNoted("bZ[W", child);
  }
}
