/*
 * CountUp class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import java.math.BigDecimal;

/**
 * JEgAbvNXB
 * <br>
 * JE^̒lێAZĂ߂̃\bh
 * pӂĂB
 * JE^̏lyяĺAftHgł͂ꂼ[y
 * {@link java.lang.Long#MAX_VALUE} ɐݒ肳邪ARXgN^Ŏw肷
 * ƂłB
 * <br>
 * ̃NX̒ڂ̃CX^X̓}`XbhɑΉĂȂA
 * {@link ts.util.CountUp#synchronizedCountUp()}\bhgpāA
 * XbhZ[tȃCX^X쐬邱ƂłB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/05/27 16:13:05 $
 */
public class CountUp
{
  /** JE^B */
  private long value_;

  /** lB */
  private long limit_;

  /**
   * ftHgRXgN^B
   * <br>
   * JE^̏l̓[Al{@link java.lang.Long#MAX_VALUE}ƂB
   */
  public CountUp()
  {
    this(0L, Long.MAX_VALUE);
  }

  /**
   * JE^̏lɂƂRXgN^B
   * <br>
   * JE^̏l̓[ƂBJE^̏l[ꍇA
   * ̂܂ܐݒ肷B
   *
   * @param  limit JE^̏lB
   */
  public CountUp(long limit)
  {
    this(0L, limit);
  }

  /**
   * JE^̏lƏlɂƂRXgN^B
   * <br>
   * ll傫ꍇÂ܂ܐݒ肷B
   *
   * @param  init JE^̏lB
   * @param  limit JE^̏lB
   */
  public CountUp(long init, long limit) 
  {
    value_ = init;
    limit_ = limit;
  }

  /**
   * ݂̃JE^l擾B
   *
   * @return ݂̃JE^lB
   */
  public long currentValue()
  {
    return value_;
  }

  /**
   * l擾B
   *
   * @return lB
   */
  public long limitValue()
  {
    return limit_;
  }

  /**
   * JE^̒llɒBǂ𔻒肷B
   *
   * @return JE^̒ll傫ꍇ<tt>true</tt>
   *         AłȂ<tt>false</tt>ԂB
   *
   */
  public boolean isReached()
  {
    return (value_ >= limit_) ? true : false;
  }

  /**
   * JE^ZB
   * <br>
   * JE^̒llzꍇɂ͗OX[B
   *
   * @return Z̃JE^lB
   * @throws OutOfRangeException JE^lzꍇB
   */
  public long increment() throws OutOfRangeException
  {
    if (value_ >= limit_) {
      BigDecimal v = new BigDecimal(String.valueOf(value_));
      v.add(BigDecimal.valueOf(1L));
      BigDecimal e = BigDecimal.valueOf(limit_);
      throw new OutOfRangeException(v, null, e);
    }

    value_ ++;
    return value_;
  }

  /**
   * XbhZ[tȃJEgAbvIuWFNg𐶐B
   * <br>
   * JE^̏l̓[Al<code>Long.MAX_VALUE</code>ƂB
   *
   * @return XbhZ[tȃJEgAbvIuWFNgB
   */
  public static CountUp synchronizedCountUp()
  {
    return synchronizedCountUp(0L, Long.MAX_VALUE);
  }

  /**
   * JE^̏lw肵āAXbhZ[tȃJEgAbvIuWFNg
   * 𐶐B
   * <br>
   * JE^̏l̓[ƂBJE^̏l[ꍇA
   * ̂܂ܐݒ肷B
   * 
   * @param  limit JE^̏lB
   * @return XbhZ[tȃJEgAbvIuWFNgB
   */
  public static CountUp synchronizedCountUp(long limit)
  {
    return synchronizedCountUp(0L, limit);
  }

  /**
   * JE^̏lƏlw肵āAXbhZ[tȃJEgAbv
   * IuWFNg𐶐B
   * <br>
   * ll傫ꍇÂ܂ܐݒ肷B
   *
   * @param  init  JE^̏lB
   * @param  limit JE^̏lB
   * @return XbhZ[tȃJEgAbvIuWFNgB
   */
  public static CountUp synchronizedCountUp(long init, long limit)
  {
    return new CountUp(init, limit) {
      @Override
      public synchronized long currentValue() {
        return super.currentValue();
      }
      @Override
      public synchronized boolean isReached() {
        return super.isReached();
      }
      @Override
      public synchronized long increment() throws OutOfRangeException {
        return super.increment();
      }
    };
  }

  /**
   * w肳ꂽJEgAbvIuWFNǧ݂̒lgpāA
   * XbhZ[tȃJEgAbvIuWFNgVɐB
   *
   * @param  c ɂȂJEgAbvIuWFNgB
   * @return XbhZ[tȃJEgAbvIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public static CountUp synchronizedCountUp(CountUp c)
  {
    assert (c != null) : "@param:c is null.";

    return synchronizedCountUp(c.currentValue(), c.limitValue());
  }
}
