/*
 * FileFilterGroupAndTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.ObjectInspector;
import ts.tester.function.print.*;
import java.io.File;
import java.io.FileFilter;
import java.util.*;

/**
 * {@link ts.util.file.FileFilterGroupAnd FileFilterGroupAnd}NX̋@\NXB
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/05/27 16:13:08 $
 */
public class FileFilterGroupAndTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(FileFilterGroupAndTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("FileFilterGroupAnd NX̋@\sB");
  }
  

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgERXgN^̊mFB");

    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("filterLst_", Collections.EMPTY_LIST);
    try {
      oi.inspect(new FileFilterGroupAnd());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void addFilter()
  {
    MSG("qtB^̒ǉ̊mFB");

    List<FileFilter> lst = new LinkedList<FileFilter>();

    ObjectInspector oi = new ObjectInspector(this);
    oi.expect("filterLst_", lst);

    FileFilterGroupAnd filterAnd = new FileFilterGroupAnd();

    FileFilter child = new FileSizeFilter(0, 1024*1024);
    filterAnd.addFilter(child);
    lst.add(child);

    try {
      oi.inspect(filterAnd);
    } catch (Exception e) {
      NG(e);
    }

    FileFilter child2 = new FileTypeFilter(FileType.Directory);
    filterAnd.addFilter(child2);
    lst.add(child2);

    try {
      oi.inspect(filterAnd);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void addFilter_1()
  {
    MSG("k̏ꍇB");

    FileFilterGroupAnd filterAnd = new FileFilterGroupAnd();
    try {
      filterAnd.addFilter(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void accept()
  {
    MSG("̊mFB");

    FileFilterGroupAnd filterAnd = new FileFilterGroupAnd();
    TRUE(filterAnd.accept(new File("./src")));
    TRUE(filterAnd.accept(new File("./src/javadoc.css")));

    filterAnd.addFilter(new FileTypeFilter(FileType.File));
    FALSE(filterAnd.accept(new File("./src")));
    TRUE(filterAnd.accept(new File("./src/javadoc.css")));

    filterAnd.addFilter(new FileSizeFilter(0, 0));
    FALSE(filterAnd.accept(new File("./src")));
    FALSE(filterAnd.accept(new File("./src/javadoc.css")));

    filterAnd.addFilter(new FileSizeFilter(0, 1024*1024));
    FALSE(filterAnd.accept(new File("./src")));
    FALSE(filterAnd.accept(new File("./src/javadoc.css")));
  }

  public void accept_1()
  {
    MSG("k̏ꍇB");

    FileFilterGroupAnd filterAnd = new FileFilterGroupAnd();
    try {
      filterAnd.accept(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }
}

