/*
 * FileTypeFilter class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.file;

import java.io.File;
import java.io.FileFilter;

/**
 * t@CE^CvƂt@CEtB^ENX
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2007/05/27 16:13:12 $
 */
public class FileTypeFilter implements FileFilter
{
  /** Ƃt@CE^CvB */
  private FileType type_ ;

  /**
   * t@CE^CvɂƂRXgN^B
   *
   * @param  type Ƃt@CE^CvB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB 
   */
  public FileTypeFilter(FileType type)
  {
    assert (type != null) : "@param:type is null.";

    type_ = type;
  }

  /**
   * w肳ꂽt@CÃIuWFNgƂt@CE^CvɊY 
   * 邩ǂ𔻒肷B
   *
   * @param  file Ώۂ̃t@CB
   * @return t@CE^CvYꍇ<tt>true</tt>ԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public boolean accept(File file)
  {
    assert (file != null) : "@param:file is null.";

    if (FileType.Directory.equals(type_)) {
      if (! file.isDirectory()) {
        return false;
      }
    }
    else {
      if (! file.isFile()) {
        return false;
      }
    }

    return true;
  }
}

