/*
 * ResultTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;

/**
 * <code>Result</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:50 $
 */
public class ResultTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(ResultTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- inner class -- */

  class ResultEx extends Result
  {
    public ResultEx() {
    }
    @Override public int count(ResultType type) {
      return 10;
    }
  }

  /* -- test case -- */

  public void constructor()
  {
    ResultEx result = new ResultEx();
    NOTNULL(result);
    EQUAL(result.getName(), "");
  }

  public void setName()
  {
    Result result = new ResultEx();
    result.setName("ABC");
    NOTNULL(result);
    EQUAL(result.getName(), "ABC");
  }

  public void setName_1()
  {
    Result result = new ResultEx();
    try {
      result.setName(null);
    } catch (AssertionError e) {
      OK(e.toString());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void count_type()
  {
    ResultEx result = new ResultEx();
    EQUAL(result.count(ResultType.NG), 10);
  }
}
