/*
 * _CaseIdentifier class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.coverage;

import ts.tester.util.ObjectSerializer;
import ts.util.CountRotate;
import java.io.Serializable;

/**
 * P[XʃNXB 
 * <br>
 * P[X茋ʃIuWFNgJxbWvZX̓OŎʂ邽߂
 * NXłB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:50 $
 */
class _CaseIdentifier implements Serializable
{
  /** VAԍB */
  static final long serialVersionUID = -7180652586927001379L;

  /** ʔԍJE^B */
  private static CountRotate counter_ = CountRotate.synchronizedCountRotate();

  /** P[XB */
  private String caseName_ = "";

  /** ʔԍB */
  long idNo_ = 0L;

  /**
   * ftHgRXgN^B
   */
  protected _CaseIdentifier()
  {}

  /**
   * P[XɂƂRXgN^B
   *
   * @param  name P[XB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  public _CaseIdentifier(String name)
  {
    assert (name != null) : "@param:name is null.";

    caseName_ = name;
    idNo_ = counter_.increment();
  }

  /**
   * P[X擾B
   *
   * @return P[XB
   */
  public String getCaseName()
  {
    return caseName_ ;
  }

  /**
   * nbVR[h擾B
   *
   * @return nbVR[hB
   */
  public int hashCode()
  {
    return (int) idNo_;
  }

  /**
   * ̃IuWFNg̒l̃IuWFNgƓǂ𔻒肷B
   * <br>
   * ̃IuWFNg̃NX܂͂̔hNX̃CX^XłA
   * ɎĂ鎯ʔԍvꍇɓƂB
   *
   * @param  rIuWFNgB
   * @return ꍇ<tt>true</tt>ԂB
   */
  public boolean equals(Object obj)
  {
    if (obj == null) {
      return false;
    }

    if (! (obj instanceof _CaseIdentifier)) {
      return false;
    }

    _CaseIdentifier cid = (_CaseIdentifier) obj;
    return (this.idNo_ == cid.idNo_) ? true : false;
  }
}
