/*
 * HtmlPrinterTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.print;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.ObjectInspector;
import ts.tester.function.print.*;
import ts.tester.function.*;
import ts.tester.coverage.LineCoverage;
import ts.tester.coverage.Coverage;
import ts.util.resource.*;
import ts.util.*;
import java.io.*;
import java.util.*;

/**
 * <code>HtmlPrinter</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.3 $, $Date: 2007/06/25 16:07:41 $
 */
public class HtmlPrinterTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(HtmlPrinterTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  protected void preTesting()
  {
    MSG("HtmlPrinterNX̋@\sB");
  }

  /* -- test case -- */

  public void constructor()
  {
    MSG("ftHgRXgN^(protected)̊mFB");

    HtmlPrinter printer = new HtmlPrinter();
    NOTNULL(printer);
    TRUE(printer instanceof HtmlPrinterBase);
    TRUE(printer instanceof ts.tester.coverage.CoveragePrinter);
    EQUAL(printer.getTesterName(), "");
    EQUAL(printer.getResource(), ts.util.resource.Resource.EMPTY);
  }

  public void constructor_testerName()
  {
    MSG("{ҖɂƂRXgN^̊mFB");

    HtmlPrinter printer = new HtmlPrinter("My Name");
    NOTNULL(printer);
    EQUAL(printer.getTesterName(), "My Name");
    FALSE(printer.getResource().equals(Resource.EMPTY));
  }

  public void constructor_testerName_0()
  {
    MSG("k̏ꍇB");
    try {
      HtmlPrinter printer = new HtmlPrinter(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_testerName_resource()
  {
    MSG("{҂ƃ\[XɂƂRXgN^̊mFB");

    try {
      String path = "classes/ts/tester/function/print/html.properties";
      PropertyResource res = new PropertyResource(path);
      HtmlPrinter printer = new HtmlPrinter("My Name", res);
      EQUAL(printer.getTesterName(), "My Name");

      File file1 = new File(res.getPath());
      File file2 = new File(path);
      EQUAL(file1.getAbsolutePath(), file2.getAbsolutePath());
    } catch (Exception e) {
      NG(e);
    }
  }

  public void constructor_testerName_res_0()
  {
    MSG("k̏ꍇB");
    try {
      HtmlPrinter printer = new HtmlPrinter("My Name", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      String path = "classes/ts/tester/function/print/html.properties";
      PropertyResource res = new PropertyResource(path);
      HtmlPrinter printer = new HtmlPrinter(null, res);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void prepareCoverage()
  {
    MSG("JobWv̏mFB");
    ObjectInspector oi = new ObjectInspector(this);
    oi.ignore("KEY_COVERAGE_HEADER");
    oi.ignore("KEY_COVERAGE_FOOTER");
    oi.ignore("KEY_CLASS_COVERAGE_PREMETHODS");
    oi.ignore("KEY_CLASS_COVERAGE_POSTMETHODS");
    oi.ignore("KEY_METHOD_COVERAGE");
    oi.ignore("FMT_SRC_COVERAGE");
    oi.ignore("FMT_CLASS_COVERAGE");
    oi.ignore("FMT_METHOD_COVERAGE");
    oi.ignore("OPT_NAME");
    oi.ignore("OPT_LASTNAME");
    oi.ignore("OPT_PACKAGEDIR");
    oi.ignore("OPT_INDEX");
    oi.ignore("OPT_LINES");
    oi.ignore("OPT_PASSED");
    oi.ignore("OPT_UNPASSED");
    oi.ignore("OPT_PASSED_RATIO");
    oi.ignore("OPT_UNPASSED_RATIO");
    oi.ignore("OPT_PASSED_LINES");
    oi.ignore("OPT_UNPASSED_LINES");
    oi.ignore("KEY_TOFILE");
    oi.ignore("KEY_HEADER");
    oi.ignore("KEY_PRECASES");
    oi.ignore("KEY_CASE");
    oi.ignore("KEY_POSTCASES");
    oi.ignore("KEY_FOOTER");
    oi.ignore("PREFIX_CHAR");
    oi.ignore("EOL");
    oi.ignore("FMT_TEST");
    oi.ignore("FMT_CASE");
    oi.ignore("OPT_NAME");
    oi.ignore("OPT_TESTER");
    oi.ignore("OPT_DATE");
    oi.ignore("OPT_JUDGE");
    oi.ignore("OPT_CHECK");
    oi.ignore("OPT_GOOD");
    oi.ignore("OPT_NOGOOD");
    oi.ignore("OPT_KNOWNBUG");
    oi.ignore("OPT_CHILD");
    oi.ignore("OPT_EMPTY");
    oi.ignore("OPT_INCOMPLETE");
    oi.ignore("OPT_INDEX");
    oi.ignore("OPT_MESSAGE");
    oi.ignore("htmlRes_");
    oi.expect("replacedMap_", new HashMap<String,Object>());
    oi.expect("isStopped_", false);
    oi.expect("coverage_", null);
    oi.expect("testerName_", "");

    HtmlPrinter printer = new HtmlPrinter();
    oi.inspect(printer);

    Coverage coverage = new LineCoverage(getClass());
    printer.prepareCoverage(coverage);
    oi.expect("coverage_", coverage);
    oi.inspect(printer);
  }

  public void postCoverage()
  {
    MSG("JobWv̌㏈̊mFB");

    HtmlPrinter printer = new HtmlPrinter() {
      @Override protected void outputHtmlFileForCoverage() {
        OK();
      }
    };
    printer.postCoverage(null);

    HtmlPrinter printer2 = new HtmlPrinter();
    printer2.postCoverage(null);
  }

  public void entryLine()
  {
    MSG("so^̏̊mFiĂȂjB");
    HtmlPrinter printer = new HtmlPrinter();
    printer.entryLine(null);
    OK();
  }

  public void entryClass()
  {
    MSG("NXo^̏̊mFiĂȂjB");
    HtmlPrinter printer = new HtmlPrinter();
    printer.entryClass(null);
    OK();
  }

  public void entryMethod()
  {
    MSG("\bhĂяȍ̊mFiĂȂjB");
    HtmlPrinter printer = new HtmlPrinter();
    printer.entryMethod(null);
    OK();
  }

  public void exitMethod()
  {
    MSG("\bhȈ̊mF(ĂȂjB");
    HtmlPrinter printer = new HtmlPrinter();
    printer.exitMethod(null);
    OK();
  }

  public void passLine()
  {
    MSG("s̒ǉ̏̊mFiĂȂjB");
    HtmlPrinter printer = new HtmlPrinter();
    printer.passLine(null);
    OK();
  }

  public void outputHtmlFile()
  {
    MSG("wqli[}bvݒ");

    ObjectInspector oi = new ObjectInspector(this);
    oi.ignore("KEY_COVERAGE_HEADER");
    oi.ignore("KEY_COVERAGE_FOOTER");
    oi.ignore("KEY_CLASS_COVERAGE_PREMETHODS");
    oi.ignore("KEY_CLASS_COVERAGE_POSTMETHODS");
    oi.ignore("KEY_METHOD_COVERAGE");
    oi.ignore("FMT_SRC_COVERAGE");
    oi.ignore("FMT_CLASS_COVERAGE");
    oi.ignore("FMT_METHOD_COVERAGE");
    oi.ignore("OPT_NAME");
    oi.ignore("OPT_LASTNAME");
    oi.ignore("OPT_PACKAGEDIR");
    oi.ignore("OPT_INDEX");
    oi.ignore("OPT_LINES");
    oi.ignore("OPT_PASSED");
    oi.ignore("OPT_UNPASSED");
    oi.ignore("OPT_PASSED_RATIO");
    oi.ignore("OPT_UNPASSED_RATIO");
    oi.ignore("OPT_PASSED_LINES");
    oi.ignore("OPT_UNPASSED_LINES");
    oi.ignore("KEY_TOFILE");
    oi.ignore("KEY_HEADER");
    oi.ignore("KEY_PRECASES");
    oi.ignore("KEY_CASE");
    oi.ignore("KEY_POSTCASES");
    oi.ignore("KEY_FOOTER");
    oi.ignore("PREFIX_CHAR");
    oi.ignore("EOL");
    oi.ignore("FMT_TEST");
    oi.ignore("FMT_CASE");
    oi.ignore("OPT_NAME");
    oi.ignore("OPT_TESTER");
    oi.ignore("OPT_DATE");
    oi.ignore("OPT_JUDGE");
    oi.ignore("OPT_CHECK");
    oi.ignore("OPT_GOOD");
    oi.ignore("OPT_NOGOOD");
    oi.ignore("OPT_KNOWNBUG");
    oi.ignore("OPT_CHILD");
    oi.ignore("OPT_EMPTY");
    oi.ignore("OPT_INCOMPLETE");
    oi.ignore("OPT_INDEX");
    oi.ignore("OPT_MESSAGE");
    oi.ignore("htmlRes_");
    oi.expect("replacedMap_", new HashMap<String,Object>());
    oi.expect("isStopped_", false);
    oi.expect("coverage_", null);
    oi.expect("testerName_", "");

    HtmlPrinter printer = new HtmlPrinter();
    oi.inspect(printer);

    Map<String,Object> repMap = new HashMap<String,Object>();
    repMap.put("aaa", "AAA");
    repMap.put("bbb", "BBB");

    printer.outputHtmlFile(repMap);
    oi.expect("replacedMap_", repMap);
    oi.inspect(printer);
  }

  public void outputHtmlFileForCoverage()
  {
    MSG("ʂHTMLt@Cɏo͂鏈̊mFB");

    final String PATH = "test/aaa.html";
    
    PropertyResource res = new PropertyResource();
    res.setFirstValue("printer.html.toFile", PATH);

    HtmlPrinter printer = new HtmlPrinter("My Name", res);

    Map<String, Object> objMap = new HashMap<String, Object>();

    CaseResult c0 = printer.createCaseResult("a0", CaseResult.NULL);
    objMap.put("test", c0);

    CaseResult c1 = printer.createCaseResult("a1", c0);
    c0.addChildResult(c1);

    CaseResult c2 = printer.createCaseResult("a2", c0);
    c0.addChildResult(c2);

    LineCoverage coverage = new LineCoverage(getClass()) {
      @Override
      public Collection<String> allClassNames() {
        List<String> lst = new ArrayList<String>();
        lst.add("java.lang.String");
        lst.add("java.lang.Integer");
        return lst;
      }
      @Override
      public Collection<Coverage.MethodKey> methodKeysOf(String className) {
        List<Coverage.MethodKey> lst = new ArrayList<Coverage.MethodKey>();
        if ("java.lang.String".equals(className)) {
          lst.add(new Coverage.MethodKey(className, "length", ""));
          lst.add(new Coverage.MethodKey(className, "indexOf", "char"));
        }
        else {
          lst.add(new Coverage.MethodKey(className, "intValue", ""));
          lst.add(new Coverage.MethodKey(className, "parseInt",
            "java.lang.String"));
        }
        return lst;
      }
    };
    printer.prepareCoverage(coverage);
    printer.outputHtmlFile(objMap);
    printer.postCoverage(coverage);

    try {
      File f = new File(PATH);
      TRUE(f.exists());
      f.delete();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void outputHtmlFile_0()
  {
    MSG("k̏ꍇB");

    HtmlPrinter printer = new HtmlPrinter("My Name");
    try {
      printer.outputHtmlFile(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void outputHtmlFileForCoverage_1()
  {
    MSG("HTMLt@C̃pXsȏꍇB");

    final String PATH = "z:/text/aaa.html";

    PropertyResource res = new PropertyResource();
    res.setFirstValue("printer.html.toFile", PATH);

    HtmlPrinter printer = new HtmlPrinter("My Name", res);

    Map<String, Object> objMap = new HashMap<String, Object>();

    CaseResult c0 = printer.createCaseResult("a0", CaseResult.NULL);
    objMap.put("test", c0);

    CaseResult c1 = printer.createCaseResult("a1", c0);
    c0.addChildResult(c1);

    CaseResult c2 = printer.createCaseResult("a2", c0);
    c0.addChildResult(c2);

    printer.outputHtmlFile(objMap);
    printer.outputHtmlFileForCoverage();

    try {
      File f = new File(PATH);
      FALSE(f.exists());
      f.delete();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void replaceArgument_arg_objMap()
  {
    MSG("wqϊ郁\bh̊mFB");
    MSG("k̏ꍇB");

    Map<String, Object> objMap = new HashMap<String, Object>();

    HtmlPrinter printer = new HtmlPrinter();
    try {
      printer.replaceArgument(null, objMap);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }

    try {
      printer.replaceArgument("aaa", null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void replaceArgument_arg_objMap_1()
  {
    MSG("wqϊ郁\bh̊mF(class-coverage.*)B");

    Map<String, Object> objMap = new HashMap<String, Object>();
    objMap.put("class-coverage", "AAA");
    objMap.put("class-coverage.index", new CountUp(12, 12));

    final ts.tester.coverage.PassResult<Integer> passRes =
      new ts.tester.coverage.PassResult<Integer>() {
        @Override public int getPassCountOfResult(Integer line) {
          switch (line) {
          case 111:
          case 121:
          case 131: return 1;
          case 112:
          case 122:
          case 132: return 0;
          default:  return 0;
          }
        }
      };
    final ts.tester.coverage.CaseResult<Integer> classRes =
      new ts.tester.coverage.CaseResult<Integer>(passRes) {
        @Override public int countAllResults() {
          return 10;
        }
        @Override public int countPassedResults() {
          return 6;
        }
        @Override public float passedRatio() {
          return 0.23f;
        }
        @Override public Enumeration<Integer> enumPassedResultKeys() {
          List<Integer> lst = new ArrayList<Integer>(3);
          lst.add(111);
          lst.add(121);
          lst.add(131);
          return Collections.enumeration(lst);
        }
        @Override public Enumeration<Integer> enumNotPassedResultKeys() {
          List<Integer> lst = new ArrayList<Integer>(3);
          lst.add(112);
          lst.add(122);
          lst.add(132);
          return Collections.enumeration(lst);
        }
      };

    LineCoverage coverage = new LineCoverage(getClass()) {
      @Override public ts.tester.coverage.PassResult<Integer>
      getPassResult(String srcPath) {
        return passRes;
      }
      @Override public ts.tester.coverage.CaseResult<Integer>
      getClassResult(String s, ts.tester.coverage.Result<Integer> pr) {
        return classRes;
      }
      @Override public List<String> allSourcePaths() {
        List<String> srcL = new ArrayList<String>(1);
        srcL.add("");
        return srcL;
      }
    };

    HtmlPrinter printer = new HtmlPrinter();
    printer.prepareCoverage(coverage);

    EQUAL(printer.replaceArgument("class-coverage.name", objMap), "AAA");
    EQUAL(printer.replaceArgument("class-coverage.lastname", objMap), "AAA");
    EQUAL(printer.replaceArgument("class-coverage.package-dir", objMap), ".");
    EQUAL(printer.replaceArgument("class-coverage.index", objMap), "12");
    EQUAL(printer.replaceArgument("class-coverage.lines", objMap), "10");
    EQUAL(printer.replaceArgument("class-coverage.passed", objMap), "6");
    EQUAL(printer.replaceArgument("class-coverage.unpassed", objMap), "4");
    EQUAL(printer.replaceArgument("class-coverage.passed-ratio", objMap), "23");
    EQUAL(printer.replaceArgument("class-coverage.unpassed-ratio", objMap), "77");
    EQUAL(printer.replaceArgument("class-coverage.passed-lines", objMap), " 111 121 131");
    EQUAL(printer.replaceArgument("class-coverage.unpassed-lines", objMap), " 112 122 132");
  }

  public void replaceArgument_arg_objMap_11()
  {
    MSG("class-coverageL[ݒ肳ĂȂꍇ");

    Map<String, Object> objMap = new HashMap<String, Object>();
//    objMap.put("class-coverage", "AAA");
    objMap.put("class-coverage.index", new CountUp(12, 12));

    final ts.tester.coverage.PassResult<Integer> passRes =
      new ts.tester.coverage.PassResult<Integer>() {
        @Override public int getPassCountOfResult(Integer line) {
          switch (line) {
          case 111:
          case 121:
          case 131: return 1;
          case 112:
          case 122:
          case 132: return 0;
          default:  return 0;
          }
        }
      };
    final ts.tester.coverage.CaseResult<Integer> classRes =
      new ts.tester.coverage.CaseResult<Integer>(passRes) {
        @Override public int countAllResults() {
          return 10;
        }
        @Override public int countPassedResults() {
          return 6;
        }
        @Override public float passedRatio() {
          return 0.23f;
        }
        @Override public Enumeration<Integer> enumPassedResultKeys() {
          List<Integer> lst = new ArrayList<Integer>(3);
          lst.add(111);
          lst.add(121);
          lst.add(131);
          return Collections.enumeration(lst);
        }
        @Override public Enumeration<Integer> enumNotPassedResultKeys() {
          List<Integer> lst = new ArrayList<Integer>(3);
          lst.add(112);
          lst.add(122);
          lst.add(132);
          return Collections.enumeration(lst);
        }
      };

    LineCoverage coverage = new LineCoverage(getClass()) {
      @Override public ts.tester.coverage.PassResult<Integer>
      getPassResult(String srcPath) {
        return passRes;
      }
      @Override public ts.tester.coverage.CaseResult<Integer>
      getClassResult(String s, ts.tester.coverage.Result<Integer> pr) {
        return classRes;
      }
      @Override public List<String> allSourcePaths() {
        List<String> srcL = new ArrayList<String>(1);
        srcL.add("");
        return srcL;
      }
    };

    HtmlPrinter printer = new HtmlPrinter();
    printer.prepareCoverage(coverage);

    EQUAL(printer.replaceArgument("class-coverage.name", objMap), "--");
    EQUAL(printer.replaceArgument("class-coverage.index", objMap), "--");
    EQUAL(printer.replaceArgument("class-coverage.lines", objMap), "--");
    EQUAL(printer.replaceArgument("class-coverage.passed", objMap), "--");
    EQUAL(printer.replaceArgument("class-coverage.unpassed", objMap), "--");
    EQUAL(printer.replaceArgument("class-coverage.passed-ratio", objMap), "--");
    EQUAL(printer.replaceArgument("class-coverage.unpassed-ratio", objMap), "--");
    EQUAL(printer.replaceArgument("class-coverage.passed-lines", objMap), "--");
    EQUAL(printer.replaceArgument("class-coverage.unpassed-lines", objMap), "--");
  }

  public void replaceArgument_arg_objMap_2()
  {
    MSG("wqϊ郁\bh̊mF(method-coverage.*)B");

    Coverage.MethodKey mk = new Coverage.MethodKey("CCC", "MMM", "");

    Map<String, Object> objMap = new HashMap<String, Object>();
    objMap.put("method-coverage", mk);
    objMap.put("method-coverage.index", new CountUp(23, 23));

    final ts.tester.coverage.PassResult<Integer> passRes =
      new ts.tester.coverage.PassResult<Integer>() {
        @Override public int getPassCountOfResult(Integer line) {
          switch (line) {
          case 111:
          case 121:
          case 131: return 1;
          case 112:
          case 122:
          case 132: return 0;
          default:  return 0;
          }
        }
      };
    final ts.tester.coverage.CaseResult<Integer> classRes =
      new ts.tester.coverage.CaseResult<Integer>(passRes);
    final ts.tester.coverage.CaseResult<Integer> methodRes =
      new ts.tester.coverage.CaseResult<Integer>(passRes) {
        @Override public int countAllResults() {
          return 10;
        }
        @Override public int countPassedResults() {
          return 6;
        }
        @Override public float passedRatio() {
          return 0.23f;
        }
        @Override public Enumeration<Integer> enumPassedResultKeys() {
          List<Integer> lst = new ArrayList<Integer>(3);
          lst.add(111);
          lst.add(121);
          lst.add(131);
          return Collections.enumeration(lst);
        }
        @Override public Enumeration<Integer> enumNotPassedResultKeys() {
          List<Integer> lst = new ArrayList<Integer>(3);
          lst.add(112);
          lst.add(122);
          lst.add(132);
          return Collections.enumeration(lst);
        }
      };

    LineCoverage coverage = new LineCoverage(getClass()) {
      @Override public ts.tester.coverage.PassResult<Integer>
      getPassResult(String srcPath) {
        return passRes;
      }
      @Override public ts.tester.coverage.CaseResult<Integer>
      getClassResult(String s, ts.tester.coverage.Result<Integer> pr) {
        return classRes;
      }
      @Override public ts.tester.coverage.CaseResult<Integer>
      getMethodResult(Coverage.MethodKey mk,
      ts.tester.coverage.Result classRes) {
        return methodRes;
      }
      @Override public List<String> allSourcePaths() {
        List<String> srcL = new ArrayList<String>(1);
        srcL.add("");
        return srcL;
      }
    };

    HtmlPrinter printer = new HtmlPrinter();
    printer.prepareCoverage(coverage);

    EQUAL(printer.replaceArgument("method-coverage.name", objMap), "MMM");
    EQUAL(printer.replaceArgument("method-coverage.index", objMap), "23");
    EQUAL(printer.replaceArgument("method-coverage.lines", objMap), "10");
    EQUAL(printer.replaceArgument("method-coverage.passed", objMap), "6");
    EQUAL(printer.replaceArgument("method-coverage.unpassed", objMap), "4");
    EQUAL(printer.replaceArgument("method-coverage.passed-ratio", objMap), "23");
    EQUAL(printer.replaceArgument("method-coverage.unpassed-ratio", objMap), "77");
    EQUAL(printer.replaceArgument("method-coverage.passed-lines", objMap), " 111 121 131");
    EQUAL(printer.replaceArgument("method-coverage.unpassed-lines", objMap), " 112 122 132");
  }

  public void replaceArgument_arg_objMap_21()
  {
    MSG("method-coverageL[ݒ肳ĂȂꍇ");

    Coverage.MethodKey mk = new Coverage.MethodKey("CCC", "MMM", "");

    Map<String, Object> objMap = new HashMap<String, Object>();
//    objMap.put("method-coverage", mk);
    objMap.put("method-coverage.index", new CountUp(23, 23));

    final ts.tester.coverage.PassResult<Integer> passRes =
      new ts.tester.coverage.PassResult<Integer>() {
        @Override public int getPassCountOfResult(Integer line) {
          switch (line) {
          case 111:
          case 121:
          case 131: return 1;
          case 112:
          case 122:
          case 132: return 0;
          default:  return 0;
          }
        }
      };
    final ts.tester.coverage.CaseResult<Integer> classRes =
      new ts.tester.coverage.CaseResult<Integer>(passRes);
    final ts.tester.coverage.CaseResult<Integer> methodRes =
      new ts.tester.coverage.CaseResult<Integer>(passRes) {
        @Override public int countAllResults() {
          return 10;
        }
        @Override public int countPassedResults() {
          return 6;
        }
        @Override public float passedRatio() {
          return 0.23f;
        }
        @Override public Enumeration<Integer> enumPassedResultKeys() {
          List<Integer> lst = new ArrayList<Integer>(3);
          lst.add(111);
          lst.add(121);
          lst.add(131);
          return Collections.enumeration(lst);
        }
        @Override public Enumeration<Integer> enumNotPassedResultKeys() {
          List<Integer> lst = new ArrayList<Integer>(3);
          lst.add(112);
          lst.add(122);
          lst.add(132);
          return Collections.enumeration(lst);
        }
      };

    LineCoverage coverage = new LineCoverage(getClass()) {
      @Override public ts.tester.coverage.PassResult<Integer>
      getPassResult(String srcPath) {
        return passRes;
      }
      @Override public ts.tester.coverage.CaseResult<Integer>
      getClassResult(String s, ts.tester.coverage.Result<Integer> pr) {
        return classRes;
      }
      @Override public ts.tester.coverage.CaseResult<Integer>
      getMethodResult(Coverage.MethodKey mk,
      ts.tester.coverage.Result classRes) {
        return methodRes;
      }
      @Override public List<String> allSourcePaths() {
        List<String> srcL = new ArrayList<String>(1);
        srcL.add("");
        return srcL;
      }
    };

    HtmlPrinter printer = new HtmlPrinter();
    printer.prepareCoverage(coverage);

    EQUAL(printer.replaceArgument("method-coverage.name", objMap), "--");
    EQUAL(printer.replaceArgument("method-coverage.index", objMap), "--");
    EQUAL(printer.replaceArgument("method-coverage.lines", objMap), "--");
    EQUAL(printer.replaceArgument("method-coverage.passed", objMap), "--");
    EQUAL(printer.replaceArgument("method-coverage.unpassed", objMap), "--");
    EQUAL(printer.replaceArgument("method-coverage.passed-ratio", objMap), "--");
    EQUAL(printer.replaceArgument("method-coverage.unpassed-ratio", objMap), "--");
    EQUAL(printer.replaceArgument("method-coverage.passed-lines", objMap), "--");
    EQUAL(printer.replaceArgument("method-coverage.unpassed-lines", objMap), "--");
  }

  public void replaceArgument_arg_objMap_3()
  {
    MSG("wqϊ郁\bh̊mF(src-coverage.*)B");

    Map<String, Object> objMap = new HashMap<String, Object>();
    objMap.put("src-coverage.index", new CountUp(34, 34));
    
    final ts.tester.coverage.PassResult<Integer> passRes =
      new ts.tester.coverage.PassResult<Integer>() {
        @Override public int getPassCountOfResult(Integer line) {
          switch (line) {
          case 111:
          case 121:
          case 131:  return 1;
          case 112:
          case 122:
          case 132:  return 0;
          default:   return 0;
          }
        }
        @Override public int countAllResults() {
          return  10;
        }
        @Override public int countPassedResults() {
          return 6;
        }
        @Override public float passedRatio() {
          return 0.88f;
        }
        @Override public Enumeration<Integer> enumPassedResultKeys() {
          List<Integer> lst = new ArrayList<Integer>(3);
          lst.add(111);
          lst.add(121);
          lst.add(131);
          return Collections.enumeration(lst);
        }
        @Override public Enumeration<Integer> enumNotPassedResultKeys() {
          List<Integer> lst = new ArrayList<Integer>(3);
          lst.add(112);
          lst.add(122);
          lst.add(132);
          return Collections.enumeration(lst);
        }
      };

    LineCoverage coverage = new LineCoverage(getClass()) {
      @Override public List<String> allSourcePaths() {
        List<String> srcL = new ArrayList<String>(1);
        srcL.add("PPP");
        return srcL;
      }
      @Override public ts.tester.coverage.PassResult<Integer>
      getPassResult(String srcPath) {
        return passRes;
      }
    };

    HtmlPrinter printer = new HtmlPrinter();
    printer.prepareCoverage(coverage);

    EQUAL(printer.replaceArgument("src-coverage.name", objMap), "PPP");
    EQUAL(printer.replaceArgument("src-coverage.index", objMap), "34");
    EQUAL(printer.replaceArgument("src-coverage.lines", objMap), "10");
    EQUAL(printer.replaceArgument("src-coverage.passed", objMap), "6");
    EQUAL(printer.replaceArgument("src-coverage.unpassed", objMap), "4");
    EQUAL(printer.replaceArgument("src-coverage.passed-ratio", objMap), "88");
    EQUAL(printer.replaceArgument("src-coverage.unpassed-ratio", objMap), "12");
    EQUAL(printer.replaceArgument("src-coverage.passed-lines", objMap), " 111 121 131");
    EQUAL(printer.replaceArgument("src-coverage.unpassed-lines", objMap), " 112 122 132");
  }

  public void replaceArgument_arg_objMap_4()
  {
    MSG("JobWɊւȊȌwqw肳ĂꍇB");

    HtmlPrinter printer = new HtmlPrinter();
    printer.setTesterName("My Name");

    Map<String, Object> objMap = new HashMap<String, Object>();
    EQUAL(printer.replaceArgument("test.tester", objMap), "--");

    CaseResult testRes = printer.createCaseResult("TTT", CaseResult.NULL);
    objMap.put("test", testRes);

    EQUAL(printer.replaceArgument("test.tester", objMap), "My Name");
  }
}
