/*
 * PrinterGroupBase class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.function.print;

import ts.tester.function.CaseResult;
import ts.tester.function.CheckResult;
import ts.tester.function.ResultType;
import ts.tester.function.Result;
import java.io.OutputStream;
import java.util.List;
import java.util.LinkedList;
import java.util.Map;
import java.util.HashMap;

/**
 * ʏo̓O[vNXB 
 * <br>
 * ̎ʏo̓IuWFNgi[Ȁo͏ꊇĎsB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:52 $
 */
public class PrinterGroupBase extends AbstractPrinter
{
  /** ʏo̓IuWFNgi[郊XgB */
  private List<Printer> printerLst_ ;

  /** P[XIuWFNgƎʏo̓IuWFNg̑Ήi[
   *  }bv */
  private Map<CaseResult, Printer> caseToPrinterMap_ ;

  /**
   * ftHgRXgN^B
   */
  public PrinterGroupBase()
  {
    printerLst_ = new LinkedList<Printer>();
    caseToPrinterMap_ = new HashMap<CaseResult, Printer>();
  }

  /**
   * ʏo̓IuWFNgǉB
   *
   * @param  printer ʏo̓IuWFNgB
   * @throws AssertionError k̏ꍇ(fobO[ĥ݁jB 
   */
  public void addPrinter(Printer printer)
  {
    assert (printer != null) : "@param:printer is null.";

    printerLst_.add(printer);
  }

  /**
   * ̃IuWFNgɊi[Ă鎎ʏo̓IuWFNg̃Xg擾
   * B
   *
   * @return ̃IuWFNgɊi[Ă鎎ʏo̓IuWFNg̃XgB
   */
  protected List<Printer> printerList()
  {
    return printerLst_;
  }

  /**
   * 𒆒f邩ǂݒ肷B
   *
   * @param  isStopped 𒆒fꍇ<tt>true</tt>ݒ肷B
   */
  public void setStopped(boolean isStopped)
  {
    super.setStopped(isStopped);

    for (Printer p : printerLst_) {
      p.setStopped(isStopped);
    }
  }

  /**
   * w肳ꂽO̎P[X茋ʃIuWFNg쐬B
   * <br>
   * i[Ă鎎ʏo̓IuWFNg̎P[X茋ʃIuWFNg
   * 쐬A܂Ƃ߂Ċi[
   * {@link ts.tester.function.print.PrinterGroupBase.CaseResultGroup
   * CaseResultGroup}IuWFNgԂB
   *
   * @param  name P[XB
   * @param  parent e̎P[X茋ʃIuWFNgB
   * @return P[X茋ʃIuWFNgB
   * @throws AssertionErrror Ƀkw肳ꂽꍇB
   */
  public CaseResult createCaseResult(String name, CaseResult parent)
  {
    CaseResultGroup caseGroup = new CaseResultGroup(name, parent);

    if (parent instanceof CaseResultGroup) {
      for (CaseResult parentCase : ((CaseResultGroup) parent).caseLst_) {
        Printer printer = caseToPrinterMap_.get(parentCase);

        CaseResult childCase = printer.createCaseResult(name, parentCase);
        caseGroup.caseLst_.add(childCase);
        caseToPrinterMap_.put(childCase, printer);
      }
    }
    else {
      for (Printer printer : printerLst_) {
        CaseResult childCase = printer.createCaseResult(name, parent);
        caseGroup.caseLst_.add(childCase);
        caseToPrinterMap_.put(childCase, printer);
      }
    }

    return caseGroup;
  }

  /**
   * Ŝ̊JnɌĂяo郁\bhB
   *
   * @param  root ŏʂ̎P[X茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇB͈
   *           {@link ts.tester.function.print.PrinterGroupBase.CaseResultGroup
   *           CaseResultGroup}IuWFNgłȂꍇ(fobO[ĥ݁jB
   */
  @Override public void testStarted(CaseResult root)
  {
    assert (root != null) : "@param:root is null.";
    assert (root instanceof CaseResultGroup) :
      "@param:root is an intance of unsupported CaseResult class.";

    CaseResultGroup caseGroup = (CaseResultGroup) root;
    for (CaseResult rootCase : caseGroup.caseLst_) {
      Printer printer = caseToPrinterMap_.get(rootCase);
      printer.testStarted(rootCase);
    }
  }

  /**
   * ̏IɌĂяo郁\bhB
   *
   * @param  root ŏʂ̎P[X茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇB͈
   *           {@link ts.tester.function.print.PrinterGroupBase.CaseResultGroup
   *           CaseResultGroup}IuWFNgłȂꍇ(fobO[ĥ݁jB
   */
  @Override public void testEnded(CaseResult root)
  {
    assert (root != null) : "@param:root is null.";
    assert (root instanceof CaseResultGroup) :
      "@param:root is an intance of unsupported CaseResult class.";

    CaseResultGroup caseGroup = (CaseResultGroup) root;
    for (CaseResult rootCase : caseGroup.caseLst_) {
      Printer printer = caseToPrinterMap_.get(rootCase);
      printer.testEnded(rootCase);
    }
  }

  /**
   * P[X̊JnɌĂяo郁\bhB
   *
   * @param  current Jn鎎P[X̔茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇB͈
   *           {@link ts.tester.function.print.PrinterGroupBase.CaseResultGroup
   *           CaseResultGroup}IuWFNgłȂꍇ(fobO[ĥ݁jB
   */
  @Override public void caseStarted(CaseResult current)
  {
    assert (current != null) : "@param:current is null.";
    assert (current instanceof CaseResultGroup) :
      "@param:current is an intance of unsupported CaseResult class.";

    CaseResultGroup caseGroup = (CaseResultGroup) current;
    for (CaseResult currentCase : caseGroup.caseLst_) {
      Printer printer = caseToPrinterMap_.get(currentCase);
      printer.caseStarted(currentCase);
    }
  }

  /**
   * P[X̏IɌĂяo郁\bhB
   *
   * @param  current IP[X̔茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇB͈
   *           {@link ts.tester.function.print.PrinterGroupBase.CaseResultGroup
   *           CaseResultGroup}IuWFNgł͂Ȃꍇ(fobO[ĥ݁jB
   */
  @Override public void caseEnded(CaseResult current)
  {
    assert (current != null) : "@param:current is null.";
    assert (current instanceof CaseResultGroup) : 
      "@param:current is an instance of unsuppoerted CaseResult class.";

    CaseResultGroup caseGroup = (CaseResultGroup) current;
    for (CaseResult currentCase : caseGroup.caseLst_) {
      Printer printer = caseToPrinterMap_.get(currentCase);
      printer.caseEnded(currentCase);
    }
  }

  /**
   * 肪sꂽɌĂяo郁\bhB
   *
   * @param  check sꂽ{@link ts.tester.function.CheckResult CheckResult}
   *           IuWFNgB
   * @param  current ݎs̎P[X̔茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇB<tt>current</tt>
   *           {@link ts.tester.function.print.PrinterGroupBase.CaseResultGroup
   *           CaseResultGroup}IuWFNgł͂Ȃꍇ(fobO[ĥ݁jB
   */
  @Override public void checkOccured(CheckResult check, CaseResult current)
  {
    assert (check != null) : "@param:check is null.";
    assert (current != null) : "@param:current is null.";
    assert (current instanceof CaseResultGroup) :
      "@param:current is an instance of unsuppoerted CaseResult class.";

    CaseResultGroup caseGroup = (CaseResultGroup) current;
    for (CaseResult currentCase : caseGroup.caseLst_) {
      Printer printer = caseToPrinterMap_.get(currentCase);
      printer.checkOccured(check, currentCase);
    }
  }

  /**
   * bZ[W̓o^ꍇɌĂяo郁\bhB
   *
   * @param  message o^郁bZ[WB
   * @param  current ݎs̎P[X̔茋ʃIuWFNgB
   * @throws AssertionError k̏ꍇB<tt>current</tt>
   *           {@link ts.tester.function.print.PrinterGroupBase.CaseResultGroup
   *           CaseResultGroup}IuWFNgł͂Ȃꍇ(fobO[ĥ݁jB
   */
  @Override public void messageNoted(String message, CaseResult current)
  {
    assert (message != null) : "@param:message is null.";
    assert (current != null) : "@param:current is null.";
    assert (current instanceof CaseResultGroup) :
      "@param:current is an instance of unsupported CaseResult class.";

    CaseResultGroup caseGroup = (CaseResultGroup) current;
    for (CaseResult currentCase : caseGroup.caseLst_) {
      Printer printer = caseToPrinterMap_.get(currentCase);
      printer.messageNoted(message, currentCase);
    }
  }

  /* -- inner case -- */

  /**
   * {@link ts.tester.function.print.PrinterGroupBase PrinterGroupBase}p
   * P[X茋ʃNXB
   * <br>
   * {@link ts.tester.function.print.PrinterGroupBase PrinterGroupBase}
   * i[鎎ʏo̓IuWFNǵAP[X茋ʃIuWFNg
   * ܂Ƃ߂Ċi[B
   */
  private class CaseResultGroup extends CaseResult
  {
    /** {@link ts.tester.function.print.PrinterGroupBase PrinterGroupBase}
     *  i[鎎ʏo̓IuWFNǵAP[X茋ʃIuWFNg
     *  i[邽߂̃XgB 
     */
    private List<CaseResult> caseLst_ ;

    /**
     * P[XƐe̎P[XʃIuWFNgɂƂRXgN^B
     *
     * @param  name P[XB
     * @param  parent e̎P[XʃIuWFNgB
     * @throws AssertionError k̏ꍇ(fobO[ĥ݁jB
     */
    CaseResultGroup(String name, CaseResult parent)
    {
      super(name, parent);

      caseLst_ = new LinkedList<CaseResult>();
    }

    /**
     * bZ[WǉB
     *
     * @param  msg bZ[WB
     */
    @Override public void addMessage(String msg)
    {
      super.addMessage(msg);

      for (CaseResult cr : caseLst_) {
        cr.addMessage(msg);
      }
    }

    /**
     * w肳ꂽʃ^Cv̌ʐ擾B
     *
     * @param  type ʃ^CvB
     * @return 茋ʐB
     * @throws AssertionError k̏ꍇAyт̃\bhsꂽ
     *           ꍇ(fobO[ĥ݁jB
     */
    @Override public int count(ResultType type)
    {
      assert (type != null) : "@param:type is null.";

      if (caseLst_.size() == 0) {
        return 0;
      }
      CaseResult cr = caseLst_.get(0);
      return cr.count(type);
    }

    /**
     * w肳ꂽ茋ʃIuWFNg̕sȂǂZB
     * <br>
     * ̃IuWFNgi[SĂ̎P[X茋ʃIuWFNgɁA
     * {@link ts.tester.function.Result Result}IuWFNgǉB
     *
     * @param  result 茋ʃIuWFNgB
     * @throws AssertionError k̏ꍇ(fobO[ĥ݁jB
     */
    @Override public void addChildResult(Result result)
    {
      assert (result != null) : "@param:result is null.";

      if (result instanceof CaseResultGroup) {
        for (CaseResult resultCase : ((CaseResultGroup) result).caseLst_) {
          CaseResult parentCase = resultCase.getParentCaseResult();
          parentCase.addChildResult(resultCase);
        }
      }
      else {
        for (CaseResult cr : caseLst_) {
          cr.addChildResult(result);
        }
      }
    }
  }
}
