/*
 * ObjectSerializer class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.util;

import java.io.Serializable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import java.io.OptionalDataException;
import java.io.IOException;

/**
 * IuWFNg̃VACYsNXB
 * <br>
 * {@link java.io.Serializable Serializable}C^[tFCXCvg
 * NX̃IuWFNgɑ΂āAVACYsB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:52 $
 */
public class ObjectSerializer
{
  /**
   * ftHgRXgN^B
   */
  public ObjectSerializer()
  {}

  /**
   * w肳ꂽIuWFNgoCgɃVACYB
   * <br>
   * VACYɂ
   * {@link java.io.ByteArrayOutputStream ByteArrayOutputStream}
   * {@link java.io.ObjectOutputStream ObjectOutputStream}gpB
   *
   * @param  obj VACYIuWFNgB
   * @return VACYꂽʁAꂽoCgB
   * @throws java.io.InvalidClassException w肳ꂽIuWFNg̃NX
   *           VACYɕKvȏ𖞂ĂȂꍇB
   * @throws java.io.IOException {@link java.io.OutputStream OutputStream}
   *           Ɋւ鉽炩̃G[ꍇB
   *
   * @see  java.io.ByteArrayOutputStream
   * @see  java.io.ObjectOutputStream
   */
  public static byte[] serializeToByteArray(Serializable obj)
    throws InvalidClassException, IOException
  {
    ByteArrayOutputStream bos = new ByteArrayOutputStream();
    ObjectOutputStream oos = new ObjectOutputStream(bos);
    try {
      oos.writeObject(obj);
    }
    catch (NotSerializableException e) {}

    return bos.toByteArray();
  }

  /**
   * w肳ꂽoCg񂩂IuWFNgfVACYB
   * <br>
   * fVACYɂ
   * {@link java.io.ByteArrayInputStream ByteArrayInputStream}
   * {@link java.io.ObjectInputStream ObjectInputStream}gpB
   *
   * @param  bytes fVACYoCgB
   * @return fVACY̌ʐꂽIuWFNgB
   * @throws java.lang.ClassNotFoundException fVACYIuWFNg
   *           ̃NXȂꍇB
   * @throws java.io.InvalidClassException fVACYIuWFNg
   *           NXVACYɕKvȏ𖞂ĂȂꍇB
   * @throws java.io.StreamCorruptedException Xg[̐񂪕s
   *           ꍇB
   * @throws java.io.OptionalDataException v~eBuf[^IuWFNg
   *           ɃXg[ɌꍇB
   * @throws java.io.IOException {@link java.io.InputStream InputStream}
   *           ւ鉽炩̃G[ꍇB
   *
   * @see java.io.ByteArrayInputStream
   * @see java.io.ObjectInputStream
   */
  public static Object deserialize(byte[] bytes)
    throws ClassNotFoundException, InvalidClassException,
           StreamCorruptedException, OptionalDataException, IOException
  {
    ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
    ObjectInputStream ois = new ObjectInputStream(bis);
    return ois.readObject();
  }

  /**
   * w肳ꂽIuWFNg𕶎ɃVACYB
   * <br>
   * ̃IuWFNgoCgɃVACYÃoCg16i\
   * ̐ɕϊĕԂB
   * <br>
   * o͐̃Xg[GR[fBOs悤ɂȂĂꍇɁA
   * VACYꂽoCg̒lύX̂h߂ɎgpB
   * <br>
   * AAoCgl<tt>0x00`0xff</tt>"00"`"FF"ɕϊ邽߁A
   * JavavOł4{AXg[ł2{̃eʂgpĂ܂B
   *
   * @param  obj VACYIuWFNgB
   * @return VACYꂽʁAꂽB
   * @throws java.io.InvalidClassException w肳ꂽIuWFNg̃NX
   *           VACYɕKvȏ𖞂ĂȂꍇB
   * @throws java.io.IOException VACYɓo̓G[ꍇB
   */
  public static String serializeToString(Serializable obj)
    throws InvalidClassException, IOException
  {
    byte[] bs = serializeToByteArray(obj);

    StringBuffer buf = new StringBuffer();
    for (byte b : bs) {
      String s = Integer.toHexString(0xff & (int) b);
      buf.append((s.length() == 1) ? ("0" + s) : s);
    }
    return buf.toString();
  }

  /**
   * w肳ꂽ񂩂IuWFNgfVACYB
   * <br>
   * {@link ts.tester.util.ObjectSerializer#serializeToString(Serializable) 
   * serializeToString }\bhgpăVACYʂ̕A
   * ̃IuWFNgɃfVACYB
   *
   * @param  str fVACY镶B
   * @return fVACY̌ʁAꂽIuWFNgB
   * @throws java.lang.ClassNotFoundException fVACYIuWFNg
   *           ̃NXȂꍇB
   * @throws java.io.InvalidClassException fVACYIuWFNg
   *           VACYɕKvȏ𖞂ĂȂꍇB
   * @throws java.io.StreamCorruptedException Xg[̐񂪕s
   *           ꍇB
   * @throws java.io.OptionalDataException v~eBuf[^IuWFNg
   *           ɃXg[ɌꍇB
   * @throws java.io.IOException fVACYɓo̓G[ꍇB
   */
  public static Object deserialize(String str)
    throws ClassNotFoundException, InvalidClassException,
           StreamCorruptedException, OptionalDataException, IOException
  {
    byte[] bb = new byte[str.length() << 2];
    for (int i=0, j=0; i<str.length(); i+=2, j++) {
      int n = Integer.parseInt(str.substring(i, i+2), 16);
      bb[j] = (byte)((n >= 128) ? (n - 256) : n); 
    }
    return deserialize(bb);
  }

}
