/*
 * Decompiled with CFR 0.152.
 */
package ts.util;

public class CountRotate {
    private long value_;
    private long minLimit_;
    private long maxLimit_;

    public CountRotate() {
        this.value_ = 0L;
        this.minLimit_ = Long.MIN_VALUE;
        this.maxLimit_ = Long.MAX_VALUE;
    }

    public CountRotate(long l) {
        this.value_ = l;
        this.minLimit_ = Long.MIN_VALUE;
        this.maxLimit_ = Long.MAX_VALUE;
    }

    public CountRotate(long l, long l2, long l3) {
        if (l2 > l3) {
            this.minLimit_ = l3;
            this.maxLimit_ = l2;
        } else {
            this.minLimit_ = l2;
            this.maxLimit_ = l3;
        }
        this.value_ = l < this.minLimit_ ? this.minLimit_ : (l > this.maxLimit_ ? this.maxLimit_ : l);
    }

    public long currentValue() {
        return this.value_;
    }

    public long increment() {
        this.value_ = this.value_ >= this.maxLimit_ ? this.minLimit_ : ++this.value_;
        return this.value_;
    }

    public static CountRotate synchronizedCountRotate() {
        return CountRotate.synchronizedCountRotate(0L);
    }

    public static CountRotate synchronizedCountRotate(long l) {
        return new CountRotate(l){

            public synchronized long currentValue() {
                return super.currentValue();
            }

            public synchronized long increment() {
                return super.increment();
            }
        };
    }

    public static CountRotate synchronizedCountRotate(long l, long l2, long l3) {
        return new CountRotate(l, l2, l3){

            public synchronized long currentValue() {
                return super.currentValue();
            }

            public synchronized long increment() {
                return super.increment();
            }
        };
    }

    public static CountRotate synchronizedCountRotate(CountRotate countRotate) {
        assert (countRotate != null) : "@param:c is null.";
        return CountRotate.synchronizedCountRotate(countRotate.value_, countRotate.minLimit_, countRotate.maxLimit_);
    }
}

