/*
 * LineCoverageTest class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.tester.coverage;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.print.*;
import ts.tester.coverage.*;
import ts.tester.coverage.Coverage.MethodKey;
import java.io.*;
import java.util.*;

/**
 * <code>LineCoverage</code>NX̋@\NXB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2007/02/16 16:12:49 $
 */
public class LineCoverageTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      PrinterGroup group = new PrinterGroup();
      group.addPrinter(new ConsolePrinter());
      group.addPrinter(new HtmlPrinter("SATOH Takayuki"));
      setPrinter(group);

      run(LineCoverageTest.class, (args.length == 0) ? null : args[0]);
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* -- test case -- */

  public void run_0() throws Exception
  {
    LineCoverage coverage = new LineCoverage(PassResultTest.class);
    coverage.addTargetClassPattern("ts.tester.coverage.PassResultTest");
    /*
    coverage.setClassFilterType(Coverage.FilterType.ALLOW_DENY_ALLOW);
    coverage.addExclusionClassPattern("java.*");
    coverage.addExclusionClassPattern("sun.*");
    coverage.addExclusionClassPattern("ts.*");
    coverage.addExclusionClassPattern("ts.tester.coverage.*");
    coverage.addTargetClassPattern("ts.tester.*");
    */
    coverage.setClassFilterType(Coverage.FilterType.DENY_ALLOW_DENY);
    coverage.addTargetClassPattern("ts.*");
    coverage.addExclusionClassPattern("ts.tester.function.*");
    try {
      coverage.addClassPath("test");
      coverage.run();
      OK();
    } catch (Exception e) {
      NG(e);
    }

    LinkedList<String> lst = new LinkedList<String>();
    Collection<String> srcPathColl = coverage.allSourcePaths();
    Iterator<String> srcIt = srcPathColl.iterator();
    while (srcIt.hasNext()) {
      try {
        TRUE(srcIt.hasNext());
        lst.add(srcIt.next());
      } catch (Exception e) {}
    }
    FALSE(srcIt.hasNext());
    Collections.sort(lst);
    EQUAL(lst.get(0), "ts\\tester\\Tester.java");
    EQUAL(lst.get(1), "ts\\tester\\coverage\\CoveragePrinter.java");
    EQUAL(lst.get(2), "ts\\tester\\coverage\\PassResultTest.java");

    Collection<String> classNameColl = coverage.allClassNames();
    Iterator<String> classNameIt = classNameColl.iterator();
    EQUAL(classNameIt.next(), "ts.tester.Tester");
    EQUAL(classNameIt.next(), "ts.tester.coverage.CoveragePrinter");
    EQUAL(classNameIt.next(), "ts.tester.coverage.PassResultTest");
    FALSE(classNameIt.hasNext());

    String srcPath =  "ts\\tester\\coverage\\PassResultTest.java";
    Result<Integer> r = coverage.getPassResult(srcPath);
    StringBuffer resultBuf = new StringBuffer();
    resultBuf.append("Coverage[");
    resultBuf.append(srcPath);
    resultBuf.append("]: ");
    resultBuf.append(r.passedRatio());
    resultBuf.append("(");
    resultBuf.append(r.countPassedResults());
    resultBuf.append("/");
    resultBuf.append(r.countAllResults());
    resultBuf.append(")");
    MSG(resultBuf.toString());

    File srcFile = new File("src", srcPath);
    BufferedReader br = new BufferedReader(new FileReader(srcFile));
    for (int i=1; ; i++) {
      String line = br.readLine();
      if (line == null) {
        break;
      }

      System.out.print("Line(" + i + ")");
      if (r.getPassCountOfResult(i) > 0) {
        System.out.print("[*]");
      }
      else if (r.containsKeyOfResult(i)) {
        System.out.print("[ ]");
      }
      else {
        System.out.print("   ");
      }
      System.out.print(":"+ line);
      System.out.println();
    }
    OK();
  }

  public void getMethodResult()
  {
    LineCoverage coverage = new LineCoverage(PassResultTest.class);

    MethodKey key = new MethodKey("a class", "a method", "some args");
    PassResult<Integer> parent = new PassResult<Integer>();

    Result<Integer> result0 = coverage.getMethodResult(key, parent);
    Result<Integer> result1 = coverage.getMethodResult(key, parent);
    EQUAL(result0, result1);
  }

  public void methodKeysOf()
  {
    LineCoverage coverage = new LineCoverage(PassResultTest.class);
    Collection<MethodKey> mkcoll = coverage.methodKeysOf("a class");
    EQUAL(mkcoll.size(), 0);

    MethodKey key = new MethodKey("a class", "a method", "some args");
    PassResult<Integer> parent = new PassResult<Integer>();

    coverage.getMethodResult(key, parent);
    mkcoll = coverage.methodKeysOf("a class");
    EQUAL(mkcoll.size(), 1);
    Iterator<MethodKey> it = mkcoll.iterator();
    TRUE(it.hasNext());
    EQUAL(it.next(), key);
    FALSE(it.hasNext());

    MethodKey key2 = new MethodKey("a class", "method 2", "some args");
    coverage.getMethodResult(key2, parent);
    mkcoll = coverage.methodKeysOf("a class");
    EQUAL(mkcoll.size(), 2);
    it = mkcoll.iterator();
    TRUE(it.hasNext());
    EQUAL(it.next(), key);
    TRUE(it.hasNext());
    EQUAL(it.next(), key2);
    FALSE(it.hasNext());
  }

  public void forEmtpyMethod()
  {
    LineCoverage c = new LineCoverage(PassResultTest.class, "");
    c.entryClass(null);
    c.entryMethod(null);
    c.exitMethod(null);
    OK();
  }
}
