/*
 * Decompiled with CFR 0.152.
 */
package ts.util;

import java.util.Calendar;
import java.util.GregorianCalendar;
import ts.util.DateTime;
import ts.util.Range;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeRange
extends Range<DateTime> {
    private long startMillis_;
    private long endMillis_;
    private Calendar calendar_;

    public DateTimeRange(DateTime dateTime, DateTime dateTime2) {
        super(dateTime, dateTime2);
    }

    @Override
    public final void setRange(DateTime dateTime, DateTime dateTime2) {
        assert (dateTime != null) : "@param:dttm1 is null.";
        assert (dateTime2 != null) : "@param:dttm2 is null.";
        Calendar calendar = dateTime.getCalendar();
        calendar.setTimeInMillis(0L);
        Calendar calendar2 = dateTime2.getCalendar();
        calendar2.setTimeInMillis(0L);
        if (!calendar.equals(calendar2)) {
            throw new IllegalArgumentException("calendar of two date-time are different.");
        }
        this.set(dateTime.getDateTimeMillis(), dateTime2.getDateTimeMillis(), calendar2);
    }

    protected void set(long l, long l2, Calendar calendar) {
        assert (calendar != null) : "@param:calendar is null.";
        if (l < l2) {
            this.startMillis_ = l;
            this.endMillis_ = l2;
        } else {
            this.startMillis_ = l2;
            this.endMillis_ = l;
        }
        this.calendar_ = calendar;
    }

    @Override
    public DateTime getStart() {
        DateTime dateTime = new DateTime(this.calendar_);
        dateTime.setDateTime(this.startMillis_);
        return dateTime;
    }

    @Override
    public DateTime getEnd() {
        DateTime dateTime = new DateTime(this.calendar_);
        dateTime.setDateTime(this.endMillis_);
        return dateTime;
    }

    public int intervalInYear() {
        long l = this.startMillis_;
        long l2 = this.endMillis_;
        this.calendar_.setTimeInMillis(l2);
        int n = this.calendar_.get(1);
        this.calendar_.setTimeInMillis(l);
        this.calendar_.add(1, n -= this.calendar_.get(1));
        long l3 = this.calendar_.getTimeInMillis();
        return l3 > l2 ? n - 1 : n;
    }

    public int intervalInMonth() {
        int n;
        int n2;
        long l = this.startMillis_;
        long l2 = this.endMillis_;
        if (this.calendar_ instanceof GregorianCalendar) {
            this.calendar_.setTimeInMillis(l2);
            n2 = this.calendar_.get(1);
            n = this.calendar_.get(2);
            this.calendar_.setTimeInMillis(l);
            n -= this.calendar_.get(2);
            n += (n2 -= this.calendar_.get(1)) * 12;
        } else {
            this.calendar_.setTimeInMillis(l2);
            n2 = this.calendar_.get(1);
            n = this.calendar_.get(2);
            this.calendar_.setTimeInMillis(l);
            int n3 = this.calendar_.get(1);
            n -= this.calendar_.get(2);
            for (int i = n3; i < n2; ++i) {
                this.calendar_.clear();
                this.calendar_.set(i + 1, 0, 1, 0, 0, 0);
                this.calendar_.add(13, -1);
                n += this.calendar_.get(2) + 1;
            }
            this.calendar_.setTimeInMillis(l);
        }
        this.calendar_.add(2, n);
        long l3 = this.calendar_.getTimeInMillis();
        return l3 > l2 ? n - 1 : n;
    }

    public int intervalInDay() {
        long l = this.startMillis_;
        long l2 = this.endMillis_;
        return (int)((l2 - l) / 86400000L);
    }

    public long intervalInHour() {
        long l = this.startMillis_;
        long l2 = this.endMillis_;
        return (l2 - l) / 3600000L;
    }

    public long intervalInMinute() {
        long l = this.startMillis_;
        long l2 = this.endMillis_;
        return (l2 - l) / 60000L;
    }

    public long intervalInSecond() {
        long l = this.startMillis_;
        long l2 = this.endMillis_;
        return (l2 - l) / 1000L;
    }

    public int countYears() {
        long l = this.startMillis_;
        long l2 = this.endMillis_;
        this.calendar_.setTimeInMillis(l2);
        int n = this.calendar_.get(1);
        this.calendar_.setTimeInMillis(l);
        return (n -= this.calendar_.get(1)) + 1;
    }

    public int countMonths() {
        int n;
        long l = this.startMillis_;
        long l2 = this.endMillis_;
        if (this.calendar_ instanceof GregorianCalendar) {
            this.calendar_.setTimeInMillis(l2);
            int n2 = this.calendar_.get(1);
            n = this.calendar_.get(2);
            this.calendar_.setTimeInMillis(l);
            n -= this.calendar_.get(2);
            n += (n2 -= this.calendar_.get(1)) * 12;
        } else {
            this.calendar_.setTimeInMillis(l2);
            int n3 = this.calendar_.get(1);
            n = this.calendar_.get(2);
            this.calendar_.setTimeInMillis(l);
            int n4 = this.calendar_.get(1);
            n -= this.calendar_.get(2);
            for (int i = n4; i < n3; ++i) {
                this.calendar_.clear();
                this.calendar_.set(i + 1, 0, 1, 0, 0, 0);
                this.calendar_.add(13, -1);
                n += this.calendar_.get(2) + 1;
            }
        }
        return n + 1;
    }

    public int countDays() {
        long l = this.startMillis_;
        long l2 = this.endMillis_;
        DateTime dateTime = new DateTime(l);
        DateTime dateTime2 = new DateTime(l2);
        dateTime.setStartTimeOfDay();
        dateTime2.setStartTimeOfDay();
        dateTime2.addDay(1);
        long l3 = dateTime2.getDateTimeMillis() - dateTime.getDateTimeMillis();
        return (int)(l3 / 86400000L);
    }

    public long countHours() {
        long l = this.startMillis_;
        long l2 = this.endMillis_;
        this.calendar_.setTimeInMillis(l);
        int n = this.calendar_.get(1);
        int n2 = this.calendar_.get(2);
        int n3 = this.calendar_.get(5);
        int n4 = this.calendar_.get(11);
        this.calendar_.clear();
        this.calendar_.set(n, n2, n3, n4, 0, 0);
        l = this.calendar_.getTimeInMillis();
        this.calendar_.setTimeInMillis(l2);
        int n5 = this.calendar_.get(1);
        int n6 = this.calendar_.get(2);
        int n7 = this.calendar_.get(5);
        int n8 = this.calendar_.get(11);
        this.calendar_.clear();
        this.calendar_.set(n5, n6, n7, n8, 0, 0);
        this.calendar_.add(11, 1);
        l2 = this.calendar_.getTimeInMillis();
        return (l2 - l) / 3600000L;
    }

    public long countMinutes() {
        long l = this.startMillis_;
        long l2 = this.endMillis_;
        this.calendar_.setTimeInMillis(l);
        int n = this.calendar_.get(1);
        int n2 = this.calendar_.get(2);
        int n3 = this.calendar_.get(5);
        int n4 = this.calendar_.get(11);
        int n5 = this.calendar_.get(12);
        this.calendar_.clear();
        this.calendar_.set(n, n2, n3, n4, n5, 0);
        l = this.calendar_.getTimeInMillis();
        this.calendar_.setTimeInMillis(l2);
        int n6 = this.calendar_.get(1);
        int n7 = this.calendar_.get(2);
        int n8 = this.calendar_.get(5);
        int n9 = this.calendar_.get(11);
        int n10 = this.calendar_.get(12);
        this.calendar_.clear();
        this.calendar_.set(n6, n7, n8, n9, n10, 0);
        this.calendar_.add(12, 1);
        l2 = this.calendar_.getTimeInMillis();
        return (l2 - l) / 60000L;
    }

    public long countSeconds() {
        long l = this.startMillis_;
        long l2 = this.endMillis_;
        this.calendar_.setTimeInMillis(l);
        int n = this.calendar_.get(1);
        int n2 = this.calendar_.get(2);
        int n3 = this.calendar_.get(5);
        int n4 = this.calendar_.get(11);
        int n5 = this.calendar_.get(12);
        int n6 = this.calendar_.get(13);
        this.calendar_.clear();
        this.calendar_.set(n, n2, n3, n4, n5, n6);
        l = this.calendar_.getTimeInMillis();
        this.calendar_.setTimeInMillis(l2);
        int n7 = this.calendar_.get(1);
        int n8 = this.calendar_.get(2);
        int n9 = this.calendar_.get(5);
        int n10 = this.calendar_.get(11);
        int n11 = this.calendar_.get(12);
        int n12 = this.calendar_.get(13);
        this.calendar_.clear();
        this.calendar_.set(n7, n8, n9, n10, n11, n12);
        this.calendar_.add(13, 1);
        l2 = this.calendar_.getTimeInMillis();
        return (l2 - l) / 1000L;
    }

    @Override
    public boolean encompass(DateTime dateTime) {
        assert (dateTime != null) : "@param:dttm is null.";
        this.calendar_.setTimeInMillis(0L);
        Calendar calendar = dateTime.getCalendar();
        calendar.setTimeInMillis(0L);
        if (!this.calendar_.equals(calendar)) {
            throw new IllegalArgumentException("Specified calendar are different from calendar of this object.");
        }
        long l = dateTime.getDateTimeMillis();
        return this.startMillis_ <= l && l <= this.endMillis_;
    }

    @Override
    public boolean encompass(DateTimeRange dateTimeRange) {
        assert (dateTimeRange != null) : "@param:range is null.";
        this.calendar_.setTimeInMillis(0L);
        Calendar calendar = dateTimeRange.calendar_;
        calendar.setTimeInMillis(0L);
        if (!this.calendar_.equals(calendar)) {
            throw new IllegalArgumentException("Specified calendar are different from calendar of this object.");
        }
        long l = this.startMillis_;
        long l2 = this.endMillis_;
        long l3 = dateTimeRange.startMillis_;
        long l4 = dateTimeRange.endMillis_;
        return l3 >= l && l4 <= l2;
    }

    public DateTimeRange intersectsWith(DateTimeRange dateTimeRange) {
        long l;
        assert (dateTimeRange != null) : "@param:range is null.";
        this.calendar_.setTimeInMillis(0L);
        Calendar calendar = dateTimeRange.calendar_;
        calendar.setTimeInMillis(0L);
        if (!this.calendar_.equals(calendar)) {
            throw new IllegalArgumentException("Specified calendar are different from calendar of this object.");
        }
        long l2 = Math.max(this.startMillis_, dateTimeRange.startMillis_);
        if (l2 > (l = Math.min(this.endMillis_, dateTimeRange.endMillis_))) {
            return null;
        }
        return new DateTimeRange(new DateTime(l2), new DateTime(l));
    }

    public DateTimeRange expandsWith(DateTime dateTime) {
        assert (dateTime != null) : "@param:dttm is null.";
        long l = Math.min(this.startMillis_, dateTime.getDateTimeMillis());
        long l2 = Math.max(this.endMillis_, dateTime.getDateTimeMillis());
        return new DateTimeRange(new DateTime(l), new DateTime(l2));
    }

    public DateTimeRange expandsWith(DateTimeRange dateTimeRange) {
        assert (dateTimeRange != null) : "@param:range is null.";
        long l = Math.min(this.startMillis_, dateTimeRange.startMillis_);
        long l2 = Math.max(this.endMillis_, dateTimeRange.endMillis_);
        return new DateTimeRange(new DateTime(l), new DateTime(l2));
    }
}

