/*
 * GeneralComparator class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import java.util.Comparator;

/**
 * ʓIȃIuWFNgrNXB
 * <br>
 * {@link java.util.Collections#sort(java.util.List) Collections#sort(List)}
 * \bh𗘗pہÃXg̗vf{@link java.util.Comparator
 * Comparable}pĂȂƂȂiłȂꍇ̓\bh
 * {@link java.lang.ClassCastException ClassCastException} X[B
 * JDK 1.5ȍ~ł́AXg̗vf^ {@link java.lang.Comparable Comparable}
 * pNXw肵ȂƁARpCEG[ɂȂjB
 * <br>
 * ɑ΂āA
 * {@link java.util.Collections#sort(java.util.List, java.util.Comparator)
 * Collections#sort(List,Comparator)}\bh́A
 * {@link java.util.Comparator Comparator}IuWFNg\ł΁A
 * Xg̗vf{@link java.lang.Comparable Comparable}pĂȂĂ
 * ȂB
 * <br>
 * ̃NX́A
 * {@link java.lang.Comparable Comparable}pĂȂvf܂ރXg
 * ł\[gɎg悤ȈʓI {@link java.util.Comparator Comparator}
 * NXłB
 * Xg̗vf{@link java.lang.Comparable Comparable}pĂꍇ
 * {@link java.lang.Comparable#compareTo(java.lang.Object) Comparable#compareTo}
 * \bhgĔrA
 * {@link java.lang.Comparable Comparable}pĂȂꍇ
 * {@link java.lang.Comparable#compareTo(java.lang.Object) Comparable#compareTo}
 * \bhŗOi{@link java.lang.ClassCastException ClassCastException})j
 * X[ꂽꍇ́A{@link java.lang.Object#toString() toString()}\bh
 * gėIuWFNg𕶎񉻂lrB
 * IuWFNg𕶎񉻂lrēƔ肳ꂽꍇ́A
 * IuWFNg̃NXrB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:44 $
 */
public class GeneralComparator implements Comparator<Object>
{
  /**
   * ftHgERXgN^B
   */
  public GeneralComparator()
  {}

  /**
   * w肳ꂽQ̃IuWFNg̑召֌WrB
   * <br>
   * ̃IuWFNgk̏ꍇ́AkłȂȂ΃k̕
   * 傫iŃ\[gƂɗĵƂĔ肷B
   * <br>
   * ̃IuWFNg{@link java.lang.Comparable Comparable}pĂ
   * ꍇ́A{@link java.lang.Comparable#compareTo(java.lang.Object)
   * Comparable#compareTo}\bhgĔrB
   * <br>
   * ǂ{@link java.lang.Comparable Comparable}pĂȂꍇA
   * {@link java.lang.Comparable#compareTo(java.lang.Object)
   * Comparable#compareTo}\bhŗOi{@link java.lang.ClassCastException
   * ClassCastException})jX[ꂽꍇ́ÃIuWFNg
   * {@link java.lang.Object#toString() toString()}\bhŕ񉻂Ĕr
   * B
   * IuWFNg𕶎񉻂lrēƔ肳ꂽꍇ́A
   * IuWFNg̃NXrB
   *
   * @param  o1  rΏۂ̃IuWFNg1B
   * @param  o2  rΏۂ̃IuWFNg2B
   * @return o1o2菬ꍇ͐̒lAo1o2傫ꍇ͕̒lA
   *         o1o2ꍇ̓[ԂB
   */
  public int compare(Object o1, Object o2)
  {
    if (o1 == null) {
      return (o2 == null) ? 0 : 1;
    }
    else if (o2 == null) {
      return -1;
    }

    try {
      return _cast_to_comparator(o1).compareTo(o2);
    }
    catch (Exception e) {
      try {
        return _cast_to_comparator(o2).compareTo(o1);
      }
      catch (Exception e2) {
        int n = (o1.toString().compareTo(o2.toString()));
        if (n != 0) {
          return n;
        }
        return o1.getClass().toString().compareTo(o2.getClass().toString());
      }
    }
  }

  @SuppressWarnings("unchecked")
  private Comparable<Object> _cast_to_comparator(Object o)
  {
    return (Comparable<Object>) o;
  }

  /**
   * ̃IuWFNg̃IuWFNgɓǂ𔻒肷B
   *
   * @param  obj rΏۂ̃IuWFNgB 
   * @return ꍇ<tt>true</tt>AłȂꍇ<tt>false</tt>ԂB
   */
  public boolean equals(Object obj)
  {
    return super.equals(obj);
  }
}

