/*
 * StringOperation class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.text;

/**
 * {Iȕ񑀍s邽߂̃NXB
 * <br>
 * Unicode̕⏕̑Ή(JSR-204)ɂA<code>char</code>ϐK
 * ΉȂȂA񑀍ɂĕɊւlGɂȂB
 * ̃NXł́A̕ɊւlȒPɂ邽߁Aȉ̕jŕy
 * Ƃł悤ɁA\bhpӂĂF
 * <ul>
 * <li><code>char</code>ϐ̎gpɗ͔A擾ꍇł{@link
 * java.lang.String String}IuWFNggpB</li>
 * <li>̒CfbNX́A<code>char</code>z̃TCYCfbNX
 * ł͂ȂAR[hE|CgPʂŊZlgpB</li>
 * <li>ԂɎ擾Ȃǂ̌JԂsꍇ́ACfbNXgp
 * ɁA{@link ts.util.text.StringSequence StringSequence}NXgp
 * B</li>
 * </ul>
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2010-10-16 09:35:14 $
 */
public final class StringOperation
{
  /**
   * ftHgRXgN^B
   */
  protected StringOperation()
  {}

  /**
   * w肳ꂽ̒擾B
   * <br>
   * ȂAłƂ́AR[hE|CgPʂ̒lB
   *
   * @param  str B
   * @return 񒷁B
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static int length(String str)
  {
    assert (str != null) : "@param:str is null.";

    return str.codePointCount(0, str.length());
  }

  /**
   * w肳ꂽ񂪋󕶎񂩂ǂ𔻒肷B
   *
   * @param  str B
   * @return 󕶎̏ꍇ<tt>true</tt>ԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static boolean isEmpty(String str)
  {
    assert (str != null) : "@param:str is null.";

    return (str.length() == 0) ? true : false;
  }

  /**
   * w肳ꂽ񂪋󔒕ō\Ă邩ǂ𔻒肷B
   * <br>
   * 󕶎̏ꍇ<tt>false</tt>ԂB
   *
   * @param  str B
   * @return 󔒕ō\Ăꍇ<tt>true</tt>ԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static boolean isWhitespaces(String str)
  {
    assert (str != null) : "@param:str is null.";

    if (str.length() == 0) {
      return false;
    }

    for (int i=0; i<str.length(); i=offsetByCodePoints(str, i, 1)) {
      if (! Character.isWhitespace(str.codePointAt(i))) {
        return false;
      }
    }

    return true;
  }

  /**
   * w肳ꂽ̕SĎw肳ꂽUnicodeubNɊ܂܂Ă
   * ǂ𔻒肷B
   * <br>
   * 󕶎̏ꍇ<tt>false</tt>ԂB
   *
   * @param  str B
   * @param  unicodeBlock UnicodeubNB
   * @return SĂ̕w肳ꂽUnicodeubN̏ꍇ<tt>true</tt>
   * ԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static boolean isUnicodeBlock(
    String str, Character.UnicodeBlock unicodeBlock)
  {
    assert (str != null) : "@param:str is null.";
    assert (unicodeBlock != null) : "@param:unicodeBlock is null.";

    if (str.length() == 0) {
      return false;
    }

    for (int i=0; i<str.length(); i=offsetByCodePoints(str, i, 1)) {
      Character.UnicodeBlock ub = Character.UnicodeBlock.of(str.codePointAt(i));
      if (! ub.equals(unicodeBlock)) {
        return false;
      }
    }

    return true;
  }

  /**
   * w肳ꂽ񂪐ō\Ă邩ǂ𔻒肷B
   * <br>
   * 󕶎̏ꍇ<tt>false</tt>ԂB
   *
   * @param  str B
   * @return ō\Ăꍇ<tt>true</tt>ԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static boolean isDigits(String str)
  {
    assert (str != null) : "@param:str is null.";

    if (str.length() == 0) {
      return false;
    }

    for (int i=0; i<str.length(); i=offsetByCodePoints(str, i, 1)) {
      if (! Character.isDigit(str.codePointAt(i))) {
        return false;
      }
    }

    return true;
  }

  /**
   * w肳ꂽCfbNX̕擾B
   * <br>
   * ȂAłCfbNXƂ́AR[hE|Cg̐擪̏ԁi0
   * JnjłB
   *
   * @param  str B
   * @param  codePointIndex R[hE|CgECfbNXB
   * @return w肳ꂽCfbNX̕B
   * @throws IndexOutOfBoundsException w肳ꂽCfbNX͈͊ȌꍇB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static String characterAt(String str, int codePointIndex)
    throws IndexOutOfBoundsException
  {
    assert (str != null) : "@param:str is null.";

    int bgnInd = offsetByCodePoints(str, 0, codePointIndex);
    int endInd = offsetByCodePoints(str, bgnInd, 1);
    return str.substring(bgnInd, endInd);
  }

  /**
   * w肳ꂽCfbNX擪Ƃ镔擾B
   * <br>
   * ȂAłCfbNXƂ́AR[hE|Cg̐擪̏ԁi0
   * JnjłB
   *
   * @param  str B
   * @param  beginCodePointIndex JnCfbNXB
   * @return w肳ꂽCfbNXJn镔B
   * @throws IndexOutOfBoundsException w肳ꂽCfbNX͈͊ȌꍇB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static String substring(String str, int beginCodePointIndex)
    throws IndexOutOfBoundsException
  {
    assert (str != null) : "@param:str is null.";

    return str.substring(offsetByCodePoints(str, 0, beginCodePointIndex));
  }

  /**
   * w肳ꂽCfbNX擪yіƂ镔擾B
   * <br>
   * ȂAłCfbNXƂ́AR[hE|Cg̐擪̏ԁi0
   * JnjłB
   *
   * @param  str B
   * @param  beginCodePointIndex JnCfbNXB
   * @param  endCodePointIndex ICfbNXB
   * @return B
   * @throws IndexOutOfBoundsException w肳ꂽCfbNX͈͊ȌꍇB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static String substring(String str,
    int beginCodePointIndex, int endCodePointIndex)
      throws IndexOutOfBoundsException
  {
    assert (str != null) : "@param:str is null.";

    int count = endCodePointIndex - beginCodePointIndex;
    int bgnInd = offsetByCodePoints(str, 0, beginCodePointIndex);
    int endInd = offsetByCodePoints(str, bgnInd, count);
    return str.substring(bgnInd, endInd);
  }

  /**
   * w肳ꂽɂāAT񂪍ŏɌCfbNX擾B
   * <br>
   * T񂪌Ȃꍇ́A̒lԂB
   * <br>
   * ȂAłCfbNXƂ́AR[hE|Cg̐擪̏ԁi0
   * JnjłB
   *
   * @param  str B
   * @param  searched TB
   * @return T镶񂪍ŏɌꂽCfbNXBȂꍇ
   *           ̒lԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static int indexOf(String str, String searched)
  {
    return indexOf(str, searched, 0);
  }

  /**
   * w肳ꂽɂāAT񂪊JnCfbNXȍ~ōŏɌ
   * CfbNX擾B
   * <br>
   * JnCfbNX͈̔͂ɂĂ͐͂ȂA̒l╶̒𒴂
   * CfbNXw肳ꂽꍇł肪sB̒lw肳ꂽꍇ́A
   * [w肳ꂽƓʂԂB
   * <br>
   * T񂪊JnCfbNXȍ~ŌȂꍇ́A̒lԂB
   * <br>
   * ȂAłCfbNXƂ́AR[hE|Cg̐擪̏ԁi0
   * JnjłB
   *
   * @param  str B
   * @param  searched TB
   * @param  fromCodePointIndex TJnCfbNXB
   * @return T镶񂪍ŏɌꂽCfbNXBȂꍇ
   *           ̒lԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static int indexOf(String str, String searched, int fromCodePointIndex)
  {
    assert (str != null) : "@param:str is null.";
    assert (searched != null) : "@param:searched is null.";

    int cpind = Math.max(fromCodePointIndex, 0);

    try {
      int bgnInd = offsetByCodePoints(str, 0, cpind);

      int n = str.length() - searched.length();
      for (int i=bgnInd; i<=n; i=offsetByCodePoints(str, i, 1), cpind++) {
        if (str.startsWith(searched, i)) {
          return cpind;
        }
      }
      return -1;
    }
    catch (IndexOutOfBoundsException e) {
      return -1;
    }
  }

  /**
   * w肳ꂽɂāAT񂪍ŌɌCfbNX擾B
   * <br>
   * ȂAłCfbNXƂ́AR[hE|Cg̐擪̏ԁi0
   * JnjłB
   *
   * @param  str B
   * @param  searched TB
   * @return T镶񂪍ŌɌꂽCfbNXBȂꍇ
   *           ̒lԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static int lastIndexOf(String str, String searched)
  {
    return lastIndexOf(str, searched, str.length());
  }

  /**
   * w肳ꂽɂāAT񂪎w肳ꂽCfbNXȑOōŌ
   * CfbNX擾B
   * <br>
   * JnCfbNX͈̔͂ɂĂ͐͂ȂA̒l╶̒𒴂
   * CfbNXw肳ꂽꍇł肪sB̒𒴂l
   * w肳ꂽꍇ́AŏICfbNXw肳ꂽƓʂԂB
   * <br>
   * ȂAłCfbNXƂ́AR[hE|Cg̐擪̏ԁi0
   * JnjłB
   *
   * @param  str B
   * @param  searched TB
   * @param  fromCodePointIndex TsŏICfbNXB
   * @return T镶񂪍ŌɌꂽCfbNXBȂꍇ
   *           ̒lԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static int lastIndexOf(String str, String searched,
    int fromCodePointIndex)
  {
    assert (str != null) : "@param:str is null.";
    assert (searched != null) : "@param:searched is null.";

    int cpind = Math.min(fromCodePointIndex,
      Math.max(StringOperation.length(str), 0));

    try {
      int bgnInd = offsetByCodePoints(str, 0, cpind);
      for (int i=bgnInd; i>=0; i=offsetByCodePoints(str, i,-1), cpind--) {
        if (str.startsWith(searched, i)) {
          return cpind;
        }
      }
    }
    catch (IndexOutOfBoundsException e) {}

    return -1;
  }

  /**
   * w肳ꂽ̊JnAw肳ꂽvtBbNXƈvĂ邩ǂ
   * 𔻒肷B
   *
   * @param  str B
   * @param  prefix vtBbNXB
   * @return ̊JnvtBbNXƈvꍇ<tt>true</tt>ԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static boolean startsWith(String str, String prefix)
  {
    assert (str != null) : "@param:str is null.";
    assert (prefix != null) : "@param:prefix is null.";

    return str.startsWith(prefix);
  }

  /**
   * w肳ꂽ̖Aw肳ꂽTtBbNXƈvĂ邩ǂ
   * 肷B
   *
   * @param  str B
   * @param  suffix TtBbNXB
   * @return ̊JnTtBbNXƈvꍇ<tt>true</tt>ԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static boolean endsWith(String str, String suffix)
  {
    assert (str != null) : "@param:str is null.";
    assert (suffix != null) : "@param:suffix is null.";

    return str.endsWith(suffix);
  }

  /**
   * w肳ꂽɁAw肳ꂽT񂪊܂܂Ă邩ǂ𔻒肷B
   *
   * @param  str B
   * @param  searched TB
   * @return T񂪊܂܂Ăꍇ<tt>true</tt>ԂB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static boolean contains(String str, String searched)
  {
    assert (str != null) : "@param:str is null.";
    assert (searched != null) : "@param:searched is null.";

    return str.contains(searched);
  }

  /**
   * w肳ꂽCfbNXR[hE|CgEIuZbgړ
   * CfbNXԂB
   * <br>
   * łCfbNX́A<code>char</code>z̃CfbNX
   * łB
   * <br>
   * ̃\bh́AJDK1.5̕siBug ID:6242664jւ̑΍̂߂ɍ쐬
   * ꂽB
   *
   * @param  index CfbNXB
   * @param  codePointOffset R[hE|CgEItZbgB
   * @return ̃CfbNXB
   * @throws IndexOutOfBoundsException ̃CfbNX̒l񒷂
   *           ꍇA̓R[hE|CgECfbNX̒l̏ꍇA
   *           ړ̃CfbNX񒷂𒴂ꍇB
   */
  protected static int offsetByCodePoints(
    String str, int index, int codePointOffset
  ) throws IndexOutOfBoundsException
  {
    if (System.getProperty("java.version").startsWith("1.5.")) {
      return new String(str).offsetByCodePoints(index, codePointOffset);
    } else {
      return str.offsetByCodePoints(index, codePointOffset);
    }
  }
}

