package ts.graph;

import ts.tester.function.coverage.FunctionTester;
import ts.tester.function.ObjectInspector;
import java.awt.*;
import java.awt.font.*;
import java.awt.geom.*;
import java.io.*;
import java.text.*;

public class GraphImageTest extends FunctionTester
{
  public static void main(String[] args)
  {
    try {
      new File("test\\GraphImage").mkdir();
      run(GraphImageTest.class, (args.length > 0) ? args[0] : null);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }

  private ObjectInspector oi = new ObjectInspector(this);

  protected void preInvocation(String methodName)
  {
    oi.ignore("TYPE_PNG");
    oi.ignore("TYPE_JPEG");
    oi.ignore("transformer_");
    oi.ignore("graphics_");
    oi.ignore("lineStyle_");
    oi.ignore("fillStyle_");
    oi.ignore("textStyle_");
    oi.ignore("lineStyleChanged_");
    oi.ignore("fillStyleChanged_");
    oi.ignore("textStyleChanged_");
    oi.ignore("DEFAULT_BORDER_STYLE");
    oi.ignore("DEFAULT_LINE_STYLE");
    oi.ignore("DEFAULT_FILL_STYLE");
    oi.ignore("DEFAULT_TEXT_STYLE");

    int[] size = { 0, 0 };
    oi.expect("imageSize_", size);

    int[] margin = { 0, 0, 0, 0 };
    oi.expect("margin_", margin);

    oi.expect("bgColor_", Color.white);
    oi.expect("borderStyle_", null);
    oi.expect("W", 0);
    oi.expect("H", 1);
    oi.expect("L", 0);
    oi.expect("T", 1);
    oi.expect("R", 2);
    oi.expect("B", 3);
    oi.expect("autoScale_", false);
  }

  class GraphImageEx extends GraphImage {
    protected void drawGraph(Rectangle r) {};
  }

  /* -- test cases -- */

  public void constants()
  {
    MSG("萔̊mFB");
    EQUAL(GraphImage.TYPE_PNG, "png");
    EQUAL(GraphImage.TYPE_JPEG, "jpeg");
  }

  public void constructor()
  {
    MSG("ftHgERXgN^̊mFB");
    oi.inspect(new GraphImageEx());
  }

  public void setSize()
  {
    MSG("摜TCY̐ݒB");
    GraphImageEx gi = new GraphImageEx();
    gi.setSize(100, 120);
    EQUAL(gi.getWidth(), 100);
    EQUAL(gi.getHeight(), 120);
  }

  public void setSize_1()
  {
    MSG("ɕ̒lݒ肵ꍇB");
    GraphImageEx gi = new GraphImageEx();
    gi.setSize(-1, 100);
    EQUAL(gi.getWidth(), 0);
    EQUAL(gi.getHeight(), 100);
    gi.setSize(100, -1);
    EQUAL(gi.getWidth(), 100);
    EQUAL(gi.getHeight(), 0);
  }
  
  public void setMargin()
  {
    MSG("}[W̐ݒB");
    GraphImageEx gi = new GraphImageEx();
    gi.setMargin(10, 20, 30, 40);
    int[] margin = { 10, 20, 30, 40 };
    oi.expect("margin_", margin);
    oi.inspect(gi);
  }

  public void setMargin_1()
  {
    MSG("ɕ̒lw肵ꍇB");
    GraphImageEx gi = new GraphImageEx();
    gi.setMargin(-1, 20, 30, 40);
    int[] margin = { 0, 20, 30, 40 };
    oi.expect("margin_", margin);
    oi.inspect(gi);

    gi.setMargin(10, -1, 30, 40);
    margin[0] = 10;
    margin[1] = 0;
    oi.expect("margin_", margin);
    oi.inspect(gi);

    gi.setMargin(10, 20, -1, 40);
    margin[1] = 20;
    margin[2] = 0;
    oi.expect("margin_", margin);
    oi.inspect(gi);

    gi.setMargin(10, 20, 30, -1);
    margin[2] = 30;
    margin[3] = 0;
    oi.expect("margin_", margin);
    oi.inspect(gi);
  }
  
  public void setBgColor()
  {
    MSG("wiF̐ݒB");
    GraphImage gi = new GraphImageEx();
    gi.setBgColor(Color.cyan);
    oi.expect("bgColor_", Color.cyan);
    oi.inspect(gi);
  }

  public void setBgColor_1()
  {
    MSG("Ƀkw肵ꍇB");
    GraphImage gi = new GraphImageEx();
    gi.setBgColor(null);
    oi.expect("bgColor_", Color.white);
    gi.setBgColor(Color.cyan);
    oi.expect("bgColor_", Color.cyan);
    gi.setBgColor(null);
    oi.expect("bgColor_", Color.cyan);
    oi.inspect(gi);
  }

  public void setBorderStyle()
  {
    MSG("ẼX^CݒB");
    GraphImage gi = new GraphImageEx();
    LineStyle style = new LineStyle(Color.blue, 2);
    gi.setBorderStyle(style);
    oi.expect("borderStyle_", style);
    oi.inspect(gi);
    gi.setBorderStyle(null);
    oi.expect("borderStyle_", null);
    oi.inspect(gi);
  }

  public void getDrawnBounds()
  {
    MSG("`̈̎ZoB");
    GraphImage gi = new GraphImageEx();
    EQUAL(gi.getDrawnBounds(), new Rectangle(0, 0, 0, 0));

    gi.setSize(150, 100);
    EQUAL(gi.getDrawnBounds(), new Rectangle(0, 0, 150, 100));

    gi.setMargin(10,20,30,40);
    EQUAL(gi.getDrawnBounds(), new Rectangle(10, 20, 110, 40));
  }

  public void getDrawnBounds_1()
  {
    MSG("}[W摜TCY𒴂ꍇB");
    GraphImage gi = new GraphImageEx();
    gi.setSize(150, 100);
    gi.setMargin(80, 50, 90, 60);
    EQUAL(gi.getDrawnBounds(), new Rectangle(80, 50, 0, 0));

    gi.setMargin(200, 180, 100, 50);
    EQUAL(gi.getDrawnBounds(), new Rectangle(150, 100, 0, 0));
  }

  public void setLineStyle()
  {
    MSG("X^C̐ݒB");
    GraphImage gi = new GraphImageEx();
    LineStyle old = gi.setLineStyle(new LineStyle(Color.red));
    EQUAL(old.getColor(), Color.black);
    old = gi.setLineStyle(new LineStyle(Color.blue));
    EQUAL(old.getColor(), Color.red);
  }

  public void setFillStyle()
  {
    MSG("hԂX^C̐ݒB");
    GraphImage gi = new GraphImageEx();
    FillStyle old = gi.setFillStyle(new FillStyle(Color.cyan));
    EQUAL(old.getColor(), ColorStyle.TRANSPARENT);
    old = gi.setFillStyle(new FillStyle(Color.orange));
    EQUAL(old.getColor(), Color.cyan);
  }

  public void setTextStyle()
  {
    MSG("eLXgEX^C̐ݒB");
    GraphImage gi = new GraphImageEx();
    TextStyle old = gi.setTextStyle(new TextStyle(Color.red));
    EQUAL(old.getAttributeMap().size(), 0);
    old = gi.setTextStyle(new TextStyle(Color.blue, 10, true, false));
    EQUAL(old.getAttributeMap().size(), 1);
    EQUAL(old.getAttributeMap().get(TextAttribute.FOREGROUND), Color.red);
  }

  public void loadLineStyle() throws Exception
  {
    MSG("X^C̃[hB");
    final String path = "test\\GraphImage\\loadLineStyle.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int[] size = { 100, 100 };
        oi.expect("imageSize_", size);
        try {
          oi.expect("loadLineStyle_", true);
          oi.expect("loadFillStyle_", true);
          oi.inspect(this);
      
          oi.invokeMethod(this, "loadLineStyle");
          oi.expect("loadLineStyle_", false);
          oi.expect("loadFillStyle_", true);
          oi.inspect(this);
      
          oi.invokeMethod(this, "loadFillStyle");
          oi.expect("loadLineStyle_", true);
          oi.expect("loadFillStyle_", false);
          oi.inspect(this);
      
          oi.invokeMethod(this, "loadLineStyle");
          oi.expect("loadLineStyle_", false);
          oi.expect("loadFillStyle_", true);
          oi.inspect(this);
      
          this.setLineStyle(new LineStyle(Color.red));
          oi.expect("loadLineStyle_", true);
          oi.expect("loadFillStyle_", true);
          oi.inspect(this);
        } catch (Exception e) {
          NG(e);
        }
      }
    };
    gi.setSize(100, 100);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
    new File(path).delete();
  }

  public void loadFillStyle()
  {
    MSG("hԂX^C̃[hB");
    final String path = "test\\GraphImage\\loadFillStyle.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int[] size = { 100, 100 };
        oi.expect("imageSize_", size);
        try {
          oi.expect("loadLineStyle_", true);
          oi.expect("loadFillStyle_", true);
          oi.inspect(this);
      
          oi.invokeMethod(this, "loadFillStyle");
          oi.expect("loadLineStyle_", true);
          oi.expect("loadFillStyle_", false);
          oi.inspect(this);
      
          oi.invokeMethod(this, "loadLineStyle");
          oi.expect("loadLineStyle_", false);
          oi.expect("loadFillStyle_", true);
          oi.inspect(this);
      
          oi.invokeMethod(this, "loadFillStyle");
          oi.expect("loadLineStyle_", true);
          oi.expect("loadFillStyle_", false);
          oi.inspect(this);
      
          this.setFillStyle(new FillStyle(Color.red));
          oi.expect("loadLineStyle_", true);
          oi.expect("loadFillStyle_", true);
          oi.inspect(this);
        } catch (Exception e) {
          NG(e);
        }
      }
    };
    gi.setSize(100, 100);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
    new File(path).delete();
  }

  public void drawBackGround()
  {
    MSG("wi̕`B");
    final String path = "test\\GraphImage\\drawBackGround.png";

    GraphImage gi = new GraphImageEx();
    gi.setSize(200, 150);
    gi.setBgColor(Color.cyan);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setOrigin()
  {
    MSG("`̈̌_ړB");
    String path = "test\\GraphImage\\setOrigin.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        setLineStyle(new LineStyle(Color.blue));
        drawLine(20, 20, 100, 100);
        setOrigin(20, 10);
        drawLine(20, 20, 100, 100);
        setOrigin(40, 20);
        drawLine(20, 20, 100, 100);
        setOrigin(60, 30);
        drawLine(20, 20, 100, 100);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void setScale()
  {
    MSG("`̈̔{ړB");
    String path = "test\\GraphImage\\setScale.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        setLineStyle(new LineStyle(Color.black));
        drawLine(20, 20, 40, 160);
        setOrigin(40, 5);
        setScale(0.8, 0.8);
        drawLine(20, 20, 40, 160);
        setScale(0.6, 0.6);
        setOrigin(80, 10);
        drawLine(20, 20, 40, 160);
        setScale(0.4, 0.4);
        setOrigin(120, 15);
        drawLine(20, 20, 40, 160);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void drawBorder()
  {
    MSG("E̕`B");
    String path = "test\\GraphImage\\drawBorder.png";

    GraphImage gi = new GraphImageEx();
    gi.setSize(200, 150);
    gi.setBgColor(Color.yellow);
    gi.setBorderStyle(new LineStyle(Color.red));
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }

    path = "test\\GraphImage\\drawBorder1.png";
    gi.setSize(100, 100);
    gi.setBgColor(new Color(0x00, 0xee, 0xee));
    gi.setMargin(10, 5, 20, 15);
    gi.setBorderStyle(new LineStyle(Color.blue));
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void drawLine()
  {
    MSG("̃^Cvʂɕ`B");
    final String path = "test\\GraphImage\\drawLine.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 3;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_ROUND;
        LineStyle lstyle;
        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_SOLID, c, j));
        drawLine(20, 20, 180, 20);

        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_DASH, c, j));
        drawLine(20, 40, 180, 40);

        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_ROUGH_DASH, c, j));
        drawLine(20, 60, 180, 60);

        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_FINE_DASH, c, j));
        drawLine(20, 80, 180, 80);

        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_DOT, c, j));
        drawLine(20, 100, 180, 100);

        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_ROUGH_DOT, c, j));
        drawLine(20, 120, 180, 120);

        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_FINE_DOT, c, j));
        drawLine(20, 140, 180, 140);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void drawLine_1()
  {
    MSG("̒[̌`Ƃɕ`B");
    final String path = "test\\GraphImage\\drawLine1.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 5;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_ROUND;

        c = BasicStroke.CAP_SQUARE;
        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_SOLID, c, j));
        drawLine(20, 20, 180, 20);

        c = BasicStroke.CAP_ROUND;
        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_SOLID, c, j));
        drawLine(20, 40, 180, 40);

        c = BasicStroke.CAP_BUTT;
        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_SOLID, c, j));
        drawLine(20, 60, 180, 60);

        c = BasicStroke.CAP_SQUARE;
        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_DASH, c, j));
        drawLine(20, 80, 180, 80);

        c = BasicStroke.CAP_ROUND;
        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_DASH, c, j));
        drawLine(20, 100, 180, 100);

        c = BasicStroke.CAP_BUTT;
        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_DASH, c, j));
        drawLine(20, 120, 180, 120);

        c = BasicStroke.CAP_SQUARE;
        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_DOT, c, j));
        drawLine(20, 140, 180, 140);

        c = BasicStroke.CAP_ROUND;
        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_DOT, c, j));
        drawLine(20, 160, 180, 160);

        c = BasicStroke.CAP_BUTT;
        setLineStyle(new LineStyle(Color.blue, w, LineStyle.TYPE_DOT, c, j));
        drawLine(20, 180, 180, 180);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void drawPolyLine()
  {
    MSG("̌̌`Ƃɕ`B");
    final String path = "test\\GraphImage\\drawPolyLine.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 16;
        int t = LineStyle.TYPE_SOLID;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_ROUND;
        float x[], y[];

        x = new float[3];
        y = new float[3];
        x[0] = 60;
        y[0] = 20;
        x[1] = 80;
        y[1] = 80;
        x[2] = 120;
        y[2] = 60;

        j = BasicStroke.JOIN_ROUND;
        setLineStyle(new LineStyle(Color.red, w, t, c, j));
        drawPolyLine(x, y);

        setOrigin(-10, 40);

        j = BasicStroke.JOIN_BEVEL;
        setLineStyle(new LineStyle(Color.green, w, t, c, j));
        drawPolyLine(x, y);

        setOrigin(-20, 80);

        j = BasicStroke.JOIN_MITER;
        setLineStyle(new LineStyle(Color.blue, w, t, c, j));
        drawPolyLine(x, y);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void drawPolygon()
  {
    MSG("̌̌`Ƃɕ`B");
    final String path = "test\\GraphImage\\drawPolygon.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 16;
        int t = LineStyle.TYPE_SOLID;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_ROUND;
        float x[], y[];

        x = new float[3];
        y = new float[3];
        x[0] = 60;
        y[0] = 20;
        x[1] = 80;
        y[1] = 80;
        x[2] = 120;
        y[2] = 60;

        setOrigin(60, 00);

        j = BasicStroke.JOIN_ROUND;
        setLineStyle(new LineStyle(Color.red, w, t, c, j));
        drawPolygon(x, y);

        setOrigin(20, 40);

        j = BasicStroke.JOIN_BEVEL;
        setLineStyle(new LineStyle(Color.green, w, t, c, j));
        drawPolygon(x, y);

        setOrigin(-20, 80);

        j = BasicStroke.JOIN_MITER;
        setLineStyle(new LineStyle(Color.blue, w, t, c, j));
        drawPolygon(x, y);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void fillPolygon()
  {
    final String path = "test\\GraphImage\\fillPolygon.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 16;
        int t = LineStyle.TYPE_SOLID;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_ROUND;
        float x[], y[];

        x = new float[3];
        y = new float[3];
        x[0] = 60;
        y[0] = 20;
        x[1] = 80;
        y[1] = 80;
        x[2] = 120;
        y[2] = 60;

        setOrigin(60, 00);

        j = BasicStroke.JOIN_ROUND;
        setLineStyle(new LineStyle(Color.red, w, t, c, j));
        setFillStyle(new FillStyle(Color.magenta, true));
        fillPolygon(x, y);

        setOrigin(20, 40);

        j = BasicStroke.JOIN_BEVEL;
        setLineStyle(new LineStyle(Color.green, w, t, c, j));
        setFillStyle(new FillStyle(Color.orange, true));
        fillPolygon(x, y);

        setOrigin(-20, 80);

        j = BasicStroke.JOIN_MITER;
        setLineStyle(new LineStyle(Color.blue, w, t, c, j));
        setFillStyle(new FillStyle(Color.cyan, true));
        fillPolygon(x, y);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void drawRect()
  {
    MSG("lp`B");
    final String path = "test\\GraphImage\\drawRect.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 16;
        int t = LineStyle.TYPE_SOLID;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_MITER;

        setLineStyle(new LineStyle(Color.red, w, t, c, j));
        drawRect(60, 20, 160, 120);

        setOrigin(20, 40);

        setLineStyle(new LineStyle(Color.green, w, t, c, j));
        drawRect(60, 20, 160, 120);

        setOrigin(-20, 80);

        setLineStyle(new LineStyle(Color.blue, w, t, c, j));
        drawRect(60, 20, 160, 120);
      }
    };
    gi.setSize(200, 250);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void fillRect()
  {
    MSG("h荞ݎlp`B");
    final String path = "test\\GraphImage\\fillRect.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 16;
        int t = LineStyle.TYPE_SOLID;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_MITER;

        setFillStyle(new FillStyle(Color.red));
        fillRect(60, 20, 160, 120);

        setOrigin(20, 40);

        setFillStyle(new FillStyle(Color.green));
        fillRect(60, 20, 160, 120);

        setOrigin(-20, 80);

        setFillStyle(new FillStyle(Color.blue));
        fillRect(60, 20, 160, 120);
      }
    };
    gi.setSize(200, 250);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void fillRect_1()
  {
    MSG("Og̏ꍇB");
    final String path = "test\\GraphImage\\fillRect1.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 16;
        int t = LineStyle.TYPE_DASH;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_MITER;

        setLineStyle(new LineStyle(Color.black, 2, t, c, j));

        setFillStyle(new FillStyle(Color.red, true));
        fillRect(60, 20, 160, 120);

        setOrigin(20, 40);

        setFillStyle(new FillStyle(Color.green, true));
        fillRect(60, 20, 160, 120);

        setOrigin(-20, 80);

        setFillStyle(new FillStyle(Color.blue, true));
        fillRect(60, 20, 160, 120);
      }
    };
    gi.setSize(200, 250);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void drawCircle()
  {
    final String path = "test\\GraphImage\\drawCircle.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 1;
        int t = LineStyle.TYPE_SOLID;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_MITER;

        setLineStyle(new LineStyle(Color.blue, w, t, c, j));
        drawCircle(100, 100, 100);
        drawCircle(100, 100, 90);
        drawCircle(100, 100, 80);
        drawCircle(100, 100, 70);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }
  
  public void fillCircle()
  {
    final String path = "test\\GraphImage\\fillCircle.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 1;
        int t = LineStyle.TYPE_SOLID;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_MITER;

        setLineStyle(new LineStyle(Color.blue, w, t, c, j));
        setFillStyle(new FillStyle(Color.cyan, true));
        fillCircle(100, 120, 60);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void drawEllipse()
  {
    final String path = "test\\GraphImage\\drawEllipse.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 1;
        int t = LineStyle.TYPE_SOLID;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_MITER;

        setLineStyle(new LineStyle(Color.blue, w, t, c, j));
        drawEllipse(100, 100, 100, 80);
        drawEllipse(100, 100, 90, 70);
        drawEllipse(100, 100, 80, 60);
        drawEllipse(100, 100, 70, 50);

        setLineStyle(new LineStyle(Color.red, w, t, c, j));
        drawEllipse(100, 100, 80, 100);
        drawEllipse(100, 100, 70, 90);
        drawEllipse(100, 100, 60, 80);
        drawEllipse(100, 100, 50, 70);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void fillEllispse()
  {
    final String path = "test\\GraphImage\\fillEllipse.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 2;
        int t = LineStyle.TYPE_DOT;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_MITER;

        setLineStyle(new LineStyle(Color.blue, w, t, c, j));
        setFillStyle(new FillStyle(Color.cyan, true));
        fillEllipse(100, 100, 100, 60);

        setLineStyle(new LineStyle(Color.red, w, t, c, j));
        setFillStyle(new FillStyle(Color.orange, true));
        fillEllipse(100, 100, 60, 100);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void drawArc()
  {
    final String path = "test\\GraphImage\\drawArc.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 2;
        int t = LineStyle.TYPE_FINE_DOT;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_MITER;

        setLineStyle(new LineStyle(Color.blue, w, t, c, j));
        setFillStyle(new FillStyle(Color.cyan, true));
        drawArc(100, 100, 100, 80, 0, 30);
        drawArc(100, 100, 90, 70, 0, 30);
        drawArc(100, 100, 80, 60, 0, 30);
        drawArc(100, 100, 70, 50, 0, 30);

        setLineStyle(new LineStyle(Color.red, w, t, c, j));
        setFillStyle(new FillStyle(Color.orange, true));
        drawArc(100, 100, 80, 100, 90, 290);
        drawArc(100, 100, 70, 90, 90, 290);
        drawArc(100, 100, 60, 80, 90, 290);
        drawArc(100, 100, 50, 70, 90, 290);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void drawArc_1()
  {
    final String path = "test\\GraphImage\\drawArc1.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 1;
        int t = LineStyle.TYPE_SOLID;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_MITER;

        setLineStyle(new LineStyle(Color.blue, w, t, c, j));
        drawArc(100, 100, 90, 70, 0+90, -110+90);

        setLineStyle(new LineStyle(Color.green, w, t, c, j));
        drawArc(100, 100, 90, 70, -110+90, -230+90);

        setLineStyle(new LineStyle(Color.red, w, t, c, j));
        drawArc(100, 100, 90, 70, -230+90, -283+90);

        setLineStyle(new LineStyle(Color.magenta, w, t, c, j));
        drawArc(100, 100, 90, 70, -283+90, -300+90);

        setLineStyle(new LineStyle(Color.darkGray, w, t, c, j));
        drawArc(100, 100, 90, 70, -300+90, -360+90);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.lightGray);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void fillArc()
  {
    final String path = "test\\GraphImage\\fillArc.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 1;
        int t = LineStyle.TYPE_SOLID;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_MITER;

        setLineStyle(new LineStyle(Color.blue, w, t, c, j));
        setFillStyle(new FillStyle(Color.cyan, true));
        fillArc(100, 100, 90, 70, 0+90, -110+90);

        setLineStyle(new LineStyle(Color.green, w, t, c, j));
        setFillStyle(new FillStyle(Color.yellow, true));
        fillArc(100, 100, 90, 70, -110+90, -230+90);

        setLineStyle(new LineStyle(Color.red, w, t, c, j));
        setFillStyle(new FillStyle(Color.orange, true));
        fillArc(100, 100, 90, 70, -230+90, -283+90);

        setLineStyle(new LineStyle(Color.magenta, w, t, c, j));
        setFillStyle(new FillStyle(Color.pink, true));
        fillArc(100, 100, 90, 70, -283+90, -300+90);

        setLineStyle(new LineStyle(Color.darkGray, w, t, c, j));
        setFillStyle(new FillStyle(Color.gray, true));
        fillArc(100, 100, 90, 70, -300+90, -360+90);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.lightGray);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void drawText()
  {
    final String path = "test\\GraphImage\\drawString.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        String txt = "`B";
        TextStyle tstyle;

        setTextStyle(new TextStyle(Color.blue));
        drawText(txt, 20, 20);

        tstyle = new TextStyle();
        tstyle.setBackGroundColor(Color.blue);
        tstyle.setColor(Color.yellow);
        setTextStyle(tstyle);
        drawText(txt, 20, 40);

        tstyle = new TextStyle(Color.black);
        tstyle.setBold(true);
        setTextStyle(tstyle);
        drawText(txt, 20, 60);

        tstyle = new TextStyle(Color.black);
        tstyle.setItalic(true);
        setTextStyle(tstyle);
        drawText(txt, 20, 80);

        tstyle = new TextStyle(Color.black);
        tstyle.setUnderline(true);
        setTextStyle(tstyle);
        drawText(txt, 20, 100);

        tstyle = new TextStyle(Color.black);
        tstyle.setSize(20);
        setTextStyle(tstyle);
        drawText(txt, 20, 120);

        tstyle = new TextStyle(Color.black);
        tstyle.setSize(8);
        setTextStyle(tstyle);
        drawText(txt, 20, 140);

        tstyle = new TextStyle(Color.black);
        setTextStyle(tstyle);
        drawText(txt, 20, 160);

        tstyle = new TextStyle(Color.black, "MS UI Gothic", 18);
        tstyle.setBackGroundColor(Color.cyan);
        setTextStyle(tstyle);
        drawText(txt, 20, 180);

        tstyle = new TextStyle(Color.black);
        setTextStyle(tstyle);
        drawText(txt, 100, 300);
        drawText(txt, 100, 300, 20.0f);
        drawText(txt, 100, 300, 40.0f);
        drawText(txt, 100, 300, 60.0f);
        drawText(txt, 100, 300, 80.0f);
        drawText(txt, 100, 300, 100.0f);
        drawText(txt, 100, 300, 120.0f);
        drawText(txt, 100, 300, 140.0f);
        drawText(txt, 100, 300, 160.0f);
        drawText(txt, 100, 300, 180.0f);
        drawText(txt, 100, 300, 200.0f);
        drawText(txt, 100, 300, 220.0f);
        drawText(txt, 100, 300, 240.0f);
        drawText(txt, 100, 300, 260.0f);
        drawText(txt, 100, 300, 280.0f);
        drawText(txt, 100, 300, 300.0f);
        drawText(txt, 100, 300, 320.0f);
        drawText(txt, 100, 300, 340.0f);

        setScale(0.5, 0.5);
        tstyle = new TextStyle(Color.black, "MS UI Gothic", 18);
        setTextStyle(tstyle);
        drawText(txt, 20, 180);
      }
    };
    gi.setSize(200, 500);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void getTextDrawnBounds()
  {
    final String path = "test\\GraphImage\\getTextDrawnBounds.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        String txt = "`̈̎擾B";
        TextStyle tstyle;
        float[] rc;

        tstyle = new TextStyle(Color.blue);
        tstyle.setBackGroundColor(Color.cyan);
        setTextStyle(tstyle);
        drawText(txt, 20, 20, 0f);

        setLineStyle(new LineStyle(Color.red));
        rc = getTextDrawnBounds(txt, 20, 20, 0f);
        drawRect(rc[L], rc[T], rc[R], rc[B]);

        setScale(3f, 4f);

        drawText(txt, 10, 12, 0f);
        rc = getTextDrawnBounds(txt, 10, 12, 0f);
        drawRect(rc[L], rc[T], rc[R], rc[B]);

        drawText(txt, 10, 20, 30f);
        rc = getTextDrawnBounds(txt, 10, 20, 30f);
        drawRect(rc[L], rc[T], rc[R], rc[B]);

        drawText(txt, 10, 40, 40);
        rc = getTextDrawnBounds(txt, 10, 40, 40f);
        drawRect(rc[L], rc[T], rc[R], rc[B]);

        setTextStyle(tstyle);
        drawText(txt, 20, 60);

        rc = getTextDrawnBounds(txt, 20, 60);
        drawRect(rc[L], rc[T], rc[R], rc[B]);
      }
    };
    gi.setSize(200, 500);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      OK();
    } catch (Exception e) {
      NG(e);
    }
  }

  public void drawPolygon_1()
  {
    MSG("xWyW̔z̃TCYႤꍇB");

    final String path = "test\\GraphImage\\fillPolygon.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 16;
        int t = LineStyle.TYPE_SOLID;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_ROUND;
        float x[], y[];

        x = new float[3];
        y = new float[4];
        x[0] = 60;
        y[0] = 20;
        x[1] = 80;
        y[1] = 80;
        x[2] = 120;
        y[2] = 60;
        y[3] = 11;

        setOrigin(60, 00);

        j = BasicStroke.JOIN_ROUND;
        setLineStyle(new LineStyle(Color.red, w, t, c, j));
        setFillStyle(new FillStyle(Color.magenta, true));
        drawPolygon(x, y);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void drawPolyLine_1()
  {
    MSG("xWyW̔z̃TCYႤꍇB");

    final String path = "test\\GraphImage\\fillPolygon.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 16;
        int t = LineStyle.TYPE_SOLID;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_ROUND;
        float x[], y[];

        x = new float[3];
        y = new float[4];
        x[0] = 60;
        y[0] = 20;
        x[1] = 80;
        y[1] = 80;
        x[2] = 120;
        y[2] = 60;
        y[3] = 11;

        setOrigin(60, 00);

        j = BasicStroke.JOIN_ROUND;
        setLineStyle(new LineStyle(Color.red, w, t, c, j));
        setFillStyle(new FillStyle(Color.magenta, true));
        drawPolyLine(x, y);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void fillPolygon_1()
  {
    MSG("xWyW̔z̃TCYႤꍇB");

    final String path = "test\\GraphImage\\fillPolygon.png";
    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 16;
        int t = LineStyle.TYPE_SOLID;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_ROUND;
        float x[], y[];

        x = new float[3];
        y = new float[4];
        x[0] = 60;
        y[0] = 20;
        x[1] = 80;
        y[1] = 80;
        x[2] = 120;
        y[2] = 60;
        y[3] = 11;

        setOrigin(60, 00);

        j = BasicStroke.JOIN_ROUND;
        setLineStyle(new LineStyle(Color.red, w, t, c, j));
        setFillStyle(new FillStyle(Color.magenta, true));
        fillPolygon(x, y);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    try {
      gi.createImageFile(gi.TYPE_PNG, path);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }

  public void outputImage()
  {
    final String path = "test\\GraphImage\\outputImage_ostream.png";

    GraphImage gi = new GraphImageEx() {
      protected void drawGraph(Rectangle drawRect) {
        int w = 2;
        int t = LineStyle.TYPE_DOT;
        int c = BasicStroke.CAP_SQUARE;
        int j = BasicStroke.JOIN_MITER;

        setLineStyle(new LineStyle(Color.blue, w, t, c, j));
        setFillStyle(new FillStyle(Color.cyan, true));
        fillEllipse(100, 100, 100, 60);

        setLineStyle(new LineStyle(Color.red, w, t, c, j));
        setFillStyle(new FillStyle(Color.orange, true));
        fillEllipse(100, 100, 60, 100);
      }
    };
    gi.setSize(200, 200);
    gi.setBgColor(Color.yellow);
    gi.setBorderStyle(new LineStyle(Color.black, 1));

    FileOutputStream ostream = null;
    try {
      ostream = new FileOutputStream(new File(path));
      gi.outputImage(gi.TYPE_PNG, ostream);
      ostream.flush();
      OK();
    } catch (Exception e) {
      NG(e);
    } finally {
      if (ostream != null) try { ostream.close(); } catch (Exception e) {}
    }
  }
}
