/*
 * AbstractTypedGetter class.
 *
 * Copyright (C) 2011 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.text.DecimalFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Set;
import java.util.HashSet;

/**
 * L[ɌтꂽlIuWFNg^ϊĎ擾邽߂̃\bh
 * ۃNXB
 *
 * @author V
 * @version $Id: AbstractTypedGetter.java,v 1.2 2011-07-04 15:42:56 tayu Exp $
 */
public abstract class AbstractTypedGetter<K,V> implements TypedGetter<K>
{
  /**
   * {@link #getBoolean(Object)}\bhɂ<tt>true</tt>Ԃꍇ
   * lIuWFNgi[WIuWFNgB
   */
  private final Set<Object> trueSet;

  /** ftHg̓tH[}bgB */
  private DateFormat dateTimeFormat;

  /**
   * ftHgERXgN^B
   */
  public AbstractTypedGetter()
  {
    this.trueSet = new HashSet<Object>();
    this.trueSet.add(Boolean.TRUE);
    this.trueSet.add(Boolean.TRUE.toString());

    this.dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
  }

  /**
   * w肳ꂽL[ɌтĂlIuWFNg擾B
   * <br>
   * тꂽlIuWFNg݂Ȃꍇ̓kԂB
   *
   * @param key L[B
   * @return ̃L[ɌтĂlIuWFNgB
   */
  protected abstract V get(K key);

  /**
   * {@link #getBoolean(Object)}\bhɂāAʂ<tt>true</tt>Ƃ
   * IuWFNgǉB
   *
   * @param obj {@link #getBoolean(Object)}\bhɂāAʂ<tt>true</tt>
   *            ƂIuWFNgB
   */
  public void addTrueObject(Object obj)
  {
    this.trueSet.add(obj);
  }

  /**
   * {@link #getBoolean(Object)}\bhɂāAʂ<tt>true</tt>Ƃ
   * IuWFNg폜B
   *
   * @param obj 폜IuWFNgB
   */
  public void removeTrueObject(Object obj)
  {
    this.trueSet.remove(obj);
  }

  /**
   * ftHg̓ݒ肷B
   * <br>
   * ̃\bhŐݒ肵́A{@link #getDateTime(Object)}
   * \bhɂĕlIuWFNgɕϊA{@link
   * #getString(Object)}\bhɂēIuWFNg𕶎lɕϊ
   * ߂ɎgpB
   * <br>
   * ȂÃIuWFNgCX^X
   * <tt>"yyyy-MM-dd HH:mm:ss"</tt>ftHg̓ƂĎgp
   * B
   * <br>
   * k͓Ƃĕs̏ꍇ̓ftHg̓XVȂB
   *
   * @param formatString B
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public void setDateTimeFormat(String formatString)
  {
    assert (formatString != null) : "@param:formatString is null.";
    
    try {
      this.dateTimeFormat = new SimpleDateFormat(formatString);
    }
    catch (Exception e) {}
  }

  /**
   * ftHg̓IuWFNgݒ肷B
   * <br>
   * ̃\bhŐݒ肵IuWFNǵA{@link #getDateTime(Object)}
   * \bhɂĕlIuWFNgɕϊA{@link
   * #getString(Object)}\bhɂēIuWFNg𕶎lɕϊ
   * ߂ɎgpB
   * <br>
   * ȂÃIuWFNgCX^X
   * <tt>"yyyy-MM-dd HH:mm:ss"</tt>ftHg̓ƂĎgp
   * B
   * <br>
   * k̏ꍇ̓ftHg̓XVȂB
   *
   * @param format IuWFNgB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public void setDateTimeFormat(DateFormat format)
  {
    assert (format != null) : "@param:format is null.";

    if (format == null) return;
    this.dateTimeFormat = format;
  }

  /**
   * w肳ꂽL[ɌтꂽlIuWFNg<tt>boolean</tt>ɕϊ
   * 擾B
   *
   * @param key L[B
   * @return <tt>boolean</tt>^ɕϊꂽlB
   */
  @Override
  public boolean getBoolean(K key)
  {
    return this.trueSet.contains(get(key));
  }

  /**
   * w肳ꂽL[ɌтꂽlIuWFNg<tt>int</tt>^ɕϊ 
   * 擾B
   *
   * @param key L[B
   * @return <tt>int</tt>^Ɏw肳ꂽlB
   */
  @Override
  public int getInteger(K key)
  {
    Object v = get(key);
    if (v == null) {
      return 0;
    }
    else if (v instanceof Integer) {
      return Integer.class.cast(v).intValue();
    }
    else if (v instanceof Long) {
      return (int) limit(
        Long.class.cast(v).longValue(),
        (long) Integer.MIN_VALUE,
        (long) Integer.MAX_VALUE);
    }
    else if (v instanceof BigInteger) {
      return limit(
        new BigDecimal(BigInteger.class.cast(v)),
        new BigDecimal(Integer.MIN_VALUE),
        new BigDecimal(Integer.MAX_VALUE)).intValue();
    }
    else if (v instanceof BigDecimal) {
      return limit(
        BigDecimal.class.cast(v),
        new BigDecimal(Integer.MIN_VALUE),
        new BigDecimal(Integer.MAX_VALUE)).intValue();
    }
    else if (v instanceof Float) {
      return (int) limit(
        Float.class.cast(v),
        (float) Integer.MIN_VALUE,
        (float) Integer.MAX_VALUE);
    }
    else if (v instanceof Double) {
      return (int) limit(
        Double.class.cast(v),
        (double) Integer.MIN_VALUE,
        (double) Integer.MAX_VALUE);
    }
    else if (v instanceof Number) {
      return Number.class.cast(v).intValue();
    }
    else {
      try {
        return limit(
          new BigDecimal(v.toString(), MathContext.UNLIMITED),
          new BigDecimal(Integer.MIN_VALUE),
          new BigDecimal(Integer.MAX_VALUE)).intValue();
      }
      catch (Exception e) {
        return 0;
      }
    }
  }

  /**
   * w肳ꂽL[ɌтꂽlIuWFNg<tt>long</tt>^ɕϊ
   * 擾B
   * <br>
   * lIuWFNg݂Ȃꍇk̏ꍇ<tt>0</tt>ԂB
   *
   * @param key L[B
   * @return <tt>long</tt>^ɕϊꂽlB
   */
  @Override
  public long getLong(K key)
  {
    Object v = get(key);
    if (v == null) {
      return 0L;
    }
    else if (v instanceof Integer) {
      return (long) Integer.class.cast(v).intValue();
    }
    else if (v instanceof Long) {
      return Long.class.cast(v).longValue();
    }
    else if (v instanceof BigInteger) {
      return limit(
        new BigDecimal(BigInteger.class.cast(v)),
        new BigDecimal(Long.MIN_VALUE),
        new BigDecimal(Long.MAX_VALUE)).longValue();
    }
    else if (v instanceof BigDecimal) {
      return limit(
        BigDecimal.class.cast(v),
        new BigDecimal(Long.MIN_VALUE),
        new BigDecimal(Long.MAX_VALUE)).longValue();
    }
    else if (v instanceof Float) {
      return (long) limit(
        Float.class.cast(v),
        (float) Long.MIN_VALUE,
        (float) Long.MAX_VALUE);
    }
    else if (v instanceof Double) {
      return (long) limit(
        Double.class.cast(v),
        (double) Long.MIN_VALUE,
        (double) Long.MAX_VALUE);
    }
    else if (v instanceof Number) {
      return Number.class.cast(v).longValue();
    }
    else {
      try {
        return limit(
          new BigDecimal(v.toString(), MathContext.UNLIMITED),
          new BigDecimal(Long.MIN_VALUE),
          new BigDecimal(Long.MAX_VALUE)).longValue();
      }
      catch (Exception e) {
        return 0L;
      }
    }
  }

  /**
   * w肳ꂽL[ɌтꂽlIuWFNg<tt>float</tt>^ɕϊ
   * 擾B
   * <br>
   * lIuWFNg݂Ȃꍇk̏ꍇ<tt>0.0</tt>ԂB 
   *
   * @param key L[B
   * @return <tt>float</tt>^ɕϊꂽlB
   */
  @Override
  public float getFloat(K key)
  {
    Object v = get(key);
    if (v == null) {
      return 0.0f;
    }
    else if (v instanceof Float) {
      return Float.class.cast(v).floatValue();
    }
    else if (v instanceof Double) {
      return new BigDecimal(Double.class.cast(v).doubleValue()).floatValue();
    }
    else if (v instanceof BigInteger) {
      return new BigDecimal(BigInteger.class.cast(v)).floatValue();
    }
    else if (v instanceof BigDecimal) {
      return BigDecimal.class.cast(v).floatValue();
    }
    else if (v instanceof Number) {
      return (float) Number.class.cast(v).longValue();
    }
    else {
      try {
        return limit(
          new BigDecimal(v.toString(), MathContext.UNLIMITED),
          new BigDecimal(-Float.MAX_VALUE),
          new BigDecimal( Float.MAX_VALUE)).floatValue();
      }
      catch (Exception e) {
        return 0.0f;
      }
    }
  }

  /**
   * w肳ꂽL[ɌтꂽlIuWFNg<tt>double</tt>^ɕϊ
   * 擾B
   * <br>
   * lIuWFNg݂Ȃꍇk̏ꍇ<tt>0.0</tt>ԂB
   *
   * @param key L[B
   * @return <tt>double</tt>^ɕϊꂽlB
   */
  @Override
  public double getDouble(K key)
  {
    Object v = get(key);
    if (v == null) {
      return 0.0;
    }
    else if (v instanceof Float) {
      return (double) Float.class.cast(v).floatValue();
    }
    else if (v instanceof Double) {
      return Double.class.cast(v).doubleValue();
    }
    else if (v instanceof BigInteger) {
      return new BigDecimal(BigInteger.class.cast(v)).doubleValue();
    }
    else if (v instanceof BigDecimal) {
      return BigDecimal.class.cast(v).doubleValue();
    }
    else if (v instanceof Number) {
      return (double) Number.class.cast(v).longValue();
    }
    else {
      try {
        return limit(
          new BigDecimal(v.toString(), MathContext.UNLIMITED),
          new BigDecimal(-Double.MAX_VALUE),
          new BigDecimal( Double.MAX_VALUE)).doubleValue();
      }
      catch (Exception e) {
        return 0.0;
      }
    }
  }
 
  /**
   * w肳ꂽL[ɌтꂽlIuWFNg{@link BigDecimal}
   * IuWFNgɕϊĎ擾B
   * <br>
   * lIuWFNg݂Ȃꍇk̏ꍇ͒l<tt>0</tt>{@link
   * BigDecimal}IuWFNgԂB
   *
   * @param key L[B
   * @return {@link BigDecimal}IuWFNgB
   */
  @Override
  public BigDecimal getBigDecimal(K key)
  {
    Object v = get(key);
    if (v == null) {
      return new BigDecimal(0L);
    }
    else if (v instanceof Float) {
      return new BigDecimal(Float.class.cast(v).floatValue());
    }
    else if (v instanceof Double) {
      return new BigDecimal(Double.class.cast(v).doubleValue());
    }
    else if (v instanceof BigInteger) {
      return new BigDecimal(BigInteger.class.cast(v));
    }
    else if (v instanceof BigDecimal) {
      return BigDecimal.class.cast(v);
    }
    else if (v instanceof Number) {
      return new BigDecimal(Number.class.cast(v).longValue());
    }
    else {
      try {
        return new BigDecimal(v.toString(), MathContext.UNLIMITED);
      }
      catch (Exception e) {
        return new BigDecimal(0L);
      }
    }
  }

  /**
   * w肳ꂽL[ɌтꂽlIuWFNg𕶎IuWFNgɕϊ
   * 擾B
   * <br>
   * lIuWFNg݂Ȃꍇk̏ꍇ͋󕶎ԂB
   *
   * @param key L[B
   * @return IuWFNgɕϊꂽlIuWFNgB
   */
  @Override
  public String getString(K key)
  {
    Object v = get(key);
    if (v == null) {
      return "";
    }
    else if (v instanceof DateTime) {
      return dateTimeFormat.format(DateTime.class.cast(v).getDate());
    }
    else if (v instanceof Date) {
      return dateTimeFormat.format(Date.class.cast(v));
    }
    else {
      return v.toString();
    }
  }

  /**
   * w肳ꂽL[ɌтꂽlIuWFNgAw肳ꂽl
   * gĕIuWFNgɕϊĎ擾B
   * <br>
   * ĺA{@link DecimalFormat}Ɏw肷p^[Ɠ̂łB
   * <br>
   * w肳ꂽL[ɌтꂽlIuWFNg𐔒lɕϊłȂꍇ
   * 󕶎ԂB
   *
   * @param key L[B
   * @param format lB
   * @return IuWFNgɕϊꂽlIuWFNgB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  @Override
  public String getNumberString(K key, String format)
  {
    assert (format != null) : "@param:format is null.";

    Object v = get(key);
    try {
      if (v == null) {
        return "";
      }
      else if (v instanceof Float) {
        double d = Float.class.cast(v).doubleValue();
        return new DecimalFormat(format).format(d);
      }
      else if (v instanceof Double) {
        double d = Double.class.cast(v).doubleValue();
        return new DecimalFormat(format).format(d);
      }
      else if (v instanceof Number) {
        return new DecimalFormat(format).format(Number.class.cast(v));
      }
      else {
        return new DecimalFormat(format).format(new BigDecimal(v.toString()));
      }
    }
    catch (Exception e) {
      return "";
    }
  }

  /**
   * w肳ꂽL[ɌтꂽlIuWFNgAw肳ꂽ
   * gĕIuWFNgɕϊĎ擾B
   * <br>
   * ́A{@link SimpleDateFormat}Ɏw肷p^[Ɠ̂
   * B
   * <br>
   * w肳ꂽL[ɌтꂽlIuWFNgɕϊłȂꍇ
   * 󕶎ԂB
   *
   * @param key L[B
   * @param format B 
   * @return IuWFNgɕϊꂽlIuWFNgB
   */
  @Override
  public String getDateTimeString(K key, String format)
  {
    assert (format != null) : "@param:format is null.";

    Object v = get(key);
    try {
      if (v == null) {
        return "";
      }
      else if (v instanceof DateTime) {
        Date d = DateTime.class.cast(v).getDate();
        return new SimpleDateFormat(format).format(d);
      }
      else if (v instanceof Date) {
        Date d = Date.class.cast(v);
        return new SimpleDateFormat(format).format(d);
      }
      else {
        Date d = dateTimeFormat.parse(v.toString());
        return new SimpleDateFormat(format).format(d);
      }
    }
    catch (Exception e) {
      return "";
    }
  }

  /**
   * w肳ꂽL[ɌтꂽlIuWFNgIuWFNgɕϊ
   * 擾B
   * <br>
   * w肳ꂽL[ɌтꂽlIuWFNgɕϊłȂꍇ
   * 1970N11000b\{@link DateTime}IuWFNgԂB
   *
   * @param key L[B
   * @return IuWFNgɕϊꂽlIuWFNgB
   */
  @Override
  public DateTime getDateTime(K key)
  {
    Object v = get(key);
    if (v == null) {
      return new DateTime(0);
    }
    else if (v instanceof DateTime) {
      return DateTime.class.cast(v);
    }
    else if (v instanceof Date) {
      return new DateTime(Date.class.cast(v));
    }
    else {
      try {
        return new DateTime(dateTimeFormat.parse(v.toString()));
      }
      catch (Exception e) {
        return new DateTime(0);
      }
    }
  }

  /**
   * w肳ꂽL[ɌтꂽlIuWFNgXgEIuWFNgɕϊ
   * Ď擾B
   * <br>
   * тĂlIuWFNgPl̏ꍇ́A̒lIuWFNgB 
   * vfƂ郊XgEIuWFNg쐬ĕԂB
   * <br>
   * w肳ꂽL[ɌтꂽlIuWFNg݂Ȃk̏ꍇ
   * ̃XgԂB
   * 
   * @param key L[B
   * @return {@link List}IuWFNgɕϊꂽlIuWFNgB
   */
  @Override
  @SuppressWarnings("unchecked")
  public List<? extends Object> getList(K key)
  {
    Object v = get(key);
    if (v == null) {
      return new ArrayList(0);
    }
    else if (v instanceof List) {
      return (List<? extends Object>) v;
    }
    else if (v instanceof Collection) {
      return new ArrayList<Object>(Collection.class.cast(v));
    }
    else if (v instanceof Object[]) {
      Object[] arr = Object[].class.cast(v);
      List lst = new ArrayList(arr.length);
      for (Object o : arr) {
        lst.add(o);
      }
      return lst;
    }
    else if (v instanceof boolean[]) {
      boolean[] arr = boolean[].class.cast(v);
      List lst = new ArrayList(arr.length);
      for (boolean b : arr) {
        lst.add(b ? Boolean.TRUE : Boolean.FALSE);
      }
      return lst;
    }
    else if (v instanceof int[]) {
      int[] arr = int[].class.cast(v);
      List lst = new ArrayList(arr.length);
      for (int i : arr) {
        lst.add(new Integer(i));
      }
      return lst;
    }
    else if (v instanceof long[]) {
      long[] arr = long[].class.cast(v);
      List lst = new ArrayList(arr.length);
      for (long l : arr) {
        lst.add(new Long(l));
      }
      return lst;
    }
    else if (v instanceof float[]) {
      float[] arr = float[].class.cast(v);
      List lst = new ArrayList(arr.length);
      for (float f : arr) {
        lst.add(new Float(f));
      }
      return lst;
    }
    else if (v instanceof double[]) {
      double[] arr = double[].class.cast(v);
      List lst = new ArrayList(arr.length);
      for (double d : arr) {
        lst.add(new Double(d));
      }
      return lst;
    }
    else if (v instanceof short[]) {
      short[] arr = short[].class.cast(v);
      List lst = new ArrayList(arr.length);
      for (short s : arr) {
        lst.add(new Short(s));
      }
      return lst;
    }
    else if (v instanceof byte[]) {
      byte[] arr = byte[].class.cast(v);
      List lst = new ArrayList(arr.length);
      for (byte b : arr) {
        lst.add(new Byte(b));
      }
      return lst;
    }
    else if (v instanceof char[]) {
      char[] arr = char[].class.cast(v);
      List lst = new ArrayList(arr.length);
      for (char c : arr) {
        lst.add(new Character(c));
      }
      return lst;
    }
    else {
      List lst = new ArrayList(1);
      lst.add(v);
      return lst;
    }
  }


  /**
   * <tt>long</tt>lw肵őlƍŏlŃ~bgB
   *
   * @param val ~bg<tt>long</tt>lB
   * @param min ŏlB
   * @param max őlB
   * @return ~bg<tt>long</tt>lB
   */
  protected long limit(long val, long min, long max)
  {
    return Math.max(min, Math.min(max, val));
  }

  /**
   * <tt>float</tt>lw肵őlƍŏlŃ~bgB
   *
   * @param val ~bg<tt>float</tt>lB
   * @param min ŏlB
   * @param max őlB
   * @return ~bg<tt>float</tt>lB
   */
  protected float limit(float val, float min, float max)
  {
    return Math.max(min, Math.min(max, val));
  }

  /**
   * <tt>double</tt>lw肵őlƍŏlŃ~bgB
   *
   * @param val ~bg<tt>double</tt>lB
   * @param min ŏlB
   * @param max őlB
   * @return ~bg<tt>double</tt>lB
   */
  protected double limit(double val, double min, double max)
  {
    return Math.max(min, Math.min(max, val));
  }

  /**
   * {@link BigDecimal}IuWFNgw肵őlƍŏlŃ~bgB
   *
   * @param val ~bg{@link BigDecimal}IuWFNgB
   * @param min ŏlB
   * @param max őlB
   * @return ~bg{@link BigDecimal}IuWFNgB
   */
  protected BigDecimal limit(BigDecimal val, BigDecimal min, BigDecimal max)
  {
    if (val.compareTo(min) < 0) {
      return min;
    }
    else if (val.compareTo(max) > 0) {
      return max;
    }
    else {
      return val;
    }
  }
}
