/*
 * PropertyResource class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.resource;

import ts.util.text.StringOperation;
import java.io.InputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.FileOutputStream;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Properties;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Date;

/**
 * vpeBt@CΏۂƂ郊\[XNXB 
 * <br>
 * JavavpeBt@C[hāA̓ew肳ꂽL[ɑ΂l
 * 擾B
 * <br>
 * {@link java.util.Properties}NXł́AvpeBt@C̃L[
 * vpeBt@C̃L[͈̏ʓIɁA
 * <pre>    vf1.vf2.vf3 = l</pre>
 * ̂悤ɋLqAvpeBL[ƒl11łݒłȂB
 * <br>
 * ɑ΂ÃNXł{@link ts.util.resource.Resource}NX
 * ̃\[XL[̏ɏ]ċLqꂽvpeBL[߂ł悤ɂ
 * AɂĂP̃L[̒lAL[lɂ
 * قȂlƂł悤ɂĂB
 * <br>
 * vpeBL[̗̏ȉɎB
 * <pre>    vf1.vf2(1\=l1,2\=l2).vf3 = l</pre>
 * AA̖Oƒl铙(=)́AGXP[vi'\'LOɕt
 * jKvB
 *
 * @author  V. 
 * @version $Revision: 1.2 $, $Date: 2011-08-01 15:29:31 $
 */
public class PropertyResource extends DefaultResource
{
  /** VAEo[WԍB */
  static final long serialVersionUID = 6818536291353948226L;

  /**
   * ftHgRXgN^B
   */
  public PropertyResource()
  {}

  /**
   * vpeBt@CɂƂRXgN^B
   *
   * @param  path vpeBt@C̃pXB
   * @throws FileNotFoundException w肵pX̃t@CȂꍇB
   * @throws IOException t@C̓o͒ɗOꍇB
   */
  public PropertyResource(String path) throws FileNotFoundException, IOException
  {
    load(path);
  }

  /**
   * Rs[RXgN^B
   *
   * @param  res Rs[̃vpeB\[XIuWFNgB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  protected PropertyResource(PropertyResource res)
  {
    super(res);
  }

  /**
   * ̃IuWFNgƓNX̃\[XIuWFNg쐬B
   *
   * @return ̃IuWFNgƓNX̃\[XIuWFNgB
   */
  @Override
  protected DefaultResource createResource()
  {
    return new PropertyResource(this);
  }

  /**
   * ̓̓Xg[烊\[Xt@C̓eǂݍށB
   *
   * @param  stream ̓Xg[B
   * @throws IOException ǂݍݒɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  @Override
  protected void load(InputStream stream) throws IOException
  {
    assert (stream != null) : "@param:stream is null.";

    renew();

    PropertiesReader prop = new PropertiesReader();
    prop.load(stream);
  }

  /**
   * ̏o̓Xg[ɁÃIuWFNgێĂeۑB
   *
   * @param  stream o̓Xg[B
   * @throws IOException t@C̕ۑɗOꍇB
   * @throws AssertionError k̏ꍇifobO[ĥ݁jB
   */
  @Override
  public void save(OutputStream stream) throws IOException
  {
    assert (stream != null) : "@param:stream is null.";

    try {
      PropertiesWriter prop = new PropertiesWriter();
      prop.store(stream, null);
    }
    catch (IOException e) {
      throw e;
    }
    catch (Exception e) {
      IOException ex = new IOException(e.toString());
      ex.setStackTrace(e.getStackTrace());
      throw ex;
    }
  }

  /* -- inner class -- */

  /**
   * vpeBt@C̓ǂݍ݂s߂̃NXB
   */
  private class PropertiesReader extends Properties
  {
    /** VAԍB */
    static final long serialVersionUID = 1121939455320561763L;

    /** L[̉߂Ɏgp郊\[Xt@CB */
    private PropertyResource loadRes_;

    /**
     * ftHgRXgN^B
     */
    public PropertiesReader()
    {
      loadRes_ = new PropertyResource();
      loadRes_.setElementSeparator(".");
      loadRes_.setAttributeParenthesis("(", ")");
      loadRes_.setAttributeSeparator(",");
      loadRes_.setAttributeMatchMark("=");
    }

    /**
     * vpeBL[ƒlݒ肷B
     *
     * @param  key vpeBL[B
     * @param  value vpeBlB
     * @return w肳ꂽvpeBL[ɑOݒ肳ĂlB
     * @throws IllegalKeyException w肳ꂽL[sȏꍇB
     * @throws AssertionError L[͒lk̏ꍇifobO[ĥ݁jB
     */
    @Override
    public Object put(Object key, Object value) throws IllegalKeyException
    {
      assert (key != null) : "@param:key is null.";
      assert (value != null) : "@param:value is null.";
      assert (key instanceof String) : "@param:key is not a string.";
      assert (value instanceof String) : "@param:value is not a string.";

      String sKey = key.toString();
      String sValue = value.toString();

      if (StringOperation.isEmpty(sKey)) {
        if (getBaseElement() == getRootElement()) {
          throw new IllegalKeyException(sKey);
        }
      }

      List<String> keyElemLst = loadRes_.splitKey(sKey);
      int lastIndex = keyElemLst.size() - 1;

      List<String> parentKeyLst = keyElemLst.subList(0, lastIndex);
      Element elem = findOrCreateFirstElement(parentKeyLst);

      String lastKeyElem = keyElemLst.get(lastIndex);
      String elemName = getNameOfKeyElement(lastKeyElem);
      List<String[]> attrLst = listAttributesOfKeyElement(lastKeyElem);

      Element lastElem = new Element(elemName);
      for (String[] attr : attrLst) {
        lastElem.putAttribute(attr[0], attr[1]);
      }
      lastElem.setValue(sValue);

      elem.addChild(lastElem);
      return lastElem;
    }
  }

  /**
   * vpeBt@C̕ۑ邽߂̃NXB
   */
  private class PropertiesWriter extends Properties
  {
    /** VAԍB */
    static final long serialVersionUID = -3779072493340204504L;

    /** L[̉߂Ɏgp郊\[Xt@CB */
    private PropertyResource loadRes_;

    /** L[ƒl̔zi[郊XgB */
    private List<String[]> elementLst_ = new LinkedList<String[]>();

    /** Xg̃CfbNXB@*/
    private int index_ ;

    /**
     * ftHgRXgN^B
     */
    public PropertiesWriter()
    {
      loadRes_ = new PropertyResource();
      loadRes_.setElementSeparator(".");
      loadRes_.setAttributeParenthesis("(", ")");
      loadRes_.setAttributeSeparator(",");
      loadRes_.setAttributeMatchMark("=");
    }

    /**
     * vpeBL[i[񋓃IuWFNg擾B
     *
     * @return vpeBL[i[񋓃IuWFNgB
     */
    @Override
    public Enumeration<Object> keys()
    {
      index_ = 0;
      elementLst_.clear();
      listAllElements(getBaseElement(), "", elementLst_);
      return new Enumeration<Object>() {
          public boolean hasMoreElements() {
            return (index_ < elementLst_.size());
          }
          public Object nextElement() {
            String[] kv = elementLst_.get(index_);
            index_ ++;
            return kv[0];
          }
        };
    }

    /**
     * w肳ꂽvpeBL[ɑΉvpeBl擾B
     * <br>
     * ۂɂ́AŕێĂCfbNXɑΉlԂB
     * ŕێĂCfbNX́A
     * {@link ts.util.resource.PropertyResource.PropertiesWriter#keys()}
     * \bhɂďÃ\bh̖߂lł
     * {@link java.util.Enumeration Enumeration}IuWFNg
     * {@link java.util.Enumeration#nextElement() nextElement()}\bh
     * s邲ƂɃCNgB
     *
     * @param  key vpeBL[B
     * @return vpeB̒lB
     * @throws IndexOutOfBoundsException ŕێĂCfbNX
     *           ͈͊ȌꍇB
     */
    @Override
    public Object get(Object key)
    {
      if (0 < index_ && index_ <= elementLst_.size()) {
        String[] kv = elementLst_.get(index_ - 1);
        return kv[1];
      }
      else {
        return null;
      }
    }

    /**
     * L[ƒl̔zXgɍċAIɊi[B
     *
     * @param  parent evfB
     * @param  parentKey evf̃L[B
     * @param  elemLst vfi[郊XgB
     * @throws AssertionError k̏ꍇifobO[ĥ݁jB
     */
    protected void listAllElements(
      Element parent, String parentKey, List<String[]> elemLst)
    {
      assert (parent != null) : "@param:parent is null.";
      assert (parentKey != null) : "@param:parentKey is null.";
      assert (elemLst != null) : "@param:elemLst is null.";

      List<Element> children = parent.getAllChildren();
      for (Element child : children) {
        StringBuilder kb = new StringBuilder();
        if (! StringOperation.isEmpty(parentKey)) {
          kb.append(parentKey).append(loadRes_.elementSeparator());
        }
        kb.append(child.getName());

        Iterator<Map.Entry<String, String>> attrIt;
        attrIt = child.getAttributes().entrySet().iterator();
        if (attrIt.hasNext()) {
          Map.Entry<String, String> attr = attrIt.next();
          kb.append(loadRes_.attributeParenthesis()[0]);
          kb.append(attr.getKey());
          kb.append(loadRes_.attributeMatchMark());
          kb.append(attr.getValue());
          while (attrIt.hasNext()) {
            attr = attrIt.next();
            kb.append(loadRes_.attributeSeparator());
            kb.append(attr.getKey());
            kb.append(loadRes_.attributeMatchMark());
            kb.append(attr.getValue());
          }
          kb.append(loadRes_.attributeParenthesis()[1]);
        }

        if (child.getValue() != null) {
          String[] kv = new String[2];
          kv[0] = kb.toString();
          kv[1] = child.getValue();
          elemLst.add(kv);
        }

        listAllElements(child, kb.toString(), elemLst);
      }
    }
  }
}
