/*
 * MapListTable class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.table;

import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.LinkedList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Collections;

/**
 * }bṽXgƂĎꂽe[uENXB
 * <br>
 * R[h\}bv{@link java.util.HashMap HashMap}IuWFNggp
 * B
 * AAJEL[̏W{@link ts.util.table.Header Header}IuWFNg
 * ɂăR[hԂŋpB
 * <br>
 * R[hERNV̓XgŎĂ邽߁AR[h̏ԂA
 * J̒lR[h𕡐i[邱ƂłB
 * <br>
 * ̃e[úAeR[h̃J\ꂳĂȂA
 * R[hɂăJ̒lƂǂ딲Ă悤ȏꍇ̗pɓK
 * B
 *
 * @param <C> JEL[̃^CvB
 * @param <V> J̒l̃^CvB 
 *
 * @author  V.
 * @version $Revision: 1.2 $, $Date: 2011-07-04 15:37:09 $
 */
public class MapListTable<C,V> extends AbstractTable<C,V>
{
  /** VAEo[WԍB */
  static final long serialVersionUID = -2802871239990289562L;

  /**
   * ftHgRXgN^B
   */
  public MapListTable()
  {}

  /**
   * R[heʂƏJeʂɂƂRXgN^B
   *
   * @param  initRecCapacity R[heʁB
   * @param  initColCapacity JeʁB
   * @throws AssertionError ̒l̏ꍇifobOE[ĥ݁jB
   */
  public MapListTable(int initRecCapacity, int initColCapacity)
  {
    super(initRecCapacity, initColCapacity);
  }

  /**
   * wb_ɂƂRXgN^B
   *
   * @param  header wb_EIuWFNgB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public MapListTable(ts.util.table.Header<C> header)
  {
    super(header);
  }

  /**
   * {@inheritDoc}
   *
   * @throws AssertionError ̒l̏ꍇifobOE[ĥ݁jB
   */
  @Override
  protected ts.util.table.Header<C> createHeader(int initColCapacity)
  {
    return new Header<C>(initColCapacity);
  }

  /**
   * {@inheritDoc}
   *
   * @throws AssertionError ̒l̏ꍇifobOE[ĥ݁jB
   */
  @Override
  protected Collection<Record<C,V>> createRecordCollection(int initRecCapacity)
  {
    assert (initRecCapacity >= 0) : "@param:initRecCapacity is negative.";
    return new LinkedList<Record<C,V>>();
  }

  /**
   * R[hEIuWFNg쐬B
   *
   * @param  initColCapacity JeʁB
   * @return R[hEIuWFNgB
   * @throws AssertionError ̒l̏ꍇifobOE[ĥ݁jB
   */
  @Override
  protected Record<C,V> createRecord(int initColCapacity)
  {
    assert (initColCapacity >= 0) : "@param:initColCapacity is negative.";
    return new MapListTableRecord();
  }

  /* -- inner class -- */

  /**
   * {@link ts.util.table.MapListTable MapListTable}NXgp
   * wb_ENXB
   */
  public static class Header<C> implements ts.util.table.Header<C>
  {
    /** VAEo[WԍB */
    static final long serialVersionUID = 7045899894614584582L;

    /** JEL[i[ӏWIuWFNgB */
    private Set<C> columnSet_ ;

    /**
     * JeʂɂƂRXgN^B
     *
     * @param  initColCapacity JeʁB
     * @throws AssertionError ̒l̏ꍇifobOE[ĥ݁jB
     */
    public Header(int initColCapacity)
    {
      assert (initColCapacity >= 0) : "@param:initColCapacity is negative.";
      columnSet_ = new HashSet<C>(initColCapacity);
    }

    /**
     * J擾B
     *
     * @return JB
     */
    public int columnCount()
    {
      return columnSet_.size();
    }

    /**
     * JEL[̃Ce[^擾B
     *
     * @return JEL[̃Ce[^B
     */
    public Enumeration<C> columns()
    {
      return Collections.enumeration(columnSet_);
    }

    /**
     * ̃wb_Ɏw肳ꂽJEL[i[Ă邩ǂmFB
     *
     * @param  column JEL[B
     * @return ̃JEL[Ãwb_Ɋi[Ăꍇ
     *         <tt>true</tt>ԂB
     */
    public boolean hasColumn(Object column)
    {
      return columnSet_.contains(column);
    }

    /**
     * JEL[ǉB
     *
     * @param  column JEL[B
     */
    public void addColumn(C column)
    {
      columnSet_.add(column);
    }
  }

  /**
   * {@link ts.util.table.MapListTable MapListTable}Ŏgp郌R[hENXB
   */
  protected class MapListTableRecord extends Record<C,V>
  {
    /** VAEo[WԍB */
    static final long serialVersionUID = 1964738182974536709L;

    /** li[}bvB */
    private Map<C,V> valueMap_ = new HashMap<C,V>();

    /**
     * ftHgERXgN^B
     */
    public MapListTableRecord()
    {}

    /**
     * {@inheritDoc}
     */
    @Override
    protected ts.util.table.Header<C> header()
    {
      return MapListTable.this.header();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected V getValue(Object column)
    {
      return valueMap_.get(column);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected V putValue(C column, V value)
    {
      return valueMap_.put(column, value);
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected V removeValue(Object column)
    {
      return valueMap_.remove(column);
    }
  }
}

