/*
 * StringCutter class.
 *
 * Copyright (C) 2007 SATOH Takayuki All Rights Reserved.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
package ts.util.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.LinkedList;

/**
 * ̕sNXB
 * <br>
 * ؂蕶ŕɕ邽߂̃\bhpӂB
 *
 * @author  V.
 * @version $Revision: 1.1.1.1 $, $Date: 2010-10-16 00:03:53 $
 */
public class StringCutter
{
  /**
   * ftHgRXgN^B
   */
  protected StringCutter()
  {}

  /**
   * Aw肳ꂽ؂蕶ŕɕB
   * <br>
   * {@link java.util.StringTokenizer StringTokenizer}Ƃ͈قȂA؂蕶
   * AČꂽꍇłÅԂ̋󕶎PvfƂĐB
   * ܂A؂蕶͕KvfƗvf̊Ԃɑ݂̂ƂāA܂͕
   * ɋ؂蕶񂪑݂ꍇ́A擪͖ɋ󕶎̗vftB
   * <br>
   * ؂蕶󕶎̏ꍇ́AOX[B
   *
   * @param  string 镶B
   * @param  delimiter ؂蕶B
   * @return i[XgB
   * @throws IllegalArgumentException ؂蕶񂪋󕶎̏ꍇB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static List<String> split(String string, String delimiter)
  {
    assert (string != null) : "@param:string is null.";
    assert (delimiter != null) : "@param:delimiter is null.";

    final int delimLen = StringOperation.length(delimiter);
    if (delimLen == 0) {
      throw new IllegalArgumentException("@param:delimiter is empty.");
    }

    List<String> lst = new LinkedList<String>();

    StringSequence seq = new StringSequence(string, -1);
    StringSequence bgn = seq.copy();
    while (seq.next().validIndex()) {
      if (seq.startsWith(delimiter)) {
        lst.add(bgn.followingString(seq));
        seq.next(delimLen-1);
        bgn = seq.copy();
      }
    }
    lst.add(bgn.followingString());
    return lst;
  }

  /**
   * Aw肳ꂽ؂蕶i啶͖jŕɕB
   * <br>
   * {@link java.util.StringTokenizer StringTokenizer}Ƃ͈قȂA؂蕶
   * AČꂽꍇłÅԂ̋󕶎PvfƂĐB
   * ܂A؂蕶͕KvfƗvf̊Ԃɑ݂̂ƂāA܂͕
   * ɋ؂蕶񂪑݂ꍇ́A擪͖ɋ󕶎̗vftB
   * <br>
   * ؂蕶󕶎̏ꍇ́AOX[B
   *
   * @param  string 镶B
   * @param  delimiter ؂蕶B
   * @return i[XgB
   * @throws IllegalArgumentException ؂蕶񂪋󕶎̏ꍇB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static List<String> splitIgnoreCase(String string, String delimiter)
  {
    assert (string != null) : "@param:string is null.";
    assert (delimiter != null) : "@param:delimiter is null.";

    final int delimLen = StringOperation.length(delimiter);
    if (delimLen == 0) {
      throw new IllegalArgumentException("@param:delimiter is empty.");
    }
    delimiter = delimiter.toUpperCase();

    List<String> lst = new LinkedList<String>();

    StringSequence seq = new StringSequence(string.toUpperCase(), -1);
    StringSequence bgn = new StringSequence(string, -1);
    while (seq.next().validIndex()) {
      if (seq.startsWith(delimiter)) {
        lst.add(bgn.followingString(seq));
        seq.next(delimLen - 1);
        bgn.next(seq.index() - bgn.index());
      }
    }
    lst.add(bgn.followingString());
    return lst;
  }

  /**
   * Aw肳ꂽ؂蕶ŕɕB
   * <br>
   * 񒆂ɁAw肳ꂽẑꂩꂽA؂蕶
   * ĕB
   * <br>
   * {@link java.util.StringTokenizer StringTokenizer}Ƃ͈قȂA؂蕶
   * AČꂽꍇłÅԂ̋󕶎PvfƂĐB
   * ܂A؂蕶͕KvfƗvf̊Ԃɑ݂̂ƂāA܂͕
   * ɋ؂蕶ꂽꍇ́A擪͖ɋ󕶎̗vftB
   * <br>
   * ؂蕶̔z̒ɋ󕶎̗vf݂ꍇ́AOX[B
   *
   * @param  string 镶B
   * @param  delimiters ؂蕶̔zB
   * @return i[XgB
   * @throws IllegalArgumentException ؂蕶̔zɋ󕶎̗vf
   *           ꍇB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static List<String> split(String string, String[] delimiters)
  {
    assert (string != null) : "@param:string is null.";
    assert (delimiters != null) : "@param:delimiters is null.";

    String[] delims = createNewArrayWithSorting(delimiters);

    List<String> lst = new LinkedList<String>();

    StringSequence seq = new StringSequence(string, -1);
    StringSequence bgn = seq.copy();
    while (seq.next().validIndex()) {
      String delim = findStarting(seq.substring(), delims);
      if (delim != null) {
        lst.add(bgn.followingString(seq));
        seq.next(StringOperation.length(delim) - 1);
        bgn = seq.copy();
      }
    }
    lst.add(bgn.followingString());
    return lst;
  }

  /**
   * Aw肳ꂽ؂蕶i啶͖jŕɕB
   * <br>
   * 񒆂ɁAw肳ꂽẑꂩꂽA؂蕶
   * ĕB
   * <br>
   * {@link java.util.StringTokenizer StringTokenizer}Ƃ͈قȂA؂蕶
   * AČꂽꍇłÅԂ̋󕶎PvfƂĐB
   * ܂A؂蕶͕KvfƗvf̊Ԃɑ݂̂ƂāA܂͕
   * ɋ؂蕶ꂽꍇ́A擪͖ɋ󕶎̗vftB
   * <br>
   * ؂蕶̔z̒ɋ󕶎̗vf݂ꍇ́AOX[B
   *
   * @param  string 镶B
   * @param  delimiters ؂蕶̔zB
   * @return i[XgB
   * @throws IllegalArgumentException ؂蕶̔zɋ󕶎̗vf
   *           ꍇB
   * @throws AssertionError k̏ꍇifobOE[ĥ݁jB
   */
  public static List<String> splitIgnoreCase(String string, String[] delimiters)
  {
    assert (string != null) : "@param:string is null.";
    assert (delimiters != null) : "@param:delimiters is null.";

    String[] delims = createUpperCaseArrayWithSorting(delimiters);

    List<String> lst = new LinkedList<String>();

    StringSequence seq = new StringSequence(string.toUpperCase(), -1);
    StringSequence bgn = new StringSequence(string, -1);
    while (seq.next().validIndex()) {
      String delim = findStarting(seq.substring(), delims);
      if (delim != null) {
        lst.add(bgn.followingString(seq));
        seq.next(StringOperation.length(delim) - 1);
        bgn.next(seq.index() - bgn.index());
      }
    }
    lst.add(bgn.followingString());
    return lst;
  }

  /**
   * ̕z̗vf\[gAVz쐬B
   * <br>
   * w肳ꂽvtBbNX̒ɁAk󕶎񂪑݂ꍇ͗OX[
   * B
   *
   * @param  strArr zB
   * @return Vɍ쐬ꂽzB
   * @throws IllegalArgumentException vtBbNX̔z̒Ƀk󕶎
   *           ̗vf݂ꍇB
   */
  private static String[] createNewArrayWithSorting(String[] strArr)
  {
    String[] newArr = new String[strArr.length];
    for (int i=0; i<strArr.length; i++) {
      if (strArr[i] == null || StringOperation.isEmpty(strArr[i])) {
        throw new IllegalArgumentException(
          "@param:strArr has elements which are null or empty string.");
      }
      newArr[i] = strArr[i];
    }
    Arrays.sort(newArr);
    return newArr;
  }

  /**
   * ̕z̗vf啶ɕϊă\[gAVz쐬B
   * <br>
   * w肳ꂽvtBbNX̒ɁAk󕶎񂪑݂ꍇ͗OX[
   * B
   *
   * @param  strArr zB
   * @return Vɍ쐬ꂽzB
   * @throws IllegalArgumentException vtBbNX̔z̒Ƀk󕶎
   *           ̗vf݂ꍇB
   */
  private static String[] createUpperCaseArrayWithSorting(String[] strArr)
  {
    String[] newArr = new String[strArr.length];
    for (int i=0; i<strArr.length; i++) {
      if (strArr[i] == null || StringOperation.isEmpty(strArr[i])) {
        throw new IllegalArgumentException(
          "@param:strArr has elements which are null or empty string.");
      }
      newArr[i] = strArr[i].toUpperCase();
    }
    Arrays.sort(newArr);
    return newArr;
  }

  /**
   * ̕񂪁Aw肳ꂽ̃vtBbNX̂ꂩƐ擪v
   * 邩ǂ𔻒肵ÃvtBbNXԂB
   * <br>
   * ̃vtBbNXvȂꍇ̓kԂB
   *
   * @param  string B
   * @param  prefixes vtBbNX̔zB
   * @return 擪vvtBbNXB
   */
  private static String findStarting(String string, String[] prefixes)
  {
    for (int i=prefixes.length - 1; i>=0; i--) {
      int len = Math.min(string.length(), prefixes[i].length());
      String substr = string.substring(0, len);
      int cmp = substr.compareTo(prefixes[i]);
      if (cmp == 0) {
        return prefixes[i];
      }
      else if (cmp > 0) {
        break;
      }
    }
    return null;
  }
}

