/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import ts.util.AbstractTypedGetter;
import ts.util.ReasonedRuntimeException;
import ts.util.resource.PropertyResource;
import ts.util.resource.Resource;

public class QueryConfig
extends AbstractTypedGetter<String, String> {
    static final long serialVersionUID = 7870866298172485389L;
    private static final QueryConfig INSTANCE = QueryConfig.createInstance();
    private final Resource resource;

    public static QueryConfig getInstance() {
        return INSTANCE;
    }

    protected static QueryConfig createInstance() throws ReasonedRuntimeException {
        return new QueryConfig();
    }

    protected QueryConfig() throws ReasonedRuntimeException {
        String string = ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".properties";
        try {
            this.resource = new PropertyResource(string){
                static final long serialVersionUID = 7870866298172485390L;

                protected InputStream getInputStream(String string) throws IOException {
                    InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
                    if (inputStream == null && !ClassLoader.getSystemResources(string).hasMoreElements()) {
                        throw new FileNotFoundException();
                    }
                    return inputStream;
                }
            };
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ReasonedRuntimeException((Enum)Error.FileNotFound, string);
        }
        catch (IOException iOException) {
            throw new ReasonedRuntimeException((Enum)Error.FailToLoad, string);
        }
    }

    public String get(String string) {
        return this.resource.getFirstValue(string.toString());
    }

    public List<String> getList(String string) {
        return this.resource.getValues(string.toString());
    }

    public static enum Error {
        FileNotFound,
        FailToLoad;

    }
}

