/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.Serializable;
import ts.query.QueryContext;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;
import ts.util.table.Table;

public class QueryResult
implements Serializable {
    static final long serialVersionUID = 8309940887092598304L;
    private final QueryContext context;
    private boolean isSuccess = false;
    private int resultCount = 0;
    private long spentTimeMillis = 0L;
    private Table<String, Object> resultTable = null;
    private Exception exception = null;

    public QueryResult(QueryContext queryContext) {
        assert (queryContext != null) : "@param:context is null.";
        this.context = queryContext;
    }

    public String getQueryId() {
        return this.context.getQueryId();
    }

    public QueryContext getContext() {
        return this.context;
    }

    protected void setSuccess(boolean bl) {
        this.isSuccess = bl;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    protected void setResultCount(int n) {
        assert (n >= 0) : "@param:resultCount is negative.";
        this.resultCount = n;
    }

    public int getResultCount() {
        return this.resultCount;
    }

    protected void setSpentTimeMillis(long l) {
        assert (l >= 0L) : "@param:spentTime is negative.";
        this.spentTimeMillis = l;
    }

    public long getSpentTimeMillis() {
        return this.spentTimeMillis;
    }

    protected void setException(ReasonedException reasonedException) {
        this.exception = reasonedException;
    }

    protected void setException(ReasonedRuntimeException reasonedRuntimeException) {
        this.exception = reasonedRuntimeException;
    }

    public Exception getException() {
        return this.exception;
    }

    public Enum getExceptionReason() {
        if (this.exception != null) {
            if (this.exception instanceof ReasonedException) {
                return ((ReasonedException)((Object)ReasonedException.class.cast(this.exception))).getReason();
            }
            if (this.exception instanceof ReasonedRuntimeException) {
                return ((ReasonedRuntimeException)((Object)ReasonedRuntimeException.class.cast(this.exception))).getReason();
            }
        }
        return null;
    }

    public Table<String, Object> getResultTable() {
        return this.resultTable;
    }

    protected void setResultTable(Table<String, Object> table) {
        this.resultTable = table;
    }
}

