package ts.query;

import ts.tester.UnitTest;
import ts.util.*;
import java.util.*;

public class QueryOutputTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryOutputTest.class, args);
  }

  public void constructor_name()
  {
    MSG("名前を引数にとるコンストラクタ。");

    QueryOutput output = new QueryOutput("abc");
    EQUAL(output.getName(), "abc");
    NULL(output.get("AAA"));
    NULL(output.get("BBB"));
    NULL(output.get("CCC"));
  }

  public void constructor_name_Null()
  {
    MSG("引数がヌルの場合。");

    try {
      new QueryOutput(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void put_key_attrValue()
  {
    MSG("属性値を設定するメソッドの確認。");

    QueryOutput output = new QueryOutput("xyz");
    EQUAL(output.getName(), "xyz");
    NULL(output.get("AAA"));
    NULL(output.get("BBB"));
    NULL(output.get("CCC"));

    output.put("AAA", 123);
    EQUAL(output.getName(), "xyz");
    EQUAL(output.get("AAA"), 123);
    NULL(output.get("BBB"));
    NULL(output.get("CCC"));

    output.put("CCC", "あいうえお");
    EQUAL(output.getName(), "xyz");
    EQUAL(output.get("AAA"), 123);
    NULL(output.get("BBB"));
    EQUAL(output.get("CCC"), "あいうえお");

    output.put("AAA", null);
    EQUAL(output.getName(), "xyz");
    NULL(output.get("AAA"));
    NULL(output.get("BBB"));
    EQUAL(output.get("CCC"), "あいうえお");

    output.put(null, 999);
    EQUAL(output.getName(), "xyz");
    NULL(output.get("AAA"));
    NULL(output.get("BBB"));
    EQUAL(output.get("CCC"), "あいうえお");
    EQUAL(output.get(null), 999);
  }
}
