package ts.query;

import ts.tester.UnitTest;
import java.util.*;

public class QueryParamValueIteratorTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryParamValueIteratorTest.class, args);
  }

  public void constructor_value()
  {
    MSG("単値を引数にとるコンストラクタ。");

    QueryParamValueIterator itr;
    itr = new QueryParamValueIterator(123);
    EQUAL(itr.count(), 1);
    EQUAL(itr.next(), 123);
    EQUAL(itr.next(), 123);
    EQUAL(itr.next(), 123);
    EQUAL(itr.next(), 123);
    EQUAL(itr.next(), 123);

    itr = new QueryParamValueIterator("あいうえお");
    EQUAL(itr.count(), 1);
    EQUAL(itr.next(), "あいうえお");
    EQUAL(itr.next(), "あいうえお");
    EQUAL(itr.next(), "あいうえお");
    EQUAL(itr.next(), "あいうえお");
    EQUAL(itr.next(), "あいうえお");
  }
  
  public void constructor_coll()
  {
    MSG("複数の値のコレクションを引数にとるコンストラクタ。");

    QueryParamValueIterator itr;
    itr = new QueryParamValueIterator(Arrays.asList(
      new Integer[]{ 111,222,333,444 }));
    EQUAL(itr.count(), 4);
    EQUAL(itr.next(), 111);
    EQUAL(itr.next(), 222);
    EQUAL(itr.next(), 333);
    EQUAL(itr.next(), 444);
    EQUAL(itr.next(), 444);
    EQUAL(itr.next(), 444);

    itr = new QueryParamValueIterator(Arrays.asList(
      new String[]{ "aaa","bbb","ccc" }));
    EQUAL(itr.count(), 3);
    EQUAL(itr.next(), "aaa");
    EQUAL(itr.next(), "bbb");
    EQUAL(itr.next(), "ccc");
    EQUAL(itr.next(), "ccc");
    EQUAL(itr.next(), "ccc");

    itr = new QueryParamValueIterator(Arrays.asList(
      new String[]{ "aaa" }));
    EQUAL(itr.count(), 1);
    EQUAL(itr.next(), "aaa");
    EQUAL(itr.next(), "aaa");
    EQUAL(itr.next(), "aaa");

    itr = new QueryParamValueIterator(Arrays.asList(
      new String[]{}));
    EQUAL(itr.count(), 0);
    NULL(itr.next());
  }
  
  public void constructor_array()
  {
    MSG("複数の値の配列を引数にとるコンストラクタ。");

    QueryParamValueIterator itr;
    itr = new QueryParamValueIterator(new Integer[]{ 111,222,333,444 });
    EQUAL(itr.count(), 4);
    EQUAL(itr.next(), 111);
    EQUAL(itr.next(), 222);
    EQUAL(itr.next(), 333);
    EQUAL(itr.next(), 444);
    EQUAL(itr.next(), 444);
    EQUAL(itr.next(), 444);

    itr = new QueryParamValueIterator(new String[]{ "aaa","bbb","ccc" });
    EQUAL(itr.count(), 3);
    EQUAL(itr.next(), "aaa");
    EQUAL(itr.next(), "bbb");
    EQUAL(itr.next(), "ccc");
    EQUAL(itr.next(), "ccc");
    EQUAL(itr.next(), "ccc");

    itr = new QueryParamValueIterator(new String[]{ "aaa" });
    EQUAL(itr.count(), 1);
    EQUAL(itr.next(), "aaa");
    EQUAL(itr.next(), "aaa");
    EQUAL(itr.next(), "aaa");

    itr = new QueryParamValueIterator(new String[]{});
    EQUAL(itr.count(), 0);
    NULL(itr.next());
  }

  public void constructor_value_Null()
  {
    MSG("引数がヌルの場合。");

    QueryParamValueIterator itr = new QueryParamValueIterator(
      (Collection<Object>) null);
    EQUAL(itr.count(), 1);
    NULL(itr.next());
    NULL(itr.next());
    NULL(itr.next());
    NULL(itr.next());
    NULL(itr.next());
  }

  public void constructor_coll_Modified()
  {
    MSG("引数に指定したコレクションの内容が変更された場合。");

    List<Integer> lst = new ArrayList<Integer>();
    lst.add(111);
    lst.add(222);
    lst.add(333);

    QueryParamValueIterator itr;
    itr = new QueryParamValueIterator(lst);
    EQUAL(itr.count(), 3);
    EQUAL(itr.next(), 111);
    EQUAL(itr.next(), 222);
    EQUAL(itr.next(), 333);
    EQUAL(itr.next(), 333);

    lst.add(444);
    EQUAL(itr.count(), 4);
    try {
      itr.next();
      NG();
    }
    catch (ConcurrentModificationException e) {
      OK(e);
    }
  }
}
