package ts.query;

import ts.tester.UnitTest;
import ts.util.*;
import java.util.*;

public class QueryResultListTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryResultListTest.class, args);
  }

  public void constructor()
  {
    MSG("デフォルト・コンストラクタの確認。");

    QueryResultList rsltLst = new QueryResultList();
    EQUAL(rsltLst.countResults(), 0);
    EQUAL(rsltLst.getAllResults().size(), 0);
    NULL(rsltLst.getFirstResult());
    NULL(rsltLst.getLastResult());
    TRUE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);
  }

  public void addResult_result()
  {
    MSG("結果オブジェクトを追加するメソッドの確認。");

    List<QueryResult> lst;

    QueryResultList rsltLst = new QueryResultList();
    EQUAL(rsltLst.countResults(), 0);
    EQUAL(rsltLst.getAllResults().size(), 0);
    NULL(rsltLst.getFirstResult());
    NULL(rsltLst.getLastResult());
    TRUE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);

    QueryResult rslt0 = new QueryResult(new QueryContext("c0", "q0"));
    rsltLst.addResult(rslt0);
    EQUAL(rsltLst.countResults(), 1);
    lst = rsltLst.getAllResults();
    EQUAL(lst.size(), 1);
    EQUAL(lst.get(0), rslt0);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt0);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);
    rslt0.setSuccess(true);
    rslt0.setSpentTimeMillis(123L);
    TRUE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 123L);

    QueryResult rslt1 = new QueryResult(new QueryContext("c0", "q1"));
    rsltLst.addResult(rslt1);
    EQUAL(rsltLst.countResults(), 2);
    lst = rsltLst.getAllResults();
    EQUAL(lst.size(), 2);
    EQUAL(lst.get(0), rslt0);
    EQUAL(lst.get(1), rslt1);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt1);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 123L);
    rslt1.setSuccess(true);
    rslt1.setSpentTimeMillis(456L);
    TRUE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 579L);

    QueryResult rslt2 = new QueryResult(new QueryContext("c0", "q2"));
    rsltLst.addResult(rslt2);
    EQUAL(rsltLst.countResults(), 3);
    lst = rsltLst.getAllResults();
    EQUAL(lst.size(), 3);
    EQUAL(lst.get(0), rslt0);
    EQUAL(lst.get(1), rslt1);
    EQUAL(lst.get(2), rslt2);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt2);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 579L);
    rslt2.setSuccess(true);
    rslt2.setSpentTimeMillis(111L);
    TRUE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 690L);
  }

  public void addResult_result_Null()
  {
    MSG("引数がヌルの場合。");

    QueryResultList rsltLst = new QueryResultList();
    try {
      rsltLst.addResult(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void getResults_queryId()
  {
    MSG("指定されたクエリIDの結果オブジェクトのリストを取得するメソッドの確認。");

    List<QueryResult> lst;

    QueryResultList rsltLst = new QueryResultList();
    EQUAL(rsltLst.getResults("q0").size(), 0);
    EQUAL(rsltLst.getResults("q1").size(), 0);
    EQUAL(rsltLst.getResults("q2").size(), 0);
    EQUAL(rsltLst.getResults("q3").size(), 0);

    QueryResult rslt0 = new QueryResult(new QueryContext("c0", "q0"));
    rsltLst.addResult(rslt0);
    lst = rsltLst.getResults("q0");
    EQUAL(lst.size(), 1);
    EQUAL(lst.get(0), rslt0);
    EQUAL(rsltLst.getResults("q1").size(), 0);
    EQUAL(rsltLst.getResults("q2").size(), 0);
    EQUAL(rsltLst.getResults("q3").size(), 0);

    QueryResult rslt1 = new QueryResult(new QueryContext("c0", "q1"));
    rsltLst.addResult(rslt1);
    lst = rsltLst.getResults("q0");
    EQUAL(lst.size(), 1);
    EQUAL(lst.get(0), rslt0);
    lst = rsltLst.getResults("q1");
    EQUAL(lst.size(), 1);
    EQUAL(lst.get(0), rslt1);
    EQUAL(rsltLst.getResults("q2").size(), 0);
    EQUAL(rsltLst.getResults("q3").size(), 0);

    QueryResult rslt2 = new QueryResult(new QueryContext("c0", "q2"));
    rsltLst.addResult(rslt2);
    lst = rsltLst.getResults("q0");
    EQUAL(lst.size(), 1);
    EQUAL(lst.get(0), rslt0);
    lst = rsltLst.getResults("q1");
    EQUAL(lst.size(), 1);
    EQUAL(lst.get(0), rslt1);
    lst = rsltLst.getResults("q2");
    EQUAL(lst.size(), 1);
    EQUAL(lst.get(0), rslt2);
    EQUAL(rsltLst.getResults("q3").size(), 0);

    QueryResult rslt3 = new QueryResult(new QueryContext("c0", "q0"));
    rsltLst.addResult(rslt3);
    lst = rsltLst.getResults("q0");
    EQUAL(lst.size(), 2);
    EQUAL(lst.get(0), rslt0);
    EQUAL(lst.get(1), rslt3);
    lst = rsltLst.getResults("q1");
    EQUAL(lst.size(), 1);
    EQUAL(lst.get(0), rslt1);
    lst = rsltLst.getResults("q2");
    EQUAL(lst.size(), 1);
    EQUAL(lst.get(0), rslt2);
    EQUAL(rsltLst.getResults("q3").size(), 0);

    QueryResult rslt4 = new QueryResult(new QueryContext("c1", "q0"));
    rsltLst.addResult(rslt4);
    lst = rsltLst.getResults("q0");
    EQUAL(lst.size(), 3);
    EQUAL(lst.get(0), rslt0);
    EQUAL(lst.get(1), rslt3);
    EQUAL(lst.get(2), rslt4);
    lst = rsltLst.getResults("q1");
    EQUAL(lst.size(), 1);
    EQUAL(lst.get(0), rslt1);
    lst = rsltLst.getResults("q2");
    EQUAL(lst.size(), 1);
    EQUAL(lst.get(0), rslt2);
    EQUAL(rsltLst.getResults("q3").size(), 0);
  }

  public void getFirstResult_queryId()
  {
    MSG("指定されたクエリIDの最初の結果オブジェクトを取得するメソッドの確認。");

    QueryResultList rsltLst = new QueryResultList();
    NULL(rsltLst.getFirstResult("q0"));
    NULL(rsltLst.getFirstResult("q1"));
    NULL(rsltLst.getFirstResult("q2"));
    NULL(rsltLst.getFirstResult("q3"));

    QueryResult rslt0 = new QueryResult(new QueryContext("c0", "q0"));
    rsltLst.addResult(rslt0);
    EQUAL(rsltLst.getFirstResult("q0"), rslt0);
    NULL(rsltLst.getFirstResult("q1"));
    NULL(rsltLst.getFirstResult("q2"));
    NULL(rsltLst.getFirstResult("q3"));

    QueryResult rslt1 = new QueryResult(new QueryContext("c0", "q1"));
    rsltLst.addResult(rslt1);
    EQUAL(rsltLst.getFirstResult("q0"), rslt0);
    EQUAL(rsltLst.getFirstResult("q1"), rslt1);
    NULL(rsltLst.getFirstResult("q2"));
    NULL(rsltLst.getFirstResult("q3"));

    QueryResult rslt2 = new QueryResult(new QueryContext("c0", "q2"));
    rsltLst.addResult(rslt2);
    EQUAL(rsltLst.getFirstResult("q0"), rslt0);
    EQUAL(rsltLst.getFirstResult("q1"), rslt1);
    EQUAL(rsltLst.getFirstResult("q2"), rslt2);
    NULL(rsltLst.getFirstResult("q3"));

    QueryResult rslt3 = new QueryResult(new QueryContext("c0", "q0"));
    rsltLst.addResult(rslt3);
    EQUAL(rsltLst.getFirstResult("q0"), rslt0);
    EQUAL(rsltLst.getFirstResult("q1"), rslt1);
    EQUAL(rsltLst.getFirstResult("q2"), rslt2);
    NULL(rsltLst.getFirstResult("q3"));

    QueryResult rslt4 = new QueryResult(new QueryContext("c1", "q0"));
    rsltLst.addResult(rslt4);
    EQUAL(rsltLst.getFirstResult("q0"), rslt0);
    EQUAL(rsltLst.getFirstResult("q1"), rslt1);
    EQUAL(rsltLst.getFirstResult("q2"), rslt2);
    NULL(rsltLst.getFirstResult("q3"));
  }

  public void getLastResult_queryId()
  {
    MSG("指定されたクエリIDの最後の結果オブジェクトを取得するメソッドの確認。");

    QueryResultList rsltLst = new QueryResultList();
    NULL(rsltLst.getLastResult("q0"));
    NULL(rsltLst.getLastResult("q1"));
    NULL(rsltLst.getLastResult("q2"));
    NULL(rsltLst.getLastResult("q3"));

    QueryResult rslt0 = new QueryResult(new QueryContext("c0", "q0"));
    rsltLst.addResult(rslt0);
    EQUAL(rsltLst.getLastResult("q0"), rslt0);
    NULL(rsltLst.getLastResult("q1"));
    NULL(rsltLst.getLastResult("q2"));
    NULL(rsltLst.getLastResult("q3"));

    QueryResult rslt1 = new QueryResult(new QueryContext("c0", "q1"));
    rsltLst.addResult(rslt1);
    EQUAL(rsltLst.getLastResult("q0"), rslt0);
    EQUAL(rsltLst.getLastResult("q1"), rslt1);
    NULL(rsltLst.getLastResult("q2"));
    NULL(rsltLst.getLastResult("q3"));

    QueryResult rslt2 = new QueryResult(new QueryContext("c0", "q2"));
    rsltLst.addResult(rslt2);
    EQUAL(rsltLst.getLastResult("q0"), rslt0);
    EQUAL(rsltLst.getLastResult("q1"), rslt1);
    EQUAL(rsltLst.getLastResult("q2"), rslt2);
    NULL(rsltLst.getLastResult("q3"));

    QueryResult rslt3 = new QueryResult(new QueryContext("c0", "q0"));
    rsltLst.addResult(rslt3);
    EQUAL(rsltLst.getLastResult("q0"), rslt3);
    EQUAL(rsltLst.getLastResult("q1"), rslt1);
    EQUAL(rsltLst.getLastResult("q2"), rslt2);
    NULL(rsltLst.getLastResult("q3"));

    QueryResult rslt4 = new QueryResult(new QueryContext("c1", "q0"));
    rsltLst.addResult(rslt4);
    EQUAL(rsltLst.getLastResult("q0"), rslt4);
    EQUAL(rsltLst.getLastResult("q1"), rslt1);
    EQUAL(rsltLst.getLastResult("q2"), rslt2);
    NULL(rsltLst.getLastResult("q3"));
  }

  public void getResultAt_index()
  {
    MSG("指定されたインデックスの結果オブジェクトを取得するメソッドの確認。");

    QueryResultList rsltLst = new QueryResultList();

    QueryResult rslt0 = new QueryResult(new QueryContext("c0", "q0"));
    rsltLst.addResult(rslt0);
    EQUAL(rsltLst.getResultAt(0), rslt0);

    QueryResult rslt1 = new QueryResult(new QueryContext("c0", "q1"));
    rsltLst.addResult(rslt1);
    EQUAL(rsltLst.getResultAt(0), rslt0);
    EQUAL(rsltLst.getResultAt(1), rslt1);

    QueryResult rslt2 = new QueryResult(new QueryContext("c0", "q2"));
    rsltLst.addResult(rslt2);
    EQUAL(rsltLst.getResultAt(0), rslt0);
    EQUAL(rsltLst.getResultAt(1), rslt1);
    EQUAL(rsltLst.getResultAt(2), rslt2);

    QueryResult rslt3 = new QueryResult(new QueryContext("c0", "q0"));
    rsltLst.addResult(rslt3);
    EQUAL(rsltLst.getResultAt(0), rslt0);
    EQUAL(rsltLst.getResultAt(1), rslt1);
    EQUAL(rsltLst.getResultAt(2), rslt2);
    EQUAL(rsltLst.getResultAt(3), rslt3);

    QueryResult rslt4 = new QueryResult(new QueryContext("c1", "q0"));
    rsltLst.addResult(rslt4);
    EQUAL(rsltLst.getResultAt(0), rslt0);
    EQUAL(rsltLst.getResultAt(1), rslt1);
    EQUAL(rsltLst.getResultAt(2), rslt2);
    EQUAL(rsltLst.getResultAt(3), rslt3);
    EQUAL(rsltLst.getResultAt(4), rslt4);
  }

  public void getResultAt_index_OutOfRange()
  {
    MSG("引数のインデックスが範囲外の場合。");

    QueryResultList rsltLst = new QueryResultList();
    try {
      rsltLst.getResultAt(-1);
      NG();
    } catch (IndexOutOfBoundsException e) {
      OK(e);
    }
    try {
      rsltLst.getResultAt(0);
      NG();
    } catch (IndexOutOfBoundsException e) {
      OK(e);
    }

    QueryResult rslt1 = new QueryResult(new QueryContext("c0", "q1"));
    rsltLst.addResult(rslt1);
    try {
      rsltLst.getResultAt(-1);
      NG();
    } catch (IndexOutOfBoundsException e) {
      OK(e);
    }
    try {
      rsltLst.getResultAt(1);
      NG();
    } catch (IndexOutOfBoundsException e) {
      OK(e);
    }

    QueryResult rslt2 = new QueryResult(new QueryContext("c0", "q2"));
    rsltLst.addResult(rslt2);
    try {
      rsltLst.getResultAt(-1);
      NG();
    } catch (IndexOutOfBoundsException e) {
      OK(e);
    }
    try {
      rsltLst.getResultAt(2);
      NG();
    } catch (IndexOutOfBoundsException e) {
      OK(e);
    }
  }

  public void setAndResetSpentTimeMillis_long()
  {
    MSG("処理時間を設定するメソッドの確認。");

    QueryResultList rsltLst = new QueryResultList();
    EQUAL(rsltLst.countResults(), 0);
    EQUAL(rsltLst.getAllResults().size(), 0);
    NULL(rsltLst.getFirstResult());
    NULL(rsltLst.getLastResult());
    TRUE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);

    rsltLst.setSpentTimeMillis(98765L);
    EQUAL(rsltLst.countResults(), 0);
    EQUAL(rsltLst.getAllResults().size(), 0);
    NULL(rsltLst.getFirstResult());
    NULL(rsltLst.getLastResult());
    TRUE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 98765L);

    rsltLst.resetSpentTimeMillis();
    EQUAL(rsltLst.countResults(), 0);
    EQUAL(rsltLst.getAllResults().size(), 0);
    NULL(rsltLst.getFirstResult());
    NULL(rsltLst.getLastResult());
    TRUE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 0L);

    QueryResult rslt0 = new QueryResult(new QueryContext("c0", "q0"));
    rslt0.setSpentTimeMillis(222L);
    rsltLst.addResult(rslt0);
    EQUAL(rsltLst.countResults(), 1);
    EQUAL(rsltLst.getAllResults().size(), 1);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt0);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 222L);

    rsltLst.setSpentTimeMillis(98765L);
    EQUAL(rsltLst.countResults(), 1);
    EQUAL(rsltLst.getAllResults().size(), 1);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt0);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 98765L);

    rsltLst.resetSpentTimeMillis();
    EQUAL(rsltLst.countResults(), 1);
    EQUAL(rsltLst.getAllResults().size(), 1);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt0);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 222L);

    QueryResult rslt1 = new QueryResult(new QueryContext("c0", "q1"));
    rslt1.setSpentTimeMillis(111L);
    rsltLst.addResult(rslt1);
    EQUAL(rsltLst.countResults(), 2);
    EQUAL(rsltLst.getAllResults().size(), 2);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt1);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 333L);

    rsltLst.setSpentTimeMillis(98765L);
    EQUAL(rsltLst.countResults(), 2);
    EQUAL(rsltLst.getAllResults().size(), 2);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt1);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 98765L);

    rsltLst.resetSpentTimeMillis();
    EQUAL(rsltLst.countResults(), 2);
    EQUAL(rsltLst.getAllResults().size(), 2);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt1);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 333L);

    QueryResult rslt2 = new QueryResult(new QueryContext("c0", "q0"));
    rslt2.setSpentTimeMillis(323L);
    rsltLst.addResult(rslt2);
    EQUAL(rsltLst.countResults(), 3);
    EQUAL(rsltLst.getAllResults().size(), 3);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt2);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 656L);

    rsltLst.setSpentTimeMillis(98765L);
    EQUAL(rsltLst.countResults(), 3);
    EQUAL(rsltLst.getAllResults().size(), 3);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt2);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 98765L);

    rsltLst.resetSpentTimeMillis();
    EQUAL(rsltLst.countResults(), 3);
    EQUAL(rsltLst.getAllResults().size(), 3);
    EQUAL(rsltLst.getFirstResult(), rslt0);
    EQUAL(rsltLst.getLastResult(), rslt2);
    FALSE(rsltLst.isSuccess());
    EQUAL(rsltLst.getSpentTimeMillis(), 656L);
  }

  public void setSpentTimeMillis_long_Negative()
  {
    MSG("引数が負値の場合。");

    QueryResultList rsltLst = new QueryResultList();

    try {
      rsltLst.setSpentTimeMillis(-1L);
      NG();
    } catch (IllegalArgumentException e) {
      OK(e);
    } catch (Exception e) {
      NG(e);
    }
  }
}

