/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.util.HashMap;
import java.util.Map;
import ts.query.DefaultQueryTransaction;
import ts.query.QueryConnection;
import ts.query.QueryConnectionFactory;
import ts.query.QueryResultList;
import ts.query.QueryTransaction;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;

public class QueryTransactionManager {
    private static final ThreadLocal<QueryTransaction> THREAD_LOCAL = new ThreadLocal();
    private static final Map<String, QueryTransaction> TRANSACTION_MAP = new HashMap<String, QueryTransaction>();

    private QueryTransactionManager() {
    }

    public static QueryTransaction createThreadLocalTransaction() throws ReasonedRuntimeException {
        return QueryTransactionManager.createThreadLocalTransaction(DefaultQueryTransaction.class);
    }

    public static QueryTransaction createThreadLocalTransaction(Class<? extends QueryTransaction> clazz) throws ReasonedRuntimeException {
        assert (clazz != null) : "@param:transactionClass is null.";
        QueryTransaction queryTransaction = THREAD_LOCAL.get();
        if (queryTransaction != null && queryTransaction.getState() != QueryTransaction.State.Ended) {
            throw new ReasonedRuntimeException((Enum)Error.ThreadLocalAlreadyExists, queryTransaction.getClass().getName());
        }
        try {
            THREAD_LOCAL.set(clazz.newInstance());
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException((Enum)Error.ThreadLocalFailToCreate, clazz.getName(), (Throwable)exception);
        }
        return new ThreadLocalTransaction();
    }

    public static QueryTransaction getThreadLocalTransaction() {
        return new ThreadLocalTransaction();
    }

    public static QueryTransaction createThreadSafeTransaction(String string) throws ReasonedRuntimeException {
        return QueryTransactionManager.createThreadSafeTransaction(string, DefaultQueryTransaction.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryTransaction createThreadSafeTransaction(String string, Class<? extends QueryTransaction> clazz) throws ReasonedRuntimeException {
        Map<String, QueryTransaction> map = TRANSACTION_MAP;
        synchronized (map) {
            QueryTransaction queryTransaction = TRANSACTION_MAP.get(string);
            if (queryTransaction != null && queryTransaction.getState() != QueryTransaction.State.Ended) {
                throw new ReasonedRuntimeException((Enum)Error.ThreadSafeAlreadyExists, string + " - " + queryTransaction.getClass().getName());
            }
            try {
                queryTransaction = clazz.newInstance();
            }
            catch (Exception exception) {
                throw new ReasonedRuntimeException((Enum)Error.ThreadSafeFailToCreate, string + " - " + clazz.getName(), (Throwable)exception);
            }
            TRANSACTION_MAP.put(string, queryTransaction);
            return new ThreadSafeTransaction(string);
        }
    }

    public static QueryTransaction getThreadSafeTransaction(String string) {
        return new ThreadSafeTransaction(string);
    }

    private static final class ThreadSafeTransaction
    implements QueryTransaction {
        private final String key;
        private QueryTransaction innerTransaction = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ThreadSafeTransaction(String string) throws ReasonedRuntimeException {
            Map map = TRANSACTION_MAP;
            synchronized (map) {
                QueryTransaction queryTransaction = (QueryTransaction)TRANSACTION_MAP.get(string);
                if (queryTransaction == null) {
                    throw new ReasonedRuntimeException((Enum)Error.ThreadSafeNotExist, string);
                }
                this.key = string;
                this.innerTransaction = queryTransaction;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void begin() {
            QueryTransaction queryTransaction = this.innerTransaction;
            synchronized (queryTransaction) {
                this.innerTransaction.begin();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void begin(long l) {
            QueryTransaction queryTransaction = this.innerTransaction;
            synchronized (queryTransaction) {
                this.innerTransaction.begin(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void commit() {
            QueryTransaction queryTransaction = this.innerTransaction;
            synchronized (queryTransaction) {
                this.innerTransaction.commit();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void rollback() {
            QueryTransaction queryTransaction = this.innerTransaction;
            synchronized (queryTransaction) {
                this.innerTransaction.rollback();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void end() {
            Object object = TRANSACTION_MAP;
            synchronized (object) {
                QueryTransaction queryTransaction = (QueryTransaction)TRANSACTION_MAP.get(this.key);
                if (queryTransaction != null && queryTransaction.equals(this.innerTransaction)) {
                    TRANSACTION_MAP.remove(this.key);
                }
            }
            object = this.innerTransaction;
            synchronized (object) {
                this.innerTransaction.end();
            }
        }

        @Override
        public QueryTransaction.State getState() {
            return this.innerTransaction.getState();
        }

        @Override
        public long getBeginTimeMillis() {
            return this.innerTransaction.getBeginTimeMillis();
        }

        @Override
        public long getLimitTimeMillis() {
            return this.innerTransaction.getLimitTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public QueryConnection getConnection(String string) throws ReasonedException {
            QueryTransaction queryTransaction = this.innerTransaction;
            synchronized (queryTransaction) {
                return this.innerTransaction.getConnection(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addConnectionFactory(String string, QueryConnectionFactory queryConnectionFactory) {
            QueryTransaction queryTransaction = this.innerTransaction;
            synchronized (queryTransaction) {
                this.innerTransaction.addConnectionFactory(string, queryConnectionFactory);
            }
        }

        @Override
        public QueryResultList getQueryResultList() {
            return this.innerTransaction.getQueryResultList().toThreadSafe();
        }

        public int hashCode() {
            return this.innerTransaction.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof ThreadSafeTransaction)) {
                return false;
            }
            ThreadSafeTransaction threadSafeTransaction = (ThreadSafeTransaction)ThreadSafeTransaction.class.cast(object);
            return this.innerTransaction.equals(threadSafeTransaction.innerTransaction);
        }
    }

    private static final class ThreadLocalTransaction
    implements QueryTransaction {
        private QueryTransaction innerTransaction = null;

        private ThreadLocalTransaction() throws ReasonedRuntimeException {
            QueryTransaction queryTransaction = (QueryTransaction)THREAD_LOCAL.get();
            if (queryTransaction == null) {
                throw new ReasonedRuntimeException((Enum)Error.ThreadLocalNotExist);
            }
            this.innerTransaction = queryTransaction;
        }

        private QueryTransaction getInnerTransaction() throws ReasonedRuntimeException {
            QueryTransaction queryTransaction = (QueryTransaction)THREAD_LOCAL.get();
            if (queryTransaction != null) {
                assert (queryTransaction == this.innerTransaction);
                return queryTransaction;
            }
            if (this.innerTransaction.getState() == QueryTransaction.State.Ended) {
                return this.innerTransaction;
            }
            throw new ReasonedRuntimeException((Enum)Error.ThreadLocalNotExist);
        }

        @Override
        public void begin() {
            this.getInnerTransaction().begin();
        }

        @Override
        public void begin(long l) {
            this.getInnerTransaction().begin(l);
        }

        @Override
        public void commit() {
            this.getInnerTransaction().commit();
        }

        @Override
        public void rollback() {
            this.getInnerTransaction().rollback();
        }

        @Override
        public void end() {
            QueryTransaction queryTransaction = this.getInnerTransaction();
            THREAD_LOCAL.remove();
            queryTransaction.end();
        }

        @Override
        public QueryTransaction.State getState() {
            return this.getInnerTransaction().getState();
        }

        @Override
        public long getBeginTimeMillis() {
            return this.getInnerTransaction().getBeginTimeMillis();
        }

        @Override
        public long getLimitTimeMillis() {
            return this.getInnerTransaction().getLimitTimeMillis();
        }

        @Override
        public QueryConnection getConnection(String string) throws ReasonedException {
            return this.getInnerTransaction().getConnection(string);
        }

        @Override
        public void addConnectionFactory(String string, QueryConnectionFactory queryConnectionFactory) {
            this.getInnerTransaction().addConnectionFactory(string, queryConnectionFactory);
        }

        @Override
        public QueryResultList getQueryResultList() {
            return this.getInnerTransaction().getQueryResultList();
        }

        public int hashCode() {
            return this.getInnerTransaction().hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof ThreadLocalTransaction)) {
                return false;
            }
            ThreadLocalTransaction threadLocalTransaction = (ThreadLocalTransaction)ThreadLocalTransaction.class.cast(object);
            return this.getInnerTransaction().equals(threadLocalTransaction.getInnerTransaction());
        }
    }

    public static enum Error {
        ThreadLocalFailToCreate,
        ThreadLocalNotExist,
        ThreadLocalAlreadyExists,
        ThreadSafeFailToCreate,
        ThreadSafeNotExist,
        ThreadSafeAlreadyExists;

    }
}

