/*
 * Decompiled with CFR 0.152.
 */
package ts.util.file;

import java.io.File;
import java.io.FileFilter;
import java.util.Date;

public class FileLastModifiedFilter
implements FileFilter {
    private Date modifiedAfter_ = null;
    private Date modifiedBefore_ = null;

    public FileLastModifiedFilter(Date date, Date date2) {
        if (date != null && date2 != null) {
            if (date.before(date2)) {
                this.modifiedAfter_ = date;
                this.modifiedBefore_ = date2;
            } else {
                this.modifiedAfter_ = date2;
                this.modifiedBefore_ = date;
            }
        } else {
            this.modifiedAfter_ = date;
            this.modifiedBefore_ = date2;
        }
    }

    @Override
    public boolean accept(File file) {
        assert (file != null) : "@param:file is null.";
        if (this.modifiedAfter_ != null && file.lastModified() < this.modifiedAfter_.getTime()) {
            return false;
        }
        return this.modifiedBefore_ == null || file.lastModified() <= this.modifiedBefore_.getTime();
    }
}

