/*
 * Decompiled with CFR 0.152.
 */
package ts.util.resource;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ts.util.resource.AttributeMap;

public class Element {
    private String name_;
    private String value_ = null;
    private AttributeMap attrMap_ = new AttributeMap();
    private Element parent_ = null;
    Map<String, List<Element>> childMap_ = new LinkedHashMap<String, List<Element>>();

    public static Element createRootElement() {
        return new Element(){

            @Override
            public String setValue(String string) {
                assert (false);
                return "";
            }

            @Override
            public String putAttribute(String string, String string2) {
                assert (false);
                return "";
            }
        };
    }

    private Element() {
        this.name_ = "";
        this.parent_ = null;
    }

    public Element(String string) {
        assert (string != null) : "@param:name is null.";
        assert (string.length() > 0) : "@param:name is empty.";
        this.name_ = string;
    }

    public String getName() {
        return this.name_;
    }

    public String getValue() {
        return this.value_;
    }

    public String setValue(String string) {
        String string2 = this.value_;
        this.value_ = string;
        return string2;
    }

    public Element getParent() {
        return this.parent_;
    }

    public AttributeMap getAttributes() {
        return this.attrMap_;
    }

    public String putAttribute(String string, String string2) {
        assert (string != null) : "@param;name is null.";
        assert (string2 != null) : "@param:value is null";
        assert (string.length() > 0) : "@param:name is empty";
        return this.attrMap_.put(string, string2);
    }

    public void addChild(Element element) {
        assert (element != null) : "@param:child is null.";
        List<Element> list = this.childMap_.get(element.getName());
        if (list == null) {
            list = new LinkedList<Element>();
            this.childMap_.put(element.getName(), list);
        }
        element.parent_ = this;
        list.add(element);
    }

    public void removeChildren(String string) {
        assert (string != null) : "@param:name is null.";
        this.childMap_.remove(string);
    }

    public void removeAllChildren() {
        this.childMap_.clear();
    }

    public Element getFirstChild(String string) {
        assert (string != null) : "@param:name is null.";
        List<Element> list = this.childMap_.get(string);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public List<Element> getChildren(String string) {
        assert (string != null) : "@param:name is null.";
        LinkedList linkedList = this.childMap_.get(string);
        return linkedList != null ? linkedList : new LinkedList();
    }

    public List<Element> getAllChildren() {
        LinkedList<Element> linkedList = new LinkedList<Element>();
        for (List<Element> list : this.childMap_.values()) {
            for (Element element : list) {
                linkedList.add(element);
            }
        }
        return linkedList;
    }
}

