package ts.query;

import ts.tester.UnitTest;
import ts.util.*;
import ts.util.resource.*;
import java.util.*;

public class QueryContentTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryContentTest.class, args);
  }

  enum Attribute {
    AAA, BBB, CCC,
  }

  public void constructor()
  {
    MSG("デフォルト・コンストラクタの確認。");

    QueryContent content = new QueryContent();
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());
  }

  public void set_key_value()
  {
    MSG("指定されたキーに結びつけられた属性値を設定するメソッドの確認。");

    QueryContent content = new QueryContent();
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    content.set(Attribute.BBB, "あいうえお");
    EQUAL(content.get(Attribute.AAA), null);
    EQUAL(content.get(Attribute.BBB), "あいうえお");
    EQUAL(content.get(Attribute.CCC), null);
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    content.set(Attribute.CCC, 12345);
    EQUAL(content.get(Attribute.AAA), null);
    EQUAL(content.get(Attribute.BBB), "あいうえお");
    EQUAL(content.get(Attribute.CCC), 12345);
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    content.set(Attribute.BBB, null);
    EQUAL(content.get(Attribute.AAA), null);
    EQUAL(content.get(Attribute.BBB), null);
    EQUAL(content.get(Attribute.CCC), 12345);
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());
  }

  public void set_key_value_Null()
  {
    MSG("引数がヌルの場合。");

    QueryContent content = new QueryContent();
    NULL(content.get(Attribute.AAA));

    try {
      content.set(null, "x");
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
    NULL(content.get(Attribute.AAA));

    content.set(Attribute.AAA, null);
    NULL(content.get(Attribute.AAA));

    content.set(Attribute.AAA, "X");
    EQUAL(content.get(Attribute.AAA), "X");

    content.set(Attribute.AAA, null);
    NULL(content.get(Attribute.AAA));
  }

  public void addParam_param()
  {
    MSG("入力パラメータを追加するメソッドの確認。");

    QueryContent content = new QueryContent();
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    QueryParam param0 = new QueryParam("ccc");
    content.addParam(param0);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 1);
    EQUAL(content.listParams().get(0), param0);
    EQUAL(content.countParams(), 1);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    QueryParam param1 = new QueryParam("ddd");
    content.addParam(param1);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 2);
    EQUAL(content.listParams().get(0), param0);
    EQUAL(content.listParams().get(1), param1);
    EQUAL(content.countParams(), 2);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    content.addParam(param0);
    content.addParam(param0);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 4);
    EQUAL(content.listParams().get(0), param0);
    EQUAL(content.listParams().get(1), param1);
    EQUAL(content.listParams().get(2), param0);
    EQUAL(content.listParams().get(3), param0);
    EQUAL(content.countParams(), 4);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());
  }

  public void addParam_param_Null()
  {
    MSG("引数がヌルの場合。");

    QueryContent content = new QueryContent();
    try {
      content.addParam(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void addParams_coll()
  {
    MSG("入力パラメータのコレクションを追加するメソッドの確認。");

    QueryContent content = new QueryContent();
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    List<QueryParam> lst = new ArrayList<QueryParam>(0);
    content.addParams(lst);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    QueryParam param0 = new QueryParam("a5");
    QueryParam param1 = new QueryParam("a2");
    QueryParam param2 = new QueryParam("a3");
    QueryParam param3 = new QueryParam("a4");
    QueryParam param4 = new QueryParam("a2");
    QueryParam param5 = new QueryParam("a3");
    lst = new ArrayList<QueryParam>(0);
    lst.add(param0);
    lst.add(param1);
    lst.add(param2);
    lst.add(param3);
    lst.add(param4);
    lst.add(param5);
    content.addParams(lst);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 6);
    EQUAL(content.listParams().get(0), param0);
    EQUAL(content.listParams().get(1), param1);
    EQUAL(content.listParams().get(2), param2);
    EQUAL(content.listParams().get(3), param3);
    EQUAL(content.listParams().get(4), param4);
    EQUAL(content.listParams().get(5), param5);
    EQUAL(content.countParams(), 6);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    lst = new ArrayList<QueryParam>(0);
    content.addParams(lst);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 6);
    EQUAL(content.listParams().get(0), param0);
    EQUAL(content.listParams().get(1), param1);
    EQUAL(content.listParams().get(2), param2);
    EQUAL(content.listParams().get(3), param3);
    EQUAL(content.listParams().get(4), param4);
    EQUAL(content.listParams().get(5), param5);
    EQUAL(content.countParams(), 6);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());
  }

  public void addParams_coll_Null()
  {
    MSG("引数がヌルの場合。");

    QueryContent content = new QueryContent();
    try {
      content.addParams((List<QueryParam>) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void addParams_coll_HasNullElement()
  {
    MSG("引数のコレクションの中にヌルの要素がある場合。");

    QueryContent content = new QueryContent();

    List<QueryParam> lst = new ArrayList<QueryParam>();
    QueryParam param0 = new QueryParam("a5");
    QueryParam param1 = new QueryParam("a2");
    QueryParam param2 = new QueryParam("a3");
    lst = new ArrayList<QueryParam>(0);
    lst.add(param0);
    lst.add(null);
    lst.add(param1);
    lst.add(param2);
    try {
      content.addParams(lst);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
  }

  public void addParams_array()
  {
    MSG("入力パラメータの配列を追加するメソッドの確認。");

    QueryContent content = new QueryContent();
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    QueryParam[] arr = new QueryParam[0];
    content.addParams(arr);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    arr = new QueryParam[6];
    arr[0] = new QueryParam("a5");
    arr[1] = new QueryParam("a2");
    arr[2] = new QueryParam("a3");
    arr[3] = new QueryParam("a4");
    arr[4] = new QueryParam("a2");
    arr[5] = new QueryParam("a3");
    content.addParams(arr);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 6);
    EQUAL(content.listParams().get(0), arr[0]);
    EQUAL(content.listParams().get(1), arr[1]);
    EQUAL(content.listParams().get(2), arr[2]);
    EQUAL(content.listParams().get(3), arr[3]);
    EQUAL(content.listParams().get(4), arr[4]);
    EQUAL(content.listParams().get(5), arr[5]);
    EQUAL(content.countParams(), 6);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    content.addParams(new QueryParam[0]);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 6);
    EQUAL(content.listParams().get(0), arr[0]);
    EQUAL(content.listParams().get(1), arr[1]);
    EQUAL(content.listParams().get(2), arr[2]);
    EQUAL(content.listParams().get(3), arr[3]);
    EQUAL(content.listParams().get(4), arr[4]);
    EQUAL(content.listParams().get(5), arr[5]);
    EQUAL(content.countParams(), 6);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());
  }

  public void addParams_array_Null()
  {
    MSG("引数がヌルの場合。");

    QueryContent content = new QueryContent();
    try {
      content.addParams((QueryParam[]) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void addParams_array_HasNullElement()
  {
    MSG("引数の配列の中にヌルの要素がある場合。");

    QueryContent content = new QueryContent();

    QueryParam[] arr = new QueryParam[4];
    arr[0] = new QueryParam("a5");
    arr[1] = null;
    arr[2] = new QueryParam("a2");
    arr[3] = new QueryParam("a3");
    try {
      content.addParams(arr);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
  }

  public void addOutput_output()
  {
    MSG("出力項目を追加するメソッドの確認。");

    QueryContent content = new QueryContent();
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    QueryOutput out0 = new QueryOutput("ccc");
    content.addOutput(out0);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    List<QueryOutput> outLst = new ArrayList<QueryOutput>(content.getOutputs());
    EQUAL(outLst.size(), 1);
    EQUAL(outLst.get(0), out0);
    EQUAL(content.countOutputs(), 1);
    TRUE(content.hasResultTable());

    QueryOutput out1 = new QueryOutput("ddd");
    content.addOutput(out1);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    outLst = new ArrayList<QueryOutput>(content.getOutputs());
    EQUAL(outLst.size(), 2);
    EQUAL(outLst.get(0), out0);
    EQUAL(outLst.get(1), out1);
    EQUAL(content.countOutputs(), 2);
    TRUE(content.hasResultTable());

    content.addOutput(out0);
    content.addOutput(out0);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    outLst = new ArrayList<QueryOutput>(content.getOutputs());
    EQUAL(outLst.size(), 2);
    EQUAL(outLst.get(0), out0);
    EQUAL(outLst.get(1), out1);
    EQUAL(content.countOutputs(), 2);
    TRUE(content.hasResultTable());
  }

  public void addOutput_output_Null()
  {
    MSG("引数がヌルの場合。");

    QueryContent content = new QueryContent();
    try {
      content.addOutput(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void addOutputs_coll()
  {
    MSG("出力項目のコレクションを追加するメソッドの確認。");

    QueryContent content = new QueryContent();
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    List<QueryOutput> lst = new ArrayList<QueryOutput>(0);
    content.addOutputs(lst);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    QueryOutput out0 = new QueryOutput("a5");
    QueryOutput out1 = new QueryOutput("a2");
    QueryOutput out2 = new QueryOutput("a3");
    QueryOutput out3 = new QueryOutput("a4");
    QueryOutput out4 = new QueryOutput("a2");
    QueryOutput out5 = new QueryOutput("a3");
    lst = new ArrayList<QueryOutput>(0);
    lst.add(out0);
    lst.add(out1);
    lst.add(out2);
    lst.add(out3);
    lst.add(out4);
    lst.add(out5);
    content.addOutputs(lst);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    List<QueryOutput> outLst = new ArrayList<QueryOutput>(content.getOutputs());
    EQUAL(outLst.size(), 4);
    EQUAL(outLst.get(0), out0);
    EQUAL(outLst.get(1), out1);
    EQUAL(outLst.get(2), out2);
    EQUAL(outLst.get(3), out3);
    EQUAL(content.countOutputs(), 4);
    TRUE(content.hasResultTable());

    lst = new ArrayList<QueryOutput>(0);
    content.addOutputs(lst);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    outLst = new ArrayList<QueryOutput>(content.getOutputs());
    EQUAL(outLst.size(), 4);
    EQUAL(outLst.get(0), out0);
    EQUAL(outLst.get(1), out1);
    EQUAL(outLst.get(2), out2);
    EQUAL(outLst.get(3), out3);
    EQUAL(content.countOutputs(), 4);
    TRUE(content.hasResultTable());
  }

  public void addOutputs_coll_Null()
  {
    MSG("引数がヌルの場合。");

    QueryContent content = new QueryContent();
    try {
      content.addOutputs((List<QueryOutput>) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void addOutputs_coll_HasNullElement()
  {
    MSG("引数のコレクションの中にヌルの要素がある場合。");

    QueryContent content = new QueryContent();

    List<QueryOutput> lst = new ArrayList<QueryOutput>();
    QueryOutput out0 = new QueryOutput("a5");
    QueryOutput out1 = new QueryOutput("a2");
    QueryOutput out2 = new QueryOutput("a3");
    lst = new ArrayList<QueryOutput>(0);
    lst.add(out0);
    lst.add(null);
    lst.add(out1);
    lst.add(out2);
    try {
      content.addOutputs(lst);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
  }

  public void addOutputs_array()
  {
    MSG("出力項目の配列を追加するメソッドの確認。");

    QueryContent content = new QueryContent();
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    QueryOutput[] arr = new QueryOutput[0];
    content.addOutputs(arr);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 0);
    EQUAL(content.countOutputs(), 0);
    FALSE(content.hasResultTable());

    arr = new QueryOutput[6];
    arr[0] = new QueryOutput("a5");
    arr[1] = new QueryOutput("a2");
    arr[2] = new QueryOutput("a3");
    arr[3] = new QueryOutput("a4");
    arr[4] = new QueryOutput("a2");
    arr[5] = new QueryOutput("a3");
    content.addOutputs(arr);

    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 4);
    List<QueryOutput> outLst = new ArrayList<QueryOutput>(content.getOutputs());
    EQUAL(outLst.get(0), arr[0]);
    EQUAL(outLst.get(1), arr[1]);
    EQUAL(outLst.get(2), arr[2]);
    EQUAL(outLst.get(3), arr[3]);
    EQUAL(content.countOutputs(), 4);
    TRUE(content.hasResultTable());

    content.addOutputs(new QueryOutput[0]);
    NULL(content.get(Attribute.AAA));
    NULL(content.get(Attribute.BBB));
    NULL(content.get(Attribute.CCC));
    EQUAL(content.listParams().size(), 0);
    EQUAL(content.countParams(), 0);
    EQUAL(content.getOutputs().size(), 4);
    outLst = new ArrayList<QueryOutput>(content.getOutputs());
    EQUAL(outLst.get(0), arr[0]);
    EQUAL(outLst.get(1), arr[1]);
    EQUAL(outLst.get(2), arr[2]);
    EQUAL(outLst.get(3), arr[3]);
    EQUAL(content.countOutputs(), 4);
    TRUE(content.hasResultTable());
  }

  public void addOutputs_array_Null()
  {
    MSG("引数がヌルの場合。");

    QueryContent content = new QueryContent();
    try {
      content.addOutputs((QueryOutput[]) null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void addOutputs_array_HasNullElement()
  {
    MSG("引数の配列の中にヌルの要素がある場合。");

    QueryContent content = new QueryContent();

    QueryOutput[] arr = new QueryOutput[4];
    arr[0] = new QueryOutput("a5");
    arr[1] = null;
    arr[2] = new QueryOutput("a2");
    arr[3] = new QueryOutput("a3");

    try {
      content.addOutputs(arr);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }
}
