package ts.query;

import ts.tester.UnitTest;
import ts.util.*;
import java.util.*;

public class QueryParamTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryParamTest.class, args);
  }

  public void constructor_name()
  {
    MSG("名前を引数にとるコンストラクタ。");

    QueryParam param = new QueryParam("abc");
    EQUAL(param.getName(), "abc");
    EQUAL(param.getIO(), QueryParam.IO.IN);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);
  }

  public void constructor_name_Null()
  {
    MSG("引数がヌルの場合。");

    try {
      new QueryParam(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void constructor_name_io()
  {
    MSG("名前と入出力区分を引数とるコンストラクタ。");

    QueryParam param = new QueryParam("xyz", QueryParam.IO.OUT);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.OUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);
  }

  public void constructor_name_io_Null()
  {
    MSG("引数がヌルの場合。");

    try {
      new QueryParam(null, QueryParam.IO.OUT);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }

    try {
      new QueryParam("aaa", null);
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void put_key_attrValue()
  {
    MSG("属性値を設定するメソッドの確認。");

    QueryParam param = new QueryParam("xyz", QueryParam.IO.INOUT);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    NULL(param.get(null));
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    param.put("AAA", 123);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    EQUAL(param.get("AAA"), 123);
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    NULL(param.get(null));
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    param.put("CCC", "あいうえお");
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    EQUAL(param.get("AAA"), 123);
    NULL(param.get("BBB"));
    EQUAL(param.get("CCC"), "あいうえお");
    NULL(param.get(null));
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    param.put(null, 999);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    EQUAL(param.get("AAA"), 123);
    NULL(param.get("BBB"));
    EQUAL(param.get("CCC"), "あいうえお");
    EQUAL(param.get(null), 999);
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    param.put("AAA", null);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    EQUAL(param.get("CCC"), "あいうえお");
    EQUAL(param.get(null), 999);
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);
  }

  public void setValue_paramValue_SingleValue()
  {
    MSG("パラメータ値が単値の場合。");

    QueryParam param = new QueryParam("xyz", QueryParam.IO.INOUT);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    NULL(param.getValue());
    NULL(param.getValue());
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    param.setValue("あいうえお");
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    EQUAL(param.getValue(), "あいうえお");
    EQUAL(param.getValue(), "あいうえお");
    EQUAL(param.getValue(), "あいうえお");
    EQUAL(param.countValues(), 1);

    param.setValue(1234);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    EQUAL(param.getValue(), 1234);
    EQUAL(param.getValue(), 1234);
    EQUAL(param.getValue(), 1234);
    EQUAL(param.countValues(), 1);
  }

  public void setValue_paramValue_Collection()
  {
    MSG("パラメータ値がコレクションの場合。");

    QueryParam param = new QueryParam("xyz", QueryParam.IO.INOUT);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    NULL(param.getValue());
    NULL(param.getValue());
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    List<String> lst = new ArrayList<String>(3);
    lst.add("あ");
    lst.add("か");
    lst.add("さ");
    param.setValue(lst);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    EQUAL(param.countValues(), 3);
    EQUAL(param.getValue(), "あ");
    EQUAL(param.getValue(), "か");
    EQUAL(param.getValue(), "さ");
    EQUAL(param.getValue(), "さ");
  }

  public void setValue_paramValue_Array()
  {
    MSG("パラメータ値が配列の場合。");

    QueryParam param = new QueryParam("xyz", QueryParam.IO.INOUT);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));  
    NULL(param.get("BBB"));  
    NULL(param.get("CCC"));  
    NULL(param.getValue());
    NULL(param.getValue());
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    Integer[] arr = new Integer[]{ 111, 222, 333, 444 };
    param.setValue(arr);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));  
    NULL(param.get("BBB"));  
    NULL(param.get("CCC"));  
    EQUAL(param.getValue(), 111);
    EQUAL(param.getValue(), 222);
    EQUAL(param.getValue(), 333);
    EQUAL(param.getValue(), 444);
    EQUAL(param.getValue(), 444);
    EQUAL(param.countValues(), 4);
  }

  public void setValue_paramValue_Null()
  {
    MSG("パラメータ値がヌルの場合。");

    QueryParam param = new QueryParam("xyz", QueryParam.IO.INOUT);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    NULL(param.getValue());
    NULL(param.getValue());
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    param.setValue(new String[0]);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    NULL(param.getValue());
    NULL(param.getValue());
    NULL(param.getValue());
    EQUAL(param.countValues(), 0);

    param.setValue(null);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryParam.IO.INOUT);
    NULL(param.get("AAA"));
    NULL(param.get("BBB"));
    NULL(param.get("CCC"));
    NULL(param.getValue());
    NULL(param.getValue());
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);
  }
}
