/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ts.query.IQueryConnection;
import ts.query.IQueryResult;
import ts.query.QueryExecution;
import ts.query.QueryExecutionConfig;
import ts.query.QueryExecutionContent;
import ts.query.QueryResult;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;

public abstract class BatchedQueryExecution
extends QueryExecution {
    public BatchedQueryExecution(QueryExecutionConfig queryExecutionConfig) throws ReasonedException, ReasonedRuntimeException {
        super(queryExecutionConfig);
    }

    public BatchedQueryExecution(QueryExecutionConfig queryExecutionConfig, IQueryConnection iQueryConnection) {
        super(queryExecutionConfig, iQueryConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Map<String, Object> map, IQueryResult iQueryResult) throws ReasonedException, ReasonedRuntimeException {
        assert (map != null && iQueryResult != null) : map == null ? "@param:inputMap is null." : (iQueryResult == null ? "@param:result is null." : "");
        long l = System.currentTimeMillis();
        long l2 = this.calcLimitTimeMillis(l);
        int n = this.calcLimitFetchCount();
        QueryResult queryResult = (QueryResult)QueryResult.class.cast(iQueryResult);
        if (queryResult.getBeginTimeMillis() <= 0L || queryResult.getBeginTimeMillis() > l) {
            queryResult.setBeginTimeMillis(l);
        }
        HashMap hashMap = new HashMap();
        try {
            Iterator<String> iterator = this.iterateSubExecutionIds();
            while (iterator.hasNext()) {
                String string = iterator.next();
                QueryExecutionContent queryExecutionContent = this.createContent();
                queryExecutionContent.setLimitTimeMillis(l2);
                queryExecutionContent.setLimitFetchCount(n);
                queryExecutionContent.put(Attribute.ResultTableMap, hashMap);
                queryExecutionContent.put(Attribute.SubExecutionId, (Serializable)((Object)string));
                try {
                    this.checkTimeout(queryExecutionContent);
                    this.prepareContent(queryExecutionContent, map);
                    this.prepareResultTable(queryExecutionContent);
                    this.checkTimeout(queryExecutionContent);
                    this.executeContent(queryExecutionContent);
                }
                finally {
                    this.disposeContent(queryExecutionContent, queryResult);
                }
            }
        }
        catch (Exception exception) {
            queryResult.setException(exception);
            throw queryResult.getException();
        }
        finally {
            queryResult.setEndTimeMillis(System.currentTimeMillis());
        }
    }

    @Override
    protected void prepareResultTable(QueryExecutionContent queryExecutionContent) {
        String string = queryExecutionContent.getString((Object)Attribute.SubExecutionId);
        Serializable serializable = queryExecutionContent.get(Attribute.ResultTableMap);
        Map map = (Map)((Object)serializable);
        if (!queryExecutionContent.hasResultTable()) {
            queryExecutionContent.setResultTable(null);
            map.remove(string);
        } else {
            queryExecutionContent.setResultTable(this.newResultTable(queryExecutionContent));
            map.put(string, queryExecutionContent.getResultTable());
        }
    }

    @Override
    protected void disposeContent(QueryExecutionContent queryExecutionContent, QueryResult queryResult) {
        String string;
        String string2 = this.getConfig().getResource().getFirstValue("ts-query.execution.result.id");
        if (string2.equals(string = queryExecutionContent.getString((Object)Attribute.SubExecutionId))) {
            super.disposeContent(queryExecutionContent, queryResult);
        }
    }

    protected abstract Iterator<String> iterateSubExecutionIds();

    public static enum Attribute {
        ResultTableMap,
        SubExecutionId;

    }
}

