/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.util.List;
import ts.query.IQueryConnection;
import ts.query.IQueryTransaction;
import ts.query.QueryEnvironment;
import ts.util.AbstractTypedGetter;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;
import ts.util.resource.PropertyResource;
import ts.util.resource.Resource;
import ts.util.resource.XmlResource;

public class QueryConnectionConfig
implements Serializable {
    static final long serialVersionUID = -6887474425180424994L;
    private final String connectionId;
    private final Resource resource;
    private final AbstractTypedGetter<String, String> typedGetter;

    public QueryConnectionConfig() {
        this.connectionId = "";
        this.resource = new PropertyResource();
        this.typedGetter = this.newTypedGetter();
    }

    public QueryConnectionConfig(String string) {
        if (string == null) {
            throw new ReasonedRuntimeException((Enum)Error.ConnectionIdIsNullOrEmpty, "[connection Id=" + string + "]");
        }
        if ((string = string.trim()).isEmpty()) {
            throw new ReasonedRuntimeException((Enum)Error.ConnectionIdIsNullOrEmpty, "[connection Id=" + string + "]");
        }
        this.connectionId = string;
        this.resource = this.loadResource();
        this.typedGetter = this.newTypedGetter();
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    protected Resource loadResource() throws ReasonedRuntimeException {
        QueryEnvironment queryEnvironment = QueryEnvironment.getInstance();
        File file = queryEnvironment.getConnectionConfigDirectory();
        File file2 = new File(file, this.getConnectionId() + ".xml");
        if (file2.exists()) {
            try {
                XmlResource xmlResource = new XmlResource();
                xmlResource.setValidating(false);
                xmlResource.load(file2.getCanonicalPath());
                return xmlResource;
            }
            catch (Exception exception) {
                throw new ReasonedRuntimeException((Enum)Error.FailToLoadConnectionConfigFile, "[path=" + file2.getAbsolutePath() + "]", (Throwable)exception);
            }
        }
        File file3 = new File(file, this.getConnectionId() + ".properties");
        if (file3.exists()) {
            try {
                return new PropertyResource(file3.getCanonicalPath());
            }
            catch (Exception exception) {
                throw new ReasonedRuntimeException((Enum)Error.FailToLoadConnectionConfigFile, "[path=" + file3.getAbsolutePath() + "]", (Throwable)exception);
            }
        }
        throw new ReasonedRuntimeException((Enum)Error.ConnectionConfigFileNotFound, "[path=" + new File(file, this.getConnectionId()).getAbsolutePath() + ".{xml|properties}]");
    }

    protected AbstractTypedGetter<String, String> newTypedGetter() {
        return new AbstractTypedGetter<String, String>(){
            static final long serialVersionUID = -6887474425180424993L;

            public String get(String string) {
                return QueryConnectionConfig.this.resource.getFirstValue(string);
            }

            public List<String> getList(String string) {
                return QueryConnectionConfig.this.resource.getValues(string);
            }
        };
    }

    protected Resource getResource() {
        return this.resource;
    }

    protected AbstractTypedGetter<String, String> typedGetter() {
        return this.typedGetter;
    }

    public <T extends IQueryConnection> T create() throws ReasonedException, ReasonedRuntimeException {
        GenericDeclaration genericDeclaration;
        String string = this.getConnectionClass();
        Class<?> clazz = null;
        try {
            genericDeclaration = Class.forName(string);
            clazz = genericDeclaration;
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException((Enum)Error.ConnectionClassNotFound, "[class=" + string + "]", (Throwable)exception);
        }
        genericDeclaration = null;
        try {
            genericDeclaration = clazz.getConstructor(QueryConnectionConfig.class);
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException((Enum)Error.ConnectionConstructorNotFound, "[class=" + string + "]", (Throwable)exception);
        }
        try {
            return (T)((IQueryConnection)((Constructor)genericDeclaration).newInstance(this));
        }
        catch (Exception exception) {
            throw new ReasonedException((Enum)Error.FailToCreateConnection, "[class=" + string + "]", (Throwable)exception);
        }
    }

    public <T extends IQueryConnection> T create(IQueryTransaction iQueryTransaction) throws ReasonedException, ReasonedRuntimeException {
        GenericDeclaration genericDeclaration;
        assert (iQueryTransaction != null) : "@param:tran is null.";
        String string = this.getConnectionClass();
        Class<?> clazz = null;
        try {
            genericDeclaration = Class.forName(string);
            clazz = genericDeclaration;
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException((Enum)Error.ConnectionClassNotFound, "[class=" + string + "]", (Throwable)exception);
        }
        genericDeclaration = null;
        try {
            genericDeclaration = clazz.getConstructor(QueryConnectionConfig.class, IQueryTransaction.class);
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException((Enum)Error.ConnectionConstructorNotFound, "[class=" + string + "]", (Throwable)exception);
        }
        try {
            return (T)((IQueryConnection)((Constructor)genericDeclaration).newInstance(this, iQueryTransaction));
        }
        catch (Exception exception) {
            throw new ReasonedException((Enum)Error.FailToCreateConnection, "[class=" + string + "]", (Throwable)exception);
        }
    }

    protected String getConnectionClass() {
        return this.typedGetter().getString((Object)"ts-query.connection.class");
    }

    protected long getLimitSpentTime() {
        try {
            return this.typedGetter().getLong((Object)"ts-query.connection.limit.spenttime");
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException((Enum)Error.IllegalLimitSpentTime, "[property value=" + this.getResource().getFirstValue("ts-query.connection.limit.spenttime") + "]", (Throwable)exception);
        }
    }

    protected void outputSampleXml(PrintWriter printWriter, String string) throws IOException {
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + string.toString() + "\"?>");
        printWriter.println("");
        printWriter.println("<!--");
        printWriter.println("  || Query Connection Configuration XML File.");
        printWriter.println("  ||");
        printWriter.println("  || This file is an XML file which specifys some configuration for an ");
        printWriter.println("  || IQueryConnection object.");
        printWriter.println("  ||");
        printWriter.println("  -->");
        printWriter.println("");
        printWriter.println("<ts-query>");
        printWriter.println(" <connection>");
        printWriter.println("  <!-- The query connection class -->");
        printWriter.println("  <class>...</class>");
        printWriter.println("  <limit>");
        printWriter.println("    <!-- Limit spent time [msec] -->");
        printWriter.println("    <spenttime>0</spenttime>");
        printWriter.println("  </limit>");
        printWriter.println("");
        this.outputSampleXmlEntries(printWriter);
        printWriter.println(" </connection>");
        printWriter.println("</ts-query>");
        printWriter.println();
    }

    protected void outputSampleXmlEntries(PrintWriter printWriter) throws IOException {
    }

    protected void outputSampleProp(PrintWriter printWriter) throws IOException {
        printWriter.println("#");
        printWriter.println("# Query Connection Property File.");
        printWriter.println("#");
        printWriter.println("# This file is a Java property file which specifys some configurations for an ");
        printWriter.println("# IQueryConnection object.");
        printWriter.println("#");
        printWriter.println("");
        printWriter.println("# The query connection class.");
        printWriter.println("ts-query.connection.class = ...");
        printWriter.println("");
        printWriter.println("# Limit spent time [msec]");
        printWriter.println("ts-query.execution.limit.spenttime = 0");
        printWriter.println("");
        this.outputSamplePropEntries(printWriter);
        printWriter.println("");
        printWriter.println("#.");
    }

    protected void outputSamplePropEntries(PrintWriter printWriter) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int executeCommand(String[] stringArray, QueryConnectionConfig queryConnectionConfig) {
        int n;
        block22: {
            boolean bl;
            File file;
            String string = "null";
            String string2 = "";
            try {
                if (stringArray != null && stringArray.length > 0) {
                    string = stringArray[0];
                }
                file = new File(stringArray[1]);
                if ("xml".equalsIgnoreCase(stringArray[2])) {
                    bl = true;
                } else if ("prop".equalsIgnoreCase(stringArray[2])) {
                    bl = false;
                } else {
                    throw new IllegalArgumentException();
                }
                string2 = stringArray[3];
                if (stringArray.length > 4) {
                    throw new IllegalArgumentException();
                }
            }
            catch (Exception exception) {
                System.err.println("HELP:");
                System.err.println(string + " <output-file-path> {xml|prop} <output-file-encoding>");
                System.err.println();
                return 1;
            }
            try {
                new String(new byte[0], string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("ERROR:");
                System.err.println("Specified encoding is unsupported: " + string2);
                System.err.println();
                return 2;
            }
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2));
                if (bl) {
                    queryConnectionConfig.outputSampleXml(printWriter, string2);
                } else {
                    queryConnectionConfig.outputSampleProp(printWriter);
                }
                printWriter.flush();
                n = 0;
                if (printWriter == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (printWriter != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    System.err.println("ERROR:");
                    System.err.println(exception.toString());
                    System.err.println();
                    return 3;
                }
            }
            try {
                printWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public static enum Error {
        ConnectionIdIsNullOrEmpty,
        ConnectionConfigFileNotFound,
        FailToLoadConnectionConfigFile,
        ConnectionClassNotFound,
        ConnectionConstructorNotFound,
        FailToCreateConnection,
        IllegalLimitSpentTime;

    }
}

