/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import ts.util.ReasonedRuntimeException;

public class QueryEnvironmentConfig
implements Serializable {
    static final long serialVersionUID = -290495901596466072L;
    private final ResourceBundle res = null;

    protected String getProperty(String string) throws ReasonedRuntimeException {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("ts.query.QueryEnvironmentConfig");
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException((Enum)Error.FailToLoadEnvironmentConfig, "[base=ts.query.QueryEnvironmentConfig]", (Throwable)exception);
        }
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new ReasonedRuntimeException((Enum)Error.PropertyKeyNotFound, "[base=ts.query.QueryEnvironmentConfig][key=" + string + "]", (Throwable)missingResourceException);
        }
        catch (RuntimeException runtimeException) {
            throw new ReasonedRuntimeException((Enum)Error.FailToGetEnvironmentProperty, "[base=ts.query.QueryEnvironmentConfig][key=" + string + "]", (Throwable)runtimeException);
        }
    }

    public String getConnectionConfigDirectory() {
        return this.getProperty("ts-query.environment.connection.config.directory");
    }

    public String getExecutionConfigDirectory() {
        return this.getProperty("ts-query.environment.execution.config.directory");
    }

    public String getQueryConfigDirectory() {
        return this.getProperty("ts-query.environment.query.config.directory");
    }

    protected static void outputSample(PrintWriter printWriter) throws IOException {
        printWriter.println("#");
        printWriter.println("# Query Environment Configuration File.");
        printWriter.println("#");
        printWriter.println("# This file is a Java property file which specifys directories of other");
        printWriter.println("# configuration files for ts-query modules.");
        printWriter.println("#");
        printWriter.println("");
        printWriter.println("# The directory of query configuration files.");
        printWriter.println("ts-query.environment.query.config.directory = ...");
        printWriter.println("");
        printWriter.println("# The directory of connection configuration files.");
        printWriter.println("ts-query.environment.connection.config.directory = ...");
        printWriter.println("");
        printWriter.println("# The directory of execution configuration files.");
        printWriter.println("ts-query.environment.execution.config.directory = ...");
        printWriter.println("");
        printWriter.println("##.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int executeCommand(String[] stringArray) {
        int n;
        block16: {
            String string;
            File file;
            String string2 = "null";
            try {
                if (stringArray != null && stringArray.length > 0) {
                    string2 = stringArray[0];
                }
                file = new File(stringArray[1]);
                string = stringArray[2];
                if (stringArray.length > 3) {
                    throw new IllegalArgumentException();
                }
            }
            catch (Exception exception) {
                System.err.println("HELP:");
                System.err.println(string2 + " <output-dir-path> <output-file-encoding>");
                System.err.println("Create a sample file of Query Environment Configuration.");
                System.err.println();
                return 1;
            }
            try {
                new String(new byte[0], string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("ERROR:");
                System.err.println("Specified encoding is unsupported: " + string);
                System.err.println();
                return 2;
            }
            File file2 = new File(file, "QueryEnvironmentConfig.properties.sample");
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), string));
                QueryEnvironmentConfig.outputSample(printWriter);
                printWriter.flush();
                n = 0;
                if (printWriter == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (printWriter != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    System.err.println("ERROR:");
                    System.err.println(exception.toString());
                    System.err.println();
                    return 3;
                }
            }
            try {
                printWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public static void main(String[] stringArray) {
        System.exit(QueryEnvironmentConfig.executeCommand(stringArray));
    }

    public static enum Error {
        FailToLoadEnvironmentConfig,
        PropertyKeyNotFound,
        FailToGetEnvironmentProperty;

    }
}

