/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.Serializable;
import java.util.Map;
import ts.query.IQueryConnection;
import ts.query.IQueryExecution;
import ts.query.IQueryResult;
import ts.query.QueryConnectionConfig;
import ts.query.QueryExecutionConfig;
import ts.query.QueryExecutionContent;
import ts.query.QueryExecutionOutput;
import ts.query.QueryResult;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;
import ts.util.table.ArrayListTable;
import ts.util.table.Header;
import ts.util.table.Table;

public abstract class QueryExecution
implements IQueryExecution {
    private final QueryExecutionConfig config;
    private final IQueryConnection connection;

    public QueryExecution(QueryExecutionConfig queryExecutionConfig) throws ReasonedException, ReasonedRuntimeException {
        assert (queryExecutionConfig != null) : "@param:config is null.";
        this.config = queryExecutionConfig;
        String string = queryExecutionConfig.getConnectionId();
        QueryConnectionConfig queryConnectionConfig = new QueryConnectionConfig(string);
        this.connection = queryConnectionConfig.create();
    }

    public QueryExecution(QueryExecutionConfig queryExecutionConfig, IQueryConnection iQueryConnection) {
        assert (queryExecutionConfig != null && iQueryConnection != null) : queryExecutionConfig != null ? "@param:config is null." : "@param:conn is null.";
        this.config = queryExecutionConfig;
        this.connection = iQueryConnection;
    }

    protected QueryExecutionConfig getConfig() {
        return this.config;
    }

    protected <T extends IQueryConnection> T getQueryConnection() {
        IQueryConnection iQueryConnection = this.connection;
        return (T)iQueryConnection;
    }

    @Override
    public String getExecutionId() {
        return this.config.getExecutionId();
    }

    @Override
    public IQueryResult execute(Map<String, Object> map) throws ReasonedException, ReasonedRuntimeException {
        String string = this.getQueryConnection().getConnectionId();
        QueryResult queryResult = new QueryResult("");
        this.execute(map, queryResult);
        return queryResult;
    }

    @Override
    public void execute(Map<String, Object> map, IQueryResult iQueryResult) throws ReasonedException, ReasonedRuntimeException {
        assert (map != null && iQueryResult != null) : map == null ? "@param:inputMap is null." : (iQueryResult == null ? "@param:result is null." : "");
        long l = System.currentTimeMillis();
        long l2 = this.calcLimitTimeMillis(l);
        int n = this.calcLimitFetchCount();
        QueryResult queryResult = (QueryResult)QueryResult.class.cast(iQueryResult);
        if (queryResult.getBeginTimeMillis() <= 0L || queryResult.getBeginTimeMillis() > l) {
            queryResult.setBeginTimeMillis(l);
        }
        QueryExecutionContent queryExecutionContent = this.createContent();
        queryExecutionContent.setLimitTimeMillis(l2);
        queryExecutionContent.setLimitFetchCount(n);
        try {
            this.checkTimeout(queryExecutionContent);
            this.prepareContent(queryExecutionContent, map);
            this.prepareResultTable(queryExecutionContent);
            this.checkTimeout(queryExecutionContent);
            this.executeContent(queryExecutionContent);
        }
        catch (Exception exception) {
            queryResult.setException(exception);
            throw queryResult.getException();
        }
        finally {
            this.disposeContent(queryExecutionContent, queryResult);
            queryResult.setEndTimeMillis(System.currentTimeMillis());
        }
    }

    protected long calcLimitTimeMillis(long l) {
        long l2 = this.getConfig().getLimitSpentTime();
        long l3 = this.getQueryConnection().getLimitTimeMillis();
        if (l <= 0L || l2 <= 0L) {
            return l3;
        }
        if (l3 <= 0L) {
            return l + l2;
        }
        return Math.min(l3, l + l2);
    }

    protected int calcLimitFetchCount() {
        return this.getConfig().getLimitFetchCount();
    }

    protected void checkTimeout(QueryExecutionContent queryExecutionContent) throws ReasonedException {
        long l = queryExecutionContent.getLimitTimeMillis();
        if (l <= 0L) {
            return;
        }
        long l2 = System.currentTimeMillis();
        if (l2 > l) {
            throw new ReasonedException((Enum)IQueryExecution.Error.Timeout, "[connection id=" + queryExecutionContent.getConnectionId() + "]" + "[execution id=" + queryExecutionContent.getExecutionId() + "]" + "[limit time=" + l + "]" + "[current time=" + l2 + "]" + "");
        }
    }

    protected void checkFetchCount(QueryExecutionContent queryExecutionContent, int n) throws ReasonedException {
        int n2 = queryExecutionContent.getLimitFetchCount();
        if (n2 <= 0) {
            return;
        }
        if (n > n2) {
            throw new ReasonedException((Enum)IQueryExecution.Error.FetchCountOver, "[connection id=" + queryExecutionContent.getConnectionId() + "]" + "[execution id=" + queryExecutionContent.getExecutionId() + "]" + "[limit count=" + n2 + "]" + "[actual count=" + n + "]" + "");
        }
    }

    protected QueryExecutionContent createContent() {
        QueryExecutionContent queryExecutionContent = new QueryExecutionContent();
        queryExecutionContent.setExecutionId(this.getConfig().getExecutionId());
        queryExecutionContent.setConnectionId(this.getQueryConnection().getConnectionId());
        return queryExecutionContent;
    }

    protected void prepareResultTable(QueryExecutionContent queryExecutionContent) {
        if (!queryExecutionContent.hasResultTable()) {
            queryExecutionContent.setResultTable(null);
        } else {
            queryExecutionContent.setResultTable(this.newResultTable(queryExecutionContent));
        }
    }

    protected Table<String, Serializable> newResultTable(QueryExecutionContent queryExecutionContent) {
        ArrayListTable.Header header = new ArrayListTable.Header(queryExecutionContent.countOutputs());
        for (QueryExecutionOutput queryExecutionOutput : queryExecutionContent.getOutputs()) {
            header.addColumn((Object)queryExecutionOutput.getName());
        }
        return new ArrayListTable((Header)header);
    }

    protected abstract void prepareContent(QueryExecutionContent var1, Map<String, Object> var2) throws ReasonedException, ReasonedRuntimeException;

    protected abstract void executeContent(QueryExecutionContent var1) throws ReasonedException, ReasonedRuntimeException;

    protected void disposeContent(QueryExecutionContent queryExecutionContent, QueryResult queryResult) {
        if (queryExecutionContent.hasResultTable() && queryExecutionContent.getResultTable() != null) {
            String string = queryExecutionContent.getExecutionId();
            queryResult.getResultTableMap().put(string, queryExecutionContent.getResultTable());
        } else {
            String string = queryExecutionContent.getExecutionId();
            queryResult.getResultTableMap().remove(string);
        }
    }
}

