/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.util.List;
import ts.query.IQueryConnection;
import ts.query.IQueryExecution;
import ts.query.IQueryTransaction;
import ts.query.QueryConnectionConfig;
import ts.query.QueryEnvironment;
import ts.util.AbstractTypedGetter;
import ts.util.ReasonedException;
import ts.util.ReasonedRuntimeException;
import ts.util.resource.PropertyResource;
import ts.util.resource.Resource;
import ts.util.resource.XmlResource;

public class QueryExecutionConfig
implements Serializable {
    static final long serialVersionUID = 4161877040444495005L;
    private final String executionId;
    private final Resource resource;
    private final AbstractTypedGetter<String, String> typedGetter;

    public QueryExecutionConfig() {
        this.executionId = "";
        this.resource = new PropertyResource();
        this.typedGetter = this.newTypedGetter();
    }

    public QueryExecutionConfig(String string) {
        if (string == null) {
            throw new ReasonedRuntimeException((Enum)Error.ExecutionIdIsNullOrEmpty, "[execution Id=" + string + "]");
        }
        if ((string = string.trim()).isEmpty()) {
            throw new ReasonedRuntimeException((Enum)Error.ExecutionIdIsNullOrEmpty, "[execution Id=" + string + "]");
        }
        this.executionId = string;
        this.resource = this.loadResource();
        this.typedGetter = this.newTypedGetter();
    }

    public String getExecutionId() {
        return this.executionId;
    }

    protected Resource loadResource() throws ReasonedRuntimeException {
        QueryEnvironment queryEnvironment = QueryEnvironment.getInstance();
        File file = queryEnvironment.getExecutionConfigDirectory();
        File file2 = new File(file, this.getExecutionId() + ".xml");
        if (file2.exists()) {
            try {
                XmlResource xmlResource = new XmlResource();
                xmlResource.setValidating(false);
                xmlResource.load(file2.getCanonicalPath());
                return xmlResource;
            }
            catch (Exception exception) {
                throw new ReasonedRuntimeException((Enum)Error.FailToLoadExecutionConfigFile, "[path=" + file2.getAbsolutePath() + "]", (Throwable)exception);
            }
        }
        File file3 = new File(file, this.getExecutionId() + ".properties");
        if (file3.exists()) {
            try {
                return new PropertyResource(file3.getCanonicalPath());
            }
            catch (Exception exception) {
                throw new ReasonedRuntimeException((Enum)Error.FailToLoadExecutionConfigFile, "[path=" + file3.getAbsolutePath() + "]", (Throwable)exception);
            }
        }
        throw new ReasonedRuntimeException((Enum)Error.ExecutionConfigFileNotFound, "[path=" + new File(file, this.getExecutionId()).getAbsolutePath() + ".{xml|properties}]");
    }

    protected AbstractTypedGetter<String, String> newTypedGetter() {
        return new AbstractTypedGetter<String, String>(){
            static final long serialVersionUID = 4161877040444495006L;

            public String get(String string) {
                return QueryExecutionConfig.this.resource.getFirstValue(string);
            }

            public List<String> getList(String string) {
                return QueryExecutionConfig.this.resource.getValues(string);
            }
        };
    }

    protected Resource getResource() {
        return this.resource;
    }

    protected AbstractTypedGetter<String, String> typedGetter() {
        return this.typedGetter;
    }

    public <T extends IQueryExecution> T create() throws ReasonedException, ReasonedRuntimeException {
        String string = this.getConnectionId();
        QueryConnectionConfig queryConnectionConfig = new QueryConnectionConfig(string);
        Object t = queryConnectionConfig.create();
        T t2 = this.create((IQueryConnection)t);
        return t2;
    }

    public <T extends IQueryExecution> T create(IQueryTransaction iQueryTransaction) throws ReasonedException, ReasonedRuntimeException {
        if (iQueryTransaction == null) {
            throw new ReasonedRuntimeException((Enum)Error.TransactionIsNull);
        }
        String string = this.getConnectionId();
        IQueryConnection iQueryConnection = iQueryTransaction.getQueryConnection(string);
        T t = this.create(iQueryConnection);
        return t;
    }

    public <T extends IQueryExecution> T create(IQueryConnection iQueryConnection) throws ReasonedException, ReasonedRuntimeException {
        GenericDeclaration genericDeclaration;
        if (iQueryConnection == null) {
            throw new ReasonedRuntimeException((Enum)Error.ConnectionIsNull);
        }
        String string = this.getExecutionClass();
        Class<?> clazz = null;
        try {
            genericDeclaration = Class.forName(string);
            clazz = genericDeclaration;
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException((Enum)Error.ExecutionClassNotFound, "[class=" + string + "]", (Throwable)exception);
        }
        genericDeclaration = null;
        try {
            genericDeclaration = clazz.getConstructor(QueryExecutionConfig.class, IQueryConnection.class);
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException((Enum)Error.ExecutionConstructorNotFound, "[class=" + string + "]", (Throwable)exception);
        }
        try {
            return (T)((IQueryExecution)((Constructor)genericDeclaration).newInstance(this, iQueryConnection));
        }
        catch (Exception exception) {
            throw new ReasonedException((Enum)Error.FailToCreateExecution, "[class=" + string + "]", (Throwable)exception);
        }
    }

    protected String getExecutionClass() {
        return this.typedGetter().getString((Object)"ts-query.execution.class");
    }

    protected String getConnectionId() {
        return this.typedGetter().getString((Object)"ts-query.execution.connection.id");
    }

    protected int getLimitFetchCount() {
        try {
            return this.typedGetter().getInteger((Object)"ts-query.execution.limit.fetchcount");
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException((Enum)Error.IllegalLimitFetchCount, "[property=ts-query.execution.limit.fetchcount][value=" + this.getResource().getFirstValue("ts-query.execution.limit.fetchcount") + "]", (Throwable)exception);
        }
    }

    protected long getLimitSpentTime() {
        try {
            return this.typedGetter().getLong((Object)"ts-query.execution.limit.spenttime");
        }
        catch (Exception exception) {
            throw new ReasonedRuntimeException((Enum)Error.IllegalLimitSpentTime, "[property=ts-query.execution.limit.spenttime][value=" + this.getResource().getFirstValue("ts-query.execution.limit.spenttime") + "]", (Throwable)exception);
        }
    }

    protected void outputSampleXml(PrintWriter printWriter, String string) throws IOException {
        printWriter.println("<?xml version=\"1.0\" encoding=\"" + string.toString() + "\"?>");
        printWriter.println("");
        printWriter.println("<!--");
        printWriter.println("  || Query Execution Configuration XML File.");
        printWriter.println("  ||");
        printWriter.println("  || This file is an XML file which specifys some configuration for an ");
        printWriter.println("  || IQueryExecution object.");
        printWriter.println("  ||");
        printWriter.println("  -->");
        printWriter.println("");
        printWriter.println("<ts-query>");
        printWriter.println(" <execution>");
        printWriter.println("  <!-- The query execution class -->");
        printWriter.println("  <class>...</class>");
        printWriter.println("  <connection>");
        printWriter.println("    <!-- The query connection id -->");
        printWriter.println("    <id>...</id>");
        printWriter.println("  </connection>");
        printWriter.println("  <limit>");
        printWriter.println("    <!-- Limit fetch count -->");
        printWriter.println("    <fetchcount>0</fetchcount>");
        printWriter.println("");
        printWriter.println("    <!-- Limit spent time [msec] -->");
        printWriter.println("    <spenttime>0</spenttime>");
        printWriter.println("  </limit>");
        printWriter.println("");
        this.outputSampleXmlEntries(printWriter);
        printWriter.println(" </execution>");
        printWriter.println("</ts-query>");
        printWriter.println();
    }

    protected void outputSampleXmlEntries(PrintWriter printWriter) throws IOException {
    }

    protected void outputSampleProp(PrintWriter printWriter) throws IOException {
        printWriter.println("#");
        printWriter.println("# Query Execution Property File.");
        printWriter.println("#");
        printWriter.println("# This file is a Java property file which specifys some configurations for an ");
        printWriter.println("# IQueryExecution object.");
        printWriter.println("#");
        printWriter.println("");
        printWriter.println("# The query execution class.");
        printWriter.println("ts-query.execution.class = ...");
        printWriter.println("");
        printWriter.println("# The query connection id");
        printWriter.println("ts-query.execution.connection.id = ...");
        printWriter.println("");
        printWriter.println("# Limit fetch count");
        printWriter.println("ts-query.execution.limit.fetchcount = 0");
        printWriter.println("");
        printWriter.println("# Limit spent time [msec]");
        printWriter.println("ts-query.execution.limit.spenttime = 0");
        printWriter.println("");
        this.outputSamplePropEntries(printWriter);
        printWriter.println("");
        printWriter.println("#.");
    }

    protected void outputSamplePropEntries(PrintWriter printWriter) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int executeCommand(String[] stringArray, QueryExecutionConfig queryExecutionConfig) {
        int n;
        block22: {
            boolean bl;
            File file;
            String string = "null";
            String string2 = "";
            try {
                if (stringArray != null && stringArray.length > 0) {
                    string = stringArray[0];
                }
                file = new File(stringArray[1]);
                if ("xml".equalsIgnoreCase(stringArray[2])) {
                    bl = true;
                } else if ("prop".equalsIgnoreCase(stringArray[2])) {
                    bl = false;
                } else {
                    throw new IllegalArgumentException();
                }
                string2 = stringArray[3];
                if (stringArray.length > 4) {
                    throw new IllegalArgumentException();
                }
            }
            catch (Exception exception) {
                System.err.println("HELP:");
                System.err.println(string + " <output-file-path> {xml|prop} <output-file-encoding>");
                System.err.println();
                return 1;
            }
            try {
                new String(new byte[0], string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("ERROR:");
                System.err.println("Specified encoding is unsupported: " + string2);
                System.err.println();
                return 2;
            }
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2));
                if (bl) {
                    queryExecutionConfig.outputSampleXml(printWriter, string2);
                } else {
                    queryExecutionConfig.outputSampleProp(printWriter);
                }
                printWriter.flush();
                n = 0;
                if (printWriter == null) break block22;
            }
            catch (Throwable throwable) {
                try {
                    if (printWriter != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    System.err.println("ERROR:");
                    System.err.println(exception.toString());
                    System.err.println();
                    return 3;
                }
            }
            try {
                printWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public static enum Error {
        ExecutionIdIsNullOrEmpty,
        ExecutionConfigFileNotFound,
        FailToLoadExecutionConfigFile,
        ExecutionClassNotFound,
        ExecutionConstructorNotFound,
        FailToCreateExecution,
        TransactionIsNull,
        ConnectionIsNull,
        IllegalLimitFetchCount,
        IllegalLimitSpentTime;

    }
}

