/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ts.query.QueryExecutionOutput;
import ts.query.QueryExecutionParam;
import ts.util.AbstractTypedGetter;
import ts.util.table.Table;

public class QueryExecutionContent
extends AbstractTypedGetter<Enum<?>, Serializable>
implements Serializable {
    static final long serialVersionUID = 2970137509789869821L;
    private String connectionId = "";
    private String executionId = "";
    private final List<QueryExecutionParam> paramLst = this.newParamList();
    private final Set<QueryExecutionOutput> outputSet = this.newOutputSet();
    private Map<Enum<?>, Serializable> attributeMap = null;
    private Table<String, Serializable> resultTable = null;
    private int fetchCount = 0;
    private int updateCount = 0;
    private long limitTimeMillis = 0L;
    private int limitFetchCount = 0;

    protected List<QueryExecutionParam> newParamList() {
        return new LinkedList<QueryExecutionParam>();
    }

    protected Set<QueryExecutionOutput> newOutputSet() {
        return new LinkedHashSet<QueryExecutionOutput>();
    }

    protected Map<Enum<?>, Serializable> newAttributeMap() {
        return new HashMap();
    }

    public Serializable get(Enum<?> enum_) {
        assert (enum_ != null) : "@param;key is null.";
        return this.attributeMap == null ? null : this.attributeMap.get(enum_);
    }

    public Serializable put(Enum<?> enum_, Serializable serializable) {
        assert (enum_ != null) : "@param:key is null.";
        if (this.attributeMap == null) {
            this.attributeMap = this.newAttributeMap();
        }
        if (serializable == null) {
            return this.attributeMap.remove(enum_);
        }
        return this.attributeMap.put(enum_, serializable);
    }

    public List<QueryExecutionParam> listParams() {
        return this.paramLst;
    }

    public int countParams() {
        return this.paramLst.size();
    }

    public void addParam(QueryExecutionParam queryExecutionParam) {
        assert (queryExecutionParam != null) : "@param:param is null.";
        this.paramLst.add(queryExecutionParam);
    }

    public Collection<QueryExecutionOutput> getOutputs() {
        return this.outputSet;
    }

    public int countOutputs() {
        return this.outputSet.size();
    }

    public void addOutput(QueryExecutionOutput queryExecutionOutput) {
        assert (queryExecutionOutput != null) : "@param:output is null.";
        this.outputSet.add(queryExecutionOutput);
    }

    public void setConnectionId(String string) {
        assert (string != null) : "@param:connId is null.";
        this.connectionId = string;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public void setExecutionId(String string) {
        assert (string != null) : "@param:execId is null.";
        this.executionId = string;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public boolean hasResultTable() {
        return this.countOutputs() > 0;
    }

    public void setResultTable(Table<String, Serializable> table) {
        this.resultTable = table;
    }

    public Table<String, Serializable> getResultTable() {
        return this.resultTable;
    }

    public void setFetchCount(int n) {
        assert (n >= 0) : "@param:count is negative.";
        this.fetchCount = n;
    }

    public int getFetchCount() {
        return this.fetchCount;
    }

    public void setUpdateCount(int n) {
        assert (n >= 0) : "@param:count is negative.";
        this.updateCount = n;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public void setLimitTimeMillis(long l) {
        this.limitTimeMillis = l;
    }

    public long getLimitTimeMillis() {
        return this.limitTimeMillis;
    }

    public void setLimitFetchCount(int n) {
        this.limitFetchCount = n;
    }

    public int getLimitFetchCount() {
        return this.limitFetchCount;
    }
}

