/*
 * Decompiled with CFR 0.152.
 */
package ts.query;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ts.util.AbstractTypedGetter;
import ts.util.table.MapIterator;
import ts.util.table.Table;

public class QueryExecutionParam
extends AbstractTypedGetter<Enum<?>, Serializable> {
    static final long serialVersionUID = -7316624337998775137L;
    private final String name;
    private final IO io;
    private Serializable value = null;
    private Iterator<Serializable> iterator = null;
    private Counter counter = null;
    private Map<Enum<?>, Serializable> attributeMap = null;

    public QueryExecutionParam(String string) {
        this(string, IO.IN);
    }

    public QueryExecutionParam(String string, IO iO) {
        assert (string != null && iO != null) : string == null ? "@param:name is null." : (iO == null ? "@param:io is null." : "");
        this.name = string;
        this.io = iO;
    }

    public String getName() {
        return this.name;
    }

    public IO getIO() {
        return this.io;
    }

    public Serializable get(Enum<?> enum_) {
        return this.attributeMap == null ? null : this.attributeMap.get(enum_);
    }

    public Serializable put(Enum<?> enum_, Serializable serializable) {
        if (this.attributeMap == null) {
            this.attributeMap = this.newAttributeMap();
        }
        if (serializable == null) {
            return this.attributeMap.remove(enum_);
        }
        return this.attributeMap.put(enum_, serializable);
    }

    public Serializable getValue() {
        return this.value;
    }

    public void next() {
        if (this.iterator != null && this.iterator.hasNext()) {
            this.value = this.iterator.next();
        }
    }

    public int countValues() {
        return this.counter != null ? this.counter.count() : 1;
    }

    public void setValue(Object object) {
        if (object == null) {
            this.value = null;
            this.counter = null;
            this.iterator = null;
        } else if (object instanceof Collection) {
            final Collection collection = (Collection)object;
            this.value = null;
            this.iterator = collection.iterator();
            this.counter = new Counter(){

                @Override
                public int count() {
                    return collection.size();
                }
            };
        } else if (object instanceof Serializable[]) {
            final Serializable[] serializableArray = (Serializable[])Serializable[].class.cast(object);
            this.value = null;
            this.iterator = Arrays.asList(serializableArray).iterator();
            this.counter = new Counter(){

                @Override
                public int count() {
                    return serializableArray.length;
                }
            };
        } else {
            this.value = (Serializable)Serializable.class.cast(object);
            this.counter = null;
            this.iterator = null;
        }
        this.next();
    }

    public void setValue(final Table<String, Serializable> table, final String string) {
        if (table == null) {
            this.value = null;
            this.counter = null;
            this.iterator = null;
        } else {
            final MapIterator mapIterator = table.records();
            this.value = null;
            this.iterator = new Iterator<Serializable>(){

                @Override
                public boolean hasNext() {
                    return mapIterator.hasNext();
                }

                @Override
                public Serializable next() {
                    Map map = (Map)mapIterator.next();
                    return map != null ? (Serializable)map.get(string) : null;
                }

                @Override
                public void remove() {
                }
            };
            this.counter = new Counter(){

                @Override
                public int count() {
                    return table.recordCount();
                }
            };
        }
        this.next();
    }

    protected Map<Enum<?>, Serializable> newAttributeMap() {
        return new HashMap();
    }

    protected static interface Counter {
        public int count();
    }

    public static enum IO {
        IN,
        OUT,
        INOUT;

    }
}

