/*
 * Decompiled with CFR 0.152.
 */
package ts.tester.function.print;

import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import ts.tester.coverage.Coverage;
import ts.tester.coverage.CoveragePrinter;
import ts.tester.coverage.LineCoverage;
import ts.tester.coverage.PassResult;
import ts.tester.function.Result;
import ts.tester.function.print.HtmlPrinterBase;
import ts.util.CountUp;
import ts.util.resource.Resource;

public class HtmlPrinter
extends HtmlPrinterBase
implements CoveragePrinter {
    protected static final String KEY_COVERAGE_HEADER = "printer.html.format.coverage.header";
    protected static final String KEY_COVERAGE_FOOTER = "printer.html.format.coverage.footer";
    protected static final String KEY_CLASS_COVERAGE_PREMETHODS = "printer.html.format.coverage.class.premethods";
    protected static final String KEY_CLASS_COVERAGE_POSTMETHODS = "printer.html.format.coverage.class.postmethods";
    protected static final String KEY_METHOD_COVERAGE = "printer.html.format.coverage.class.method";
    protected static final String FMT_SRC_COVERAGE = "src-coverage";
    protected static final String FMT_CLASS_COVERAGE = "class-coverage";
    protected static final String FMT_METHOD_COVERAGE = "method-coverage";
    protected static final String OPT_LINES = ".lines";
    protected static final String OPT_PASSED = ".passed";
    protected static final String OPT_UNPASSED = ".unpassed";
    protected static final String OPT_PASSED_RATIO = ".passed-ratio";
    protected static final String OPT_UNPASSED_RATIO = ".unpassed-ratio";
    protected static final String OPT_PASSED_LINES = ".passed-lines";
    protected static final String OPT_UNPASSED_LINES = ".unpassed-lines";
    private Coverage coverage_ = null;
    private Map<String, Object> replacedMap_ = new HashMap<String, Object>();

    protected HtmlPrinter() {
    }

    public HtmlPrinter(String string) {
        super(string);
    }

    public HtmlPrinter(String string, Resource resource) {
        super(string, resource);
    }

    @Override
    public void prepareCoverage(Coverage coverage) {
        this.coverage_ = coverage;
    }

    @Override
    public void postCoverage(Coverage coverage) {
        this.outputHtmlFileForCoverage();
    }

    @Override
    public void entryLine(Location location) {
    }

    @Override
    public void entryClass(ReferenceType referenceType) {
    }

    @Override
    public void entryMethod(Method method) {
    }

    @Override
    public void exitMethod(Method method) {
    }

    @Override
    public void passLine(Location location) {
    }

    @Override
    protected void outputHtmlFile(Map<String, Object> map) {
        assert (map != null) : "@param:objMap is null.";
        if (this.coverage_ == null) {
            super.outputHtmlFile(map);
            return;
        }
        this.replacedMap_ = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outputHtmlFileForCoverage() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Collection<String> collection = null;
        if (this.coverage_ != null && (object4 = (collection = this.coverage_.allClassNames()).iterator()).hasNext()) {
            object3 = (String)object4.next();
            this.replacedMap_.put(FMT_CLASS_COVERAGE, object3);
            object2 = this.coverage_.methodKeysOf((String)object3);
            object = object2.iterator();
            if (object.hasNext()) {
                this.replacedMap_.put(FMT_METHOD_COVERAGE, object.next());
            }
        }
        object4 = new CountUp(1L, 1L);
        this.replacedMap_.put("src-coverage.index", object4);
        this.replacedMap_.put("class-coverage.index", object4);
        this.replacedMap_.put("method-coverage.index", object4);
        object3 = null;
        try {
            Iterator<String> iterator;
            object2 = this.getReplacedString("printer.html.toFile", this.replacedMap_);
            object = new File((String)object2);
            File file = ((File)object).getParentFile();
            if (file != null && !file.exists()) {
                file.mkdirs();
            }
            object3 = new FileWriter((String)object2);
            PrintWriter printWriter = new PrintWriter((Writer)object3);
            printWriter.println(this.getReplacedString("printer.html.format.header", this.replacedMap_));
            printWriter.flush();
            printWriter.println(this.getReplacedString("printer.html.format.precases", this.replacedMap_));
            printWriter.flush();
            HtmlPrinterBase._CaseResult _CaseResult2 = (HtmlPrinterBase._CaseResult)this.replacedMap_.get("test");
            for (Result result : _CaseResult2.resultList()) {
                iterator = this.replacedMap_.put("case", result);
                printWriter.println(this.getReplacedString("printer.html.format.case", this.replacedMap_));
                printWriter.flush();
                this.replacedMap_.put("case", iterator);
            }
            printWriter.println(this.getReplacedString("printer.html.format.postcases", this.replacedMap_));
            printWriter.flush();
            if (this.coverage_ != null) {
                Result result;
                printWriter.println(this.getReplacedString(KEY_COVERAGE_HEADER, this.replacedMap_));
                printWriter.flush();
                CountUp countUp = new CountUp();
                result = new CountUp();
                this.replacedMap_.put("src-coverage.index", countUp);
                this.replacedMap_.put("class-coverage.index", result);
                iterator = collection.iterator();
                while (iterator.hasNext()) {
                    result.increment();
                    String string = iterator.next();
                    Object object5 = this.replacedMap_.put(FMT_CLASS_COVERAGE, string);
                    printWriter.println(this.getReplacedString(KEY_CLASS_COVERAGE_PREMETHODS, this.replacedMap_));
                    printWriter.flush();
                    CountUp countUp2 = new CountUp();
                    this.replacedMap_.put("method-coverage.index", countUp2);
                    Collection<Coverage.MethodKey> collection2 = this.coverage_.methodKeysOf(string);
                    Iterator<Coverage.MethodKey> iterator2 = collection2.iterator();
                    while (iterator2.hasNext()) {
                        countUp.increment();
                        countUp2.increment();
                        Coverage.MethodKey methodKey = iterator2.next();
                        Object object6 = this.replacedMap_.put(FMT_METHOD_COVERAGE, methodKey);
                        printWriter.println(this.getReplacedString(KEY_METHOD_COVERAGE, this.replacedMap_));
                        printWriter.flush();
                        this.replacedMap_.put(FMT_METHOD_COVERAGE, object6);
                    }
                    printWriter.println(this.getReplacedString(KEY_CLASS_COVERAGE_POSTMETHODS, this.replacedMap_));
                    printWriter.flush();
                    this.replacedMap_.put(FMT_CLASS_COVERAGE, object5);
                }
                this.replacedMap_.remove("src-coverage.index");
                this.replacedMap_.remove("class-coverage.index");
                printWriter.println(this.getReplacedString(KEY_COVERAGE_FOOTER, this.replacedMap_));
                printWriter.flush();
            }
            printWriter.println(this.getReplacedString("printer.html.format.footer", this.replacedMap_));
            printWriter.flush();
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
        finally {
            if (object3 != null) {
                try {
                    ((OutputStreamWriter)object3).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    protected String replaceArgument(String string, Map<String, Object> map) {
        block43: {
            block44: {
                block42: {
                    assert (string != null) : "@param:arg is null.";
                    assert (map != null) : "@param:objMap is null.";
                    if (this.coverage_ == null) {
                        return super.replaceArgument(string, map);
                    }
                    if (!string.startsWith(FMT_CLASS_COVERAGE)) break block42;
                    Object object = map.get(FMT_CLASS_COVERAGE);
                    if (object == null || !(object instanceof String)) {
                        return "--";
                    }
                    String string2 = object.toString();
                    if (!(this.coverage_ instanceof LineCoverage)) break block43;
                    LineCoverage lineCoverage = (LineCoverage)this.coverage_;
                    PassResult<Integer> passResult = null;
                    ts.tester.coverage.Result<Integer> result = null;
                    for (String string3 : lineCoverage.allSourcePaths()) {
                        passResult = lineCoverage.getPassResult(string3);
                        result = lineCoverage.getClassResult(string2, passResult);
                        String string4 = string.substring(FMT_CLASS_COVERAGE.length());
                        if (string4.equals(".name")) {
                            return string2;
                        }
                        if (string4.equals(".lastname")) {
                            return this.getClassLastName(string2);
                        }
                        if (string4.equals(".package-dir")) {
                            return this.getPackageDir(string2);
                        }
                        if (string4.equals(".index")) {
                            CountUp countUp = (CountUp)map.get("class-coverage.index");
                            return String.valueOf(countUp.currentValue());
                        }
                        if (string4.equals(OPT_LINES)) {
                            return String.valueOf(result.countAllResults());
                        }
                        if (string4.equals(OPT_PASSED)) {
                            return String.valueOf(result.countPassedResults());
                        }
                        if (string4.equals(OPT_UNPASSED)) {
                            return String.valueOf(result.countAllResults() - result.countPassedResults());
                        }
                        if (string4.equals(OPT_PASSED_RATIO)) {
                            return String.valueOf((int)(result.passedRatio() * 100.0f));
                        }
                        if (string4.equals(OPT_UNPASSED_RATIO)) {
                            return String.valueOf(100 - (int)(result.passedRatio() * 100.0f));
                        }
                        if (string4.equals(OPT_PASSED_LINES)) {
                            StringBuffer stringBuffer = new StringBuffer();
                            Enumeration<Integer> enumeration = result.enumPassedResultKeys();
                            while (enumeration.hasMoreElements()) {
                                int n = enumeration.nextElement();
                                if (result.getPassCountOfResult(n) <= 0) continue;
                                stringBuffer.append(" ").append(n);
                            }
                            return stringBuffer.toString();
                        }
                        if (!string4.equals(OPT_UNPASSED_LINES)) continue;
                        StringBuffer stringBuffer = new StringBuffer();
                        Enumeration<Integer> enumeration = result.enumNotPassedResultKeys();
                        while (enumeration.hasMoreElements()) {
                            int n = enumeration.nextElement();
                            if (result.getPassCountOfResult(n) != 0) continue;
                            stringBuffer.append(" ").append(n);
                        }
                        return stringBuffer.toString();
                    }
                    break block43;
                }
                if (!string.startsWith(FMT_METHOD_COVERAGE)) break block44;
                Object object = map.get(FMT_METHOD_COVERAGE);
                if (object == null || !(object instanceof Coverage.MethodKey)) {
                    return "--";
                }
                Coverage.MethodKey methodKey = (Coverage.MethodKey)object;
                PassResult<Integer> passResult = null;
                ts.tester.coverage.Result<Integer> result = null;
                ts.tester.coverage.Result<Integer> result2 = null;
                if (!(this.coverage_ instanceof LineCoverage)) break block43;
                LineCoverage lineCoverage = (LineCoverage)this.coverage_;
                for (String string5 : lineCoverage.allSourcePaths()) {
                    passResult = lineCoverage.getPassResult(string5);
                    result = lineCoverage.getClassResult(methodKey.getClassName(), passResult);
                    result2 = lineCoverage.getMethodResult(methodKey, result);
                    String string6 = string.substring(FMT_METHOD_COVERAGE.length());
                    if (string6.equals(".name")) {
                        return methodKey.getMethodName();
                    }
                    if (string6.equals(".index")) {
                        CountUp countUp = (CountUp)map.get("method-coverage.index");
                        return String.valueOf(countUp.currentValue());
                    }
                    if (string6.equals(OPT_LINES)) {
                        return String.valueOf(result2.countAllResults());
                    }
                    if (string6.equals(OPT_PASSED)) {
                        return String.valueOf(result2.countPassedResults());
                    }
                    if (string6.equals(OPT_UNPASSED)) {
                        return String.valueOf(result2.countAllResults() - result2.countPassedResults());
                    }
                    if (string6.equals(OPT_PASSED_RATIO)) {
                        return String.valueOf((int)(result2.passedRatio() * 100.0f));
                    }
                    if (string6.equals(OPT_UNPASSED_RATIO)) {
                        return String.valueOf(100 - (int)(result2.passedRatio() * 100.0f));
                    }
                    if (string6.equals(OPT_PASSED_LINES)) {
                        StringBuffer stringBuffer = new StringBuffer();
                        Enumeration<Integer> enumeration = result2.enumPassedResultKeys();
                        while (enumeration.hasMoreElements()) {
                            int n = enumeration.nextElement();
                            if (result2.getPassCountOfResult(n) <= 0) continue;
                            stringBuffer.append(" ").append(n);
                        }
                        return stringBuffer.toString();
                    }
                    if (!string6.equals(OPT_UNPASSED_LINES)) continue;
                    StringBuffer stringBuffer = new StringBuffer();
                    Enumeration<Integer> enumeration = result2.enumNotPassedResultKeys();
                    while (enumeration.hasMoreElements()) {
                        int n = enumeration.nextElement();
                        if (result2.getPassCountOfResult(n) != 0) continue;
                        stringBuffer.append(" ").append(n);
                    }
                    return stringBuffer.toString();
                }
                break block43;
            }
            if (string.startsWith(FMT_SRC_COVERAGE)) {
                PassResult<Integer> passResult = null;
                if (this.coverage_ instanceof LineCoverage) {
                    LineCoverage lineCoverage = (LineCoverage)this.coverage_;
                    for (String string7 : lineCoverage.allSourcePaths()) {
                        passResult = lineCoverage.getPassResult(string7);
                        String string8 = string.substring(FMT_SRC_COVERAGE.length());
                        if (string8.equals(".name")) {
                            return string7;
                        }
                        if (string8.equals(".index")) {
                            CountUp countUp = (CountUp)map.get("src-coverage.index");
                            return String.valueOf(countUp.currentValue());
                        }
                        if (string8.equals(OPT_LINES)) {
                            return String.valueOf(((ts.tester.coverage.Result)passResult).countAllResults());
                        }
                        if (string8.equals(OPT_PASSED)) {
                            return String.valueOf(((ts.tester.coverage.Result)passResult).countPassedResults());
                        }
                        if (string8.equals(OPT_UNPASSED)) {
                            return String.valueOf(((ts.tester.coverage.Result)passResult).countAllResults() - ((ts.tester.coverage.Result)passResult).countPassedResults());
                        }
                        if (string8.equals(OPT_PASSED_RATIO)) {
                            return String.valueOf((int)(passResult.passedRatio() * 100.0f));
                        }
                        if (string8.equals(OPT_UNPASSED_RATIO)) {
                            return String.valueOf(100 - (int)(passResult.passedRatio() * 100.0f));
                        }
                        if (string8.equals(OPT_PASSED_LINES)) {
                            StringBuffer stringBuffer = new StringBuffer();
                            Enumeration enumeration = ((ts.tester.coverage.Result)passResult).enumPassedResultKeys();
                            while (enumeration.hasMoreElements()) {
                                int n = (Integer)enumeration.nextElement();
                                if (((ts.tester.coverage.Result)passResult).getPassCountOfResult(n) <= 0) continue;
                                stringBuffer.append(" ").append(n);
                            }
                            return stringBuffer.toString();
                        }
                        if (!string8.equals(OPT_UNPASSED_LINES)) continue;
                        StringBuffer stringBuffer = new StringBuffer();
                        Enumeration enumeration = ((ts.tester.coverage.Result)passResult).enumNotPassedResultKeys();
                        while (enumeration.hasMoreElements()) {
                            int n = (Integer)enumeration.nextElement();
                            if (((ts.tester.coverage.Result)passResult).getPassCountOfResult(n) != 0) continue;
                            stringBuffer.append(" ").append(n);
                        }
                        return stringBuffer.toString();
                    }
                }
            }
        }
        return super.replaceArgument(string, map);
    }
}

