package ts.query;

import ts.tester.UnitTest;
import ts.util.table.*;
import java.util.Iterator;
import java.io.Serializable;

public class QueryExecutionContentTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryExecutionContentTest.class, args);
  }

  enum Attr {
    AAA, BBB, CCC,
  }
  enum Error {
    ERR0, ERR1, ERR2,
  }

  public void constructor()
  {
    MSG("デフォルト・コンストラクタ。");

    QueryExecutionContent cont = new QueryExecutionContent();
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);
  }

  public void put_key_value()
  {
    MSG("属性値を設定するメソッドの確認。");

    QueryExecutionContent cont = new QueryExecutionContent();
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    NULL(cont.put(Attr.BBB, "あいうえお"));
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    EQUAL(cont.get(Attr.BBB), "あいうえお");
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    NULL(cont.put(Attr.CCC, 12345));
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    EQUAL(cont.get(Attr.BBB), "あいうえお");
    EQUAL(cont.get(Attr.CCC), 12345);
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    EQUAL(cont.put(Attr.BBB, null), "あいうえお");
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    EQUAL(cont.get(Attr.CCC), 12345);
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);
  }

  public void put_key_value_Null()
  {
    MSG("引数がヌルの場合。");

    QueryExecutionContent cont = new QueryExecutionContent();

    try {
      cont.put(null, "a");
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
  }

  public void addParam_param()
  {
    MSG("入力パラメータを追加するメソッドの確認。");

    QueryExecutionContent cont = new QueryExecutionContent();
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    QueryExecutionParam param0 = new QueryExecutionParam("PARAM0");
    cont.addParam(param0);
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 1);
    EQUAL(cont.countParams(), 1);
    EQUAL(cont.listParams().get(0), param0);
    EQUAL(cont.listParams().get(0).getName(), "PARAM0");
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    QueryExecutionParam param1 = new QueryExecutionParam("PARAM1");
    cont.addParam(param1);
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 2);
    EQUAL(cont.countParams(), 2);
    EQUAL(cont.listParams().get(0), param0);
    EQUAL(cont.listParams().get(0).getName(), "PARAM0");
    EQUAL(cont.listParams().get(1), param1);
    EQUAL(cont.listParams().get(1).getName(), "PARAM1");
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    MSG("- 名前が重複する入力パラメータの場合。");

    QueryExecutionParam param2 = new QueryExecutionParam("PARAM0");
    cont.addParam(param2);
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 3);
    EQUAL(cont.countParams(), 3);
    EQUAL(cont.listParams().get(0), param0);
    EQUAL(cont.listParams().get(0).getName(), "PARAM0");
    EQUAL(cont.listParams().get(1), param1);
    EQUAL(cont.listParams().get(1).getName(), "PARAM1");
    EQUAL(cont.listParams().get(2), param2);
    EQUAL(cont.listParams().get(2).getName(), "PARAM0");
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);
  }

  public void addParam_param_Null()
  {
    MSG("引数がヌルの場合。");

    QueryExecutionContent cont = new QueryExecutionContent();
    try {
      cont.addParam(null);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
  }

  public void addOutput_output()
  {
    MSG("出力項目を追加するメソッドの確認。");

    QueryExecutionContent cont = new QueryExecutionContent();
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    QueryExecutionOutput out0 = new QueryExecutionOutput("OUT0");
    cont.addOutput(out0);
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 1);
    Iterator itr0 = cont.getOutputs().iterator();
    TRUE (itr0.hasNext());
    EQUAL(itr0.next(), out0);
    FALSE(itr0.hasNext());
    EQUAL(cont.countOutputs(), 1);
    TRUE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    QueryExecutionOutput out1 = new QueryExecutionOutput("OUT1");
    cont.addOutput(out1);
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 2);
    Iterator itr1 = cont.getOutputs().iterator();
    TRUE (itr1.hasNext());
    EQUAL(itr1.next(), out0);
    TRUE (itr1.hasNext());
    EQUAL(itr1.next(), out1);
    FALSE(itr1.hasNext());
    EQUAL(cont.countOutputs(), 2);
    TRUE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    MSG("- 名前が重複する出力項目の場合。");

    QueryExecutionOutput out2 = new QueryExecutionOutput("OUT0");
    cont.addOutput(out2);
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 2);
    Iterator itr2 = cont.getOutputs().iterator();
    TRUE (itr2.hasNext());
    EQUAL(itr2.next(), out0);
    TRUE (itr2.hasNext());
    EQUAL(itr2.next(), out1);
    FALSE(itr2.hasNext());
    EQUAL(cont.countOutputs(), 2);
    TRUE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);
  }

  public void addOutput_output_Null()
  {
    MSG("引数がヌルの場合。");

    QueryExecutionContent cont = new QueryExecutionContent();
    try {
      cont.addOutput(null);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
  }

  public void setConnectionId_connId()
  {
    MSG("接続先IDを設定するメソッドの確認。");

    QueryExecutionContent cont = new QueryExecutionContent();
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    cont.setConnectionId("c0");
    EQUAL(cont.getConnectionId(), "c0");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    cont.setConnectionId("c1");
    EQUAL(cont.getConnectionId(), "c1");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);
  }

  public void setConnectionId_connId_Null()
  {
    MSG("引数がヌルの場合。");

    QueryExecutionContent cont = new QueryExecutionContent();
    try {
      cont.setConnectionId(null);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
  }

  public void setExecutionId_execId()
  {
    MSG("実行IDを設定するメソッドの確認。");

    QueryExecutionContent cont = new QueryExecutionContent();
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    cont.setExecutionId("e0");
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "e0");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    cont.setExecutionId("e1");
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "e1");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);
  }

  public void setExecutionId_execId_Null()
  {
    MSG("引数がヌルの場合。");

    QueryExecutionContent cont = new QueryExecutionContent();
    try {
      cont.setExecutionId(null);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
  }

  public void setResultTable_table()
  {
    MSG("結果データ・テーブルを設定するメソッドの確認。");

    Table<String,Serializable> table =
      new ArrayListTable<String,Serializable>();

    QueryExecutionContent cont = new QueryExecutionContent();
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    cont.setResultTable(table);
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    EQUAL(cont.getResultTable(), table);
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);
  }

  public void setResultTable_table_Null()
  {
    MSG("引数がヌルの場合。");

    QueryExecutionContent cont = new QueryExecutionContent();
    cont.setResultTable(null);
    NULL(cont.getResultTable());
  }

  public void setFetchCount_count()
  {
    MSG("取得データ件数を設定するメソッドの確認。");

    QueryExecutionContent cont = new QueryExecutionContent();
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    cont.setFetchCount(1234);
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 1234);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    cont.setFetchCount(0);
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);
  }

  public void setFetchCount_count_Negative()
  {
    MSG("引数が負値の場合。");

    QueryExecutionContent cont = new QueryExecutionContent();
    try {
      cont.setFetchCount(-1);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
  }

  public void setUpdateCount_count()
  {
    MSG("取得データ件数を設定するメソッドの確認。");

    QueryExecutionContent cont = new QueryExecutionContent();
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    cont.setUpdateCount(1234);
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 1234);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);

    cont.setUpdateCount(0);
    EQUAL(cont.getConnectionId(), "");
    EQUAL(cont.getExecutionId(), "");
    NULL(cont.get(Attr.AAA));
    NULL(cont.get(Attr.BBB));
    NULL(cont.get(Attr.CCC));
    EQUAL(cont.listParams().size(), 0);
    EQUAL(cont.countParams(), 0);
    EQUAL(cont.getOutputs().size(), 0);
    EQUAL(cont.countOutputs(), 0);
    FALSE(cont.hasResultTable());
    NULL(cont.getResultTable());
    EQUAL(cont.getFetchCount(), 0);
    EQUAL(cont.getUpdateCount(), 0);
    EQUAL(cont.getLimitTimeMillis(), 0L);
    EQUAL(cont.getLimitFetchCount(), 0);
  }

  public void setUpdateCount_count_Negative()
  {
    MSG("引数が負値の場合。");

    QueryExecutionContent cont = new QueryExecutionContent();
    try {
      cont.setUpdateCount(-1);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
  }

  public void setLimitTimeMillis_limitTm()
  {
    MSG("制限時刻を設定するメソッドの確認。");

    QueryExecutionContent cont = new QueryExecutionContent();
    EQUAL(cont.getLimitTimeMillis(), 0L);

    cont.setLimitTimeMillis(100L);
    EQUAL(cont.getLimitTimeMillis(), 100L);

    cont.setLimitTimeMillis(0L);
    EQUAL(cont.getLimitTimeMillis(), 0L);

    MSG("- 引数が負値の場合。");
    cont.setLimitTimeMillis(-1L);
    EQUAL(cont.getLimitTimeMillis(), -1L);
  }

  public void setLimitFetchCount_limitCnt()
  {
    MSG("制限件数を設定するメソッドの確認。");

    QueryExecutionContent cont = new QueryExecutionContent();
    EQUAL(cont.getLimitFetchCount(), 0);

    cont.setLimitFetchCount(100);
    EQUAL(cont.getLimitFetchCount(), 100);

    cont.setLimitFetchCount(0);
    EQUAL(cont.getLimitFetchCount(), 0);

    MSG("- 引数が負値の場合。");

    cont.setLimitFetchCount(-1);
    EQUAL(cont.getLimitFetchCount(), -1);
  }
}
