package ts.query;

import ts.tester.UnitTest;
import ts.util.*;
import java.util.*;

public class QueryExecutionOutputTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryExecutionOutputTest.class, args);
  }

  enum ATTR { AAA, BBB, CCC }

  public void constructor_name()
  {
    MSG("名前を引数にとるコンストラクタ。");

    QueryExecutionOutput output = new QueryExecutionOutput("abc");
    EQUAL(output.getName(), "abc");
    NULL(output.get(ATTR.AAA));
    NULL(output.get(ATTR.BBB));
    NULL(output.get(ATTR.CCC));
  }

  public void constructor_name_Null()
  {
    MSG("引数がヌルの場合。");

    try {
      new QueryExecutionOutput(null);
      NG();
    } catch (AssertionError e) {
      OK(e);
    }
  }

  public void put_key_attrValue()
  {
    MSG("属性値を設定するメソッドの確認。");

    QueryExecutionOutput output = new QueryExecutionOutput("xyz");

    EQUAL(output.getName(), "xyz");
    NULL(output.get(ATTR.AAA));
    NULL(output.get(ATTR.BBB));
    NULL(output.get(ATTR.CCC));

    output.put(ATTR.AAA, 123);

    EQUAL(output.getName(), "xyz");
    EQUAL(output.get(ATTR.AAA), 123);
    NULL(output.get(ATTR.BBB));
    NULL(output.get(ATTR.CCC));

    output.put(ATTR.CCC, "あいうえお");

    EQUAL(output.getName(), "xyz");
    EQUAL(output.get(ATTR.AAA), 123);
    NULL(output.get(ATTR.BBB));
    EQUAL(output.get(ATTR.CCC), "あいうえお");

    output.put(ATTR.AAA, null);

    EQUAL(output.getName(), "xyz");
    NULL(output.get(ATTR.AAA));
    NULL(output.get(ATTR.BBB));
    EQUAL(output.get(ATTR.CCC), "あいうえお");

    output.put(null, 999);

    EQUAL(output.getName(), "xyz");
    NULL(output.get(ATTR.AAA));
    NULL(output.get(ATTR.BBB));
    EQUAL(output.get(ATTR.CCC), "あいうえお");
    EQUAL(output.get(null), 999);
  }

  public void equals()
  {
    MSG("オブジェクトが等しいかどうかを判定するメソッドの確認。");

    QueryExecutionOutput output0 = new QueryExecutionOutput("xyz");
    QueryExecutionOutput output1 = new QueryExecutionOutput("xyz");
    QueryExecutionOutput output2 = new QueryExecutionOutput("abc");
    QueryExecutionOutput output3 = new QueryExecutionOutput("xyz0");
    QueryExecutionOutput output4 = new QueryExecutionOutput("XYZ");
    QueryExecutionOutput output5 = new QueryExecutionOutput("xyz") {
      static final long serialVersionUID = -1L;
    };

    TRUE(output0.equals(output0));
    TRUE(output0.equals(output1));
    TRUE(output1.equals(output0));
    FALSE(output0.equals(output2));
    FALSE(output2.equals(output0));
    FALSE(output0.equals(output3));
    FALSE(output3.equals(output0));
    FALSE(output0.equals(output4));
    FALSE(output4.equals(output0));
    TRUE(output0.equals(output5));
    TRUE(output5.equals(output0));
  }

  public void equals_obj_Null()
  {
    MSG("引数がヌルの場合。");

    QueryExecutionOutput output0 = new QueryExecutionOutput("xyz");
    FALSE(output0.equals(null));
  }

  public void equals_obj_OtherClass()
  {
    MSG("引数が他のクラスのインスタンスの場合。");

    QueryExecutionOutput output0 = new QueryExecutionOutput("xyz");
    QueryExecutionParam param0 = new QueryExecutionParam("xyz");
    String str0 = "xyz";

    FALSE(output0.equals(param0));
    FALSE(output0.equals(str0));
  }

  public void _hashCode()
  {
    MSG("ハッシュ・コードを求めるメソッドの確認。");

    Map<QueryExecutionOutput,QueryExecutionOutput> map =
      new HashMap<QueryExecutionOutput,QueryExecutionOutput>();

    QueryExecutionOutput output0 = new QueryExecutionOutput("xyz");
    QueryExecutionOutput output1 = new QueryExecutionOutput("xyz");
    QueryExecutionOutput output2 = new QueryExecutionOutput("abc");
    QueryExecutionOutput output3 = new QueryExecutionOutput("xyz0");
    QueryExecutionOutput output4 = new QueryExecutionOutput("XYZ");
    QueryExecutionOutput output5 = new QueryExecutionOutput("xyz") {
      static final long serialVersionUID = -1L;
    };

    map.put(output0, output0);
    EQUAL(map.size(), 1);
    EQUAL(map.get(output0), output0);
    EQUAL(map.get(output1), output0);
    NULL(map.get(output2));
    NULL(map.get(output3));
    NULL(map.get(output4));
    EQUAL(map.get(output5), output0);

    map.put(output1, output1);
    EQUAL(map.size(), 1);
    EQUAL(map.get(output0), output1);
    EQUAL(map.get(output1), output1);
    NULL(map.get(output2));
    NULL(map.get(output3));
    NULL(map.get(output4));
    EQUAL(map.get(output5), output1);

    map.put(output2, output2);
    EQUAL(map.size(), 2);
    EQUAL(map.get(output0), output1);
    EQUAL(map.get(output1), output1);
    EQUAL(map.get(output2), output2);
    NULL(map.get(output3));
    NULL(map.get(output4));
    EQUAL(map.get(output5), output1);

    map.put(output3, output3);
    EQUAL(map.size(), 3);
    EQUAL(map.get(output0), output1);
    EQUAL(map.get(output1), output1);
    EQUAL(map.get(output2), output2);
    EQUAL(map.get(output3), output3);
    NULL(map.get(output4));
    EQUAL(map.get(output5), output1);

    map.put(output4, output4);
    EQUAL(map.size(), 4);
    EQUAL(map.get(output0), output1);
    EQUAL(map.get(output1), output1);
    EQUAL(map.get(output2), output2);
    EQUAL(map.get(output3), output3);
    EQUAL(map.get(output4), output4);
    EQUAL(map.get(output5), output1);

    map.put(output5, output5);
    EQUAL(map.size(), 4);
    EQUAL(map.get(output0), output5);
    EQUAL(map.get(output1), output5);
    EQUAL(map.get(output2), output2);
    EQUAL(map.get(output3), output3);
    EQUAL(map.get(output4), output4);
    EQUAL(map.get(output5), output5);
  }
}
