package ts.query;

import ts.tester.UnitTest;
import ts.util.*;
import java.util.*;

public class QueryExecutionParamTest extends UnitTest
{
  public static void main(String[] args)
  {
    run(QueryExecutionParamTest.class, args);
  }

  enum ATTR { AAA, BBB, CCC, }

  public void constructor_name()
  {
    MSG("名前を引数にとるコンストラクタ。");

    QueryExecutionParam param = new QueryExecutionParam("abc");
    EQUAL(param.getName(), "abc");
    EQUAL(param.getIO(), QueryExecutionParam.IO.IN);
    NULL(param.get(ATTR.AAA));
    NULL(param.get(ATTR.BBB));
    NULL(param.get(ATTR.CCC));
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);
  }

  public void constructor_name_Null()
  {
    MSG("引数がヌルの場合。");

    try {
      new QueryExecutionParam(null);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
  }

  public void constructor_name_io()
  {
    MSG("名前と入出力区分を引数にとるコンストラクタ。");

    QueryExecutionParam param =
      new QueryExecutionParam("xyz", QueryExecutionParam.IO.OUT);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.OUT);
    NULL(param.get(ATTR.AAA));
    NULL(param.get(ATTR.BBB));
    NULL(param.get(ATTR.CCC));
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);
  }

  public void constructor_name_io_Null()
  {
    MSG("引数がヌルの場合。");

    try {
      new QueryExecutionParam(null, QueryExecutionParam.IO.OUT);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }

    try {
      new QueryExecutionParam("aaa", null);
      NG();
    }
    catch (AssertionError e) {
      OK(e);
    }
  }

  public void put_attrKey_attrValue()
  {
    MSG("属性値を設定するメソッドの確認。");

    QueryExecutionParam param =
      new QueryExecutionParam("xyz", QueryExecutionParam.IO.INOUT);

    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.INOUT);
    NULL(param.get(ATTR.AAA));
    NULL(param.get(ATTR.BBB));
    NULL(param.get(ATTR.CCC));
    NULL(param.get(null));
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    param.put(ATTR.AAA, 123);

    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.INOUT);
    EQUAL(param.get(ATTR.AAA), 123);
    NULL(param.get(ATTR.BBB));
    NULL(param.get(ATTR.CCC));
    NULL(param.get(null));
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    param.put(ATTR.CCC, "あいうえお");

    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.INOUT);
    EQUAL(param.get(ATTR.AAA), 123);
    NULL(param.get(ATTR.BBB));
    EQUAL(param.get(ATTR.CCC), "あいうえお");
    NULL(param.get(null));
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    param.put(null, 999);

    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.INOUT);
    EQUAL(param.get(ATTR.AAA), 123);
    NULL(param.get(ATTR.BBB));
    EQUAL(param.get(ATTR.CCC), "あいうえお");
    EQUAL(param.get(null), 999);
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    param.put(ATTR.AAA, null);

    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.INOUT);
    NULL(param.get(ATTR.AAA));
    NULL(param.get(ATTR.BBB));
    EQUAL(param.get(ATTR.CCC), "あいうえお");
    EQUAL(param.get(null), 999);
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);
  }

  public void setValue_paramValue_SingleValue()
  {
    MSG("パラメータ値が単値の場合。");

    QueryExecutionParam param =
      new QueryExecutionParam("xyz", QueryExecutionParam.IO.INOUT);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.INOUT);
    NULL(param.get(ATTR.AAA));
    NULL(param.get(ATTR.BBB));
    NULL(param.get(ATTR.CCC));
    NULL(param.getValue());
    NULL(param.getValue());
    param.next();
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    param.setValue("あいうえお");
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.INOUT);
    NULL(param.get(ATTR.AAA));
    NULL(param.get(ATTR.BBB));
    NULL(param.get(ATTR.CCC));
    EQUAL(param.getValue(), "あいうえお");
    EQUAL(param.getValue(), "あいうえお");
    param.next();
    EQUAL(param.getValue(), "あいうえお");
    EQUAL(param.countValues(), 1);

    param.setValue(1234);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.INOUT);
    NULL(param.get(ATTR.AAA));
    NULL(param.get(ATTR.BBB));
    NULL(param.get(ATTR.CCC));
    EQUAL(param.getValue(), 1234);
    EQUAL(param.getValue(), 1234);
    param.next();
    EQUAL(param.getValue(), 1234);
    EQUAL(param.countValues(), 1);
  }

  public void setValue_paramValue_Collection()
  {
    MSG("パラメータ値がコレクションの場合。");

    QueryExecutionParam param =
      new QueryExecutionParam("xyz", QueryExecutionParam.IO.INOUT);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.INOUT);
    NULL(param.get(ATTR.AAA));
    NULL(param.get(ATTR.BBB));
    NULL(param.get(ATTR.CCC));
    NULL(param.getValue());
    param.next();
    NULL(param.getValue());
    param.next();
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    List<String> lst = new ArrayList<String>(3);
    lst.add("あ");
    lst.add("か");
    lst.add("さ");
    param.setValue(lst);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.INOUT);
    NULL(param.get(ATTR.AAA));
    NULL(param.get(ATTR.BBB));
    NULL(param.get(ATTR.CCC));
    EQUAL(param.countValues(), 3);
    EQUAL(param.getValue(), "あ");
    param.next();
    EQUAL(param.getValue(), "か");
    param.next();
    EQUAL(param.getValue(), "さ");
    param.next();
    EQUAL(param.getValue(), "さ");
  }

  public void setValue_paramValue_Array()
  {
    MSG("パラメータ値が配列の場合。");

    QueryExecutionParam param =
      new QueryExecutionParam("xyz", QueryExecutionParam.IO.INOUT);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.INOUT);
    NULL(param.get(ATTR.AAA));  
    NULL(param.get(ATTR.BBB));  
    NULL(param.get(ATTR.CCC));  
    NULL(param.getValue());
    param.next();
    NULL(param.getValue());
    param.next();
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    Integer[] arr = new Integer[]{ 111, 222, 333, 444 };
    param.setValue(arr);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.INOUT);
    NULL(param.get(ATTR.AAA));  
    NULL(param.get(ATTR.BBB));  
    NULL(param.get(ATTR.CCC));  
    EQUAL(param.getValue(), 111);
    param.next();
    EQUAL(param.getValue(), 222);
    param.next();
    EQUAL(param.getValue(), 333);
    param.next();
    EQUAL(param.getValue(), 444);
    param.next();
    EQUAL(param.getValue(), 444);
    EQUAL(param.countValues(), 4);
  }

  public void setValue_paramValue_Null()
  {
    MSG("パラメータ値がヌルの場合。");

    QueryExecutionParam param =
      new QueryExecutionParam("xyz", QueryExecutionParam.IO.INOUT);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.INOUT);
    NULL(param.get(ATTR.AAA));
    NULL(param.get(ATTR.BBB));
    NULL(param.get(ATTR.CCC));
    NULL(param.getValue());
    param.next();
    NULL(param.getValue());
    param.next();
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);

    param.setValue(new String[0]);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.INOUT);
    NULL(param.get(ATTR.AAA));
    NULL(param.get(ATTR.BBB));
    NULL(param.get(ATTR.CCC));
    NULL(param.getValue());
    param.next();
    NULL(param.getValue());
    param.next();
    NULL(param.getValue());
    EQUAL(param.countValues(), 0);

    param.setValue(null);
    EQUAL(param.getName(), "xyz");
    EQUAL(param.getIO(), QueryExecutionParam.IO.INOUT);
    NULL(param.get(ATTR.AAA));
    NULL(param.get(ATTR.BBB));
    NULL(param.get(ATTR.CCC));
    NULL(param.getValue());
    param.next();
    NULL(param.getValue());
    param.next();
    NULL(param.getValue());
    EQUAL(param.countValues(), 1);
  }
}

