/* GENERATED FILE - EDIT THE SOURCE IN unicodelib.im INSTEAD! */

#include "_stdint.h"

struct unicode_block {
   int start,end;
   const char *name;
};

/* basic array lookup for map "unicode_blocks" */

struct unicode_block __icemap_unicode_blocks_array[262]={
  {0x0,0x7F,"Basic Latin"},{0x80,0xFF,"Latin-1 Supplement"},
  {0x100,0x17F,"Latin Extended-A"},{0x180,0x24F,"Latin Extended-B"},
  {0x250,0x2AF,"IPA Extensions"},
  {0x2B0,0x2FF,"Spacing Modifier Letters"},
  {0x300,0x36F,"Combining Diacritical Marks"},
  {0x370,0x3FF,"Greek and Coptic"},{0x400,0x4FF,"Cyrillic"},
  {0x500,0x52F,"Cyrillic Supplement"},{0x530,0x58F,"Armenian"},
  {0x590,0x5FF,"Hebrew"},{0x600,0x6FF,"Arabic"},{0x700,0x74F,"Syriac"},
  {0x750,0x77F,"Arabic Supplement"},{0x780,0x7BF,"Thaana"},
  {0x7C0,0x7FF,"NKo"},{0x800,0x83F,"Samaritan"},
  {0x840,0x85F,"Mandaic"},{0x8A0,0x8FF,"Arabic Extended-A"},
  {0x900,0x97F,"Devanagari"},{0x980,0x9FF,"Bengali"},
  {0xA00,0xA7F,"Gurmukhi"},{0xA80,0xAFF,"Gujarati"},
  {0xB00,0xB7F,"Oriya"},{0xB80,0xBFF,"Tamil"},{0xC00,0xC7F,"Telugu"},
  {0xC80,0xCFF,"Kannada"},{0xD00,0xD7F,"Malayalam"},
  {0xD80,0xDFF,"Sinhala"},{0xE00,0xE7F,"Thai"},{0xE80,0xEFF,"Lao"},
  {0xF00,0xFFF,"Tibetan"},{0x1000,0x109F,"Myanmar"},
  {0x10A0,0x10FF,"Georgian"},{0x1100,0x11FF,"Hangul Jamo"},
  {0x1200,0x137F,"Ethiopic"},{0x1380,0x139F,"Ethiopic Supplement"},
  {0x13A0,0x13FF,"Cherokee"},
  {0x1400,0x167F,"Unified Canadian Aboriginal Syllabics"},
  {0x1680,0x169F,"Ogham"},{0x16A0,0x16FF,"Runic"},
  {0x1700,0x171F,"Tagalog"},{0x1720,0x173F,"Hanunoo"},
  {0x1740,0x175F,"Buhid"},{0x1760,0x177F,"Tagbanwa"},
  {0x1780,0x17FF,"Khmer"},{0x1800,0x18AF,"Mongolian"},
  {0x18B0,0x18FF,"Unified Canadian Aboriginal Syllabics Extended"},
  {0x1900,0x194F,"Limbu"},{0x1950,0x197F,"Tai Le"},
  {0x1980,0x19DF,"New Tai Lue"},{0x19E0,0x19FF,"Khmer Symbols"},
  {0x1A00,0x1A1F,"Buginese"},{0x1A20,0x1AAF,"Tai Tham"},
  {0x1AB0,0x1AFF,"Combining Diacritical Marks Extended"},
  {0x1B00,0x1B7F,"Balinese"},{0x1B80,0x1BBF,"Sundanese"},
  {0x1BC0,0x1BFF,"Batak"},{0x1C00,0x1C4F,"Lepcha"},
  {0x1C50,0x1C7F,"Ol Chiki"},{0x1CC0,0x1CCF,"Sundanese Supplement"},
  {0x1CD0,0x1CFF,"Vedic Extensions"},
  {0x1D00,0x1D7F,"Phonetic Extensions"},
  {0x1D80,0x1DBF,"Phonetic Extensions Supplement"},
  {0x1DC0,0x1DFF,"Combining Diacritical Marks Supplement"},
  {0x1E00,0x1EFF,"Latin Extended Additional"},
  {0x1F00,0x1FFF,"Greek Extended"},
  {0x2000,0x206F,"General Punctuation"},
  {0x2070,0x209F,"Superscripts and Subscripts"},
  {0x20A0,0x20CF,"Currency Symbols"},
  {0x20D0,0x20FF,"Combining Diacritical Marks for Symbols"},
  {0x2100,0x214F,"Letterlike Symbols"},{0x2150,0x218F,"Number Forms"},
  {0x2190,0x21FF,"Arrows"},{0x2200,0x22FF,"Mathematical Operators"},
  {0x2300,0x23FF,"Miscellaneous Technical"},
  {0x2400,0x243F,"Control Pictures"},
  {0x2440,0x245F,"Optical Character Recognition"},
  {0x2460,0x24FF,"Enclosed Alphanumerics"},
  {0x2500,0x257F,"Box Drawing"},{0x2580,0x259F,"Block Elements"},
  {0x25A0,0x25FF,"Geometric Shapes"},
  {0x2600,0x26FF,"Miscellaneous Symbols"},{0x2700,0x27BF,"Dingbats"},
  {0x27C0,0x27EF,"Miscellaneous Mathematical Symbols-A"},
  {0x27F0,0x27FF,"Supplemental Arrows-A"},
  {0x2800,0x28FF,"Braille Patterns"},
  {0x2900,0x297F,"Supplemental Arrows-B"},
  {0x2980,0x29FF,"Miscellaneous Mathematical Symbols-B"},
  {0x2A00,0x2AFF,"Supplemental Mathematical Operators"},
  {0x2B00,0x2BFF,"Miscellaneous Symbols and Arrows"},
  {0x2C00,0x2C5F,"Glagolitic"},{0x2C60,0x2C7F,"Latin Extended-C"},
  {0x2C80,0x2CFF,"Coptic"},{0x2D00,0x2D2F,"Georgian Supplement"},
  {0x2D30,0x2D7F,"Tifinagh"},{0x2D80,0x2DDF,"Ethiopic Extended"},
  {0x2DE0,0x2DFF,"Cyrillic Extended-A"},
  {0x2E00,0x2E7F,"Supplemental Punctuation"},
  {0x2E80,0x2EFF,"CJK Radicals Supplement"},
  {0x2F00,0x2FDF,"Kangxi Radicals"},
  {0x2FF0,0x2FFF,"Ideographic Description Characters"},
  {0x3000,0x303F,"CJK Symbols and Punctuation"},
  {0x3040,0x309F,"Hiragana"},{0x30A0,0x30FF,"Katakana"},
  {0x3100,0x312F,"Bopomofo"},
  {0x3130,0x318F,"Hangul Compatibility Jamo"},{0x3190,0x319F,"Kanbun"},
  {0x31A0,0x31BF,"Bopomofo Extended"},{0x31C0,0x31EF,"CJK Strokes"},
  {0x31F0,0x31FF,"Katakana Phonetic Extensions"},
  {0x3200,0x32FF,"Enclosed CJK Letters and Months"},
  {0x3300,0x33FF,"CJK Compatibility"},
  {0x3400,0x4DBF,"CJK Unified Ideographs Extension A"},
  {0x4DC0,0x4DFF,"Yijing Hexagram Symbols"},
  {0x4E00,0x9FFF,"CJK Unified Ideographs"},
  {0xA000,0xA48F,"Yi Syllables"},{0xA490,0xA4CF,"Yi Radicals"},
  {0xA4D0,0xA4FF,"Lisu"},{0xA500,0xA63F,"Vai"},
  {0xA640,0xA69F,"Cyrillic Extended-B"},{0xA6A0,0xA6FF,"Bamum"},
  {0xA700,0xA71F,"Modifier Tone Letters"},
  {0xA720,0xA7FF,"Latin Extended-D"},{0xA800,0xA82F,"Syloti Nagri"},
  {0xA830,0xA83F,"Common Indic Number Forms"},
  {0xA840,0xA87F,"Phags-pa"},{0xA880,0xA8DF,"Saurashtra"},
  {0xA8E0,0xA8FF,"Devanagari Extended"},{0xA900,0xA92F,"Kayah Li"},
  {0xA930,0xA95F,"Rejang"},{0xA960,0xA97F,"Hangul Jamo Extended-A"},
  {0xA980,0xA9DF,"Javanese"},{0xA9E0,0xA9FF,"Myanmar Extended-B"},
  {0xAA00,0xAA5F,"Cham"},{0xAA60,0xAA7F,"Myanmar Extended-A"},
  {0xAA80,0xAADF,"Tai Viet"},{0xAAE0,0xAAFF,"Meetei Mayek Extensions"},
  {0xAB00,0xAB2F,"Ethiopic Extended-A"},
  {0xAB30,0xAB6F,"Latin Extended-E"},
  {0xAB70,0xABBF,"Cherokee Supplement"},{0xABC0,0xABFF,"Meetei Mayek"},
  {0xAC00,0xD7AF,"Hangul Syllables"},
  {0xD7B0,0xD7FF,"Hangul Jamo Extended-B"},
  {0xD800,0xDB7F,"High Surrogates"},
  {0xDB80,0xDBFF,"High Private Use Surrogates"},
  {0xDC00,0xDFFF,"Low Surrogates"},{0xE000,0xF8FF,"Private Use Area"},
  {0xF900,0xFAFF,"CJK Compatibility Ideographs"},
  {0xFB00,0xFB4F,"Alphabetic Presentation Forms"},
  {0xFB50,0xFDFF,"Arabic Presentation Forms-A"},
  {0xFE00,0xFE0F,"Variation Selectors"},
  {0xFE10,0xFE1F,"Vertical Forms"},
  {0xFE20,0xFE2F,"Combining Half Marks"},
  {0xFE30,0xFE4F,"CJK Compatibility Forms"},
  {0xFE50,0xFE6F,"Small Form Variants"},
  {0xFE70,0xFEFF,"Arabic Presentation Forms-B"},
  {0xFF00,0xFFEF,"Halfwidth and Fullwidth Forms"},
  {0xFFF0,0xFFFF,"Specials"},{0x10000,0x1007F,"Linear B Syllabary"},
  {0x10080,0x100FF,"Linear B Ideograms"},
  {0x10100,0x1013F,"Aegean Numbers"},
  {0x10140,0x1018F,"Ancient Greek Numbers"},
  {0x10190,0x101CF,"Ancient Symbols"},
  {0x101D0,0x101FF,"Phaistos Disc"},{0x10280,0x1029F,"Lycian"},
  {0x102A0,0x102DF,"Carian"},{0x102E0,0x102FF,"Coptic Epact Numbers"},
  {0x10300,0x1032F,"Old Italic"},{0x10330,0x1034F,"Gothic"},
  {0x10350,0x1037F,"Old Permic"},{0x10380,0x1039F,"Ugaritic"},
  {0x103A0,0x103DF,"Old Persian"},{0x10400,0x1044F,"Deseret"},
  {0x10450,0x1047F,"Shavian"},{0x10480,0x104AF,"Osmanya"},
  {0x10500,0x1052F,"Elbasan"},{0x10530,0x1056F,"Caucasian Albanian"},
  {0x10600,0x1077F,"Linear A"},{0x10800,0x1083F,"Cypriot Syllabary"},
  {0x10840,0x1085F,"Imperial Aramaic"},{0x10860,0x1087F,"Palmyrene"},
  {0x10880,0x108AF,"Nabataean"},{0x108E0,0x108FF,"Hatran"},
  {0x10900,0x1091F,"Phoenician"},{0x10920,0x1093F,"Lydian"},
  {0x10980,0x1099F,"Meroitic Hieroglyphs"},
  {0x109A0,0x109FF,"Meroitic Cursive"},{0x10A00,0x10A5F,"Kharoshthi"},
  {0x10A60,0x10A7F,"Old South Arabian"},
  {0x10A80,0x10A9F,"Old North Arabian"},{0x10AC0,0x10AFF,"Manichaean"},
  {0x10B00,0x10B3F,"Avestan"},
  {0x10B40,0x10B5F,"Inscriptional Parthian"},
  {0x10B60,0x10B7F,"Inscriptional Pahlavi"},
  {0x10B80,0x10BAF,"Psalter Pahlavi"},{0x10C00,0x10C4F,"Old Turkic"},
  {0x10C80,0x10CFF,"Old Hungarian"},
  {0x10E60,0x10E7F,"Rumi Numeral Symbols"},{0x11000,0x1107F,"Brahmi"},
  {0x11080,0x110CF,"Kaithi"},{0x110D0,0x110FF,"Sora Sompeng"},
  {0x11100,0x1114F,"Chakma"},{0x11150,0x1117F,"Mahajani"},
  {0x11180,0x111DF,"Sharada"},
  {0x111E0,0x111FF,"Sinhala Archaic Numbers"},
  {0x11200,0x1124F,"Khojki"},{0x11280,0x112AF,"Multani"},
  {0x112B0,0x112FF,"Khudawadi"},{0x11300,0x1137F,"Grantha"},
  {0x11480,0x114DF,"Tirhuta"},{0x11580,0x115FF,"Siddham"},
  {0x11600,0x1165F,"Modi"},{0x11680,0x116CF,"Takri"},
  {0x11700,0x1173F,"Ahom"},{0x118A0,0x118FF,"Warang Citi"},
  {0x11AC0,0x11AFF,"Pau Cin Hau"},{0x12000,0x123FF,"Cuneiform"},
  {0x12400,0x1247F,"Cuneiform Numbers and Punctuation"},
  {0x12480,0x1254F,"Early Dynastic Cuneiform"},
  {0x13000,0x1342F,"Egyptian Hieroglyphs"},
  {0x14400,0x1467F,"Anatolian Hieroglyphs"},
  {0x16800,0x16A3F,"Bamum Supplement"},{0x16A40,0x16A6F,"Mro"},
  {0x16AD0,0x16AFF,"Bassa Vah"},{0x16B00,0x16B8F,"Pahawh Hmong"},
  {0x16F00,0x16F9F,"Miao"},{0x1B000,0x1B0FF,"Kana Supplement"},
  {0x1BC00,0x1BC9F,"Duployan"},
  {0x1BCA0,0x1BCAF,"Shorthand Format Controls"},
  {0x1D000,0x1D0FF,"Byzantine Musical Symbols"},
  {0x1D100,0x1D1FF,"Musical Symbols"},
  {0x1D200,0x1D24F,"Ancient Greek Musical Notation"},
  {0x1D300,0x1D35F,"Tai Xuan Jing Symbols"},
  {0x1D360,0x1D37F,"Counting Rod Numerals"},
  {0x1D400,0x1D7FF,"Mathematical Alphanumeric Symbols"},
  {0x1D800,0x1DAAF,"Sutton SignWriting"},
  {0x1E800,0x1E8DF,"Mende Kikakui"},
  {0x1EE00,0x1EEFF,"Arabic Mathematical Alphabetic Symbols"},
  {0x1F000,0x1F02F,"Mahjong Tiles"},{0x1F030,0x1F09F,"Domino Tiles"},
  {0x1F0A0,0x1F0FF,"Playing Cards"},
  {0x1F100,0x1F1FF,"Enclosed Alphanumeric Supplement"},
  {0x1F200,0x1F2FF,"Enclosed Ideographic Supplement"},
  {0x1F300,0x1F5FF,"Miscellaneous Symbols and Pictographs"},
  {0x1F600,0x1F64F,"Emoticons"},
  {0x1F650,0x1F67F,"Ornamental Dingbats"},
  {0x1F680,0x1F6FF,"Transport and Map Symbols"},
  {0x1F700,0x1F77F,"Alchemical Symbols"},
  {0x1F780,0x1F7FF,"Geometric Shapes Extended"},
  {0x1F800,0x1F8FF,"Supplemental Arrows-C"},
  {0x1F900,0x1F9FF,"Supplemental Symbols and Pictographs"},
  {0x20000,0x2A6DF,"CJK Unified Ideographs Extension B"},
  {0x2A700,0x2B73F,"CJK Unified Ideographs Extension C"},
  {0x2B740,0x2B81F,"CJK Unified Ideographs Extension D"},
  {0x2B820,0x2CEAF,"CJK Unified Ideographs Extension E"},
  {0x2F800,0x2FA1F,"CJK Compatibility Ideographs Supplement"},
  {0xE0000,0xE007F,"Tags"},
  {0xE0100,0xE01EF,"Variation Selectors Supplement"},
  {0xF0000,0xFFFFF,"Supplementary Private Use Area-A"},
  {0x100000,0x10FFFF,"Supplementary Private Use Area-B"},
};

struct arabic_form {
   uint16_t initial,medial,final,isolated;
};

/* basic array lookup for map "arabic_forms" */

struct arabic_form __icemap_arabic_forms_array[256]={
  {0x600,0x600,0x600,0x600},{0x601,0x601,0x601,0x601},
  {0x602,0x602,0x602,0x602},{0x603,0x603,0x603,0x603},
  {0x604,0x604,0x604,0x604},{0x605,0x605,0x605,0x605},
  {0x606,0x606,0x606,0x606},{0x607,0x607,0x607,0x607},
  {0x608,0x608,0x608,0x608},{0x609,0x609,0x609,0x609},
  {0x60A,0x60A,0x60A,0x60A},{0x60B,0x60B,0x60B,0x60B},
  {0x60C,0x60C,0x60C,0x60C},{0x60D,0x60D,0x60D,0x60D},
  {0x60E,0x60E,0x60E,0x60E},{0x60F,0x60F,0x60F,0x60F},
  {0x610,0x610,0x610,0x610},{0x611,0x611,0x611,0x611},
  {0x612,0x612,0x612,0x612},{0x613,0x613,0x613,0x613},
  {0x614,0x614,0x614,0x614},{0x615,0x615,0x615,0x615},
  {0x616,0x616,0x616,0x616},{0x617,0x617,0x617,0x617},
  {0x618,0x618,0x618,0x618},{0x619,0x619,0x619,0x619},
  {0x61A,0x61A,0x61A,0x61A},{0x61B,0x61B,0x61B,0x61B},
  {0x61C,0x61C,0x61C,0x61C},{0,0,0,0} /* undefined code point */,
  {0x61E,0x61E,0x61E,0x61E},{0x61F,0x61F,0x61F,0x61F},
  {0x620,0x620,0x620,0x620},{0x621,0x621,0x621,0xFE80},
  {0x622,0x622,0xFE82,0xFE81},{0x623,0x623,0xFE84,0xFE83},
  {0x624,0x624,0xFE86,0xFE85},{0x625,0x625,0xFE88,0xFE87},
  {0xFE8B,0xFE8C,0xFE8A,0xFE89},{0x627,0x627,0xFE8E,0xFE8D},
  {0xFE91,0xFE92,0xFE90,0xFE8F},{0x629,0x629,0xFE94,0xFE93},
  {0xFE97,0xFE98,0xFE96,0xFE95},{0xFE9B,0xFE9C,0xFE9A,0xFE99},
  {0xFE9F,0xFEA0,0xFE9E,0xFE9D},{0xFEA3,0xFEA4,0xFEA2,0xFEA1},
  {0xFEA7,0xFEA8,0xFEA6,0xFEA5},{0x62F,0x62F,0xFEAA,0xFEA9},
  {0x630,0x630,0xFEAC,0xFEAB},{0x631,0x631,0xFEAE,0xFEAD},
  {0x632,0x632,0xFEB0,0xFEAF},{0xFEB3,0xFEB4,0xFEB2,0xFEB1},
  {0xFEB7,0xFEB8,0xFEB6,0xFEB5},{0xFEBB,0xFEBC,0xFEBA,0xFEB9},
  {0xFEBF,0xFEC0,0xFEBE,0xFEBD},{0xFEC3,0xFEC4,0xFEC2,0xFEC1},
  {0xFEC7,0xFEC8,0xFEC6,0xFEC5},{0xFECB,0xFECC,0xFECA,0xFEC9},
  {0xFECF,0xFED0,0xFECE,0xFECD},{0x63B,0x63B,0x63B,0x63B},
  {0x63C,0x63C,0x63C,0x63C},{0x63D,0x63D,0x63D,0x63D},
  {0x63E,0x63E,0x63E,0x63E},{0x63F,0x63F,0x63F,0x63F},
  {0x640,0x640,0x640,0x640},{0xFED3,0xFED4,0xFED2,0xFED1},
  {0xFED7,0xFED8,0xFED6,0xFED5},{0xFEDB,0xFEDC,0xFEDA,0xFED9},
  {0xFEDF,0xFEE0,0xFEDE,0xFEDD},{0xFEE3,0xFEE4,0xFEE2,0xFEE1},
  {0xFEE7,0xFEE8,0xFEE6,0xFEE5},{0xFEEB,0xFEEC,0xFEEA,0xFEE9},
  {0x648,0x648,0xFEEE,0xFEED},{0x649,0x649,0xFEF0,0xFEEF},
  {0xFEF3,0xFEF4,0xFEF2,0xFEF1},{0x64B,0x64B,0x64B,0x64B},
  {0x64C,0x64C,0x64C,0x64C},{0x64D,0x64D,0x64D,0x64D},
  {0x64E,0x64E,0x64E,0x64E},{0x64F,0x64F,0x64F,0x64F},
  {0x650,0x650,0x650,0x650},{0x651,0x651,0x651,0x651},
  {0x652,0x652,0x652,0x652},{0x653,0x653,0x653,0x653},
  {0x654,0x654,0x654,0x654},{0x655,0x655,0x655,0x655},
  {0x656,0x656,0x656,0x656},{0x657,0x657,0x657,0x657},
  {0x658,0x658,0x658,0x658},{0x659,0x659,0x659,0x659},
  {0x65A,0x65A,0x65A,0x65A},{0x65B,0x65B,0x65B,0x65B},
  {0x65C,0x65C,0x65C,0x65C},{0x65D,0x65D,0x65D,0x65D},
  {0x65E,0x65E,0x65E,0x65E},{0x65F,0x65F,0x65F,0x65F},
  {0x660,0x660,0x660,0x660},{0x661,0x661,0x661,0x661},
  {0x662,0x662,0x662,0x662},{0x663,0x663,0x663,0x663},
  {0x664,0x664,0x664,0x664},{0x665,0x665,0x665,0x665},
  {0x666,0x666,0x666,0x666},{0x667,0x667,0x667,0x667},
  {0x668,0x668,0x668,0x668},{0x669,0x669,0x669,0x669},
  {0x66A,0x66A,0x66A,0x66A},{0x66B,0x66B,0x66B,0x66B},
  {0x66C,0x66C,0x66C,0x66C},{0x66D,0x66D,0x66D,0x66D},
  {0x66E,0x66E,0x66E,0x66E},{0x66F,0x66F,0x66F,0x66F},
  {0x670,0x670,0x670,0x670},{0x671,0x671,0xFB51,0xFB50},
  {0x672,0x672,0x672,0x672},{0x673,0x673,0x673,0x673},
  {0x674,0x674,0x674,0x674},{0x675,0x675,0x675,0x675},
  {0x676,0x676,0x676,0x676},{0x677,0x677,0x677,0xFBDD},
  {0x678,0x678,0x678,0x678},{0xFB68,0xFB69,0xFB67,0xFB66},
  {0xFB60,0xFB61,0xFB5F,0xFB5E},{0xFB54,0xFB55,0xFB53,0xFB52},
  {0x67C,0x67C,0x67C,0x67C},{0x67D,0x67D,0x67D,0x67D},
  {0xFB58,0xFB59,0xFB57,0xFB56},{0xFB64,0xFB65,0xFB63,0xFB62},
  {0xFB5C,0xFB5D,0xFB5B,0xFB5A},{0x681,0x681,0x681,0x681},
  {0x682,0x682,0x682,0x682},{0xFB78,0xFB79,0xFB77,0xFB76},
  {0xFB74,0xFB75,0xFB73,0xFB72},{0x685,0x685,0x685,0x685},
  {0xFB7C,0xFB7D,0xFB7B,0xFB7A},{0xFB80,0xFB81,0xFB7F,0xFB7E},
  {0x688,0x688,0xFB89,0xFB88},{0x689,0x689,0x689,0x689},
  {0x68A,0x68A,0x68A,0x68A},{0x68B,0x68B,0x68B,0x68B},
  {0x68C,0x68C,0xFB85,0xFB84},{0x68D,0x68D,0xFB83,0xFB82},
  {0x68E,0x68E,0xFB87,0xFB86},{0x68F,0x68F,0x68F,0x68F},
  {0x690,0x690,0x690,0x690},{0x691,0x691,0xFB8D,0xFB8C},
  {0x692,0x692,0x692,0x692},{0x693,0x693,0x693,0x693},
  {0x694,0x694,0x694,0x694},{0x695,0x695,0x695,0x695},
  {0x696,0x696,0x696,0x696},{0x697,0x697,0x697,0x697},
  {0x698,0x698,0xFB8B,0xFB8A},{0x699,0x699,0x699,0x699},
  {0x69A,0x69A,0x69A,0x69A},{0x69B,0x69B,0x69B,0x69B},
  {0x69C,0x69C,0x69C,0x69C},{0x69D,0x69D,0x69D,0x69D},
  {0x69E,0x69E,0x69E,0x69E},{0x69F,0x69F,0x69F,0x69F},
  {0x6A0,0x6A0,0x6A0,0x6A0},{0x6A1,0x6A1,0x6A1,0x6A1},
  {0x6A2,0x6A2,0x6A2,0x6A2},{0x6A3,0x6A3,0x6A3,0x6A3},
  {0xFB6C,0xFB6D,0xFB6B,0xFB6A},{0x6A5,0x6A5,0x6A5,0x6A5},
  {0xFB70,0xFB71,0xFB6F,0xFB6E},{0x6A7,0x6A7,0x6A7,0x6A7},
  {0x6A8,0x6A8,0x6A8,0x6A8},{0xFB90,0xFB91,0xFB8F,0xFB8E},
  {0x6AA,0x6AA,0x6AA,0x6AA},{0x6AB,0x6AB,0x6AB,0x6AB},
  {0x6AC,0x6AC,0x6AC,0x6AC},{0xFBD5,0xFBD6,0xFBD4,0xFBD3},
  {0x6AE,0x6AE,0x6AE,0x6AE},{0xFB94,0xFB95,0xFB93,0xFB92},
  {0x6B0,0x6B0,0x6B0,0x6B0},{0xFB9C,0xFB9D,0xFB9B,0xFB9A},
  {0x6B2,0x6B2,0x6B2,0x6B2},{0xFB98,0xFB99,0xFB97,0xFB96},
  {0x6B4,0x6B4,0x6B4,0x6B4},{0x6B5,0x6B5,0x6B5,0x6B5},
  {0x6B6,0x6B6,0x6B6,0x6B6},{0x6B7,0x6B7,0x6B7,0x6B7},
  {0x6B8,0x6B8,0x6B8,0x6B8},{0x6B9,0x6B9,0x6B9,0x6B9},
  {0x6BA,0x6BA,0xFB9F,0xFB9E},{0xFBA2,0xFBA3,0xFBA1,0xFBA0},
  {0x6BC,0x6BC,0x6BC,0x6BC},{0x6BD,0x6BD,0x6BD,0x6BD},
  {0xFBAC,0xFBAD,0xFBAB,0xFBAA},{0x6BF,0x6BF,0x6BF,0x6BF},
  {0x6C0,0x6C0,0xFBA5,0xFBA4},{0xFBA8,0xFBA9,0xFBA7,0xFBA6},
  {0x6C2,0x6C2,0x6C2,0x6C2},{0x6C3,0x6C3,0x6C3,0x6C3},
  {0x6C4,0x6C4,0x6C4,0x6C4},{0x6C5,0x6C5,0xFBE1,0xFBE0},
  {0x6C6,0x6C6,0xFBDA,0xFBD9},{0x6C7,0x6C7,0xFBD8,0xFBD7},
  {0x6C8,0x6C8,0xFBDC,0xFBDB},{0x6C9,0x6C9,0xFBE3,0xFBE2},
  {0x6CA,0x6CA,0x6CA,0x6CA},{0x6CB,0x6CB,0xFBDF,0xFBDE},
  {0xFBFE,0xFBFF,0xFBFD,0xFBFC},{0x6CD,0x6CD,0x6CD,0x6CD},
  {0x6CE,0x6CE,0x6CE,0x6CE},{0x6CF,0x6CF,0x6CF,0x6CF},
  {0xFBE6,0xFBE7,0xFBE5,0xFBE4},{0x6D1,0x6D1,0x6D1,0x6D1},
  {0x6D2,0x6D2,0xFBAF,0xFBAE},{0x6D3,0x6D3,0xFBB1,0xFBB0},
  {0x6D4,0x6D4,0x6D4,0x6D4},{0x6D5,0x6D5,0x6D5,0x6D5},
  {0x6D6,0x6D6,0x6D6,0x6D6},{0x6D7,0x6D7,0x6D7,0x6D7},
  {0x6D8,0x6D8,0x6D8,0x6D8},{0x6D9,0x6D9,0x6D9,0x6D9},
  {0x6DA,0x6DA,0x6DA,0x6DA},{0x6DB,0x6DB,0x6DB,0x6DB},
  {0x6DC,0x6DC,0x6DC,0x6DC},{0x6DD,0x6DD,0x6DD,0x6DD},
  {0x6DE,0x6DE,0x6DE,0x6DE},{0x6DF,0x6DF,0x6DF,0x6DF},
  {0x6E0,0x6E0,0x6E0,0x6E0},{0x6E1,0x6E1,0x6E1,0x6E1},
  {0x6E2,0x6E2,0x6E2,0x6E2},{0x6E3,0x6E3,0x6E3,0x6E3},
  {0x6E4,0x6E4,0x6E4,0x6E4},{0x6E5,0x6E5,0x6E5,0x6E5},
  {0x6E6,0x6E6,0x6E6,0x6E6},{0x6E7,0x6E7,0x6E7,0x6E7},
  {0x6E8,0x6E8,0x6E8,0x6E8},{0x6E9,0x6E9,0x6E9,0x6E9},
  {0x6EA,0x6EA,0x6EA,0x6EA},{0x6EB,0x6EB,0x6EB,0x6EB},
  {0x6EC,0x6EC,0x6EC,0x6EC},{0x6ED,0x6ED,0x6ED,0x6ED},
  {0x6EE,0x6EE,0x6EE,0x6EE},{0x6EF,0x6EF,0x6EF,0x6EF},
  {0x6F0,0x6F0,0x6F0,0x6F0},{0x6F1,0x6F1,0x6F1,0x6F1},
  {0x6F2,0x6F2,0x6F2,0x6F2},{0x6F3,0x6F3,0x6F3,0x6F3},
  {0x6F4,0x6F4,0x6F4,0x6F4},{0x6F5,0x6F5,0x6F5,0x6F5},
  {0x6F6,0x6F6,0x6F6,0x6F6},{0x6F7,0x6F7,0x6F7,0x6F7},
  {0x6F8,0x6F8,0x6F8,0x6F8},{0x6F9,0x6F9,0x6F9,0x6F9},
  {0x6FA,0x6FA,0x6FA,0x6FA},{0x6FB,0x6FB,0x6FB,0x6FB},
  {0x6FC,0x6FC,0x6FC,0x6FC},{0x6FD,0x6FD,0x6FD,0x6FD},
  {0x6FE,0x6FE,0x6FE,0x6FE},{0x6FF,0x6FF,0x6FF,0x6FF},
};

/* basic array lookup for map "arabic_base_forms" */

uint16_t __icemap_arabic_base_forms_array[933]={
  0x671,0x671,0x67B,0x67B,0x67B,0x67B,0x67E,0x67E,0x67E,0x67E,0x680,
  0x680,0x680,0x680,0x67A,0x67A,0x67A,0x67A,0x67F,0x67F,0x67F,0x67F,
  0x679,0x679,0x679,0x679,0x6A4,0x6A4,0x6A4,0x6A4,0x6A6,0x6A6,0x6A6,
  0x6A6,0x684,0x684,0x684,0x684,0x683,0x683,0x683,0x683,0x686,0x686,
  0x686,0x686,0x687,0x687,0x687,0x687,0x68D,0x68D,0x68C,0x68C,0x68E,
  0x68E,0x688,0x688,0x698,0x698,0x691,0x691,0x6A9,0x6A9,0x6A9,0x6A9,
  0x6AF,0x6AF,0x6AF,0x6AF,0x6B3,0x6B3,0x6B3,0x6B3,0x6B1,0x6B1,0x6B1,
  0x6B1,0x6BA,0x6BA,0x6BB,0x6BB,0x6BB,0x6BB,0x6C0,0x6C0,0x6C1,0x6C1,
  0x6C1,0x6C1,0x6BE,0x6BE,0x6BE,0x6BE,0x6D2,0x6D2,0x6D3,0x6D3,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6AD,0x6AD,
  0x6AD,0x6AD,0x6C7,0x6C7,0x6C6,0x6C6,0x6C8,0x6C8,0x677,0x6CB,0x6CB,
  0x6C5,0x6C5,0x6C9,0x6C9,0x6D0,0x6D0,0x6D0,0x6D0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6CC,
  0x6CC,0x6CC,0x6CC,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
  0x621,0x622,0x622,0x623,0x623,0x624,0x624,0x625,0x625,0x626,0x626,
  0x626,0x626,0x627,0x627,0x628,0x628,0x628,0x628,0x629,0x629,0x62A,
  0x62A,0x62A,0x62A,0x62B,0x62B,0x62B,0x62B,0x62C,0x62C,0x62C,0x62C,
  0x62D,0x62D,0x62D,0x62D,0x62E,0x62E,0x62E,0x62E,0x62F,0x62F,0x630,
  0x630,0x631,0x631,0x632,0x632,0x633,0x633,0x633,0x633,0x634,0x634,
  0x634,0x634,0x635,0x635,0x635,0x635,0x636,0x636,0x636,0x636,0x637,
  0x637,0x637,0x637,0x638,0x638,0x638,0x638,0x639,0x639,0x639,0x639,
  0x63A,0x63A,0x63A,0x63A,0x641,0x641,0x641,0x641,0x642,0x642,0x642,
  0x642,0x643,0x643,0x643,0x643,0x644,0x644,0x644,0x644,0x645,0x645,
  0x645,0x645,0x646,0x646,0x646,0x646,0x647,0x647,0x647,0x647,0x648,
  0x648,0x649,0x649,0x64A,0x64A,0x64A,0x64A,
};

/* bit-cascade lookup on ints for map "has_alternates" */

struct has_alternates_entry {
  int16_t child[8];
  int8_t bit;
} has_alternates_table[]={
{{1,2,3,4,5,6,7,8},4},
{{9,10,9,10,9,10,9,10},3},
{{11,12,11,12,11,12,11,12},3},
{{13,14,13,14,13,14,13,14},3},
{{15,16,15,16,15,16,15,16},3},
{{17,18,17,18,17,18,17,18},3},
{{19,20,19,20,19,20,19,20},3},
{{21,22,21,22,21,22,21,22},3},
{{23,24,23,24,23,24,23,24},3},
{{25,26,27,28,29,30,31,32},7},
{{33,34,35,36,37,38,39,40},7},
{{41,26,42,43,44,45,46,47},7},
{{48,49,50,51,52,53,54,55},7},
{{56,57,58,59,60,61,62,63},7},
{{64,65,66,67,68,69,70,71},7},
{{72,73,74,75,76,77,78,79},7},
{{80,81,82,83,84,85,86,87},7},
{{88,89,90,91,92,93,54,94},7},
{{95,96,97,98,99,100,101,102},7},
{{103,104,105,106,107,108,40,109},7},
{{110,111,112,106,113,114,115,116},7},
{{111,117,118,119,120,121,122,123},7},
{{111,124,125,126,127,128,129,130},7},
{{131,132,133,134,135,136,137,138},7},
{{139,140,141,142,143,144,145,146},7},
{{147,-1,-1,-1,148,-1,149,150},11},
{{-1,-1,-1,150,151,-1,-1,150},11},
{{-1,-1,152,-1,153,-1,152,150},11},
{{154,-1,155,-1,-1,-1,155,150},11},
{{-1,-1,-1,-1,156,-1,157,-1},11},
{{158,-1,-1,-1,-1,-1,155,150},11},
{{159,-1,-1,-1,160,150,155,161},11},
{{162,-1,-1,-1,-1,150,155,-2},11},
{{163,-1,-1,-1,164,-1,165,150},11},
{{-1,-1,-1,150,166,-1,-1,150},11},
{{-1,-1,167,-1,168,-1,-1,150},11},
{{169,-1,170,-1,171,-1,170,150},11},
{{172,173,-1,-1,174,173,175,-1},11},
{{176,-1,177,-1,-1,-1,155,150},11},
{{178,172,-1,-1,-1,150,155,150},11},
{{-1,-1,-1,-1,-1,150,155,-2},11},
{{179,-1,-1,-1,151,-1,-1,150},11},
{{180,-1,181,-1,182,-1,-1,150},11},
{{-1,-1,155,-1,-1,183,184,185},11},
{{-1,-1,-1,-1,186,-1,187,150},11},
{{188,-1,-1,-1,-1,-1,155,150},11},
{{-1,-1,177,189,-1,150,155,190},11},
{{191,-1,-1,-1,-1,150,155,-2},11},
{{192,-1,-1,-1,193,-1,-1,150},11},
{{-1,-1,-1,150,194,-1,195,150},11},
{{-1,-1,155,-1,196,-1,-1,150},11},
{{197,-1,198,199,-1,200,155,150},11},
{{-1,-1,-1,-1,201,-1,202,200},11},
{{203,-1,-1,204,205,183,206,150},11},
{{-1,-1,-1,189,-1,150,155,150},11},
{{207,208,184,-1,-1,150,155,-2},11},
{{209,-1,-1,-1,210,-1,-1,150},11},
{{211,-1,-1,150,212,-1,-1,150},11},
{{-1,-1,155,-1,213,-1,-1,150},11},
{{-1,-1,214,150,-1,-1,-1,150},11},
{{215,-1,-1,-1,216,-1,217,-1},11},
{{218,-1,-1,-1,-1,-1,155,150},11},
{{219,-1,-1,-1,-1,150,155,-2},11},
{{220,-1,214,-1,-1,150,155,-2},11},
{{-1,-1,-1,-1,174,-1,-1,150},11},
{{221,-1,-1,150,222,-1,-1,150},11},
{{-1,-1,155,223,224,-1,197,150},11},
{{225,-1,155,150,-1,-1,-1,150},11},
{{150,-1,-1,-1,226,200,227,-1},11},
{{228,-1,-1,-1,-1,-1,155,150},11},
{{-1,-1,-1,-1,-1,150,155,229},11},
{{-1,-1,230,-1,-1,150,155,-2},11},
{{231,-1,-1,-1,232,-1,233,150},11},
{{234,-1,-1,150,212,-1,-1,150},11},
{{235,-1,236,150,237,-1,236,150},11},
{{-1,-1,155,150,238,-1,-1,150},11},
{{150,239,-1,-1,240,-1,241,150},11},
{{242,239,177,-1,-1,-1,155,150},11},
{{-1,-1,-1,-1,243,150,155,150},11},
{{-1,-1,244,245,-1,150,155,229},11},
{{246,-1,-1,247,248,-1,249,150},11},
{{250,-1,-1,150,212,-1,-1,150},11},
{{251,-1,252,253,237,-1,254,255},11},
{{-1,183,155,150,256,183,181,150},11},
{{247,-1,-1,-1,173,-1,257,150},11},
{{258,-1,219,-1,-1,-1,155,150},11},
{{-1,-1,-1,-1,-1,150,155,150},11},
{{259,245,260,261,-1,150,155,150},11},
{{262,-1,-1,-1,174,-1,-1,150},11},
{{163,-1,-1,-1,263,-1,-1,150},11},
{{180,-1,264,150,265,-1,155,150},11},
{{266,-1,155,-1,267,-1,-1,150},11},
{{215,-1,-1,-1,-1,-1,155,268},11},
{{269,-1,177,-1,270,-1,271,150},11},
{{272,-1,273,231,-1,150,155,274},11},
{{-1,-1,-1,204,201,-1,-1,150},11},
{{-1,-1,-1,150,150,-1,-1,150},11},
{{275,-1,276,277,201,-1,170,277},11},
{{278,-1,155,-1,-1,-1,-1,-1},11},
{{247,-1,-1,-1,-1,-1,-1,150},11},
{{279,-1,-1,-1,-1,-1,155,150},11},
{{-1,208,-1,280,-1,150,155,281},11},
{{-1,245,219,-1,-1,150,155,185},11},
{{282,-1,-1,-1,174,-1,-1,150},11},
{{283,-1,-1,-1,212,-1,-1,150},11},
{{284,-1,285,150,286,-1,287,150},11},
{{-1,-1,155,-1,-1,-1,-1,-1},11},
{{-1,-1,219,-1,-1,-1,155,253},11},
{{288,-1,219,-1,-1,-1,155,150},11},
{{289,-1,-1,172,-1,255,155,290},11},
{{208,-1,-1,-1,174,183,-1,150},11},
{{-1,-1,-1,-1,212,-1,-1,150},11},
{{-1,-1,211,150,286,-1,291,150},11},
{{-1,-1,177,-1,-1,292,155,150},11},
{{293,294,-1,-1,-1,-1,155,150},11},
{{-1,295,296,297,163,298,299,-2},11},
{{-1,172,300,172,-1,301,155,302},11},
{{303,-1,-1,-1,212,-1,-1,150},11},
{{-1,-1,304,150,286,-1,305,150},11},
{{-1,-1,155,-1,306,-1,307,-1},11},
{{-1,-1,-1,-1,308,309,155,309},11},
{{278,-1,-1,-1,-1,-1,155,150},11},
{{-1,-1,-1,-1,308,150,155,-2},11},
{{-1,-1,310,-1,-1,309,155,311},11},
{{303,-1,-1,-1,312,-1,-1,150},11},
{{-1,-1,313,247,286,183,314,150},11},
{{-1,-1,155,-1,-1,-1,155,-1},11},
{{315,-1,-1,-1,316,317,318,317},11},
{{-1,-1,-1,-1,174,-1,175,150},11},
{{-1,319,-1,-1,-1,150,155,-2},11},
{{-1,-1,-1,-1,-1,309,155,311},11},
{{303,-1,-1,-1,320,-1,-1,150},11},
{{-1,183,-1,183,-1,292,-1,150},11},
{{208,-1,321,-1,286,189,322,150},11},
{{323,-1,155,189,-1,-1,-1,150},11},
{{324,233,-1,-1,-1,325,155,326},11},
{{-1,239,-1,-1,-1,199,155,150},11},
{{270,327,-1,-1,328,150,236,-2},11},
{{329,-1,330,307,-1,-1,155,155},11},
{{-1,-1,-1,-1,151,294,-1,150},11},
{{-1,-1,162,185,-1,208,219,150},11},
{{331,208,175,208,286,208,175,150},11},
{{-1,-1,332,317,-1,-1,-1,333},11},
{{334,-1,-1,-1,-1,150,335,150},11},
{{-1,-1,-1,-1,-1,333,335,333},11},
{{336,337,338,339,340,150,155,-2},11},
{{225,341,197,342,343,344,155,345},11},
{{-1,346,-1,346,-1,346,-1,346},10},
{{347,151,347,151,347,151,347,151},10},
{{348,-1,348,-1,348,-1,348,-1},10},
{{-1,-2,-1,-2,-1,-2,-1,-2},10},
{{-2,-2,-2,-2,-1,-1,-1,-1},13},
{{349,-1,349,-1,349,-1,349,-1},10},
{{350,351,350,351,350,351,350,351},10},
{{352,353,352,353,352,353,352,353},10},
{{-2,-1,-2,-1,-2,-1,-2,-1},10},
{{346,-1,346,-1,346,-1,346,-1},10},
{{354,-1,354,-1,354,-1,354,-1},10},
{{-1,355,-1,355,-1,355,-1,355},10},
{{356,-1,356,-1,356,-1,356,-1},10},
{{357,-1,357,-1,357,-1,357,-1},10},
{{358,359,358,359,358,359,358,359},10},
{{360,-1,360,-1,360,-1,360,-1},10},
{{-1,361,-1,361,-1,361,-1,361},10},
{{362,151,362,151,362,151,362,151},10},
{{363,-1,363,-1,363,-1,363,-1},10},
{{364,365,364,365,364,365,364,365},10},
{{366,-1,366,-1,366,-1,366,-1},10},
{{367,-1,367,-1,367,-1,367,-1},10},
{{368,369,368,369,368,369,368,369},10},
{{370,-1,370,-1,370,-1,370,-1},10},
{{368,-1,368,-1,368,-1,368,-1},10},
{{-1,360,-1,360,-1,360,-1,360},10},
{{371,-1,371,-1,371,-1,371,-1},10},
{{372,-1,372,-1,372,-1,372,-1},10},
{{373,-1,373,-1,373,-1,373,-1},10},
{{-1,374,-1,374,-1,374,-1,374},10},
{{375,-1,375,-1,375,-1,375,-1},10},
{{376,-1,376,-1,376,-1,376,-1},10},
{{-1,377,-1,377,-1,377,-1,377},10},
{{361,-1,361,-1,361,-1,361,-1},10},
{{378,-1,378,-1,378,-1,378,-1},10},
{{379,-1,379,-1,379,-1,379,-1},10},
{{-1,380,-1,380,-1,380,-1,380},10},
{{381,-1,381,-1,381,-1,381,-1},10},
{{-1,381,-1,381,-1,381,-1,381},10},
{{382,-1,382,-1,382,-1,382,-1},10},
{{383,-1,383,-1,383,-1,383,-1},10},
{{352,369,352,369,352,369,352,369},10},
{{-1,384,-1,384,-1,384,-1,384},10},
{{378,-2,378,-2,378,-2,378,-2},10},
{{385,-1,385,-1,385,-1,385,-1},10},
{{-1,386,-1,386,-1,386,-1,386},10},
{{387,151,387,151,387,151,387,151},10},
{{388,151,388,151,388,151,388,151},10},
{{389,-1,389,-1,389,-1,389,-1},10},
{{390,-1,390,-1,390,-1,390,-1},10},
{{384,-1,384,-1,384,-1,384,-1},10},
{{391,-1,391,-1,391,-1,391,-1},10},
{{-1,378,-1,378,-1,378,-1,378},10},
{{-1,392,-1,392,-1,392,-1,392},10},
{{393,-1,393,-1,393,-1,393,-1},10},
{{394,-1,394,-1,394,-1,394,-1},10},
{{395,396,395,396,395,396,395,396},10},
{{-1,352,-1,352,-1,352,-1,352},10},
{{368,397,368,397,368,397,368,397},10},
{{-2,398,-2,398,-2,398,-2,398},10},
{{353,-1,353,-1,353,-1,353,-1},10},
{{-1,396,-1,396,-1,396,-1,396},10},
{{-1,399,-1,399,-1,399,-1,399},10},
{{400,362,400,362,400,362,400,362},10},
{{396,-1,396,-1,396,-1,396,-1},10},
{{-1,151,-1,151,-1,151,-1,151},10},
{{401,-1,401,-1,401,-1,401,-1},10},
{{402,-1,402,-1,402,-1,402,-1},10},
{{-1,359,-1,359,-1,359,-1,359},10},
{{403,-1,403,-1,403,-1,403,-1},10},
{{404,-1,404,-1,404,-1,404,-1},10},
{{-1,405,-1,405,-1,405,-1,405},10},
{{380,-1,380,-1,380,-1,380,-1},10},
{{406,-1,406,-1,406,-1,406,-1},10},
{{407,408,407,408,407,408,407,408},10},
{{361,151,361,151,361,151,361,151},10},
{{-1,409,-1,409,-1,409,-1,409},10},
{{410,-1,410,-1,410,-1,410,-1},10},
{{369,-1,369,-1,369,-1,369,-1},10},
{{411,-1,411,-1,411,-1,411,-1},10},
{{412,-1,412,-1,412,-1,412,-1},10},
{{-1,413,-1,413,-1,413,-1,413},10},
{{392,-2,392,-2,392,-2,392,-2},10},
{{414,-1,414,-1,414,-1,414,-1},10},
{{-1,415,-1,415,-1,415,-1,415},10},
{{416,-1,416,-1,416,-1,416,-1},10},
{{408,-1,408,-1,408,-1,408,-1},10},
{{417,-1,417,-1,417,-1,417,-1},10},
{{418,-1,418,-1,418,-1,418,-1},10},
{{419,-1,419,-1,419,-1,419,-1},10},
{{420,-1,420,-1,420,-1,420,-1},10},
{{-1,357,-1,357,-1,357,-1,357},10},
{{-1,421,-1,421,-1,421,-1,421},10},
{{422,-1,422,-1,422,-1,422,-1},10},
{{423,-1,423,-1,423,-1,423,-1},10},
{{-2,424,-2,424,-2,424,-2,424},10},
{{-1,368,-1,368,-1,368,-1,368},10},
{{425,-1,425,-1,425,-1,425,-1},10},
{{-1,426,-1,426,-1,426,-1,426},10},
{{-1,427,-1,427,-1,427,-1,427},10},
{{-1,402,-1,402,-1,402,-1,402},10},
{{428,-1,428,-1,428,-1,428,-1},10},
{{429,-1,429,-1,429,-1,429,-1},10},
{{430,-1,430,-1,430,-1,430,-1},10},
{{431,-1,431,-1,431,-1,431,-1},10},
{{432,-1,432,-1,432,-1,432,-1},10},
{{-1,433,-1,433,-1,433,-1,433},10},
{{434,-1,434,-1,434,-1,434,-1},10},
{{-1,435,-1,435,-1,435,-1,435},10},
{{-1,436,-1,436,-1,436,-1,436},10},
{{437,-1,437,-1,437,-1,437,-1},10},
{{438,439,438,439,438,439,438,439},10},
{{440,-1,440,-1,440,-1,440,-1},10},
{{441,-1,441,-1,441,-1,441,-1},10},
{{-1,442,-1,442,-1,442,-1,442},10},
{{-1,443,-1,443,-1,443,-1,443},10},
{{-1,444,-1,444,-1,444,-1,444},10},
{{359,-1,359,-1,359,-1,359,-1},10},
{{445,-1,445,-1,445,-1,445,-1},10},
{{446,-1,446,-1,446,-1,446,-1},10},
{{-1,372,-1,372,-1,372,-1,372},10},
{{-1,447,-1,447,-1,447,-1,447},10},
{{448,449,448,449,448,449,448,449},10},
{{450,-1,450,-1,450,-1,450,-1},10},
{{451,-1,451,-1,451,-1,451,-1},10},
{{452,-1,452,-1,452,-1,452,-1},10},
{{453,-1,453,-1,453,-1,453,-1},10},
{{-1,454,-1,454,-1,454,-1,454},10},
{{368,380,368,380,368,380,368,380},10},
{{455,-1,455,-1,455,-1,455,-1},10},
{{-1,391,-1,391,-1,391,-1,391},10},
{{456,-1,456,-1,456,-1,456,-1},10},
{{396,457,396,457,396,457,396,457},10},
{{380,384,380,384,380,384,380,384},10},
{{380,-2,380,-2,380,-2,380,-2},10},
{{-1,458,-1,458,-1,458,-1,458},10},
{{-1,450,-1,450,-1,450,-1,450},10},
{{459,426,459,426,459,426,459,426},10},
{{460,-1,460,-1,460,-1,460,-1},10},
{{151,-1,151,-1,151,-1,151,-1},10},
{{461,-1,461,-1,461,-1,461,-1},10},
{{-1,462,-1,462,-1,462,-1,462},10},
{{463,-1,463,-1,463,-1,463,-1},10},
{{378,381,378,381,378,381,378,381},10},
{{464,-1,464,-1,464,-1,464,-1},10},
{{-1,465,-1,465,-1,465,-1,465},10},
{{435,-1,435,-1,435,-1,435,-1},10},
{{-1,466,-1,466,-1,466,-1,466},10},
{{467,-1,467,-1,467,-1,467,-1},10},
{{468,-1,468,-1,468,-1,468,-1},10},
{{-1,469,-1,469,-1,469,-1,469},10},
{{470,-2,470,-2,470,-2,470,-2},10},
{{-2,361,-2,361,-2,361,-2,361},10},
{{471,-1,471,-1,471,-1,471,-1},10},
{{-1,468,-1,468,-1,468,-1,468},10},
{{-2,472,-2,472,-2,472,-2,472},10},
{{-1,393,-1,393,-1,393,-1,393},10},
{{473,-1,473,-1,473,-1,473,-1},10},
{{474,-1,474,-1,474,-1,474,-1},10},
{{-1,408,-1,408,-1,408,-1,408},10},
{{465,-1,465,-1,465,-1,465,-1},10},
{{-1,475,-1,475,-1,475,-1,475},10},
{{-1,358,-1,358,-1,358,-1,358},10},
{{476,-1,476,-1,476,-1,476,-1},10},
{{-2,358,-2,358,-2,358,-2,358},10},
{{-1,362,-1,362,-1,362,-1,362},10},
{{477,-1,477,-1,477,-1,477,-1},10},
{{478,-1,478,-1,478,-1,478,-1},10},
{{369,479,369,479,369,479,369,479},10},
{{459,-1,459,-1,459,-1,459,-1},10},
{{-1,480,-1,480,-1,480,-1,480},10},
{{481,-1,481,-1,481,-1,481,-1},10},
{{-1,482,-1,482,-1,482,-1,482},10},
{{483,151,483,151,483,151,483,151},10},
{{484,-1,484,-1,484,-1,484,-1},10},
{{485,-1,485,-1,485,-1,485,-1},10},
{{486,402,486,402,486,402,486,402},10},
{{-1,487,-1,487,-1,487,-1,487},10},
{{400,488,400,488,400,488,400,488},10},
{{-1,488,-1,488,-1,488,-1,488},10},
{{-1,489,-1,489,-1,489,-1,489},10},
{{490,491,490,491,490,491,490,491},10},
{{492,-1,492,-1,492,-1,492,-1},10},
{{493,-1,493,-1,493,-1,493,-1},10},
{{372,366,372,366,372,366,372,366},10},
{{392,-1,392,-1,392,-1,392,-1},10},
{{-1,456,-1,456,-1,456,-1,456},10},
{{396,494,396,494,396,494,396,494},10},
{{358,-1,358,-1,358,-1,358,-1},10},
{{495,-1,495,-1,495,-1,495,-1},10},
{{-1,369,-1,369,-1,369,-1,369},10},
{{482,-1,482,-1,482,-1,482,-1},10},
{{458,384,458,384,458,384,458,384},10},
{{475,-1,475,-1,475,-1,475,-1},10},
{{421,496,421,496,421,496,421,496},10},
{{480,496,480,496,480,496,480,496},10},
{{-1,497,-1,497,-1,497,-1,497},10},
{{378,496,378,496,378,496,378,496},10},
{{-2,496,-2,496,-2,496,-2,496},10},
{{-1,-1,498,499,-1,-1,498,499},1},
{{500,151,151,151,500,151,151,151},1},
{{500,-1,-1,-1,500,-1,-1,-1},1},
{{501,-1,469,-1,501,-1,469,-1},1},
{{151,151,498,151,151,151,498,151},1},
{{151,-1,151,-1,-1,-1,-1,-1},0},
{{-1,469,-1,-1,-1,469,-1,-1},1},
{{501,469,-2,501,501,469,-2,501},1},
{{-2,-2,502,503,-2,-2,502,503},1},
{{469,501,469,-2,469,501,469,-2},1},
{{501,502,-1,-1,501,502,-1,-1},1},
{{-1,498,-1,-1,-1,498,-1,-1},1},
{{-2,-2,-2,469,-2,-2,-2,469},1},
{{501,-2,-2,-2,501,-2,-2,-2},1},
{{-1,-1,469,-1,-1,-1,469,-1},1},
{{499,-1,-1,-1,499,-1,-1,-1},1},
{{151,499,-1,-1,151,499,-1,-1},1},
{{151,503,-1,-1,151,503,-1,-1},1},
{{151,151,151,499,151,151,151,499},1},
{{151,151,503,-2,151,151,503,-2},1},
{{469,469,501,-1,469,469,501,-1},1},
{{498,151,151,151,498,151,151,151},1},
{{498,-1,-1,-1,498,-1,-1,-1},1},
{{501,-1,-1,-1,501,-1,-1,-1},1},
{{502,-2,-2,-2,502,-2,-2,-2},1},
{{-1,-1,499,-1,-1,-1,499,-1},1},
{{-1,-1,-1,498,-1,-1,-1,498},1},
{{-2,-2,-2,502,-2,-2,-2,502},1},
{{469,-1,-2,469,469,-1,-2,469},1},
{{501,-1,-1,-2,501,-1,-1,-2},1},
{{469,-2,-1,469,469,-2,-1,469},1},
{{499,151,498,-1,499,151,498,-1},1},
{{-1,501,-2,-2,-1,501,-2,-2},1},
{{151,151,498,499,151,151,498,499},1},
{{-1,-1,-1,501,-1,-1,-1,501},1},
{{-1,-2,-2,-2,-1,-2,-2,-2},1},
{{498,499,498,151,498,499,498,151},1},
{{502,503,502,151,502,503,502,151},1},
{{-1,-1,-1,-2,-1,-1,-1,-2},1},
{{501,-2,501,-2,501,-2,501,-2},1},
{{-1,499,151,151,-1,499,151,151},1},
{{151,-1,151,-1,151,-1,151,-1},1},
{{151,151,499,-1,151,151,499,-1},1},
{{-1,498,499,501,-1,498,499,501},1},
{{498,151,151,-1,498,151,151,-1},1},
{{-2,-2,-2,501,-2,-2,-2,501},1},
{{-2,-1,-1,-1,-2,-1,-1,-1},1},
{{151,-1,-1,-1,151,-1,-1,-1},1},
{{151,-2,-2,469,151,-2,-2,469},1},
{{498,-1,469,-1,498,-1,469,-1},1},
{{469,-1,-1,-1,469,-1,-1,-1},1},
{{-1,-1,504,-1,-1,-1,504,-1},1},
{{-1,-1,505,-1,-1,-1,505,-1},1},
{{151,499,-2,-1,151,499,-2,-1},1},
{{-1,-1,151,499,-1,-1,151,499},1},
{{151,499,499,499,151,499,499,499},1},
{{-2,469,-1,-1,-2,469,-1,-1},1},
{{-1,498,498,-1,-1,498,498,-1},1},
{{-2,502,502,-2,-2,502,502,-2},1},
{{-1,-1,-1,-1,-2,-1,-2,-1},0},
{{501,-1,-2,501,501,-1,-2,501},1},
{{499,469,-1,501,499,469,-1,501},1},
{{-1,-1,-1,499,-1,-1,-1,499},1},
{{-1,-1,-2,469,-1,-1,-2,469},1},
{{499,-1,151,498,499,-1,151,498},1},
{{-1,-1,151,498,-1,-1,151,498},1},
{{-2,-2,151,502,-2,-2,151,502},1},
{{501,-1,501,501,501,-1,501,501},1},
{{501,-2,469,-1,501,-2,469,-1},1},
{{469,-1,501,-1,469,-1,501,-1},1},
{{-1,151,151,151,-1,151,151,151},1},
{{-1,-2,-2,-1,-1,-2,-2,-1},1},
{{-1,502,-1,-1,-1,502,-1,-1},1},
{{-2,502,-2,-2,-2,502,-2,-2},1},
{{151,498,151,151,151,498,151,151},1},
{{-1,501,-1,-1,-1,501,-1,-1},1},
{{499,-1,-1,499,499,-1,-1,499},1},
{{503,-2,-2,503,503,-2,-2,503},1},
{{-1,-2,-1,-2,-1,-1,-1,-1},0},
{{501,501,-1,501,501,501,-1,501},1},
{{-1,-1,501,-1,-1,-1,501,-1},1},
{{-1,469,-1,-2,-1,469,-1,-2},1},
{{498,499,499,499,498,499,499,499},1},
{{502,499,-1,-1,502,499,-1,-1},1},
{{-2,469,-2,469,-2,469,-2,469},1},
{{499,-1,-1,498,499,-1,-1,498},1},
{{503,-2,501,498,503,-2,501,498},1},
{{-2,469,-2,-2,-2,469,-2,-2},1},
{{503,-2,503,151,503,-2,503,151},1},
{{-2,-2,-2,-1,-2,-2,-2,-1},1},
{{499,-1,498,-1,499,-1,498,-1},1},
{{-2,-2,503,-2,-2,-2,503,-2},1},
{{-2,469,469,-1,-2,469,469,-1},1},
{{-1,-2,-1,469,-1,-2,-1,469},1},
{{-1,469,-1,501,-1,469,-1,501},1},
{{-1,501,-1,469,-1,501,-1,469},1},
{{-1,-1,-1,-1,-1,-2,-1,-2},0},
{{-2,501,501,-1,-2,501,501,-1},1},
{{151,151,151,503,151,151,151,503},1},
{{499,-1,498,151,499,-1,498,151},1},
{{-2,-1,-2,-2,-2,-1,-2,-2},1},
{{-2,-2,469,501,-2,-2,469,501},1},
{{-1,-1,499,469,-1,-1,499,469},1},
{{-2,-1,501,-2,-2,-1,501,-2},1},
{{-1,-1,151,-1,-1,-1,151,-1},1},
{{-2,-2,502,-2,-2,-2,502,-2},1},
{{501,-1,-1,501,501,-1,-1,501},1},
{{469,-2,-1,-1,469,-2,-1,-1},1},
{{469,-2,-2,-2,469,-2,-2,-2},1},
{{502,-2,501,501,502,-2,501,501},1},
{{-2,-2,469,-1,-2,-2,469,-1},1},
{{-2,501,469,-1,-2,501,469,-1},1},
{{-1,-1,501,469,-1,-1,501,469},1},
{{-1,151,-1,-1,-1,151,-1,-1},1},
{{501,151,-1,-2,501,151,-1,-2},1},
{{503,151,151,-2,503,151,151,-2},1},
{{469,-2,469,-1,469,-2,469,-1},1},
{{-2,469,501,469,-2,469,501,469},1},
{{502,151,151,151,502,151,151,151},1},
{{-1,-2,-1,-2,-1,-2,-1,-2},2},
{{-1,-1,-2,-1,-1,-1,-2,-1},1},
{{-1,-1,-1,506,-1,-1,-1,506},1},
{{-1,501,469,-1,-1,501,469,-1},1},
{{-2,-1,-2,-1,-2,-1,-2,-1},0},
{{-1,504,-1,504,-1,504,-1,504},2},
{{501,469,-1,-2,501,469,-1,-2},1},
{{-1,-2,469,-1,-1,-2,469,-1},1},
{{-1,469,469,469,-1,469,469,469},1},
{{151,502,502,502,151,502,502,502},1},
{{-1,499,-1,-1,-1,499,-1,-1},1},
{{-1,469,-1,469,-1,469,-1,469},1},
{{469,-2,469,501,469,-2,469,501},1},
{{502,-2,502,503,502,-2,502,503},1},
{{-1,469,-2,-1,-1,469,-2,-1},1},
{{-2,-1,-2,-1,-2,-1,-2,-1},2},
{{-2,151,-2,-2,-2,151,-2,-2},1},
{{-1,-1,501,-2,-1,-1,501,-2},1},
{{151,-1,151,151,151,-1,151,151},1},
{{-2,-1,469,-2,-2,-1,469,-2},1},
{{-2,151,502,-2,-2,151,502,-2},1},
{{501,-2,-1,-1,501,-2,-1,-1},1},
{{501,-1,501,-2,501,-1,501,-2},1},
{{-2,469,469,-2,-2,469,469,-2},1},
{{469,-1,-1,501,469,-1,-1,501},1},
{{-1,498,151,-1,-1,498,151,-1},1},
{{506,-1,-1,-1,506,-1,-1,-1},1},
{{-2,469,-2,-1,-2,469,-2,-1},1},
{{-1,-1,469,-2,-1,-1,469,-2},1},
{{-2,-2,-1,-2,-2,-2,-1,-2},1},
{{-1,499,-1,469,-1,499,-1,469},1},
{{-1,-1,-1,469,-1,-1,-1,469},1},
{{504,-1,-1,-1,504,-1,-1,-1},1},
{{-1,151,-1,151,-1,151,-1,151},0},
{{151,-1,151,-1,151,-1,151,-1},0},
{{507,151,507,151,507,151,507,151},0},
{{-1,-2,-1,-2,-1,-2,-1,-2},0},
{{-2,151,-2,151,-2,151,-2,151},0},
{{151,-2,151,-2,151,-2,151,-2},0},
{{-1,-1,-1,-1,-2,-2,-2,-2},13},
{{-1,504,-1,504,-1,504,-1,504},0},
{{504,-1,504,-1,504,-1,504,-1},0},
{{-2,-2,-1,-1,-1,-1,-1,-1},13},
};

#define MAP has_alternates_table[search]
int has_alternates_lookup(int key) {
   int search;

   for (search=0;search>=0;)
     search=MAP.child[(key>>MAP.bit)&7];
   return ((-1)-search);
}
#undef MAP

