/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.tsukuyomi.openid.yadis;

import java.net.MalformedURLException;
import java.net.URL;
import jp.sourceforge.tsukuyomi.openid.yadis.YadisException;
import org.openxri.XRI;

public class YadisUrl {
    private URL _yadisUrl;

    private static URL urlFromString(String urlString) throws YadisException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new YadisException("Invalid URL: " + urlString, 2, e);
        }
        return url;
    }

    public YadisUrl(String urlString) throws YadisException {
        this(YadisUrl.urlFromString(urlString));
        if (!this.isValid(this._yadisUrl)) {
            throw new YadisException("The scheme name of a Yadis URL must be 'http' or 'https'", 3);
        }
    }

    public YadisUrl(URL urlId) throws YadisException {
        if (!this.isValid(urlId)) {
            throw new YadisException("The scheme name of a Yadis URL must be 'http' or 'https'", 3);
        }
        this._yadisUrl = urlId;
    }

    private boolean isValid(URL url) {
        return url.getProtocol().equalsIgnoreCase("http") || url.getProtocol().equalsIgnoreCase("https");
    }

    public YadisUrl(XRI xriId) throws YadisException {
        this(YadisUrl.urlFromString(xriId.toURINormalForm()));
    }

    public URL getUrl() {
        return this._yadisUrl;
    }

    public String toString() {
        return this._yadisUrl.toString();
    }
}

